/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser.formats;

import org.jboss.galleon.util.formatparser.FormatErrors;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingContext;
import org.jboss.galleon.util.formatparser.ParsingFormat;
import org.jboss.galleon.util.formatparser.ParsingFormatBase;
import org.jboss.galleon.util.formatparser.formats.KeyValueParsingFormat;

public class MapParsingFormat
extends ParsingFormatBase {
    public static final String NAME = "Map";
    public static final char OPENING_CHAR = '{';
    public static final char CLOSING_CHAR = '}';
    public static final char ENTRY_SEPARATOR_CHAR = ',';
    protected KeyValueParsingFormat entryFormat;

    public static MapParsingFormat getInstance() {
        return new MapParsingFormat();
    }

    public static MapParsingFormat getInstance(ParsingFormat key, ParsingFormat value) {
        return MapParsingFormat.getInstance(KeyValueParsingFormat.newInstance(key, value));
    }

    public static MapParsingFormat getInstance(KeyValueParsingFormat entryFormat) {
        return new MapParsingFormat(entryFormat);
    }

    protected MapParsingFormat() {
        this(NAME, KeyValueParsingFormat.getInstance());
    }

    protected MapParsingFormat(KeyValueParsingFormat entryFormat) {
        this(NAME, entryFormat);
    }

    protected MapParsingFormat(String name) {
        this(name, KeyValueParsingFormat.getInstance());
    }

    protected MapParsingFormat(String name, String contentType) {
        this(name, contentType, KeyValueParsingFormat.getInstance());
    }

    protected MapParsingFormat(String name, KeyValueParsingFormat entryFormat) {
        this(name, NAME, entryFormat);
    }

    protected MapParsingFormat(String name, String contentType, KeyValueParsingFormat entryFormat) {
        super(name, contentType == null ? NAME : contentType);
        this.entryFormat = entryFormat;
    }

    public boolean isAcceptsKey(Object key) {
        return true;
    }

    public MapParsingFormat setEntryFormat(KeyValueParsingFormat entryFormat) {
        this.entryFormat = entryFormat;
        return this;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public boolean isOpeningChar(char ch) {
        return ch == '{';
    }

    @Override
    public void pushed(ParsingContext ctx) throws FormatParsingException {
        if (ctx.charNow() != '{') {
            throw new FormatParsingException(FormatErrors.unexpectedStartingCharacter(this, '{', ctx.charNow()));
        }
    }

    @Override
    public void react(ParsingContext ctx) throws FormatParsingException {
        switch (ctx.charNow()) {
            case ',': {
                ctx.popFormats();
                break;
            }
            case '}': {
                ctx.end();
                break;
            }
            default: {
                ctx.bounce();
            }
        }
    }

    @Override
    public void deal(ParsingContext ctx) throws FormatParsingException {
        if (Character.isWhitespace(ctx.charNow())) {
            return;
        }
        ctx.pushFormat(this.entryFormat);
    }

    @Override
    public void eol(ParsingContext ctx) throws FormatParsingException {
        throw new FormatParsingException(FormatErrors.formatIncomplete(this));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.entryFormat == null ? 0 : this.entryFormat.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapParsingFormat other = (MapParsingFormat)obj;
        return !(this.entryFormat == null ? other.entryFormat != null : !this.entryFormat.equals(other.entryFormat));
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(NAME).append('<').append(this.entryFormat.getKeyFormat()).append(',').append(this.entryFormat.getValueFormat());
        return buf.append('>').toString();
    }
}

