/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;

public class PackageDependencySpec
implements Comparable<PackageDependencySpec> {
    public static final int OPTIONAL = 1;
    public static final int PASSIVE = 3;
    public static final int REQUIRED = 4;
    private final String name;
    private final int type;

    public static boolean isOptional(int type) {
        return type != 4;
    }

    public static PackageDependencySpec required(String name) {
        return new PackageDependencySpec(name, 4);
    }

    public static PackageDependencySpec optional(String name) {
        return new PackageDependencySpec(name, 1);
    }

    public static PackageDependencySpec passive(String name) {
        return new PackageDependencySpec(name, 3);
    }

    public static PackageDependencySpec newInstance(String packageName, int type) throws ProvisioningDescriptionException {
        switch (type) {
            case 1: {
                return PackageDependencySpec.optional(packageName);
            }
            case 3: {
                return PackageDependencySpec.passive(packageName);
            }
            case 4: {
                return PackageDependencySpec.required(packageName);
            }
        }
        throw new ProvisioningDescriptionException(Errors.unexpectedPackageDependencyType(packageName, type));
    }

    protected PackageDependencySpec(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOptional() {
        return (this.type & 1) == 1;
    }

    public boolean isPassive() {
        return (this.type & 3) == 3;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageDependencySpec other = (PackageDependencySpec)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.name);
        if (this.isOptional()) {
            buf.append(this.type == 1 ? " optional" : " passive");
        }
        return buf.append(']').toString();
    }

    @Override
    public int compareTo(PackageDependencySpec o) {
        return this.name.compareTo(o.name);
    }
}

