/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.map.MapCommand;
import org.aesh.command.parser.OptionParserException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.AbstractPathCompleter;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.state.configuration.ProvisionedConfigurationCompleter;
import org.jboss.galleon.cli.cmd.state.feature.FeatureCommandActivator;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;
import org.jboss.galleon.spec.FeatureParameterSpec;

public class StateAddFeatureCommand
extends AbstractDynamicCommand {
    public StateAddFeatureCommand(PmSession pmSession) {
        super(pmSession, false);
    }

    @Override
    protected boolean canComplete(PmSession pmSession) {
        return true;
    }

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options) throws CommandExecutionException {
        try {
            session.getPmSession().getState().addFeature(session.getPmSession(), this.getSpec(session.getPmSession().getState(), this.getId()), this.getConfiguration(session.getPmSession().getState()), options);
        }
        catch (IOException | ProvisioningException | PathConsumerException | PathParserException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.addFeatureFailed(), ex);
        }
    }

    private ConfigInfo getConfiguration(State state) throws PathParserException, PathConsumerException, ProvisioningException {
        List args = (List)this.getValue("");
        String config = (String)args.get(0);
        String path = "/configs/final/" + config + '/';
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(state.getContainer(), false);
        PathParser.parse(path, consumer);
        ConfigInfo ci = consumer.getConfig();
        if (ci == null) {
            throw new ProvisioningException("Not a valid config " + config);
        }
        return ci;
    }

    private FeatureSpecInfo getSpec(State state, String id) throws PathParserException, PathConsumerException, ProvisioningException {
        String path = "/feature-specs/" + id;
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(new AllFeaturesContainer(state.getContainer()), false);
        PathParser.parse(path, consumer);
        Group grp = consumer.getCurrentNode(path);
        if (grp == null) {
            throw new ProvisioningException("Invalid path");
        }
        if (grp.getSpec() == null) {
            throw new ProvisioningException("Path is not a feature-spec");
        }
        return grp.getSpec();
    }

    @Override
    protected String getName() {
        return "add-feature";
    }

    @Override
    protected String getDescription() {
        return "Add a new feature to a configuration";
    }

    private String getId() {
        List<String> args = (List<String>)this.getValue("");
        if (args == null && (args = this.getArgumentsValues()) == null) {
            return null;
        }
        String featureSpec = null;
        if (args.size() > 1) {
            featureSpec = args.get(1);
        }
        return featureSpec;
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
        List args = (List)this.getValue("");
        if (args != null && args.size() == 2) {
            return;
        }
        throw new CommandExecutionException("Invalid config and feature-spec");
    }

    @Override
    protected List<AbstractDynamicCommand.DynamicOption> getDynamicOptions(State state) throws Exception {
        if (state == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractDynamicCommand.DynamicOption> options = new ArrayList<AbstractDynamicCommand.DynamicOption>();
        Iterator<Map.Entry<String, FeatureParameterSpec>> iterator = this.getSpec(state, this.getId()).getSpec().getParams().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FeatureParameterSpec> entry;
            AbstractDynamicCommand.DynamicOption dyn = new AbstractDynamicCommand.DynamicOption(entry.getKey(), !(entry = iterator.next()).getValue().isNillable() && !entry.getValue().hasDefaultValue());
            String defValue = entry.getValue().getDefaultValue();
            if (defValue != null) {
                dyn.setDefaultValue(defValue.toString());
            }
            options.add(dyn);
        }
        return options;
    }

    @Override
    protected List<ProcessedOption> getStaticOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("").hasValue(true).description("Configuration / Feature id").type(String.class).required(true).hasMultipleValues(true).optionType(OptionType.ARGUMENTS).completer(AddArgumentsCompleter.class).build());
        return options;
    }

    @Override
    protected PmCommandActivator getActivator() {
        return new FeatureCommandActivator();
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }

    public static class AddArgumentsCompleter
    implements OptionCompleter<PmCompleterInvocation> {
        @Override
        public void complete(PmCompleterInvocation completerInvocation) {
            MapCommand cmd = (MapCommand)completerInvocation.getCommand();
            Object value = cmd.getValue("");
            if (value == null || !(value instanceof List) || ((List)value).isEmpty()) {
                new ProvisionedConfigurationCompleter().complete(completerInvocation);
            } else if (value instanceof List && ((List)value).size() == 1) {
                new FeatureSpecIdCompleter().complete(completerInvocation);
            }
        }
    }

    public static class FeatureSpecIdCompleter
    extends AbstractPathCompleter {
        @Override
        protected FeatureContainer getContainer(PmCompleterInvocation completerInvocation) throws Exception {
            PmSession session = completerInvocation.getPmSession();
            return new AllFeaturesContainer(session.getState().getContainer());
        }

        @Override
        protected String getCurrentPath(PmCompleterInvocation session) throws Exception {
            return "/feature-specs/";
        }

        @Override
        protected void filterCandidates(FeatureContainerPathConsumer consumer, List<String> candidates) {
        }
    }

    private static class AllFeaturesContainer
    extends FeatureContainer {
        private final FeatureContainer container;

        AllFeaturesContainer(FeatureContainer container) {
            super(null, null, container.getProvisioningConfig());
            this.container = container;
        }

        @Override
        public Map<String, Group> getFeatureSpecs() {
            HashMap<String, Group> map = new HashMap<String, Group>();
            for (FeatureContainer dep : this.container.getFullDependencies().values()) {
                for (String orig : dep.getFeatureSpecs().keySet()) {
                    Group root = (Group)map.get(orig);
                    if (root == null) {
                        root = Group.fromString(null, orig);
                        map.put(orig, root);
                    }
                    Group depRoot = dep.getFeatureSpecs().get(orig);
                    for (Group pkg : depRoot.getGroups()) {
                        root.addGroup(pkg);
                    }
                }
            }
            return map;
        }
    }
}

