/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.ByteArrayOutputStream;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.AsymmetricOperatorFactory;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.KeyUnwrapper;
import org.bouncycastle.crypto.KeyWrapOperatorFactory;
import org.bouncycastle.crypto.KeyWrapper;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SingleBlockCipher;
import org.bouncycastle.crypto.SingleBlockDecryptor;
import org.bouncycastle.crypto.SingleBlockEncryptor;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsKeyWrapOperatorFactory;
import org.bouncycastle.jcajce.provider.BaseWrapCipher;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseSingleBlockCipher
extends CipherSpi {
    private static final Class TlsRsaPremasterSecretParameterSpec = AccessController.doPrivileged(new PrivilegedAction<Class>(){

        @Override
        public Class run() {
            return BaseSingleBlockCipher.lookup("sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec");
        }
    });
    private final BouncyCastleFipsProvider fipsProvider;
    private final boolean wrapModeOnly;
    private final FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory;
    private final KeyWrapOperatorFactory generalKeyWrapOperatorFactory;
    private final AsymmetricOperatorFactory generalFactory;
    private final Map<Algorithm, Parameters> baseParametersMap;
    private final Algorithm[] algorithms;
    private final PublicKeyConverter publicKeyConverter;
    private final PrivateKeyConverter privateKeyConverter;
    private final ParametersCreatorProvider parametersCreatorProvider;
    private final Class[] availableSpecs;
    private Set<Algorithm> activeAlgorithmSet = new HashSet<Algorithm>();
    private SingleBlockCipher cipher;
    private AlgorithmParameterSpec paramSpec;
    private AlgorithmParameters engineParams;
    private boolean publicKeyOnly = false;
    private boolean privateKeyOnly = false;
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();
    private Parameters algParameters;
    private KeyWrapper keyWrapper;
    private KeyUnwrapper keyUnwrapper;

    public BaseSingleBlockCipher(BouncyCastleFipsProvider bouncyCastleFipsProvider, boolean bl, boolean bl2, boolean bl3, Class[] classArray, AsymmetricOperatorFactory asymmetricOperatorFactory, FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory, KeyWrapOperatorFactory keyWrapOperatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, ParametersCreatorProvider parametersCreatorProvider, Map<Algorithm, Parameters> map, Algorithm ... algorithmArray) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.publicKeyOnly = bl;
        this.privateKeyOnly = bl2;
        this.wrapModeOnly = bl3;
        this.availableSpecs = classArray;
        this.generalFactory = asymmetricOperatorFactory;
        this.fipsKeyWrapOperatorFactory = fipsKeyWrapOperatorFactory;
        this.generalKeyWrapOperatorFactory = keyWrapOperatorFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parametersCreatorProvider = parametersCreatorProvider;
        this.baseParametersMap = map;
        this.algorithms = algorithmArray;
        this.activeAlgorithmSet.addAll(Arrays.asList(algorithmArray));
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        if (key instanceof RSAKey) {
            RSAKey rSAKey = (RSAKey)((Object)key);
            return rSAKey.getModulus().bitLength();
        }
        if (key instanceof DHKey) {
            DHKey dHKey = (DHKey)((Object)key);
            return dHKey.getParams().getP().bitLength();
        }
        throw new IllegalArgumentException("not an valid key!");
    }

    @Override
    protected int engineGetOutputSize(int n) {
        try {
            return this.cipher.getOutputSize();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Single block Cipher not initialised");
        }
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.algParameters != null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("OAEP", this.fipsProvider);
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.toString(), exception);
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NONE") || string2.equals("ECB")) {
            return;
        }
        throw new NoSuchAlgorithmException("can't support mode " + string);
    }

    private void initFromSpec(Set<Algorithm> set, OAEPParameterSpec oAEPParameterSpec) throws NoSuchPaddingException {
        Algorithm algorithm2;
        for (Algorithm algorithm2 : set) {
            if (!algorithm2.getName().endsWith("OAEP")) continue;
            this.activeAlgorithmSet.add(algorithm2);
        }
        MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters();
        algorithm2 = Utils.digestNameToAlgMap.get(mGF1ParameterSpec.getDigestAlgorithm());
        if (algorithm2 == null) {
            throw new NoSuchPaddingException("no match on OAEP constructor for digest algorithm: " + mGF1ParameterSpec.getDigestAlgorithm());
        }
        this.paramSpec = oAEPParameterSpec;
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        HashSet<Algorithm> hashSet = new HashSet<Algorithm>(this.activeAlgorithmSet);
        this.activeAlgorithmSet.clear();
        if (string2.equals("NOPADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (algorithm.getName().indexOf(47) >= 0) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("PKCS1PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("PKCS1V1.5")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("OAEPPADDING")) {
            this.initFromSpec(hashSet, OAEPParameterSpec.DEFAULT);
        } else if (string2.equals("OAEPWITHSHA1ANDMGF1PADDING") || string2.equals("OAEPWITHSHA-1ANDMGF1PADDING")) {
            this.initFromSpec(hashSet, OAEPParameterSpec.DEFAULT);
        } else if (string2.equals("OAEPWITHSHA224ANDMGF1PADDING") || string2.equals("OAEPWITHSHA-224ANDMGF1PADDING")) {
            this.initFromSpec(hashSet, new OAEPParameterSpec("SHA-224", "MGF1", new MGF1ParameterSpec("SHA-224"), PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA256ANDMGF1PADDING") || string2.equals("OAEPWITHSHA-256ANDMGF1PADDING")) {
            this.initFromSpec(hashSet, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA384ANDMGF1PADDING") || string2.equals("OAEPWITHSHA-384ANDMGF1PADDING")) {
            this.initFromSpec(hashSet, new OAEPParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA512ANDMGF1PADDING") || string2.equals("OAEPWITHSHA-512ANDMGF1PADDING")) {
            this.initFromSpec(hashSet, new OAEPParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA3-224ANDMGF1PADDING")) {
            this.initFromSpec(hashSet, new OAEPParameterSpec("SHA3-224", "MGF1", new MGF1ParameterSpec("SHA3-224"), PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA3-256ANDMGF1PADDING")) {
            this.initFromSpec(hashSet, new OAEPParameterSpec("SHA3-256", "MGF1", new MGF1ParameterSpec("SHA3-256"), PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA3-384ANDMGF1PADDING")) {
            this.initFromSpec(hashSet, new OAEPParameterSpec("SHA3-384", "MGF1", new MGF1ParameterSpec("SHA3-384"), PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA3-512ANDMGF1PADDING")) {
            this.initFromSpec(hashSet, new OAEPParameterSpec("SHA3-512", "MGF1", new MGF1ParameterSpec("SHA3-512"), PSource.PSpecified.DEFAULT));
        } else {
            throw new NoSuchPaddingException("Padding " + string + " unknown.");
        }
        if (this.activeAlgorithmSet.isEmpty()) {
            throw new NoSuchPaddingException(string2 + " not found");
        }
    }

    @Override
    protected void engineInit(int n, Key key, final AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object t;
        final Algorithm algorithm = this.activeAlgorithmSet.size() == 1 ? this.activeAlgorithmSet.iterator().next() : this.algorithms[0];
        AsymmetricOperatorFactory asymmetricOperatorFactory = this.generalFactory;
        if (algorithmParameterSpec == null || algorithmParameterSpec instanceof OAEPParameterSpec || TlsRsaPremasterSecretParameterSpec != null && TlsRsaPremasterSecretParameterSpec.isAssignableFrom(algorithmParameterSpec.getClass())) {
            if (key instanceof RSAPublicKey || key instanceof DHPublicKey) {
                if (this.privateKeyOnly && n == 1) {
                    throw new InvalidKeyException("Mode 1 requires PrivateKey for encryption");
                }
                t = this.publicKeyConverter.convertKey(algorithm, (PublicKey)key);
            } else if (key instanceof RSAPrivateKey || key instanceof DHPrivateKey) {
                if (this.publicKeyOnly && n == 1) {
                    throw new InvalidKeyException("Mode 2 requires PublicKey for encryption");
                }
                t = this.privateKeyConverter.convertKey(algorithm, (PrivateKey)key);
            } else {
                if (key != null) {
                    throw new InvalidKeyException("Unknown key type passed to single block cipher: " + key.getClass().getName());
                }
                throw new InvalidKeyException("Null key type passed to single block cipher");
            }
            if (algorithmParameterSpec instanceof OAEPParameterSpec) {
                OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)algorithmParameterSpec;
                this.paramSpec = algorithmParameterSpec;
                if (!oAEPParameterSpec.getMGFAlgorithm().equalsIgnoreCase("MGF1") && !oAEPParameterSpec.getMGFAlgorithm().equals(PKCSObjectIdentifiers.id_mgf1.getId())) {
                    throw new InvalidAlgorithmParameterException("Unknown mask generation function specified");
                }
                if (!(oAEPParameterSpec.getMGFParameters() instanceof MGF1ParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Unkown MGF parameters");
                }
                Algorithm algorithm2 = Utils.digestNameToAlgMap.get(oAEPParameterSpec.getDigestAlgorithm());
                if (algorithm2 == null) {
                    throw new InvalidAlgorithmParameterException("No match on digest algorithm: " + oAEPParameterSpec.getDigestAlgorithm());
                }
                MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters();
                Algorithm algorithm3 = Utils.digestNameToAlgMap.get(mGF1ParameterSpec.getDigestAlgorithm());
                if (algorithm3 == null) {
                    throw new InvalidAlgorithmParameterException("no match on MGF digest algorithm: " + mGF1ParameterSpec.getDigestAlgorithm());
                }
            } else if (algorithmParameterSpec != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        if (TlsRsaPremasterSecretParameterSpec == null || TlsRsaPremasterSecretParameterSpec.isAssignableFrom(algorithmParameterSpec.getClass())) {
                            // empty if block
                        }
                        return null;
                    }
                });
            }
        } else {
            throw new InvalidAlgorithmParameterException("Unknown parameter type: " + algorithmParameterSpec.getClass().getName());
        }
        if (secureRandom == null) {
            secureRandom = this.fipsProvider.getDefaultSecureRandom();
        }
        this.algParameters = this.parametersCreatorProvider.get(new Parameters(){

            public Algorithm getAlgorithm() {
                return algorithm;
            }
        }).createParameters(true, this.paramSpec, secureRandom);
        this.bOut.reset();
        switch (n) {
            case 3: {
                if (algorithm instanceof FipsAlgorithm) {
                    this.keyWrapper = this.fipsKeyWrapOperatorFactory.createKeyWrapper((org.bouncycastle.crypto.Key)t, this.algParameters);
                } else {
                    try {
                        this.keyWrapper = this.generalKeyWrapOperatorFactory.createKeyWrapper(t, this.algParameters);
                    }
                    catch (ClassCastException classCastException) {
                        throw new InvalidParameterException("Cipher does not support WRAP_MODE");
                    }
                }
                this.keyWrapper = Utils.addRandomIfNeeded(this.keyWrapper, secureRandom);
                break;
            }
            case 4: {
                if (algorithm instanceof FipsAlgorithm) {
                    this.keyUnwrapper = this.fipsKeyWrapOperatorFactory.createKeyUnwrapper((org.bouncycastle.crypto.Key)t, this.algParameters);
                } else {
                    try {
                        this.keyUnwrapper = this.generalKeyWrapOperatorFactory.createKeyUnwrapper(t, this.algParameters);
                    }
                    catch (ClassCastException classCastException) {
                        throw new InvalidParameterException("Cipher does not support WRAP_MODE");
                    }
                }
                this.keyUnwrapper = Utils.addRandomIfNeeded(this.keyUnwrapper, secureRandom);
                break;
            }
            case 1: {
                if (this.wrapModeOnly) {
                    throw new InvalidParameterException("Cipher available for WRAP_MODE and UNWRAP_MODE only");
                }
                this.cipher = Utils.addRandomIfNeeded(asymmetricOperatorFactory.createBlockEncryptor((AsymmetricKey)t, this.algParameters), secureRandom);
                break;
            }
            case 2: {
                if (this.wrapModeOnly) {
                    if (algorithm instanceof FipsAlgorithm) {
                        this.keyUnwrapper = this.fipsKeyWrapOperatorFactory.createKeyUnwrapper((org.bouncycastle.crypto.Key)t, this.algParameters);
                    } else {
                        try {
                            this.keyUnwrapper = this.generalKeyWrapOperatorFactory.createKeyUnwrapper(t, this.algParameters);
                        }
                        catch (ClassCastException classCastException) {
                            throw new InvalidParameterException("Cipher does not support WRAP_MODE");
                        }
                    }
                    this.keyUnwrapper = Utils.addRandomIfNeeded(this.keyUnwrapper, secureRandom);
                    break;
                }
                this.cipher = Utils.addRandomIfNeeded(asymmetricOperatorFactory.createBlockDecryptor((AsymmetricKey)t, this.algParameters), secureRandom);
                break;
            }
            default: {
                throw new InvalidParameterException("Unknown opmode " + n + " passed to single block cipher");
            }
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        OAEPParameterSpec oAEPParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                oAEPParameterSpec = algorithmParameters.getParameterSpec(OAEPParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Cannot recognize parameters: " + invalidParameterSpecException.toString(), invalidParameterSpecException);
            }
        }
        this.engineParams = algorithmParameters;
        this.engineInit(n, key, oAEPParameterSpec, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Eeeek! " + invalidAlgorithmParameterException.toString(), invalidAlgorithmParameterException);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.bOut.write(byArray, n, n2);
        this.checkBufferSize();
        return null;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.bOut.write(byArray, n, n2);
        this.checkBufferSize();
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        if (byArray != null) {
            this.bOut.write(byArray, n, n2);
        }
        this.checkBufferSize();
        return this.getOutput();
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (n3 + this.engineGetOutputSize(n2) > byArray2.length) {
            throw new ShortBufferException("Not enough space for output");
        }
        if (byArray != null) {
            this.bOut.write(byArray, n, n2);
        }
        this.checkBufferSize();
        byte[] byArray3 = this.getOutput();
        for (int i = 0; i != byArray3.length; ++i) {
            byArray2[n3 + i] = byArray3[i];
        }
        Arrays.fill(byArray3, (byte)0);
        return byArray3.length;
    }

    private void checkBufferSize() {
        if (this.cipher != null && this.bOut.size() > this.cipher.getInputSize()) {
            throw new ArrayIndexOutOfBoundsException("Too much data for block: maximum " + this.cipher.getInputSize() + " bytes");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getOutput() throws BadPaddingException, IllegalBlockSizeException {
        byte[] byArray;
        block16: {
            byArray = null;
            byArray = this.bOut.toByteArray();
            if (this.cipher instanceof SingleBlockEncryptor) {
                try {
                    byte[] byArray2 = ((SingleBlockEncryptor)this.cipher).encryptBlock(byArray, 0, byArray.length);
                    return byArray2;
                }
                catch (PlainInputProcessingException plainInputProcessingException) {
                    throw new IllegalBlockSizeException("unable to encrypt block: " + plainInputProcessingException.getMessage());
                }
            }
            if (this.cipher == null) break block16;
            try {
                return ((SingleBlockDecryptor)this.cipher).decryptBlock(byArray, 0, byArray.length);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadBlockException("unable to decrypt block", invalidCipherTextException);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new BadBlockException("unable to decrypt block", arrayIndexOutOfBoundsException);
            }
        }
        try {
            return this.keyUnwrapper.unwrap(byArray, 0, byArray.length);
        }
        catch (InvalidWrappingException invalidWrappingException) {
            throw new BadBlockException("unable to decrypt block", invalidWrappingException);
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new BadBlockException("unable to decrypt block", arrayIndexOutOfBoundsException);
            }
        }
        finally {
            if (byArray != null) {
                Arrays.fill(byArray, (byte)0);
                Utils.clearAndResetByteArrayOutputStream(this.bOut);
            }
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Key parameter is null");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding");
        }
        try {
            return this.keyWrapper.wrap(byArray, 0, byArray.length);
        }
        catch (PlainInputProcessingException plainInputProcessingException) {
            throw new IllegalBlockSizeException(plainInputProcessingException.getMessage());
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.keyUnwrapper.unwrap(byArray, 0, byArray.length);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("unwrapping failed", exception);
        }
        return BaseWrapCipher.rebuildKey(string, n, byArray2, this.fipsProvider);
    }

    private static Class lookup(String string) {
        try {
            Class<?> clazz = BaseSingleBlockCipher.class.getClassLoader().loadClass(string);
            return clazz;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class BadBlockException
    extends BadPaddingException {
        private Throwable cause;

        public BadBlockException(String string, Throwable throwable) {
            super(string);
            this.cause = throwable;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }

    static class Builder {
        private final BouncyCastleFipsProvider fipsProvider;
        private final Map<Algorithm, Parameters> baseParametersMap;
        private final Algorithm[] algorithms;
        private boolean publicKeyOnly;
        private boolean privateKeyOnly;
        private boolean wrapModeOnly;
        private AsymmetricOperatorFactory generalFactory;
        private PublicKeyConverter publicKeyConverter;
        private PrivateKeyConverter privateKeyConverter;
        private ParametersCreatorProvider parametersCreatorProvider;
        private FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory;
        private KeyWrapOperatorFactory generalKeyWrapOperatorFactory;
        private Class[] availableSpecs = new Class[0];

        Builder(BouncyCastleFipsProvider bouncyCastleFipsProvider, Algorithm ... algorithmArray) {
            this.fipsProvider = bouncyCastleFipsProvider;
            this.baseParametersMap = new HashMap<Algorithm, Parameters>();
            this.algorithms = algorithmArray;
        }

        Builder(BouncyCastleFipsProvider bouncyCastleFipsProvider, Parameters ... parametersArray) {
            this.fipsProvider = bouncyCastleFipsProvider;
            this.baseParametersMap = new HashMap<Algorithm, Parameters>(parametersArray.length);
            this.algorithms = new Algorithm[parametersArray.length];
            for (int i = 0; i != parametersArray.length; ++i) {
                this.baseParametersMap.put(parametersArray[i].getAlgorithm(), parametersArray[i]);
                this.algorithms[i] = parametersArray[i].getAlgorithm();
            }
        }

        Builder setPublicKeyOnly(boolean bl) {
            this.publicKeyOnly = bl;
            return this;
        }

        Builder setPrivateKeyOnly(boolean bl) {
            this.privateKeyOnly = bl;
            return this;
        }

        Builder setWrapModeOnly(boolean bl) {
            this.wrapModeOnly = bl;
            return this;
        }

        Builder withFipsOperators(AsymmetricOperatorFactory asymmetricOperatorFactory, FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory) {
            this.generalFactory = asymmetricOperatorFactory;
            this.fipsKeyWrapOperatorFactory = fipsKeyWrapOperatorFactory;
            return this;
        }

        Builder withGeneralOperators(AsymmetricOperatorFactory asymmetricOperatorFactory, KeyWrapOperatorFactory keyWrapOperatorFactory) {
            this.generalFactory = asymmetricOperatorFactory;
            this.generalKeyWrapOperatorFactory = keyWrapOperatorFactory;
            return this;
        }

        Builder withPublicKeyConverter(PublicKeyConverter publicKeyConverter) {
            this.publicKeyConverter = publicKeyConverter;
            return this;
        }

        Builder withPrivateKeyConverter(PrivateKeyConverter privateKeyConverter) {
            this.privateKeyConverter = privateKeyConverter;
            return this;
        }

        Builder withParameters(Class[] classArray) {
            this.availableSpecs = classArray;
            return this;
        }

        Builder withParametersCreatorProvider(ParametersCreatorProvider parametersCreatorProvider) {
            this.parametersCreatorProvider = parametersCreatorProvider;
            return this;
        }

        BaseSingleBlockCipher build() {
            return new BaseSingleBlockCipher(this.fipsProvider, this.publicKeyOnly, this.privateKeyOnly, this.wrapModeOnly, this.availableSpecs, this.generalFactory, this.fipsKeyWrapOperatorFactory, this.generalKeyWrapOperatorFactory, this.publicKeyConverter, this.privateKeyConverter, this.parametersCreatorProvider, this.baseParametersMap, this.algorithms);
        }
    }
}

