/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileManagerImpl;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.profile.event.ProfileChangeEvent;
import ca.sqlpower.architect.profile.event.ProfileChangeListener;
import ca.sqlpower.architect.profile.event.ProfileResultEvent;
import ca.sqlpower.architect.profile.event.ProfileResultListener;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ProfileResultsViewer;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.dbtree.DBTreeCellRenderer;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.ProgressWatcher;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ProfileRowComponent
extends JPanel
implements Selectable {
    private static final Logger logger = Logger.getLogger(ProfileRowComponent.class);
    private static ImageIcon tableIcon = DBTreeCellRenderer.TABLE_ICON;
    private static ImageIcon stopIcon = SPSUtils.createIcon((String)"stop", (String)"Stop Profile", (int)16);
    private static ImageIcon refreshIcon = SPSUtils.createIcon((String)"arrow_refresh", (String)"Re-Profile", (int)16);
    private static ImageIcon deleteIcon = SPSUtils.createIcon((String)"delete", (String)"Delete Profile", (int)16);
    private final TableProfileResult result;
    private final ProfileManager pm;
    private final JLabel statusLabel = new JLabel(String.format("Rows: %d   %s   Time:  %s   Cols: %d/%d", 500, "Mar 9, 2007", 15000, 10, 10));
    private final JButton reProfileButton;
    private final JButton cancelButton;
    private final JButton deleteButton;
    private final ProfileResultListener profileResultListener = new ProfileResultListener(){

        @Override
        public void profileCancelled(ProfileResultEvent event) {
            ProfileRowComponent.this.statusLabel.setVisible(true);
            ProfileRowComponent.this.statusLabel.setText("Cancelled");
            ProfileRowComponent.this.cancelButton.setVisible(false);
            ProfileRowComponent.this.deleteButton.setVisible(true);
            ProfileRowComponent.this.progressBar.setVisible(false);
            ProfileRowComponent.this.reProfileButton.setVisible(true);
        }

        @Override
        public void profileFinished(ProfileResultEvent event) {
            ProfileRowComponent.this.reProfileButton.setVisible(true);
            ProfileRowComponent.this.cancelButton.setVisible(false);
            ProfileRowComponent.this.deleteButton.setVisible(true);
            ProfileRowComponent.this.statusLabel.setVisible(true);
            if (ProfileRowComponent.this.result.getException() == null) {
                if (ProfileRowComponent.this.result.getCreateStartTime() >= 0L) {
                    ProfileRowComponent.this.statusLabel.setText(ProfileRowComponent.this.result.toString());
                    ProfileRowComponent.this.statusLabel.setForeground(null);
                } else {
                    ProfileRowComponent.this.statusLabel.setText("Waiting to be profiled...");
                    ProfileRowComponent.this.statusLabel.setForeground(null);
                }
            } else {
                ProfileRowComponent.this.statusLabel.setText("Failed: " + ProfileRowComponent.this.result.getException().getMessage());
                ProfileRowComponent.this.statusLabel.setForeground(Color.RED);
            }
            ProfileRowComponent.this.progressBar.setVisible(false);
            if (ProfileRowComponent.this.getParent() != null) {
                ProfileRowComponent.this.fireProfileChangedEvent();
            }
        }

        @Override
        public void profileStarted(ProfileResultEvent event) {
            ProfileRowComponent.this.reProfileButton.setVisible(false);
            ProfileRowComponent.this.deleteButton.setVisible(false);
            ProfileRowComponent.this.statusLabel.setVisible(false);
            ProfileRowComponent.this.cancelButton.setVisible(true);
        }
    };
    private final SPListener profileStartedListener = new AbstractSPListener(){

        public void propertyChanged(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("createStartTime") && ProfileRowComponent.this.result.getException() == null) {
                if (ProfileRowComponent.this.result.getCreateStartTime() >= 0L) {
                    ProfileRowComponent.this.statusLabel.setText(ProfileRowComponent.this.result.toString());
                    ProfileRowComponent.this.statusLabel.setForeground(null);
                } else {
                    ProfileRowComponent.this.statusLabel.setText("Waiting to be profiled...");
                    ProfileRowComponent.this.statusLabel.setForeground(null);
                }
            } else if (evt.getPropertyName().equals("exception")) {
                ProfileRowComponent.this.statusLabel.setText("Failed: " + ProfileRowComponent.this.result.getException().getMessage());
                ProfileRowComponent.this.statusLabel.setForeground(Color.RED);
            }
        }
    };
    private boolean selected = false;
    private List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    private final JProgressBar progressBar = new JProgressBar();
    private final List<ProfileChangeListener> profileListeners = new ArrayList<ProfileChangeListener>();

    private void showProfile(Object source) {
        if (this.getResult().getException() != null) {
            ASUtils.showExceptionDialogNoReport(this, "Profiling failed for table " + this.getResult().getProfiledObject(), this.getResult().getException());
        } else if (this.getResult().getProgressMonitor().isFinished() && !this.getResult().getProgressMonitor().isCancelled() && !(source instanceof JButton)) {
            ProfileResultsViewer profileResultsViewer = new ProfileResultsViewer((ProfileManagerImpl)this.pm);
            profileResultsViewer.clearScanList();
            profileResultsViewer.addTableProfileResultToScan(this.result);
            profileResultsViewer.addTableProfileResult(this.result);
            profileResultsViewer.getDialog().setVisible(true);
        }
    }

    public ProfileRowComponent(final TableProfileResult result, final ProfileManager pm) {
        super(new RowComponentLayout(5, 5));
        this.result = result;
        this.pm = pm;
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setBackground(Color.WHITE);
        this.add((Component)new JLabel(tableIcon), (Object)ComponentType.ICON);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ProfileRowComponent.this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                logger.debug((Object)("Focus lost on " + ((SQLTable)result.getProfiledObject()).getName() + " bounds are " + ProfileRowComponent.this.getBounds()));
            }

            @Override
            public void focusGained(FocusEvent e) {
                ProfileRowComponent.this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                logger.debug((Object)("Focus gained on " + ((SQLTable)result.getProfiledObject()).getName() + " bounds are " + ProfileRowComponent.this.getBounds()));
            }
        });
        this.reProfileButton = new JButton(refreshIcon);
        this.reProfileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pm.asynchCreateProfiles(Collections.singletonList(result.getProfiledObject()));
            }
        });
        this.cancelButton = new JButton(stopIcon);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                result.getProgressMonitor().setCancelled(true);
                logger.debug((Object)"STOP");
            }
        });
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug((Object)("ProfileRowComponent: DELETE object: " + result));
                pm.removeProfile(result);
            }
        };
        this.deleteButton = new JButton(deleteAction);
        this.deleteButton.setIcon(deleteIcon);
        this.add((Component)this.deleteButton, (Object)ComponentType.DELETE);
        SQLTable table = (SQLTable)result.getProfiledObject();
        StringBuilder tableName = new StringBuilder();
        if (table.getCatalog() != null) {
            tableName.append(table.getCatalogName()).append(".");
        }
        if (table.getSchema() != null) {
            tableName.append(table.getSchemaName()).append(".");
        }
        tableName.append(table.getName());
        this.add((Component)new JLabel(tableName.toString()), (Object)ComponentType.TABLE_NAME);
        this.add((Component)new JLabel("(" + table.getParentDatabase().getName() + ")"), (Object)ComponentType.CONNECTION_NAME);
        this.add((Component)this.reProfileButton, (Object)ComponentType.RELOAD);
        ProgressWatcher pw = new ProgressWatcher(this.progressBar, result.getProgressMonitor());
        pw.setHideLabelWhenFinished(true);
        pw.setHideProgressBarWhenFinished(true);
        pw.start();
        result.addProfileResultListener(this.profileResultListener);
        result.addSPListener(this.profileStartedListener);
        this.add((Component)this.progressBar, (Object)ComponentType.PROGRESS_BAR);
        this.statusLabel.setVisible(false);
        this.add((Component)this.statusLabel, (Object)ComponentType.TABLE_INFO);
        this.add((Component)this.cancelButton, (Object)ComponentType.CANCEL);
        this.addMouseListener(new ProfileRowMouseListener());
        this.profileResultListener.profileFinished(null);
    }

    public TableProfileResult getResult() {
        return this.result;
    }

    @Override
    public void setSelected(boolean v, int selectionType) {
        logger.debug((Object)("Is this profile row component focusable? " + this.isFocusable()));
        logger.debug((Object)("Does this panel have focus? " + this.isFocusOwner()));
        if (v) {
            this.requestFocusInWindow();
        }
        this.selected = v;
        this.setBackground(this.selected ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("List.background"));
        this.fireSelectionEvent(new SelectionEvent(this, this.selected ? 1 : 2, selectionType));
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        this.listeners.remove(l);
    }

    public void fireSelectionEvent(SelectionEvent e) {
        for (SelectionListener listener : this.listeners) {
            if (e.getType() == 1) {
                listener.itemSelected(e);
                continue;
            }
            listener.itemDeselected(e);
        }
    }

    public void addProfileChangeListener(ProfileChangeListener pcl) {
        this.profileListeners.add(pcl);
    }

    public void removeProfileChangeListener(ProfileChangeListener pcl) {
        this.profileListeners.remove(pcl);
    }

    private void fireProfileChangedEvent() {
        ProfileChangeEvent e = new ProfileChangeEvent(this.pm, this.pm.getResults());
        for (int i = this.profileListeners.size() - 1; i >= 0; --i) {
            this.profileListeners.get(i).profileListChanged(e);
        }
    }

    @Override
    public String toString() {
        return ((SQLTable)this.result.getProfiledObject()).getName() + " with status " + this.statusLabel.getText();
    }

    private class ProfileRowMouseListener
    extends MouseAdapter {
        private ProfileRowMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            Object obj = evt.getSource();
            if (evt.getButton() == 1) {
                if (evt.getClickCount() == 2) {
                    ProfileRowComponent.this.showProfile(obj);
                } else if ((evt.getModifiersEx() & SPSUtils.MULTISELECT_MASK) != 0) {
                    ProfileRowComponent.this.setSelected(!ProfileRowComponent.this.selected, 8);
                } else if ((evt.getModifiersEx() & 0x40) != 0) {
                    ProfileRowComponent.this.setSelected(true, 16);
                } else {
                    ProfileRowComponent.this.setSelected(true, 4);
                }
            }
        }
    }

    private static class RowComponentLayout
    implements LayoutManager2 {
        private int xGap;
        private int yGap;
        private Component icon;
        private Component tableName;
        private Component connectionName;
        private Component tableInfo;
        private Component progressBar;
        private Component reload;
        private Component cancel;
        private Component delete;

        public RowComponentLayout(int xGap, int yGap) {
            logger.debug((Object)"RowComponentLayout constructed");
            this.xGap = xGap;
            this.yGap = yGap;
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            ComponentType type = (ComponentType)((Object)constraints);
            switch (type) {
                case ICON: {
                    this.icon = comp;
                    break;
                }
                case TABLE_NAME: {
                    this.tableName = comp;
                    break;
                }
                case CONNECTION_NAME: {
                    this.connectionName = comp;
                    break;
                }
                case TABLE_INFO: {
                    this.tableInfo = comp;
                    break;
                }
                case PROGRESS_BAR: {
                    this.progressBar = comp;
                    break;
                }
                case RELOAD: {
                    this.reload = comp;
                    break;
                }
                case CANCEL: {
                    this.cancel = comp;
                    break;
                }
                case DELETE: {
                    this.delete = comp;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown constraint given to RowCompnentLayout");
                }
            }
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.addLayoutComponent(comp, name);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y;
            int x;
            Dimension preferredSize;
            logger.debug((Object)"layoutContainer called");
            JComponent p = (JComponent)parent;
            Insets inset = p.getBorder().getBorderInsets(p);
            int height = parent.getHeight() + inset.top;
            int width = parent.getWidth() + inset.left;
            int stretchyPreferredWidth = width - inset.left - inset.right - 4 * this.xGap - this.icon.getPreferredSize().width - 2 * this.reload.getPreferredSize().width;
            if (this.icon != null) {
                preferredSize = this.icon.getPreferredSize();
                x = inset.left;
                y = height / 2 - preferredSize.height / 2;
                this.icon.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.tableName != null) {
                int preferredWidth = Math.min(stretchyPreferredWidth, this.tableName.getPreferredSize().width);
                Dimension preferredSize2 = new Dimension(preferredWidth, this.tableName.getPreferredSize().height);
                int x2 = inset.left + this.icon.getPreferredSize().width + this.xGap;
                int y2 = height / 2 - this.yGap / 2 - preferredSize2.height;
                this.tableName.setBounds(x2, y2, preferredSize2.width, preferredSize2.height);
            }
            if (this.connectionName != null) {
                preferredSize = new Dimension(stretchyPreferredWidth - this.tableName.getPreferredSize().width, this.connectionName.getPreferredSize().height);
                x = inset.left + this.icon.getPreferredSize().width + this.xGap + this.tableName.getPreferredSize().width + this.xGap;
                y = height / 2 - this.yGap / 2 - preferredSize.height;
                this.connectionName.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.tableInfo != null) {
                preferredSize = new Dimension(stretchyPreferredWidth, this.tableInfo.getPreferredSize().height);
                x = inset.left + this.icon.getPreferredSize().width + this.xGap;
                y = height / 2 + this.yGap / 2;
                this.tableInfo.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.progressBar != null) {
                preferredSize = new Dimension(stretchyPreferredWidth, this.progressBar.getPreferredSize().height);
                x = inset.left + this.icon.getPreferredSize().width + this.xGap;
                y = height / 2 + this.yGap / 2;
                this.progressBar.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.delete != null) {
                preferredSize = this.delete.getPreferredSize();
                x = width - inset.right - preferredSize.width;
                y = height / 2 - preferredSize.height / 2;
                this.delete.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.cancel != null) {
                preferredSize = this.cancel.getPreferredSize();
                x = width - inset.right - preferredSize.width;
                y = height / 2 - preferredSize.height / 2;
                this.cancel.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.reload != null) {
                preferredSize = this.reload.getPreferredSize();
                x = width - inset.right - this.cancel.getPreferredSize().width - this.xGap - preferredSize.width;
                y = height / 2 - preferredSize.height / 2;
                this.reload.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(this.icon.getMinimumSize().width + 3 * this.xGap + Math.max(this.progressBar.getMinimumSize().width, this.tableName.getMinimumSize().width + this.xGap + this.connectionName.getMinimumSize().width) + 2 * this.reload.getMinimumSize().width, this.tableName.getMinimumSize().height + this.yGap + this.progressBar.getMinimumSize().height);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JComponent p = (JComponent)parent;
            Insets inset = p.getBorder().getBorderInsets(p);
            int maxOfBarAndInfo = Math.max(this.progressBar.getPreferredSize().width, this.tableInfo.getPreferredSize().width);
            return new Dimension(this.icon.getPreferredSize().width + 3 * this.xGap + Math.max(maxOfBarAndInfo, this.tableName.getPreferredSize().width + this.xGap + this.connectionName.getPreferredSize().width) + 2 * this.reload.getPreferredSize().width + inset.left + inset.right, this.tableName.getPreferredSize().height + this.yGap + this.progressBar.getPreferredSize().height + inset.top + inset.bottom);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private static enum ComponentType {
        ICON,
        TABLE_NAME,
        CONNECTION_NAME,
        TABLE_INFO,
        PROGRESS_BAR,
        RELOAD,
        CANCEL,
        DELETE;

    }
}

