/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.hll;

class NumberUtil {
    public static final double LOGE_2 = 0.6931471805599453;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    NumberUtil() {
    }

    public static double log2(double value) {
        return Math.log(value) / 0.6931471805599453;
    }

    public static String toHex(byte[] bytes, int offset, int count) {
        if (offset >= bytes.length) {
            throw new IllegalArgumentException("Offset is greater than the length (" + offset + " >= " + bytes.length + ").");
        }
        int byteCount = Math.min(bytes.length - offset, count);
        int upperBound = byteCount + offset;
        char[] chars = new char[byteCount * 2];
        int charIndex = 0;
        for (int i = offset; i < upperBound; ++i) {
            byte value = bytes[i];
            chars[charIndex++] = HEX[value >>> 4 & 0xF];
            chars[charIndex++] = HEX[value & 0xF];
        }
        return new String(chars);
    }

    public static byte[] fromHex(String string, int offset, int count) {
        if (offset >= string.length()) {
            throw new IllegalArgumentException("Offset is greater than the length (" + offset + " >= " + string.length() + ").");
        }
        if ((count & 1) != 0) {
            throw new IllegalArgumentException("Count is not divisible by two (" + count + ").");
        }
        int charCount = Math.min(string.length() - offset, count);
        int upperBound = offset + charCount;
        byte[] bytes = new byte[charCount >>> 1];
        int byteIndex = 0;
        for (int i = offset; i < upperBound; i += 2) {
            bytes[byteIndex++] = (byte)((NumberUtil.digit(string.charAt(i)) << 4 | NumberUtil.digit(string.charAt(i + 1))) & 0xFF);
        }
        return bytes;
    }

    private static final int digit(char character) {
        switch (character) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Character is not in [a-fA-F0-9] ('" + character + "').");
    }
}

