/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp.tools;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.lemmatizer.DictionaryLemmatizer;
import opennlp.tools.lemmatizer.LemmatizerME;
import opennlp.tools.lemmatizer.LemmatizerModel;

public class NLPLemmatizerOp {
    private final DictionaryLemmatizer dictionaryLemmatizer;
    private final LemmatizerME lemmatizerME;

    public NLPLemmatizerOp(InputStream dictionary, LemmatizerModel lemmatizerModel) throws IOException {
        assert (dictionary != null || lemmatizerModel != null) : "At least one parameter must be non-null";
        this.dictionaryLemmatizer = dictionary == null ? null : new DictionaryLemmatizer(dictionary);
        this.lemmatizerME = lemmatizerModel == null ? null : new LemmatizerME(lemmatizerModel);
    }

    public String[] lemmatize(String[] words, String[] postags) {
        String[] lemmas = null;
        String[] maxEntLemmas = null;
        if (this.dictionaryLemmatizer != null) {
            lemmas = this.dictionaryLemmatizer.lemmatize(words, postags);
            for (int i = 0; i < lemmas.length; ++i) {
                if (!lemmas[i].equals("O")) continue;
                if (this.lemmatizerME != null) {
                    if (maxEntLemmas == null) {
                        maxEntLemmas = this.lemmatizerME.lemmatize(words, postags);
                    }
                    if ("_".equals(maxEntLemmas[i])) {
                        lemmas[i] = words[i];
                        continue;
                    }
                    lemmas[i] = maxEntLemmas[i];
                    continue;
                }
                lemmas[i] = words[i];
            }
        } else {
            maxEntLemmas = this.lemmatizerME.lemmatize(words, postags);
            for (int i = 0; i < maxEntLemmas.length; ++i) {
                if (!"_".equals(maxEntLemmas[i])) continue;
                maxEntLemmas[i] = words[i];
            }
            lemmas = maxEntLemmas;
        }
        return lemmas;
    }
}

