/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import opennlp.tools.namefind.RegexNameFinder;

public class RegexNameFinderFactory {
    public static synchronized RegexNameFinder getDefaultRegexNameFinders(Map<String, Pattern[]> config, DEFAULT_REGEX_NAME_FINDER ... defaults) {
        Objects.requireNonNull(config, "config must not be null");
        HashMap<String, Pattern[]> defaultsToMap = new HashMap<String, Pattern[]>();
        if (defaults != null) {
            defaultsToMap = RegexNameFinderFactory.defaultsToMap(defaults);
        }
        defaultsToMap.putAll(config);
        return new RegexNameFinder(defaultsToMap);
    }

    public static synchronized RegexNameFinder getDefaultRegexNameFinders(DEFAULT_REGEX_NAME_FINDER ... defaults) {
        Objects.requireNonNull(defaults, "defaults must not be null");
        return new RegexNameFinder(RegexNameFinderFactory.defaultsToMap(defaults));
    }

    private static synchronized Map<String, Pattern[]> defaultsToMap(DEFAULT_REGEX_NAME_FINDER ... defaults) {
        HashMap<String, Pattern[]> regexMap = new HashMap<String, Pattern[]>();
        for (DEFAULT_REGEX_NAME_FINDER def : defaults) {
            regexMap.putAll(def.getRegexMap());
        }
        return regexMap;
    }

    public static enum DEFAULT_REGEX_NAME_FINDER implements RegexAble
    {
        USA_PHONE_NUM{

            @Override
            public Map<String, Pattern[]> getRegexMap() {
                Pattern[] p = new Pattern[]{Pattern.compile("((\\(\\d{3}\\) ?)|(\\d{3}-))?\\d{3}-\\d{4}")};
                HashMap<String, Pattern[]> regexMap = new HashMap<String, Pattern[]>();
                regexMap.put(this.getType(), p);
                return regexMap;
            }

            @Override
            public String getType() {
                return "PHONE_NUM";
            }
        }
        ,
        EMAIL{

            @Override
            public Map<String, Pattern[]> getRegexMap() {
                Pattern[] p = new Pattern[]{Pattern.compile("([a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9]([a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", 2)};
                HashMap<String, Pattern[]> regexMap = new HashMap<String, Pattern[]>();
                regexMap.put(this.getType(), p);
                return regexMap;
            }

            @Override
            public String getType() {
                return "EMAIL";
            }
        }
        ,
        URL{

            @Override
            public Map<String, Pattern[]> getRegexMap() {
                Pattern[] p = new Pattern[]{Pattern.compile("\\b(((ht|f)tp(s?)\\:\\/\\/|~\\/|\\/)|www.)(\\w+:\\w+@)?(([-\\w]+\\.)+(com|org|net|gov|mil|biz|info|mobi|name|aero|jobs|museum|travel|[a-z]{2}))(:[\\d]{1,5})?(((\\/([-\\w~!$+|.,=]|%[a-f\\d]{2})+)+|\\/)+|\\?|#)?((\\?([-\\w~!$+|.,*:]|%[a-f\\d{2}])+=?([-\\w~!$+|.,*:=]|%[a-f\\d]{2})*)(&(?:[-\\w~!$+|.,*:]|%[a-f\\d{2}])+=?([-\\w~!$+|.,*:=]|%[a-f\\d]{2})*)*)*(#([-\\w~!$+|.,*:=]|%[a-f\\d]{2})*)?\\b", 2)};
                HashMap<String, Pattern[]> regexMap = new HashMap<String, Pattern[]>();
                regexMap.put(this.getType(), p);
                return regexMap;
            }

            @Override
            public String getType() {
                return "URL";
            }
        }
        ,
        MGRS{

            @Override
            public Map<String, Pattern[]> getRegexMap() {
                Pattern[] p = new Pattern[]{Pattern.compile("\\d{1,2}[A-Za-z]\\s*[A-Za-z]{2}\\s*\\d{1,5}\\s*\\d{1,5}", 2)};
                HashMap<String, Pattern[]> regexMap = new HashMap<String, Pattern[]>();
                regexMap.put(this.getType(), p);
                return regexMap;
            }

            @Override
            public String getType() {
                return "MGRS";
            }
        }
        ,
        DEGREES_MIN_SEC_LAT_LON{

            @Override
            public Map<String, Pattern[]> getRegexMap() {
                Pattern[] p = new Pattern[]{Pattern.compile("([-|\\+]?\\d{1,3}[d|D|\\u00B0|\\s](\\s*\\d{1,2}['|\\u2019|\\s])?(\\s*\\d{1,2}[\\\"|\\u201d])?\\s*[N|n|S|s]?)(\\s*|,|,\\s*)([-|\\+]?\\d{1,3}[d|D|\\u00B0|\\s](\\s*\\d{1,2}['|\\u2019|\\s])?(\\s*\\d{1,2}[\\\"|\\u201d])?\\s*[E|e|W|w]?)", 2)};
                HashMap<String, Pattern[]> regexMap = new HashMap<String, Pattern[]>();
                regexMap.put(this.getType(), p);
                return regexMap;
            }

            @Override
            public String getType() {
                return "DEGREES_MIN_SEC_LAT_LON";
            }
        };

    }

    public static interface RegexAble {
        public Map<String, Pattern[]> getRegexMap();

        public String getType();
    }
}

