/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;

public interface ClusterStateProvider
extends SolrCloseable {
    public ClusterState.CollectionRef getState(String var1);

    public Set<String> getLiveNodes();

    public List<String> resolveAlias(String var1);

    public Map<String, String> getAliasProperties(String var1);

    default public String resolveSimpleAlias(String alias) throws IllegalArgumentException {
        List<String> aliases = this.resolveAlias(alias);
        if (aliases.size() > 1) {
            throw new IllegalArgumentException("Simple alias '" + alias + "' points to more than 1 collection: " + aliases);
        }
        return aliases.get(0);
    }

    default public boolean isRoutedAlias(String alias) {
        return this.getAliasProperties(alias).entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith("router."));
    }

    public ClusterState getClusterState() throws IOException;

    default public DocCollection getCollection(String name) throws IOException {
        return this.getClusterState().getCollectionOrNull(name);
    }

    public Map<String, Object> getClusterProperties();

    default public <T> T getClusterProperty(String key, T defaultValue) {
        Object value = this.getClusterProperties().get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    default public <T> T getClusterProperty(String propertyName) {
        return (T)this.getClusterProperties().get(propertyName);
    }

    public String getPolicyNameByCollection(String var1);

    public void connect();
}

