/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import org.apache.lucene.index.IndexCommit;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.snapshots.SolrSnapshotMetaDataManager;
import org.apache.solr.handler.admin.CoreAdminHandler;

class CreateSnapshotOp
implements CoreAdminHandler.CoreAdminOp {
    CreateSnapshotOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String commitName = params.required().get("commitName");
        String cname = params.required().get("core");
        CoreContainer cc = it.handler.getCoreContainer();
        try (SolrCore core = cc.getCore(cname);){
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + cname);
            }
            String indexDirPath = core.getIndexDir();
            IndexDeletionPolicyWrapper delPol = core.getDeletionPolicy();
            IndexCommit ic = delPol.getAndSaveLatestCommit();
            try {
                if (null == ic) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No index commits to snapshot in core " + cname);
                }
                SolrSnapshotMetaDataManager mgr = core.getSnapshotMetaDataManager();
                mgr.snapshot(commitName, indexDirPath, ic.getGeneration());
                it.rsp.add("core", core.getName());
                it.rsp.add("commitName", commitName);
                it.rsp.add("indexDirPath", indexDirPath);
                it.rsp.add("generation", ic.getGeneration());
                it.rsp.add("files", ic.getFileNames());
            }
            finally {
                delPol.releaseCommitPoint(ic);
            }
        }
    }
}

