/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MutableMemBuffer;
import ghidra.util.GhidraBigEndianDataConverter;
import ghidra.util.GhidraLittleEndianDataConverter;
import java.math.BigInteger;

public class MemoryBufferImpl
implements MutableMemBuffer {
    private static final int DEFAULT_BUFSIZE = 1024;
    private static final int THRESH = 8;
    private Memory mem;
    private Address startAddr;
    private byte[] buffer;
    private int startAddrIndex = 0;
    private int minOffset = 0;
    private int maxOffset = -1;

    public MemoryBufferImpl(Memory mem, Address addr) {
        this(mem, addr, 1024);
    }

    public MemoryBufferImpl(Memory mem, Address addr, int bufSize) {
        this.mem = mem;
        this.buffer = new byte[bufSize];
        this.setPosition(addr);
    }

    @Override
    public MemoryBufferImpl clone() {
        return new MemoryBufferImpl(this.mem, this.startAddr, this.buffer.length);
    }

    @Override
    public void advance(int displacement) throws AddressOverflowException {
        Address addr = this.startAddr.addNoWrap(displacement);
        this.setPosition(addr);
    }

    @Override
    public void setPosition(Address addr) {
        long diff;
        if (this.minOffset <= this.maxOffset && addr.getAddressSpace().equals(this.startAddr.getAddressSpace()) && (diff = addr.subtract(this.startAddr)) >= (long)this.minOffset && diff < (long)(this.maxOffset - 8)) {
            this.startAddr = addr;
            this.minOffset -= (int)diff;
            this.maxOffset -= (int)diff;
            this.startAddrIndex = (int)((long)this.startAddrIndex + diff);
            return;
        }
        this.startAddr = addr;
        this.startAddrIndex = 0;
        this.minOffset = 0;
        this.maxOffset = -1;
        try {
            this.maxOffset = this.mem.getBytes(addr, this.buffer, 0, this.buffer.length) - 1;
        }
        catch (AddressOutOfBoundsException | MemoryAccessException object) {
            // empty catch block
        }
    }

    @Override
    public byte getByte(int offset) throws MemoryAccessException {
        if (offset >= this.minOffset && offset <= this.maxOffset) {
            return this.buffer[this.startAddrIndex + offset];
        }
        try {
            Address addr = this.startAddr.addNoWrap(offset);
            int nRead = this.mem.getBytes(addr, this.buffer, 0, this.buffer.length);
            this.startAddrIndex = -offset;
            this.minOffset = offset;
            this.maxOffset = offset + nRead - 1;
            return this.buffer[0];
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException(e.getMessage());
        }
    }

    @Override
    public Address getAddress() {
        return this.startAddr;
    }

    @Override
    public Memory getMemory() {
        return this.mem;
    }

    @Override
    public int getBytes(byte[] b, int offset) {
        if (offset >= this.minOffset && b.length + offset <= this.maxOffset) {
            System.arraycopy(this.buffer, this.startAddrIndex + offset, b, 0, b.length);
            return b.length;
        }
        try {
            return this.mem.getBytes(this.startAddr.addNoWrap(offset), b);
        }
        catch (AddressOverflowException | MemoryAccessException e) {
            return 0;
        }
    }

    @Override
    public boolean isBigEndian() {
        return this.mem.isBigEndian();
    }

    @Override
    public short getShort(int offset) throws MemoryAccessException {
        if (this.mem.isBigEndian()) {
            return GhidraBigEndianDataConverter.INSTANCE.getShort(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getShort(this, offset);
    }

    @Override
    public int getInt(int offset) throws MemoryAccessException {
        if (this.mem.isBigEndian()) {
            return GhidraBigEndianDataConverter.INSTANCE.getInt(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getInt(this, offset);
    }

    @Override
    public long getLong(int offset) throws MemoryAccessException {
        if (this.mem.isBigEndian()) {
            return GhidraBigEndianDataConverter.INSTANCE.getLong(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getLong(this, offset);
    }

    @Override
    public BigInteger getBigInteger(int offset, int size, boolean signed) throws MemoryAccessException {
        if (this.mem.isBigEndian()) {
            return GhidraBigEndianDataConverter.INSTANCE.getBigInteger(this, offset, size, signed);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getBigInteger(this, offset, size, signed);
    }
}

