/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceImpl;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.LinkedList;
import java.util.List;

public class SubroutineDestReferenceIterator
implements CodeBlockReferenceIterator {
    private LinkedList<CodeBlockReference> blockRefQueue = new LinkedList();
    private TaskMonitor monitor;

    public SubroutineDestReferenceIterator(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        this.monitor = monitor;
        SubroutineDestReferenceIterator.getDestinations(block, this.blockRefQueue, monitor);
    }

    @Override
    public CodeBlockReference next() throws CancelledException {
        this.monitor.checkCanceled();
        return this.blockRefQueue.isEmpty() ? null : this.blockRefQueue.removeFirst();
    }

    @Override
    public boolean hasNext() throws CancelledException {
        this.monitor.checkCanceled();
        return !this.blockRefQueue.isEmpty();
    }

    public static int getNumDestinations(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        return SubroutineDestReferenceIterator.getDestinations(block, null, monitor);
    }

    private static int getDestinations(CodeBlock block, List<CodeBlockReference> blockRefQueue, TaskMonitor monitor) throws CancelledException {
        if (block == null || block.getMinAddress() == null) {
            return 0;
        }
        int count = 0;
        CodeBlockModel model = block.getModel();
        boolean includeExternals = model.externalsIncluded();
        CodeBlockIterator bblockIter = model.getBasicBlockModel().getCodeBlocksContaining(block, monitor);
        while (bblockIter.hasNext()) {
            CodeBlock bblock = bblockIter.next();
            CodeBlockReferenceIterator bbDestIter = bblock.getDestinations(monitor);
            while (bbDestIter.hasNext()) {
                CodeBlockReference bbDestRef = bbDestIter.next();
                FlowType refFlowType = bbDestRef.getFlowType();
                Address destAddr = bbDestRef.getReference();
                boolean addBlockRef = false;
                if (destAddr.isExternalAddress()) {
                    if (includeExternals) {
                        addBlockRef = true;
                    }
                } else if (refFlowType.isCall()) {
                    addBlockRef = true;
                } else if ((refFlowType.isJump() || refFlowType.isFallthrough()) && !block.contains(destAddr)) {
                    addBlockRef = true;
                }
                if (!addBlockRef) continue;
                SubroutineDestReferenceIterator.queueDestReferences(blockRefQueue, block, bbDestRef.getReferent(), destAddr, refFlowType);
                ++count;
            }
        }
        return count;
    }

    private static void queueDestReferences(List<CodeBlockReference> blockRefQueue, CodeBlock srcBlock, Address srcAddr, Address destAddr, FlowType flowType) {
        if (blockRefQueue != null) {
            CodeBlockReferenceImpl blockRef = new CodeBlockReferenceImpl(srcBlock, null, flowType, destAddr, srcAddr);
            blockRefQueue.add(blockRef);
        }
    }
}

