/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.Record;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.symbol.VariableStorageManagerDB;
import ghidra.program.database.symbol.VariableSymbolDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SymbolType;

public class GlobalVariableSymbolDB
extends VariableSymbolDB {
    public GlobalVariableSymbolDB(SymbolManager symbolMgr, DBObjectCache<SymbolDB> cache, VariableStorageManagerDB variableMgr, Address address, Record record) {
        super(symbolMgr, cache, SymbolType.GLOBAL_VAR, variableMgr, address, record);
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.GLOBAL_VAR;
    }

    @Override
    public Object getObject() {
        if (!this.checkIsValid()) {
            return null;
        }
        VariableStorage storage = this.getVariableStorage();
        if (storage == null) {
            return null;
        }
        return storage.getRegister();
    }

    @Override
    public String getName() {
        if (!this.checkIsValid()) {
            return "[Invalid VariableSymbol - Deleted!]";
        }
        VariableStorage storage = this.getVariableStorage();
        if (storage == null) {
            return "local__!BAD!";
        }
        return super.getName();
    }
}

