/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.app.MainPanel;
import org.catacombae.jparted.app.MainWindow;
import org.catacombae.jparted.lib.RandomAccessFileDataLocator;
import org.catacombae.jparted.lib.ps.Partition;
import org.catacombae.jparted.lib.ps.PartitionSystemHandler;
import org.catacombae.jparted.lib.ps.PartitionSystemHandlerFactory;
import org.catacombae.jparted.lib.ps.PartitionSystemRecognizer;
import org.catacombae.jparted.lib.ps.PartitionSystemType;

public class MainController {
    private MainWindow mainWindow;
    private MainPanel mainPanel;
    LinkedList<PartitionSystemHandler> psHandlers = new LinkedList();

    public MainController() {
        this.mainPanel = new MainPanel();
        this.mainWindow = new MainWindow(this.mainPanel);
        this.mainWindow.setLoadFileItemListener(new LoadFileItemListener());
        this.mainWindow.setExitItemListener(new ExitItemListener());
        this.mainWindow.setAboutItemListener(new AboutItemListener());
        this.mainPanel.setPartitionSystemsBoxListener(new PartitionSystemsBoxListener());
        this.mainPanel.setSynchronizeButtonListener(new SynchronizeButtonListener());
        this.mainWindow.setDefaultCloseOperation(3);
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public void showMainWindow() {
        this.mainPanel.setPartitionSystemsBoxContents(new Vector<String>());
        this.mainPanel.setPartitionSystemsBoxEnabled(false);
        this.mainPanel.setSynchronizeButtonEnabled(false);
        this.mainWindow.setVisible(true);
    }

    private void exitProgram() {
        this.mainWindow.setVisible(false);
        System.exit(0);
    }

    private class SynchronizeButtonListener
    implements ActionListener {
        private SynchronizeButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    private class PartitionSystemsBoxListener
    implements ActionListener {
        private PartitionSystemsBoxListener() {
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    private class AboutItemListener
    implements ActionListener {
        private AboutItemListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            JOptionPane.showMessageDialog(MainController.this.mainPanel, "jParted 0.1", "About", 1);
        }
    }

    private class ExitItemListener
    implements ActionListener {
        private ExitItemListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            MainController.this.exitProgram();
        }
    }

    private class LoadFileItemListener
    implements ActionListener {
        private LoadFileItemListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            if (fileChooser.showOpenDialog(MainController.this.mainPanel) == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                RandomAccessFileDataLocator loc = new RandomAccessFileDataLocator(selectedFile);
                Vector<PartitionSystemHandler> detectedPartitionSystems = new Vector<PartitionSystemHandler>();
                Vector<String> detectedPartitionSystemDescriptions = new Vector<String>();
                for (PartitionSystemType curType : PartitionSystemType.values()) {
                    PartitionSystemHandlerFactory fac;
                    if (!curType.isTopLevelCapable() || (fac = curType.createDefaultHandlerFactory()) == null) continue;
                    PartitionSystemRecognizer recognizer = fac.getRecognizer();
                    ReadableRandomAccessStream stream = loc.createReadOnlyFile();
                    long streamLength = -1L;
                    try {
                        streamLength = stream.length();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!recognizer.detect(stream, 0L, streamLength)) continue;
                    PartitionSystemHandler handler = fac.createHandler(loc);
                    detectedPartitionSystems.add(fac.createHandler(loc));
                    detectedPartitionSystemDescriptions.add(fac.getInfo().getPartitionSystemName() + " (" + handler.getPartitionCount() + " partitions)");
                }
                if (detectedPartitionSystemDescriptions.size() > 0) {
                    MainController.this.mainPanel.setPartitionSystemsBoxEnabled(true);
                    MainController.this.mainPanel.setPartitionSystemsBoxContents(detectedPartitionSystemDescriptions);
                } else {
                    MainController.this.mainPanel.setPartitionSystemsBoxEnabled(false);
                }
                MainController.this.mainPanel.clearPartitionList();
                if (detectedPartitionSystems.size() > 0) {
                    PartitionSystemHandler handler = (PartitionSystemHandler)detectedPartitionSystems.get(0);
                    Partition[] partitions = handler.getPartitions();
                    int i = 0;
                    for (Partition p : partitions) {
                        MainController.this.mainPanel.addPartition("" + (i++ + 1), p.getType().toString(), "", "" + p.getStartOffset(), p.getStartOffset() + p.getLength() + "");
                    }
                } else {
                    JOptionPane.showMessageDialog(MainController.this.mainPanel, "No partition systems found.", "Info", 1);
                }
            }
        }
    }
}

