/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import org.apache.commons.collections4.map.ReferenceMap;

public class FileFingerprintCache {
    private ReferenceMap<FileFingerprintRec, String> fileFingerprintToMD5Map = new ReferenceMap();

    public synchronized void clear() {
        this.fileFingerprintToMD5Map.clear();
    }

    public synchronized void add(String path, String md5, long timestamp, long length) {
        this.fileFingerprintToMD5Map.put((Object)new FileFingerprintRec(path, timestamp, length), (Object)md5);
    }

    public synchronized boolean contains(String path, String md5, long timestamp, long length) {
        String prevMD5 = (String)this.fileFingerprintToMD5Map.get((Object)new FileFingerprintRec(path, timestamp, length));
        return prevMD5 != null && prevMD5.equals(md5);
    }

    public synchronized String getMD5(String path, long timestamp, long length) {
        String prevMD5 = (String)this.fileFingerprintToMD5Map.get((Object)new FileFingerprintRec(path, timestamp, length));
        return prevMD5;
    }

    static class FileFingerprintRec {
        final String path;
        final long timestamp;
        final long length;

        FileFingerprintRec(String path, long timestamp, long length) {
            this.path = path;
            this.timestamp = timestamp;
            this.length = length;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.length ^ this.length >>> 32);
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FileFingerprintRec)) {
                return false;
            }
            FileFingerprintRec other = (FileFingerprintRec)obj;
            if (this.length != other.length) {
                return false;
            }
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return this.timestamp == other.timestamp;
        }
    }
}

