/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.SimpleDiffUtility;
import java.math.BigInteger;

public class AddressIndexMapConverter
extends AddressIndexMap {
    AddressIndexMap addressIndexMap;
    Program mapProgram;
    Program otherProgram;

    public AddressIndexMapConverter(AddressIndexMap addressIndexMap, Program mapProgram, Program otherProgram) {
        if (mapProgram == otherProgram) {
            throw new RuntimeException();
        }
        this.addressIndexMap = addressIndexMap;
        this.mapProgram = mapProgram;
        this.otherProgram = otherProgram;
    }

    @Override
    public Address getAddress(BigInteger index) {
        Address mapAddress = this.addressIndexMap.getAddress(index);
        return SimpleDiffUtility.getCompatibleAddress((Program)this.mapProgram, (Address)mapAddress, (Program)this.otherProgram);
    }

    @Override
    public AddressSetView getOriginalAddressSet() {
        return DiffUtility.getCompatibleAddressSet(this.addressIndexMap.getOriginalAddressSet(), this.otherProgram);
    }

    @Override
    public AddressSetView getIndexedAddressSet() {
        return DiffUtility.getCompatibleAddressSet(this.addressIndexMap.getIndexedAddressSet(), this.otherProgram);
    }

    @Override
    public AddressSet getAddressSet(FieldSelection sel) {
        return DiffUtility.getCompatibleAddressSet((AddressSetView)this.addressIndexMap.getAddressSet(sel), this.otherProgram);
    }

    @Override
    public FieldSelection getFieldSelection(AddressSetView set) {
        AddressSet mapSet = DiffUtility.getCompatibleAddressSet(set, this.mapProgram);
        return this.addressIndexMap.getFieldSelection((AddressSetView)mapSet);
    }

    private Address getMapAddress(Address addr) {
        AddressSpace locAddressSpace = addr.getAddressSpace();
        AddressSpace programAddressSpace = this.mapProgram.getAddressFactory().getAddressSpace(locAddressSpace.getUniqueSpaceID());
        Address mapAddress = programAddressSpace == locAddressSpace ? addr : SimpleDiffUtility.getCompatibleAddress((Program)this.otherProgram, (Address)addr, (Program)this.mapProgram);
        return mapAddress;
    }

    @Override
    public BigInteger getIndex(Address addr) {
        Address mapAddress = this.getMapAddress(addr);
        return this.addressIndexMap.getIndex(mapAddress);
    }

    @Override
    public BigInteger getMaxIndex(Address addr) {
        Address mapAddress = this.getMapAddress(addr);
        return this.addressIndexMap.getMaxIndex(mapAddress);
    }

    @Override
    public BigInteger getMinIndex(Address addr) {
        Address mapAddress = this.getMapAddress(addr);
        return this.addressIndexMap.getMinIndex(mapAddress);
    }
}

