/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_ProtocolMethod;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ObjectiveC1_ProtocolMethodList
implements StructConverter {
    public static final String NAME = "objc_protocol_method_list";
    private ObjectiveC1_State _state;
    private long _index;
    private int method_count;
    private List<ObjectiveC1_ProtocolMethod> method_list = new ArrayList<ObjectiveC1_ProtocolMethod>();

    ObjectiveC1_ProtocolMethodList(ObjectiveC1_State state, BinaryReader reader, ObjectiveC_MethodType methodType) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        if (this._index == 0L) {
            return;
        }
        this.method_count = reader.readNextInt();
        for (int i = 0; i < this.method_count; ++i) {
            this.method_list.add(new ObjectiveC1_ProtocolMethod(state, reader, methodType));
        }
    }

    public int getMethodCount() {
        return this.method_count;
    }

    public List<ObjectiveC1_ProtocolMethod> getMethodList() {
        return this.method_list;
    }

    public static DataType toGenericDataType(ObjectiveC1_State state) throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add(DWORD, "method_count", null);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_protocol_method_list_" + this.method_count + "_", 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add(DWORD, "method_count", null);
        if (this.method_count > 0) {
            DataType dt = this.method_list.get(0).toDataType();
            struct.add((DataType)new ArrayDataType(dt, this.method_count, dt.getLength()), "method_list", null);
        }
        return struct;
    }

    public void applyTo() throws Exception {
        if (this._index == 0L) {
            return;
        }
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(this._index);
        DataType dt = this.toDataType();
        this._state.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this._state.program.getListing().createData(address, dt);
        for (ObjectiveC1_ProtocolMethod method : this.method_list) {
            if (this._state.monitor.isCancelled()) break;
            method.applyTo();
        }
    }
}

