/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.match;

import ghidra.app.plugin.match.FunctionHasher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.LongObjectHashtable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class MatchFunctions {
    private MatchFunctions() {
    }

    public static List<MatchedFunctions> matchFunctions(Program aProgram, AddressSetView setA, Program bProgram, AddressSetView setB, int minimumFunctionSize, boolean includeOneToOne, boolean includeNonOneToOne, FunctionHasher hasher, TaskMonitor monitor) throws CancelledException {
        Function func;
        LongObjectHashtable functionHashes = new LongObjectHashtable();
        ArrayList<MatchedFunctions> functionMatches = new ArrayList<MatchedFunctions>();
        FunctionIterator aProgfIter = aProgram.getFunctionManager().getFunctions(setA, true);
        FunctionIterator bProgfIter = bProgram.getFunctionManager().getFunctions(setB, true);
        monitor.setIndeterminate(false);
        monitor.initialize((long)(2 * (aProgram.getFunctionManager().getFunctionCount() + bProgram.getFunctionManager().getFunctionCount())));
        monitor.setMessage("Hashing functions in " + aProgram.getName());
        while (!monitor.isCancelled() && aProgfIter.hasNext()) {
            monitor.incrementProgress(1L);
            func = (Function)aProgfIter.next();
            if (func.isThunk() || func.getBody().getNumAddresses() < (long)minimumFunctionSize) continue;
            MatchFunctions.hashFunction(monitor, (LongObjectHashtable<Match>)functionHashes, func, hasher, true);
        }
        monitor.setMessage("Hashing functions in " + bProgram.getName());
        while (!monitor.isCancelled() && bProgfIter.hasNext()) {
            monitor.incrementProgress(1L);
            func = (Function)bProgfIter.next();
            if (func.isThunk() || func.getBody().getNumAddresses() < (long)minimumFunctionSize) continue;
            MatchFunctions.hashFunction(monitor, (LongObjectHashtable<Match>)functionHashes, func, hasher, false);
        }
        long[] keys = functionHashes.getKeys();
        long progress = monitor.getProgress();
        monitor.setMaximum(progress + (long)keys.length);
        monitor.setProgress(progress);
        monitor.setMessage("Finding function matches");
        for (int i = 0; i < keys.length; ++i) {
            monitor.incrementProgress(1L);
            if (monitor.isCancelled()) break;
            Match match = (Match)functionHashes.get(keys[i]);
            ArrayList<Address> aProgAddrs = match.aAddresses;
            ArrayList<Address> bProgAddrs = match.bAddresses;
            if ((!includeOneToOne || aProgAddrs.size() != 1 || bProgAddrs.size() != 1) && (!includeNonOneToOne || aProgAddrs.size() == 1 && bProgAddrs.size() == 1)) continue;
            for (Address aAddr : aProgAddrs) {
                for (Address bAddr : bProgAddrs) {
                    MatchedFunctions functionMatch = new MatchedFunctions(aProgram, bProgram, aAddr, bAddr, aProgAddrs.size(), bProgAddrs.size(), "Code Only Match");
                    functionMatches.add(functionMatch);
                }
            }
        }
        return functionMatches;
    }

    public static List<MatchedFunctions> matchOneFunction(Program aProgram, Address aEntryPoint, Program bProgram, FunctionHasher hasher, TaskMonitor monitor) throws CancelledException {
        return MatchFunctions.matchOneFunction(aProgram, aEntryPoint, bProgram, null, hasher, monitor);
    }

    public static List<MatchedFunctions> matchOneFunction(Program aProgram, Address aEntryPoint, Program bProgram, AddressSetView bAddressSet, FunctionHasher hasher, TaskMonitor monitor) throws CancelledException {
        LongObjectHashtable functionHashes = new LongObjectHashtable();
        ArrayList<MatchedFunctions> functionMatches = new ArrayList<MatchedFunctions>();
        Function aFunc = aProgram.getFunctionManager().getFunctionContaining(aEntryPoint);
        FunctionIterator bProgfIter = bAddressSet == null ? bProgram.getFunctionManager().getFunctions(true) : bProgram.getFunctionManager().getFunctions(bAddressSet, true);
        MatchFunctions.hashFunction(monitor, (LongObjectHashtable<Match>)functionHashes, aFunc, hasher, true);
        while (!monitor.isCancelled() && bProgfIter.hasNext()) {
            Function func = (Function)bProgfIter.next();
            MatchFunctions.hashFunction(monitor, (LongObjectHashtable<Match>)functionHashes, func, hasher, false);
        }
        long[] keys = functionHashes.getKeys();
        for (int i = 0; i < keys.length && !monitor.isCancelled(); ++i) {
            Match match = (Match)functionHashes.get(keys[i]);
            ArrayList<Address> aProgAddrs = match.aAddresses;
            ArrayList<Address> bProgAddrs = match.bAddresses;
            if (aProgAddrs.size() != 1 || bProgAddrs.size() < 1) continue;
            for (int m = 0; m < bProgAddrs.size(); ++m) {
                MatchedFunctions functionMatch = new MatchedFunctions(aProgram, bProgram, aProgAddrs.get(0), bProgAddrs.get(m), aProgAddrs.size(), bProgAddrs.size(), "Code Only Match");
                functionMatches.add(functionMatch);
            }
            functionHashes.remove(keys[i]);
        }
        return functionMatches;
    }

    private static void hashFunction(TaskMonitor monitor, LongObjectHashtable<Match> functionHashes, Function function, FunctionHasher hasher, boolean isProgA) throws CancelledException {
        long hash = hasher.hash(function, monitor);
        Match subMatch = (Match)functionHashes.get(hash);
        if (subMatch == null) {
            subMatch = new Match();
            functionHashes.put(hash, (Object)subMatch);
        }
        subMatch.add(function.getEntryPoint(), isProgA);
    }

    public static class MatchedFunctions {
        private final Program aProg;
        private final Program bProg;
        private final Address aAddr;
        private final Address bAddr;
        private final int aMatchNum;
        private final int bMatchNum;

        MatchedFunctions(Program aProg, Program bProg, Address aAddr, Address bAddr, int aMatchNum, int bMatchNum, String reason) {
            this.aProg = aProg;
            this.bProg = bProg;
            this.aAddr = aAddr;
            this.bAddr = bAddr;
            this.aMatchNum = aMatchNum;
            this.bMatchNum = bMatchNum;
        }

        public Program getAProgram() {
            return this.aProg;
        }

        public Program getBProgram() {
            return this.bProg;
        }

        public Address getAFunctionAddress() {
            return this.aAddr;
        }

        public Address getBFunctionAddress() {
            return this.bAddr;
        }

        public int getAMatchNum() {
            return this.aMatchNum;
        }

        public int getBMatchNum() {
            return this.bMatchNum;
        }
    }

    private static class Match {
        final ArrayList<Address> aAddresses = new ArrayList();
        final ArrayList<Address> bAddresses = new ArrayList();

        private Match() {
        }

        public void add(Address address, boolean isProgA) {
            if (isProgA) {
                this.aAddresses.add(address);
            } else {
                this.bAddresses.add(address);
            }
        }
    }
}

