/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview.entropy;

import ghidra.app.plugin.core.overview.entropy.Palette;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class PalettePanel
extends JPanel {
    private Palette palette;
    private final int topBottomMargin;

    PalettePanel(int topBottomMargin) {
        this.topBottomMargin = topBottomMargin;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(20, 10);
    }

    public void setPalette(Palette palette) {
        this.palette = palette;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int height = this.getHeight() - 2 * this.topBottomMargin;
        int width = this.getWidth();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        if (this.palette == null) {
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, width - 1, height - 1);
            return;
        }
        int palsize = this.palette.getSize();
        for (int i = 0; i < height; ++i) {
            int index = i * palsize / height;
            if (index >= palsize) {
                index = palsize - 1;
            }
            Color c = this.palette.getColor(index);
            g.setColor(c);
            g.fillRect(0, this.topBottomMargin + i, width, 1);
        }
        g.setColor(Color.BLACK);
        g.drawRect(0, this.topBottomMargin, width - 1, height);
    }
}

