/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.Msg;
import ghidra.util.exception.UsrException;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class ClearAction
extends CompositeEditorTableAction {
    private static final String GROUP_NAME = "3_COMPONENT_EDITOR_ACTION";
    private static final ImageIcon CLEAR_ICON = ResourceManager.loadImage((String)"images/erase16.png");
    private static final String[] popupPath = new String[]{"Clear"};
    private KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 0);

    public ClearAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Clear Components", GROUP_NAME, popupPath, null, CLEAR_ICON);
        this.setDescription("Clear the selected components");
        this.setKeyBindingData(new KeyBindingData(this.keyStroke));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        try {
            this.model.clearSelectedComponents();
        }
        catch (OutOfMemoryError memExc) {
            String errMsg = "Couldn't clear components. Out of memory.";
            Msg.showError((Object)this, null, (String)"Out of Memory", (Object)errMsg, (Throwable)memExc);
        }
        catch (UsrException ue) {
            this.model.setStatus(ue.getMessage());
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isClearAllowed());
    }
}

