/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemConsideredStatus;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.task.TagMarkupItemTask;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import java.util.List;

abstract class SetMarkupItemConsideredAction
extends DockingAction {
    final VTController controller;

    SetMarkupItemConsideredAction(VTController controller, String actionName) {
        super(actionName, VTPlugin.OWNER);
        this.controller = controller;
    }

    abstract VTMarkupItemConsideredStatus getTagType();

    public void actionPerformed(ActionContext context) {
        VTSession session = this.controller.getSession();
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        TagMarkupItemTask task = new TagMarkupItemTask(session, markupItems, this.getTagType());
        task.addTaskListener(new TaskListener(){

            public void taskCompleted(Task t) {
                SetMarkupItemConsideredAction.this.controller.refresh();
            }

            public void taskCancelled(Task t) {
            }
        });
        this.controller.runVTTask(task);
    }

    public boolean isEnabledForContext(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        if (markupItems.size() == 0) {
            return false;
        }
        VTMarkupItemStatus thisActionsStatus = this.getTagType().getMarkupItemStatus();
        for (VTMarkupItem markupItem : markupItems) {
            VTMarkupItemStatus status = markupItem.getStatus();
            if (markupItem.canApply() && !status.equals((Object)thisActionsStatus)) continue;
            return false;
        }
        return true;
    }

    public boolean isAddToPopup(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        if (markupItems.size() == 0) {
            return false;
        }
        for (VTMarkupItem markupItem : markupItems) {
            if (markupItem.canApply()) continue;
            return false;
        }
        return true;
    }
}

