/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.markuptype;

import ghidra.feature.vt.api.markuptype.DataTypeMarkupType;
import ghidra.feature.vt.api.markuptype.EolCommentMarkupType;
import ghidra.feature.vt.api.markuptype.FunctionNameMarkupType;
import ghidra.feature.vt.api.markuptype.FunctionSignatureMarkupType;
import ghidra.feature.vt.api.markuptype.LabelMarkupType;
import ghidra.feature.vt.api.markuptype.PlateCommentMarkupType;
import ghidra.feature.vt.api.markuptype.PostCommentMarkupType;
import ghidra.feature.vt.api.markuptype.PreCommentMarkupType;
import ghidra.feature.vt.api.markuptype.RepeatableCommentMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VTMarkupTypeFactory {
    private static Map<Integer, VTMarkupType> idToTypeMap = new HashMap<Integer, VTMarkupType>();
    private static Map<VTMarkupType, Integer> typeToIdMap = new HashMap<VTMarkupType, Integer>();

    private static void register(Integer id, VTMarkupType markupType) {
        idToTypeMap.put(id, markupType);
        typeToIdMap.put(markupType, id);
    }

    public static List<VTMarkupType> getMarkupTypes() {
        return new ArrayList<VTMarkupType>(idToTypeMap.values());
    }

    public static VTMarkupType getMarkupType(int id) {
        return idToTypeMap.get(id);
    }

    public static int getID(VTMarkupType markupType) {
        Integer id = typeToIdMap.get(markupType);
        if (id == null) {
            if (SystemUtilities.isInTestingMode()) {
                VTMarkupTypeFactory.register(9999, markupType);
                return 9999;
            }
            throw new AssertException("Attempted to use an unregistered VTMarkupType");
        }
        return id;
    }

    static {
        VTMarkupTypeFactory.register(12, EolCommentMarkupType.INSTANCE);
        VTMarkupTypeFactory.register(13, FunctionNameMarkupType.INSTANCE);
        VTMarkupTypeFactory.register(22, LabelMarkupType.INSTANCE);
        VTMarkupTypeFactory.register(23, PlateCommentMarkupType.INSTANCE);
        VTMarkupTypeFactory.register(24, PostCommentMarkupType.INSTANCE);
        VTMarkupTypeFactory.register(25, PreCommentMarkupType.INSTANCE);
        VTMarkupTypeFactory.register(26, RepeatableCommentMarkupType.INSTANCE);
        VTMarkupTypeFactory.register(27, DataTypeMarkupType.INSTANCE);
        VTMarkupTypeFactory.register(29, FunctionSignatureMarkupType.INSTANCE);
    }
}

