/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.util.Msg;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import java.util.HashSet;

public class EnumEditor
extends PropertyEditorSupport {
    private Enum<?> value;

    @Override
    public void setValue(Object o) {
        this.value = (Enum)o;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String[] getTags() {
        try {
            Method m = this.value.getClass().getMethod("values", new Class[0]);
            Enum[] enums = (Enum[])m.invoke(null, new Object[0]);
            HashSet<String> set = new HashSet<String>();
            String[] choices = new String[enums.length];
            for (int i = 0; i < enums.length; ++i) {
                String s = enums[i].toString();
                if (s == null || set.contains(s)) {
                    s = enums[i].name();
                }
                choices[i] = s;
                set.add(s);
            }
            return choices;
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + t.getMessage()), (Throwable)t);
            return new String[]{this.value.toString()};
        }
    }

    public Enum<?>[] getEnums() {
        try {
            Method m = this.value.getClass().getMethod("values", new Class[0]);
            Enum[] enums = (Enum[])m.invoke(null, new Object[0]);
            return enums;
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + t.getMessage()), (Throwable)t);
            return new Enum[]{this.value};
        }
    }

    @Override
    public String getAsText() {
        return this.value.toString();
    }

    @Override
    public void setAsText(String s) {
        try {
            Method m = this.value.getClass().getMethod("values", new Class[0]);
            Enum[] enums = (Enum[])m.invoke(null, new Object[0]);
            for (int i = 0; i < enums.length; ++i) {
                if (!s.equals(enums[i].toString())) continue;
                this.value = enums[i];
                break;
            }
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + t.getMessage()), (Throwable)t);
        }
        this.firePropertyChange();
    }
}

