/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package docking.widgets.tree.tasks;

import java.util.List;

import javax.swing.JTree;
import javax.swing.tree.TreePath;

import docking.widgets.tree.GTree;
import docking.widgets.tree.support.GTreeSelectionEvent;

public class GTreeSelectPathsTask extends AbstractSelectPathsTask {

	private final List<TreePath> paths;

	public GTreeSelectPathsTask(GTree gtree, JTree tree, List<TreePath> paths,
			GTreeSelectionEvent.EventOrigin origin) {
		super(gtree, tree, origin);
		this.paths = paths;
	}

	@Override
	List<TreePath> getTreePaths() {
		return paths;
	}
}
