/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.DomainFileIndex;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.util.SystemUtilities;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class DomainFolderChangeListenerList
implements DomainFolderChangeListener {
    private DomainFileIndex fileIndex;
    private List<DomainFolderChangeListener> list = new CopyOnWriteArrayList<DomainFolderChangeListener>();

    DomainFolderChangeListenerList(DomainFileIndex fileIndex) {
        this.fileIndex = fileIndex;
    }

    void addListener(DomainFolderChangeListener listener) {
        this.list.add(listener);
    }

    void removeListener(DomainFolderChangeListener listener) {
        this.list.remove(listener);
    }

    @Override
    public void domainFolderAdded(DomainFolder folder) {
        this.fileIndex.domainFolderAdded(folder);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFolderAdded(folder);
            }
        });
    }

    @Override
    public void domainFileAdded(DomainFile file) {
        this.fileIndex.domainFileAdded(file);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFileAdded(file);
            }
        });
    }

    @Override
    public void domainFolderRemoved(DomainFolder parent, String name) {
        this.fileIndex.domainFolderRemoved(parent, name);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFolderRemoved(parent, name);
            }
        });
    }

    @Override
    public void domainFileRemoved(DomainFolder parent, String name, String fileID) {
        this.fileIndex.domainFileRemoved(parent, name, fileID);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFileRemoved(parent, name, fileID);
            }
        });
    }

    @Override
    public void domainFolderRenamed(DomainFolder folder, String oldName) {
        this.fileIndex.domainFolderRenamed(folder, oldName);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFolderRenamed(folder, oldName);
            }
        });
    }

    @Override
    public void domainFileRenamed(DomainFile file, String oldName) {
        this.fileIndex.domainFileRenamed(file, oldName);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFileRenamed(file, oldName);
            }
        });
    }

    @Override
    public void domainFolderMoved(DomainFolder folder, DomainFolder oldParent) {
        this.fileIndex.domainFolderMoved(folder, oldParent);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFolderMoved(folder, oldParent);
            }
        });
    }

    @Override
    public void domainFileMoved(DomainFile file, DomainFolder oldParent, String oldName) {
        this.fileIndex.domainFileMoved(file, oldParent, oldName);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFileMoved(file, oldParent, oldName);
            }
        });
    }

    @Override
    public void domainFolderSetActive(DomainFolder folder) {
        this.fileIndex.domainFolderSetActive(folder);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFolderSetActive(folder);
            }
        });
    }

    @Override
    public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
        this.fileIndex.domainFileStatusChanged(file, fileIDset);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFileStatusChanged(file, fileIDset);
            }
        });
    }

    @Override
    public void domainFileObjectOpenedForUpdate(DomainFile file, DomainObject object) {
        this.fileIndex.domainFileObjectOpenedForUpdate(file, object);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFileObjectOpenedForUpdate(file, object);
            }
        });
    }

    @Override
    public void domainFileObjectClosed(DomainFile file, DomainObject object) {
        this.fileIndex.domainFileObjectClosed(file, object);
        if (this.list.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFileObjectClosed(file, object);
            }
        });
    }

    @Override
    public void domainFileObjectReplaced(DomainFile file, DomainObject oldObject) {
        this.fileIndex.domainFileObjectReplaced(file, oldObject);
        if (this.list.isEmpty()) {
            return;
        }
        Runnable r = () -> {
            for (DomainFolderChangeListener listener : this.list) {
                listener.domainFileObjectReplaced(file, oldObject);
            }
        };
        SystemUtilities.runSwingNow((Runnable)r);
    }

    public void clearAll() {
        this.list.clear();
    }
}

