/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.security.loginmodule;

import com.sun.security.auth.UserPrincipal;
import ghidra.server.RepositoryManager;
import ghidra.util.timer.Watchdog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import utilities.util.FileUtilities;

public class ExternalProgramLoginModule
implements LoginModule {
    private static final String USER_PROMPT_OPTION_NAME = "USER_PROMPT";
    private static final String PASSWORD_PROMPT_OPTION_NAME = "PASSWORD_PROMPT";
    private static final String TIMEOUT_OPTION_NAME = "TIMEOUT";
    private static final String PROGRAM_OPTION_NAME = "PROGRAM";
    private static final String ARG_OPTION_NAME = "ARG_";
    private static final long DEFAULT_TIMEOUT_MS = 10000L;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, Object> options;
    private UserPrincipal user;
    private String username;
    private char[] password;
    private String[] cmdArray;
    private String extProgramName;
    private boolean success;
    private boolean committed;
    private long timeout_ms = 10000L;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        this.readOptions();
        this.getNameAndPassword();
        this.callExternalProgram();
        this.success = true;
        this.user = new UserPrincipal(this.username);
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.success) {
            return false;
        }
        if (!this.subject.isReadOnly() && !this.user.implies(this.subject)) {
            this.subject.getPrincipals().add(this.user);
        }
        this.committed = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.success) {
            return false;
        }
        if (!this.committed) {
            this.success = false;
            this.cleanup();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.cleanup();
            throw new LoginException("Subject is read-only");
        }
        this.subject.getPrincipals().remove(this.user);
        this.cleanup();
        this.success = false;
        this.committed = false;
        return true;
    }

    private void cleanup() {
        this.user = null;
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
    }

    private void readOptions() throws LoginException {
        String timeoutStr = (String)this.options.get(TIMEOUT_OPTION_NAME);
        if (timeoutStr != null) {
            try {
                this.timeout_ms = Long.parseLong(timeoutStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.readExtProgOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callExternalProgram() throws LoginException {
        AtomicReference<Process> process = new AtomicReference<Process>();
        try (Watchdog watchdog = new Watchdog(this.timeout_ms, () -> {
            Process local_p = (Process)process.get();
            if (local_p != null) {
                local_p.destroyForcibly();
            }
        });){
            watchdog.arm();
            Process p = Runtime.getRuntime().exec(this.cmdArray);
            process.set(p);
            FileUtilities.asyncForEachLine((InputStream)p.getInputStream(), stdOutStr -> RepositoryManager.log(null, null, this.extProgramName + " STDOUT: " + stdOutStr, null));
            FileUtilities.asyncForEachLine((InputStream)p.getErrorStream(), errStr -> RepositoryManager.log(null, null, this.extProgramName + " STDERR: " + errStr, null));
            PrintWriter outputWriter = new PrintWriter(p.getOutputStream());
            outputWriter.write(this.username);
            outputWriter.write("\n");
            outputWriter.write(this.password);
            outputWriter.write("\n");
            outputWriter.flush();
            int exitValue = p.waitFor();
            if (exitValue != 0) {
                throw new FailedLoginException("Login failed: external command exited with error " + exitValue);
            }
        }
        catch (IOException | InterruptedException e) {
            try {
                RepositoryManager.log(null, null, "Exception when executing " + this.extProgramName + ":" + e.getMessage(), null);
                throw new LoginException("Error executing external program");
            }
            catch (Throwable throwable) {
                Arrays.fill(this.password, '\u0000');
                this.password = null;
                Process p = (Process)process.get();
                if (p != null && p.isAlive() && p.isAlive()) {
                    try {
                        p.waitFor(this.timeout_ms, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        p.destroyForcibly();
                    }
                }
                throw throwable;
            }
        }
        Arrays.fill(this.password, '\u0000');
        this.password = null;
        Process p = (Process)process.get();
        if (p != null && p.isAlive() && p.isAlive()) {
            try {
                p.waitFor(this.timeout_ms, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                p.destroyForcibly();
            }
        }
    }

    private void readExtProgOptions() throws LoginException {
        String externalProgram = (String)this.options.get(PROGRAM_OPTION_NAME);
        if (externalProgram == null || externalProgram.isBlank()) {
            throw new LoginException("Missing PROGRAM=path_to_external_program in options");
        }
        File extProFile = new File(externalProgram).getAbsoluteFile();
        if (!extProFile.exists()) {
            throw new LoginException("Bad PROGRAM=path_to_external_program in options");
        }
        this.extProgramName = extProFile.getName();
        List argKeys = this.options.keySet().stream().filter(key -> key.startsWith(ARG_OPTION_NAME)).sorted().collect(Collectors.toList());
        ArrayList<String> cmdArrayValues = new ArrayList<String>();
        cmdArrayValues.add(externalProgram.toString());
        for (String argKey : argKeys) {
            String val = this.options.get(argKey).toString();
            cmdArrayValues.add(val);
        }
        this.cmdArray = cmdArrayValues.toArray(new String[cmdArrayValues.size()]);
    }

    private void getNameAndPassword() throws LoginException {
        String userPrompt = this.options.getOrDefault(USER_PROMPT_OPTION_NAME, "User name").toString();
        String passPrompt = this.options.getOrDefault(PASSWORD_PROMPT_OPTION_NAME, "Password").toString();
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        NameCallback ncb = null;
        PasswordCallback pcb = null;
        if (this.username == null) {
            ncb = new NameCallback(userPrompt);
            callbacks.add(ncb);
        }
        if (this.password == null) {
            pcb = new PasswordCallback(passPrompt, false);
            callbacks.add(pcb);
        }
        if (!callbacks.isEmpty()) {
            try {
                this.callbackHandler.handle(callbacks.toArray(new Callback[callbacks.size()]));
                if (ncb != null) {
                    this.username = ncb.getName();
                }
                if (pcb != null) {
                    this.password = pcb.getPassword();
                    pcb.clearPassword();
                }
                if (this.username == null || this.password == null) {
                    throw new LoginException("Failed to get username or password");
                }
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw new LoginException("Error during callback: " + e.getMessage());
            }
        }
        this.validateUsernameAndPasswordFormat();
    }

    private void validateUsernameAndPasswordFormat() throws LoginException {
        if (this.username.contains("\n") || this.username.contains("\u0000")) {
            throw new LoginException("Bad characters in username");
        }
        String tmpPass = String.valueOf(this.password);
        if (tmpPass.contains("\n") || tmpPass.contains("\u0000")) {
            throw new LoginException("Bad characters in password");
        }
    }
}

