/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nullable;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.Adaptors.FieldDefinition;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.Format.Instruction21c;
import org.jf.dexlib.Code.Format.Instruction41c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.SparseArray;
import org.jf.dexlib.Util.Utf8Utils;
import org.jf.util.CommentingIndentingWriter;
import org.jf.util.IndentingWriter;

public class ClassDefinition {
    private ClassDefItem classDefItem;
    @Nullable
    private ClassDataItem classDataItem;
    private SparseArray<FieldIdItem> fieldsSetInStaticConstructor;
    protected boolean validationErrors;

    public ClassDefinition(ClassDefItem classDefItem) {
        this.classDefItem = classDefItem;
        this.classDataItem = classDefItem.getClassData();
        this.findFieldsSetInStaticConstructor();
    }

    public boolean hadValidationErrors() {
        return this.validationErrors;
    }

    private void findFieldsSetInStaticConstructor() {
        this.fieldsSetInStaticConstructor = new SparseArray();
        if (this.classDataItem == null) {
            return;
        }
        for (ClassDataItem.EncodedMethod directMethod : this.classDataItem.getDirectMethods()) {
            if (!directMethod.method.getMethodName().getStringValue().equals("<clinit>") || directMethod.codeItem == null) continue;
            block5: for (Instruction instruction : directMethod.codeItem.getInstructions()) {
                switch (instruction.opcode) {
                    case SPUT: 
                    case SPUT_BOOLEAN: 
                    case SPUT_BYTE: 
                    case SPUT_CHAR: 
                    case SPUT_OBJECT: 
                    case SPUT_SHORT: 
                    case SPUT_WIDE: {
                        Instruction21c ins = (Instruction21c)instruction;
                        FieldIdItem fieldIdItem = (FieldIdItem)ins.getReferencedItem();
                        this.fieldsSetInStaticConstructor.put(fieldIdItem.getIndex(), (Object)fieldIdItem);
                        continue block5;
                    }
                    case SPUT_JUMBO: 
                    case SPUT_BOOLEAN_JUMBO: 
                    case SPUT_BYTE_JUMBO: 
                    case SPUT_CHAR_JUMBO: 
                    case SPUT_OBJECT_JUMBO: 
                    case SPUT_SHORT_JUMBO: 
                    case SPUT_WIDE_JUMBO: {
                        Instruction21c ins = (Instruction41c)instruction;
                        FieldIdItem fieldIdItem = (FieldIdItem)ins.getReferencedItem();
                        this.fieldsSetInStaticConstructor.put(fieldIdItem.getIndex(), (Object)fieldIdItem);
                        continue block5;
                    }
                }
            }
        }
    }

    public void writeTo(IndentingWriter writer) throws IOException {
        this.writeClass(writer);
        this.writeSuper(writer);
        this.writeSourceFile(writer);
        this.writeInterfaces(writer);
        this.writeAnnotations(writer);
        this.writeStaticFields(writer);
        this.writeInstanceFields(writer);
        this.writeDirectMethods(writer);
        this.writeVirtualMethods(writer);
    }

    private void writeClass(IndentingWriter writer) throws IOException {
        writer.write(".class ");
        this.writeAccessFlags(writer);
        writer.write(this.classDefItem.getClassType().getTypeDescriptor());
        writer.write(10);
    }

    private void writeAccessFlags(IndentingWriter writer) throws IOException {
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForClass((int)this.classDefItem.getAccessFlags())) {
            writer.write(accessFlag.toString());
            writer.write(32);
        }
    }

    private void writeSuper(IndentingWriter writer) throws IOException {
        TypeIdItem superClass = this.classDefItem.getSuperclass();
        if (superClass != null) {
            writer.write(".super ");
            writer.write(superClass.getTypeDescriptor());
            writer.write(10);
        }
    }

    private void writeSourceFile(IndentingWriter writer) throws IOException {
        StringIdItem sourceFile = this.classDefItem.getSourceFile();
        if (sourceFile != null) {
            writer.write(".source \"");
            Utf8Utils.writeEscapedString((Writer)writer, (String)sourceFile.getStringValue());
            writer.write("\"\n");
        }
    }

    private void writeInterfaces(IndentingWriter writer) throws IOException {
        TypeListItem interfaceList = this.classDefItem.getInterfaces();
        if (interfaceList == null) {
            return;
        }
        List interfaces = interfaceList.getTypes();
        if (interfaces == null || interfaces.size() == 0) {
            return;
        }
        writer.write(10);
        writer.write("# interfaces\n");
        for (TypeIdItem typeIdItem : interfaceList.getTypes()) {
            writer.write(".implements ");
            writer.write(typeIdItem.getTypeDescriptor());
            writer.write(10);
        }
    }

    private void writeAnnotations(IndentingWriter writer) throws IOException {
        AnnotationDirectoryItem annotationDirectory = this.classDefItem.getAnnotations();
        if (annotationDirectory == null) {
            return;
        }
        AnnotationSetItem annotationSet = annotationDirectory.getClassAnnotations();
        if (annotationSet == null) {
            return;
        }
        writer.write("\n\n");
        writer.write("# annotations\n");
        AnnotationFormatter.writeTo(writer, annotationSet);
    }

    private void writeStaticFields(IndentingWriter writer) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        assert (this.classDefItem != null);
        EncodedArrayItem encodedStaticInitializers = this.classDefItem.getStaticFieldInitializers();
        EncodedValue[] staticInitializers = encodedStaticInitializers != null ? encodedStaticInitializers.getEncodedArray().values : new EncodedValue[]{};
        List encodedFields = this.classDataItem.getStaticFields();
        if (encodedFields.size() == 0) {
            return;
        }
        writer.write("\n\n");
        writer.write("# static fields\n");
        for (int i = 0; i < encodedFields.size(); ++i) {
            if (i > 0) {
                writer.write(10);
            }
            ClassDataItem.EncodedField field = (ClassDataItem.EncodedField)encodedFields.get(i);
            EncodedValue encodedValue = null;
            if (i < staticInitializers.length) {
                encodedValue = staticInitializers[i];
            }
            AnnotationSetItem fieldAnnotations = null;
            AnnotationDirectoryItem annotations = this.classDefItem.getAnnotations();
            if (annotations != null) {
                fieldAnnotations = annotations.getFieldAnnotations(field.field);
            }
            IndentingWriter fieldWriter = writer;
            if (i > 0 && field.equals(encodedFields.get(i - 1))) {
                fieldWriter = new CommentingIndentingWriter((Writer)writer, "#");
                fieldWriter.write("Ignoring field with duplicate signature\n");
                System.err.println(String.format("Warning: class %s has duplicate static field %s, Ignoring.", this.classDefItem.getClassType().getTypeDescriptor(), field.field.getShortFieldString()));
            }
            boolean setInStaticConstructor = this.fieldsSetInStaticConstructor.get(field.field.getIndex()) != null;
            FieldDefinition.writeTo(fieldWriter, field, encodedValue, fieldAnnotations, setInStaticConstructor);
        }
    }

    private void writeInstanceFields(IndentingWriter writer) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        List encodedFields = this.classDataItem.getInstanceFields();
        if (encodedFields.size() == 0) {
            return;
        }
        writer.write("\n\n");
        writer.write("# instance fields\n");
        for (int i = 0; i < encodedFields.size(); ++i) {
            ClassDataItem.EncodedField field = (ClassDataItem.EncodedField)encodedFields.get(i);
            if (i > 0) {
                writer.write(10);
            }
            AnnotationSetItem fieldAnnotations = null;
            AnnotationDirectoryItem annotations = this.classDefItem.getAnnotations();
            if (annotations != null) {
                fieldAnnotations = annotations.getFieldAnnotations(field.field);
            }
            IndentingWriter fieldWriter = writer;
            if (i > 0 && field.equals(encodedFields.get(i - 1))) {
                fieldWriter = new CommentingIndentingWriter((Writer)writer, "#");
                fieldWriter.write("Ignoring field with duplicate signature\n");
                System.err.println(String.format("Warning: class %s has duplicate instance field %s, Ignoring.", this.classDefItem.getClassType().getTypeDescriptor(), field.field.getShortFieldString()));
            }
            FieldDefinition.writeTo(fieldWriter, field, null, fieldAnnotations, false);
        }
    }

    private void writeDirectMethods(IndentingWriter writer) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        List directMethods = this.classDataItem.getDirectMethods();
        if (directMethods.size() == 0) {
            return;
        }
        writer.write("\n\n");
        writer.write("# direct methods\n");
        this.writeMethods(writer, directMethods);
    }

    private void writeVirtualMethods(IndentingWriter writer) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        List virtualMethods = this.classDataItem.getVirtualMethods();
        if (virtualMethods.size() == 0) {
            return;
        }
        writer.write("\n\n");
        writer.write("# virtual methods\n");
        this.writeMethods(writer, virtualMethods);
    }

    private void writeMethods(IndentingWriter writer, List<ClassDataItem.EncodedMethod> methods) throws IOException {
        for (int i = 0; i < methods.size(); ++i) {
            ClassDataItem.EncodedMethod method = methods.get(i);
            if (i > 0) {
                writer.write(10);
            }
            AnnotationSetItem methodAnnotations = null;
            AnnotationSetRefList parameterAnnotations = null;
            AnnotationDirectoryItem annotations = this.classDefItem.getAnnotations();
            if (annotations != null) {
                methodAnnotations = annotations.getMethodAnnotations(method.method);
                parameterAnnotations = annotations.getParameterAnnotations(method.method);
            }
            IndentingWriter methodWriter = writer;
            if (i > 0 && method.equals((Object)methods.get(i - 1))) {
                methodWriter = new CommentingIndentingWriter((Writer)writer, "#");
                methodWriter.write("Ignoring method with duplicate signature\n");
                System.err.println(String.format("Warning: class %s has duplicate method %s, Ignoring.", this.classDefItem.getClassType().getTypeDescriptor(), method.method.getShortMethodString()));
            }
            MethodDefinition methodDefinition = new MethodDefinition(method);
            methodDefinition.writeTo(methodWriter, methodAnnotations, parameterAnnotations);
            ValidationException validationException = methodDefinition.getValidationException();
            if (validationException == null) continue;
            System.err.println(String.format("Error while disassembling method %s. Continuing.", method.method.getMethodString()));
            validationException.printStackTrace(System.err);
            this.validationErrors = true;
        }
    }
}

