/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dalvik.dex.inject;

import ghidra.file.formats.android.dex.analyzer.DexAnalysisState;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.FieldIDItem;
import ghidra.file.formats.android.dex.format.MethodIDItem;
import ghidra.file.formats.android.dex.format.PrototypesIDItem;
import ghidra.file.formats.android.dex.format.StringIDItem;
import ghidra.file.formats.android.dex.format.TypeItem;
import ghidra.file.formats.android.dex.format.TypeList;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Undefined4DataType;
import ghidra.program.model.lang.ConstantPool;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import java.io.IOException;
import java.util.ArrayList;

public class ConstantPoolDex
extends ConstantPool {
    private Program program;
    private DexHeader dexHeader;
    private DataTypeManager dtManager;

    public ConstantPoolDex(Program program) throws IOException {
        this.program = program;
        DexAnalysisState analysisState = DexAnalysisState.getState((Program)program);
        this.dexHeader = analysisState.getHeader();
        this.dtManager = program.getDataTypeManager();
    }

    private void fillinField(int fieldID, boolean isStatic, ConstantPool.Record res) {
        String classString;
        String[] pathArray;
        FieldIDItem fieldIDItem = (FieldIDItem)this.dexHeader.getFields().get(fieldID);
        StringIDItem stringItem = (StringIDItem)this.dexHeader.getStrings().get(fieldIDItem.getNameIndex());
        res.tag = 4;
        res.token = stringItem.getStringDataItem().getString();
        if (isStatic && (pathArray = DexUtil.convertClassStringToPathArray((String)"", (String)(classString = DexUtil.convertTypeIndexToString((DexHeader)this.dexHeader, (short)fieldIDItem.getClassIndex())))) != null) {
            res.token = pathArray[pathArray.length - 1] + "." + res.token;
        }
        DataType fieldDT = this.dexHeader.getDataType(this.program, fieldIDItem.getTypeIndex());
        res.type = new PointerDataType(fieldDT);
    }

    private void fillinArrayLength(ConstantPool.Record res) {
        res.tag = 5;
        res.token = "length";
        res.type = IntegerDataType.dataType;
    }

    private String removeUniquifier(String name) {
        int len = name.length();
        if (len < 10 || name.charAt(len - 9) != '_') {
            return name;
        }
        char matchChar = name.charAt(len - 8);
        if (matchChar != '5' && matchChar != 'e') {
            return name;
        }
        if (name.charAt(len - 7) != '0') {
            return name;
        }
        return name.substring(0, len - 9);
    }

    private void fillinMethod(int methodID, boolean isStatic, ConstantPool.Record res) {
        TypeList parameters;
        Symbol symbol;
        MethodIDItem methodIDItem = (MethodIDItem)this.dexHeader.getMethods().get(methodID);
        Address addr = this.dexHeader.getMethodAddress(this.program, methodID);
        res.token = null;
        String namespaceString = null;
        if (addr != Address.NO_ADDRESS && (symbol = this.program.getSymbolTable().getPrimarySymbol(addr)) != null && symbol.getSource() != SourceType.DEFAULT) {
            res.token = symbol.getName();
            res.token = this.removeUniquifier(res.token);
            namespaceString = symbol.getParentNamespace().getName();
        }
        if (res.token == null) {
            res.token = DexUtil.convertToString((DexHeader)this.dexHeader, (int)methodIDItem.getNameIndex());
        }
        if (isStatic) {
            String classString;
            String[] pathArray;
            if (namespaceString == null && (pathArray = DexUtil.convertClassStringToPathArray((String)"", (String)(classString = DexUtil.convertTypeIndexToString((DexHeader)this.dexHeader, (int)methodIDItem.getClassIndex())))) != null) {
                namespaceString = pathArray[pathArray.length - 1];
            }
            if (namespaceString != null) {
                res.token = namespaceString + "." + res.token;
            }
        }
        res.tag = 3;
        String defName = res.token + "_" + Integer.toHexString(methodID);
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(defName, this.dtManager);
        res.type = new PointerDataType((DataType)funcDef);
        res.hasThisPtr = !isStatic;
        int prototypeIndex = methodIDItem.getProtoIndex() & 0xFFFF;
        PrototypesIDItem prototype = (PrototypesIDItem)this.dexHeader.getPrototypes().get(prototypeIndex);
        DataType returnDataType = this.dexHeader.getDataType(this.program, (short)prototype.getReturnTypeIndex());
        funcDef.setReturnType(returnDataType);
        ArrayList<ParameterDefinitionImpl> paramDef = new ArrayList<ParameterDefinitionImpl>();
        if (!isStatic) {
            ParameterDefinitionImpl pDef = new ParameterDefinitionImpl("ref", (DataType)Undefined4DataType.dataType, null);
            paramDef.add(pDef);
        }
        if ((parameters = prototype.getParameters()) != null) {
            for (TypeItem parameterTypeItem : parameters.getItems()) {
                DataType parameterDataType = this.dexHeader.getDataType(this.program, parameterTypeItem.getType());
                ParameterDefinitionImpl pDef = new ParameterDefinitionImpl("", parameterDataType, null);
                paramDef.add(pDef);
            }
        }
        ParameterDefinition[] finalDefs = new ParameterDefinition[paramDef.size()];
        paramDef.toArray(finalDefs);
        funcDef.setArguments(finalDefs);
    }

    private void fillinString(int stringID, ConstantPool.Record res) {
        StringIDItem stringIDItem = (StringIDItem)this.dexHeader.getStrings().get(stringID);
        res.tag = 1;
        res.setUTF8Data(stringIDItem.getStringDataItem().getString());
        res.type = PointerDataType.dataType;
    }

    private void fillinClass(short classID, ConstantPool.Record res) {
        res.tag = 2;
        res.token = "<none>";
        if (classID == -1) {
            res.type = DataType.DEFAULT;
        } else {
            res.type = this.dexHeader.getDataType(this.program, classID);
            if (res.type instanceof Pointer) {
                res.token = ((Pointer)res.type).getDataType().getName();
            }
        }
    }

    private void fillinSuper(ConstantPool.Record res) {
        res.tag = 3;
        res.token = "super";
        res.type = DataType.DEFAULT;
    }

    private void fillinInstanceOf(short classID, ConstantPool.Record res) {
        res.tag = 6;
        res.token = "instanceof";
        res.type = classID == -1 ? DataType.DEFAULT : this.dexHeader.getDataType(this.program, classID);
    }

    public ConstantPool.Record getRecord(long[] ref) {
        ConstantPool.Record res = new ConstantPool.Record();
        switch ((int)ref[1]) {
            case 0: {
                this.fillinMethod((int)ref[0], false, res);
                return res;
            }
            case 1: {
                this.fillinField((int)ref[0], false, res);
                return res;
            }
            case 2: {
                this.fillinField((int)ref[0], true, res);
                return res;
            }
            case 3: {
                this.fillinMethod((int)ref[0], true, res);
                return res;
            }
            case 4: {
                this.fillinString((int)ref[0], res);
                return res;
            }
            case 5: {
                this.fillinClass((short)ref[0], res);
                return res;
            }
            case 6: {
                this.fillinArrayLength(res);
                return res;
            }
            case 7: {
                this.fillinSuper(res);
                return res;
            }
            case 8: {
                this.fillinInstanceOf((short)ref[0], res);
                return res;
            }
        }
        return null;
    }
}

