/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.bin.format.pdb.PdbUtil;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.File;

class ApplyLineNumbers {
    private XmlPullParser xmlParser;
    private Program program;

    ApplyLineNumbers(PdbParser pdbParser, XmlPullParser xmlParser, Program program) {
        this.xmlParser = xmlParser;
        this.program = program;
    }

    void applyTo(TaskMonitor monitor, MessageLog log) {
        while (this.xmlParser.hasNext()) {
            if (monitor.isCancelled()) {
                return;
            }
            XmlElement elem = this.xmlParser.peek();
            if (elem.isEnd() && elem.getName().equals("function")) break;
            elem = this.xmlParser.next();
            String sourcefileName = elem.getAttribute("source_file");
            int start = XmlUtilities.parseInt((String)elem.getAttribute("start"));
            int addr = XmlUtilities.parseInt((String)elem.getAttribute("addr"));
            Address address = PdbUtil.reladdr(this.program, addr);
            CodeUnit cu = this.program.getListing().getCodeUnitContaining(address);
            if (cu == null) {
                log.appendMsg("PDB", "Could not apply source code line number (no code unit found at " + address + ")");
            } else {
                cu.setProperty("Source Path", sourcefileName);
                cu.setProperty("Source File", new File(sourcefileName).getName());
                cu.setProperty("Source Line", start);
            }
            XmlElement xmlElement = this.xmlParser.next();
        }
    }
}

