/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class DoubleEncodedValue
extends EncodedValue {
    public final double value;

    protected DoubleEncodedValue(Input in, byte valueArg) {
        long longValue = EncodedValueUtils.decodeRightZeroExtendedValue(in.readBytes(valueArg + 1));
        this.value = Double.longBitsToDouble(longValue);
    }

    public DoubleEncodedValue(double value) {
        this.value = value;
    }

    @Override
    public void writeValue(AnnotatedOutput out) {
        byte[] bytes = EncodedValueUtils.encodeRightZeroExtendedValue(Double.doubleToRawLongBits(this.value));
        if (out.annotates()) {
            out.annotate(1, "value_type=" + ValueType.VALUE_DOUBLE.name() + ",value_arg=" + (bytes.length - 1));
            out.annotate(bytes.length, "value: " + this.value);
        }
        out.writeByte(ValueType.VALUE_DOUBLE.value | bytes.length - 1 << 5);
        out.write(bytes);
    }

    @Override
    public int placeValue(int offset) {
        return offset + 1 + EncodedValueUtils.getRequiredBytesForRightZeroExtendedValue(Double.doubleToRawLongBits(this.value));
    }

    @Override
    protected int compareValue(EncodedValue o) {
        DoubleEncodedValue other = (DoubleEncodedValue)o;
        return Double.compare(this.value, other.value);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_DOUBLE;
    }

    public int hashCode() {
        return (int)Double.doubleToRawLongBits(this.value);
    }
}

