/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction22x
extends Instruction
implements TwoRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private short regB;

    public Instruction22x(Opcode opcode, short regA, int regB) {
        super(opcode);
        if (regA >= 256) {
            throw new RuntimeException("The register number must be less than v16");
        }
        if (regB >= 65536) {
            throw new RuntimeException("The register number must be less than v65536");
        }
        this.regA = (byte)regA;
        this.regB = (short)regB;
    }

    private Instruction22x(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regA = buffer[bufferIndex + 1];
        this.regB = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 2);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regA);
        out.writeShort(this.regB);
    }

    @Override
    public Format getFormat() {
        return Format.Format22x;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public int getRegisterB() {
        return this.regB & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction22x(opcode, buffer, bufferIndex);
        }
    }
}

