/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.DialogComponentProvider;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncProto;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.RenameVariableAction;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighConstant;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.data.DataTypeParser;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;

public class RetypeVariableAction
extends AbstractDecompilerAction {
    private final DecompilerController controller;
    private final PluginTool tool;

    public RetypeVariableAction(PluginTool tool, DecompilerController controller) {
        super("Retype Variable");
        this.tool = tool;
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Retype Variable"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 128));
    }

    private void retypeReturnType(DataType dataType, ClangReturnType parent) {
        int resp;
        Program program = this.controller.getProgram();
        DataTypeManager dataTypeManager = program.getDataTypeManager();
        HighFunction hfunction = this.getHighFunctionFromReturnTypeToken(parent);
        if (hfunction == null) {
            return;
        }
        boolean commitRequired = RetypeVariableAction.checkFullCommit(null, hfunction);
        if (commitRequired && (resp = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Parameter Commit Required", (String)"Retyping the return value requires all other parameters to be committed!\nContinue with retype?", (String)"Continue")) != 1) {
            return;
        }
        Function function = hfunction.getFunction();
        boolean successfulMod = false;
        int transactionID = program.startTransaction("Retype return type");
        try {
            if (dataType.getDataTypeManager() != dataTypeManager) {
                dataType = dataTypeManager.resolve(dataType, null);
            }
            if (commitRequired) {
                try {
                    HighFunctionDBUtil.commitParamsToDatabase((HighFunction)hfunction, (boolean)true, (SourceType)SourceType.USER_DEFINED);
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Unexpected exception", (Throwable)e);
                }
                catch (InvalidInputException e) {
                    Msg.showError((Object)((Object)this), null, (String)"Parameter Commit Failed", (Object)e.getMessage());
                }
            }
            function.setReturnType(dataType, SourceType.USER_DEFINED);
            successfulMod = true;
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type return type '" + this.getName() + "': " + e.getMessage()));
        }
        program.endTransaction(transactionID, successfulMod);
    }

    private HighFunction getHighFunctionFromReturnTypeToken(ClangReturnType returnType) {
        Varnode varnode = returnType.getVarnode();
        if (varnode == null) {
            ClangNode proto = returnType.Parent();
            if (proto instanceof ClangFuncProto) {
                ClangFunction func = ((ClangFuncProto)proto).getClangFunction();
                if (func == null) {
                    return null;
                }
                return func.getHighFunction();
            }
            return null;
        }
        HighVariable high = varnode.getHigh();
        return high.getHighFunction();
    }

    private DataType chooseDataType(DataType currentDataType) {
        Program program = this.controller.getProgram();
        DataTypeManager dataTypeManager = program.getDataTypeManager();
        DataTypeSelectionDialog chooserDialog = new DataTypeSelectionDialog(this.tool, dataTypeManager, Integer.MAX_VALUE, DataTypeParser.AllowedDataTypes.FIXED_LENGTH);
        chooserDialog.setInitialDataType(currentDataType);
        this.tool.showDialog((DialogComponentProvider)chooserDialog);
        return chooserDialog.getUserChosenDataType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retypeVariable(HighVariable var, Varnode exactSpot, DataType dt) {
        HighFunction hfunction = var.getHighFunction();
        boolean commitRequired = RetypeVariableAction.checkFullCommit(var, hfunction);
        if (commitRequired) {
            exactSpot = null;
        }
        if (exactSpot != null) {
            try {
                var = hfunction.splitOutMergeGroup(var, exactSpot);
            }
            catch (PcodeException e) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Retype Failed", (Object)e.getMessage());
                return;
            }
        }
        Program program = this.controller.getProgram();
        DataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean successfulMod = false;
        int transaction = program.startTransaction("Retype Variable");
        try {
            if (dt.getDataTypeManager() != dataTypeManager) {
                dt = dataTypeManager.resolve(dt, null);
            }
            if (commitRequired) {
                boolean useDataTypes = hfunction.getFunction().getSignatureSource() != SourceType.DEFAULT;
                try {
                    HighFunctionDBUtil.commitParamsToDatabase((HighFunction)hfunction, (boolean)useDataTypes, (SourceType)SourceType.USER_DEFINED);
                    if (useDataTypes) {
                        HighFunctionDBUtil.commitReturnToDatabase((HighFunction)hfunction, (SourceType)SourceType.USER_DEFINED);
                    }
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Unexpected exception", (Throwable)e);
                }
                catch (InvalidInputException e) {
                    Msg.showError((Object)((Object)this), null, (String)"Parameter Commit Failed", (Object)e.getMessage());
                }
            }
            HighFunctionDBUtil.updateDBVariable((HighVariable)var, null, (DataType)dt, (SourceType)SourceType.USER_DEFINED);
            successfulMod = true;
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type variable '" + var.getName() + "': " + e.getMessage()));
        }
        finally {
            program.endTransaction(transaction, successfulMod);
        }
    }

    private int getEndComponentIndex(Structure struct, DataTypeComponent comp, DataType newtype) {
        int newlen = newtype.getLength();
        if (newlen <= 0) {
            return -1;
        }
        DataType curtype = comp.getDataType();
        newlen -= curtype.getLength();
        int index = comp.getOrdinal();
        while (newlen > 0) {
            if (++index >= struct.getNumComponents()) {
                return -1;
            }
            comp = struct.getComponent(index);
            curtype = comp.getDataType();
            if (curtype != DataType.DEFAULT) {
                return -1;
            }
            newlen -= curtype.getLength();
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retypeStructVariable(Structure dt, DataTypeComponent comp, DataType newtype) {
        Program program = this.controller.getProgram();
        DataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean successfulMod = false;
        if (comp == null) {
            if (!dt.isNotYetDefined()) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Retype Failed", (Object)("Could not find component of '" + dt.getName() + "' to retype"));
                return;
            }
            int transaction = program.startTransaction("Retype Structure Field");
            try {
                if (newtype.getDataTypeManager() != dataTypeManager) {
                    newtype = dataTypeManager.resolve(newtype, null);
                }
                dt.insert(0, newtype);
                successfulMod = true;
            }
            finally {
                program.endTransaction(transaction, successfulMod);
            }
            return;
        }
        int transaction = program.startTransaction("Retype Structure Field");
        try {
            if (newtype.getDataTypeManager() != dataTypeManager) {
                newtype = dataTypeManager.resolve(newtype, null);
            }
            int startind = comp.getOrdinal();
            int endind = this.getEndComponentIndex(dt, comp, newtype);
            if (endind < 0) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type structure '" + dt.getName() + "': Datatype did not fit"));
                return;
            }
            for (int i = endind; i > startind; --i) {
                dt.clearComponent(i);
            }
            dt.replaceAtOffset(comp.getOffset(), newtype, newtype.getLength(), comp.getFieldName(), comp.getComment());
            successfulMod = true;
        }
        finally {
            program.endTransaction(transaction, successfulMod);
        }
    }

    public static boolean checkFullCommit(HighVariable var, HighFunction hfunction) {
        if (var != null && !(var instanceof HighParam)) {
            return false;
        }
        Function function = hfunction.getFunction();
        Parameter[] parameters = function.getParameters();
        LocalSymbolMap localSymbolMap = hfunction.getLocalSymbolMap();
        int numParams = localSymbolMap.getNumParams();
        if (numParams != parameters.length) {
            return true;
        }
        for (int i = 0; i < numParams; ++i) {
            HighParam param = localSymbolMap.getParam(i);
            if (param.getSlot() != i) {
                return true;
            }
            VariableStorage storage = param.getStorage();
            if (0 == storage.compareTo(parameters[i].getVariableStorage())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = this.controller.getFunction();
        if (function instanceof UndefinedFunction) {
            return false;
        }
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            Structure dt = RenameVariableAction.getStructDataType(tokenAtCursor);
            if (dt == null) {
                return false;
            }
            this.getPopupMenuData().setMenuItemName("Retype Field");
            return true;
        }
        if (tokenAtCursor.Parent() instanceof ClangReturnType) {
            this.getPopupMenuData().setMenuItemName("Retype Return");
            return true;
        }
        if (!tokenAtCursor.isVariableRef()) {
            return false;
        }
        HighVariable variable = tokenAtCursor.getHighVariable();
        if (variable == null) {
            Address addr = RenameVariableAction.getStorageAddress(tokenAtCursor, this.controller);
            if (addr == null) {
                return false;
            }
            variable = RenameVariableAction.forgeHighVariable(addr, this.controller);
            if (variable == null) {
                return false;
            }
        }
        if (!(variable instanceof HighConstant)) {
            if (variable instanceof HighLocal) {
                this.getPopupMenuData().setMenuItemName("Retype Variable");
                return true;
            }
            if (variable instanceof HighGlobal) {
                this.getPopupMenuData().setMenuItemName("Retype Global");
                return true;
            }
        }
        return false;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        HighVariable variable = null;
        Structure struct = null;
        DataTypeComponent comp = null;
        DataType dataType = null;
        if (tokenAtCursor instanceof ClangFieldToken) {
            struct = RenameVariableAction.getStructDataType(tokenAtCursor);
            int offset = RenameVariableAction.getDataTypeOffset(tokenAtCursor);
            if (struct == null) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Retype Failed", (Object)"Failed to re-type structure");
                return;
            }
            if (offset < 0 || offset >= struct.getLength()) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type structure: " + struct.getName()));
                return;
            }
            comp = struct.getComponentAt(offset);
            dataType = comp == null ? this.chooseDataType(DataType.DEFAULT) : this.chooseDataType(comp.getDataType());
        } else {
            if (tokenAtCursor.Parent() instanceof ClangReturnType) {
                ClangReturnType parent = (ClangReturnType)tokenAtCursor.Parent();
                dataType = this.chooseDataType(parent.getDataType());
                if (dataType == null) {
                    return;
                }
                this.retypeReturnType(dataType, parent);
                return;
            }
            variable = tokenAtCursor.getHighVariable();
            if (variable == null) {
                Address addr = RenameVariableAction.getStorageAddress(tokenAtCursor, this.controller);
                if (addr == null) {
                    return;
                }
                variable = RenameVariableAction.forgeHighVariable(addr, this.controller);
                if (variable == null) {
                    return;
                }
            }
            dataType = this.chooseDataType(variable.getDataType());
        }
        if (dataType == null) {
            return;
        }
        if (struct != null) {
            this.retypeStructVariable(struct, comp, dataType);
        } else {
            this.retypeVariable(variable, tokenAtCursor.getVarnode(), dataType);
        }
    }
}

