/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import ghidra.bitpatterns.info.ContextRegisterExtent;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.DataGatheringParams;
import ghidra.bitpatterns.info.FileBitPatternInfo;
import ghidra.bitpatterns.info.FunctionBitPatternInfo;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class FileBitPatternInfoReader {
    private List<FunctionBitPatternInfo> fInfoList;
    private List<Long> startingAddresses;
    private ContextRegisterExtent registerExtent;
    private int numFuncs = 0;
    private int numFiles = 0;
    private DataGatheringParams params;

    public FileBitPatternInfoReader(Program program, DataGatheringParams params, Component parent) {
        this.startingAddresses = new ArrayList<Long>();
        this.fInfoList = new ArrayList<FunctionBitPatternInfo>();
        this.registerExtent = new ContextRegisterExtent();
        this.params = params;
        this.numFiles = 1;
        MineProgramTask mineTask = new MineProgramTask(program);
        new TaskLauncher((Task)mineTask, parent);
    }

    public FileBitPatternInfoReader(File xmlDir, Component parent) {
        if (!xmlDir.isDirectory()) {
            throw new IllegalArgumentException(xmlDir.getName() + " is not a directory");
        }
        this.startingAddresses = new ArrayList<Long>();
        this.fInfoList = new ArrayList<FunctionBitPatternInfo>();
        this.registerExtent = new ContextRegisterExtent();
        File[] dataFiles = xmlDir.listFiles();
        ReadDirectoryTask readTask = new ReadDirectoryTask(dataFiles);
        new TaskLauncher((Task)readTask, parent);
    }

    FileBitPatternInfoReader(File xmlDir) {
        if (!xmlDir.isDirectory()) {
            throw new IllegalArgumentException(xmlDir.getName() + " is not a directory");
        }
        this.startingAddresses = new ArrayList<Long>();
        this.fInfoList = new ArrayList<FunctionBitPatternInfo>();
        this.registerExtent = new ContextRegisterExtent();
        this.params = null;
        Iterator dataFiles = FileUtils.iterateFiles((File)xmlDir, null, (boolean)false);
        while (dataFiles.hasNext()) {
            File dataFile = (File)dataFiles.next();
            this.processXmlFile(dataFile);
        }
    }

    private void processFBPIList(List<FunctionBitPatternInfo> fList) {
        for (FunctionBitPatternInfo fInfo : fList) {
            ++this.numFuncs;
            this.fInfoList.add(fInfo);
            this.startingAddresses.add(Long.parseUnsignedLong(fInfo.getAddress(), 16));
            this.registerExtent.addContextInfo(fInfo.getContextRegisters());
        }
    }

    public List<Long> getStartingAddresses() {
        return this.startingAddresses;
    }

    public int getNumFuncs() {
        return this.numFuncs;
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    public ContextRegisterExtent getContextRegisterExtent() {
        return this.registerExtent;
    }

    public List<FunctionBitPatternInfo> getFInfoList() {
        return this.fInfoList;
    }

    public List<Long> getFilteredAddresses(ContextRegisterFilter registerFilter) {
        ArrayList<Long> filteredAddresses = new ArrayList<Long>();
        for (FunctionBitPatternInfo fInfo : this.fInfoList) {
            if (!registerFilter.allows(fInfo.getContextRegisters())) continue;
            filteredAddresses.add(Long.parseUnsignedLong(fInfo.getAddress(), 16));
        }
        return filteredAddresses;
    }

    public DataGatheringParams getDataGatheringParams() {
        return this.params;
    }

    private void processXmlFile(File dataFile) {
        if (!dataFile.getName().endsWith(".xml")) {
            Msg.info((Object)this, (Object)("Skipping " + dataFile.getName()));
            return;
        }
        ++this.numFiles;
        FileBitPatternInfo fileInfo = null;
        try {
            fileInfo = FileBitPatternInfo.fromXmlFile(dataFile);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Error reading FileBitPatternInfo file " + dataFile), (Throwable)e);
            return;
        }
        if (fileInfo.getFuncBitPatternInfo() == null) {
            Msg.info((Object)this, (Object)("fList.getFuncBitPatternInfoList null for " + dataFile));
            return;
        }
        if (this.params == null) {
            this.params = new DataGatheringParams();
            this.params.setNumFirstBytes(fileInfo.getNumFirstBytes());
            this.params.setNumPreBytes(fileInfo.getNumPreBytes());
            this.params.setNumReturnBytes(fileInfo.getNumReturnBytes());
            this.params.setNumFirstInstructions(fileInfo.getNumFirstInstructions());
            this.params.setNumPreInstructions(fileInfo.getNumPreInstructions());
            this.params.setNumReturnInstructions(fileInfo.getNumReturnInstructions());
        }
        this.processFBPIList(fileInfo.getFuncBitPatternInfo());
    }

    class ReadDirectoryTask
    extends Task {
        private File[] dataFiles;

        public ReadDirectoryTask(File[] dataFiles) {
            super("Reading XML", true, true, true);
            this.dataFiles = dataFiles;
        }

        public void run(TaskMonitor monitor) {
            monitor.setMaximum((long)this.dataFiles.length);
            FileBitPatternInfoReader.this.params = null;
            for (File dataFile : this.dataFiles) {
                monitor.incrementProgress(1L);
                FileBitPatternInfoReader.this.processXmlFile(dataFile);
            }
        }
    }

    class MineProgramTask
    extends Task {
        private AddressSetView initialized;
        private FunctionIterator fIter;
        private List<FunctionBitPatternInfo> fList;
        private Program program;

        public MineProgramTask(Program program) {
            super("Mining Program", true, true, true);
            this.program = program;
            this.initialized = program.getMemory().getLoadedAndInitializedAddressSet();
            this.fIter = program.getFunctionManager().getFunctions(true);
            this.fList = new ArrayList<FunctionBitPatternInfo>();
        }

        public void run(TaskMonitor monitor) {
            monitor.setMaximum((long)this.program.getFunctionManager().getFunctionCount());
            while (this.fIter.hasNext() && !monitor.isCancelled()) {
                FunctionBitPatternInfo fStart;
                monitor.incrementProgress(1L);
                Function func = (Function)this.fIter.next();
                if (func.isThunk() || func.isExternal() || !this.initialized.contains(func.getEntryPoint()) || this.program.getListing().getInstructionAt(func.getEntryPoint()) == null || (fStart = new FunctionBitPatternInfo(this.program, func, FileBitPatternInfoReader.this.params)).getFirstBytes() == null) continue;
                this.fList.add(fStart);
            }
            FileBitPatternInfoReader.this.processFBPIList(this.fList);
        }
    }
}

