/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.internal;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GTreeModel
implements TreeModel {
    private GTreeRootNode root;
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private boolean isFiringNodeStructureChanged;

    public GTreeModel(GTreeRootNode root) {
        this.root = root;
    }

    public void setRootNode(GTreeRootNode root) {
        this.root = root;
        this.fireRootChanged();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public GTreeRootNode getModelRoot() {
        return this.root;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        GTreeNode gTreeParent = (GTreeNode)parent;
        return gTreeParent.getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        GTreeNode gTreeParent = (GTreeNode)parent;
        return gTreeParent.getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        GTreeNode gTreeParent = (GTreeNode)parent;
        return gTreeParent.getIndexOfChild((GTreeNode)child);
    }

    @Override
    public boolean isLeaf(Object node) {
        GTreeNode gTreeNode = (GTreeNode)node;
        return gTreeNode.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        node.valueChanged(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeStructureChanged(GTreeNode changedNode) {
        if (this.isFiringNodeStructureChanged) {
            return;
        }
        try {
            this.isFiringNodeStructureChanged = true;
            SystemUtilities.assertThisIsTheSwingThread((String)"GTreeModel.fireNodeStructuredChanged() must be called from the AWT thread");
            TreeModelEvent event = new TreeModelEvent((Object)this, changedNode.getTreePath());
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(event);
            }
        }
        finally {
            this.isFiringNodeStructureChanged = false;
        }
    }

    public void fireRootChanged() {
        SystemUtilities.runIfSwingOrPostSwingLater((Runnable)new Runnable(){

            @Override
            public void run() {
                GTreeRootNode rootNode = GTreeModel.this.root;
                if (rootNode != null) {
                    GTreeModel.this.fireNodeStructureChanged(GTreeModel.this.root);
                }
            }
        });
    }

    public void fireNodeDataChanged(GTreeNode parentNode, GTreeNode changedNode) {
        TreeModelEvent event;
        SystemUtilities.assertThisIsTheSwingThread((String)"GTreeModel.fireNodeChanged() must be called from the AWT thread");
        if (parentNode == null) {
            event = new TreeModelEvent((Object)this, changedNode.getTreePath(), null, null);
        } else {
            int indexInParent = changedNode.getIndexInParent();
            if (indexInParent < 0) {
                return;
            }
            event = new TreeModelEvent((Object)this, parentNode.getTreePath(), new int[]{indexInParent}, new Object[]{changedNode});
        }
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(event);
        }
    }

    public void fireNodeAdded(GTreeNode parentNode, GTreeNode newNode) {
        SystemUtilities.assertThisIsTheSwingThread((String)"GTreeModel.fireNodeAdded() must be called from the AWT thread");
        int indexInParent = newNode.getIndexInParent();
        if (indexInParent < 0) {
            return;
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, parentNode.getTreePath(), new int[]{indexInParent}, new Object[]{newNode});
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(event);
        }
    }

    public void fireNodeRemoved(GTreeNode parentNode, GTreeNode removedNode, int oldIndexInParent) {
        SystemUtilities.assertThisIsTheSwingThread((String)"GTreeModel.fireNodeRemoved() must be called from the AWT thread");
        TreeModelEvent event = new TreeModelEvent((Object)this, parentNode.getTreePath(), new int[]{oldIndexInParent}, new Object[]{removedNode});
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(event);
        }
    }

    public void dispose() {
        this.root = null;
    }
}

