/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.ColumnSortState;
import docking.widgets.table.TableSortState;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;

public class TableSortingContext<T> {
    private TableSortState sortState;
    private Comparator<T> comparator;

    public TableSortingContext(TableSortState sortState, Comparator<T> comparator) {
        this.sortState = Objects.requireNonNull(sortState);
        this.comparator = Objects.requireNonNull(comparator);
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public TableSortState getSortState() {
        return this.sortState;
    }

    public boolean isUnsorted() {
        return this.sortState.isUnsorted();
    }

    public boolean isReverseOf(TableSortingContext<T> otherContext) {
        Iterator<ColumnSortState> otherIterator;
        ColumnSortState otherOnlyItem;
        int otherColumnIndex;
        int sortedColumnCount = this.sortState.getSortedColumnCount();
        if (sortedColumnCount != 1) {
            return false;
        }
        int otherSortedColumnCount = otherContext.sortState.getSortedColumnCount();
        if (sortedColumnCount != otherSortedColumnCount) {
            return false;
        }
        Iterator<ColumnSortState> iterator = this.sortState.iterator();
        ColumnSortState onlyItem = iterator.next();
        int columnIndex = onlyItem.getColumnModelIndex();
        if (columnIndex != (otherColumnIndex = (otherOnlyItem = (otherIterator = otherContext.sortState.iterator()).next()).getColumnModelIndex())) {
            return false;
        }
        return onlyItem.getSortDirection() != otherOnlyItem.getSortDirection();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TableSortingContext)) {
            return false;
        }
        TableSortingContext other = (TableSortingContext)obj;
        return this.sortState.equals(other.sortState);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sortState == null ? 0 : this.sortState.hashCode());
        return result;
    }

    public String toString() {
        return this.sortState.toString();
    }
}

