/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.indexedscrollpane;

import docking.widgets.indexedscrollpane.IndexedScrollable;
import docking.widgets.indexedscrollpane.ViewToIndexMapper;
import java.math.BigInteger;
import java.util.Arrays;

public class PreMappedViewToIndexMapper
implements ViewToIndexMapper {
    private IndexedScrollable model;
    private int viewHeight;
    private int[] layoutStarts;

    public PreMappedViewToIndexMapper(IndexedScrollable model) {
        this.model = model;
        this.createLayoutStarts();
    }

    private void createLayoutStarts() {
        int n = this.model.getIndexCount().intValue();
        this.layoutStarts = new int[n];
        int yPos = 0;
        for (int i = 0; i < n; ++i) {
            this.layoutStarts[i] = yPos;
            int height = this.model.getHeight(BigInteger.valueOf(i));
            yPos += height;
        }
        this.viewHeight = yPos;
    }

    @Override
    public BigInteger getIndex(int value) {
        int index = Arrays.binarySearch(this.layoutStarts, value);
        if (index < 0) {
            index = -index - 2;
        }
        return BigInteger.valueOf(index);
    }

    @Override
    public int getScrollValue(BigInteger startIndex, BigInteger endIndex, int startY, int endY) {
        if (this.layoutStarts.length == 0) {
            return 0;
        }
        return this.layoutStarts[startIndex.intValue()] - startY;
    }

    @Override
    public int getVerticalOffset(int value) {
        if (this.layoutStarts.length == 0) {
            return 0;
        }
        int index = Arrays.binarySearch(this.layoutStarts, value);
        if (index >= 0) {
            return 0;
        }
        index = -index - 2;
        return this.layoutStarts[index] - value;
    }

    @Override
    public int getViewHeight() {
        return this.viewHeight;
    }

    @Override
    public void setVisibleViewHeight(int height) {
    }

    @Override
    public void indexModelDataChanged(BigInteger start, BigInteger end) {
        int startIndex = start.intValue();
        int endIndex = Math.min(this.layoutStarts.length, end.intValue() + 1);
        int yPos = this.layoutStarts[startIndex];
        for (int i = startIndex; i < endIndex; ++i) {
            this.layoutStarts[i] = yPos;
            int height = this.model.getHeight(BigInteger.valueOf(i));
            yPos += height;
        }
        if (endIndex < this.layoutStarts.length) {
            int diff = yPos - this.layoutStarts[endIndex];
            for (int i = endIndex; i < this.layoutStarts.length; ++i) {
                this.layoutStarts[i] = this.layoutStarts[i] + diff;
            }
            this.viewHeight += diff;
        } else {
            this.viewHeight = yPos;
        }
    }
}

