/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.FunctionSignatureImpl;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.DataTypeSymbol;
import ghidra.program.model.pcode.DynamicSymbol;
import ghidra.program.model.pcode.FunctionPrototype;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.UsrException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HighFunctionDBUtil {
    public static final String AUTO_CAT = "/auto_proto";

    public static void commitReturnToDatabase(HighFunction highFunction, SourceType source) {
        try {
            DataType dataType;
            Function function = highFunction.getFunction();
            String convention = function.getCallingConventionName();
            String modelName = highFunction.getFunctionPrototype().getModelName();
            if (modelName != null && !modelName.equals(convention)) {
                function.setCallingConvention(modelName);
            }
            if ((dataType = highFunction.getFunctionPrototype().getReturnType()) == null) {
                dataType = DefaultDataType.dataType;
                source = SourceType.DEFAULT;
            }
            function.setReturnType(dataType, source);
        }
        catch (InvalidInputException e) {
            Msg.error(HighFunctionDBUtil.class, (Object)e.getMessage());
        }
    }

    public static void commitParamsToDatabase(HighFunction highFunction, boolean useDataTypes, SourceType source) throws DuplicateNameException, InvalidInputException {
        Function function = highFunction.getFunction();
        List<Parameter> params = HighFunctionDBUtil.getParameters(highFunction, useDataTypes);
        HighFunctionDBUtil.commitParamsToDatabase(function, highFunction.getFunctionPrototype(), params, highFunction.getFunctionPrototype().isVarArg(), true, source);
    }

    private static List<Parameter> getParameters(HighFunction highFunction, boolean useDataTypes) throws InvalidInputException {
        Function function = highFunction.getFunction();
        Program program = function.getProgram();
        DataTypeManager dtm = program.getDataTypeManager();
        LocalSymbolMap symbolMap = highFunction.getLocalSymbolMap();
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        int paramCnt = symbolMap.getNumParams();
        for (int i = 0; i < paramCnt; ++i) {
            DataType dataType;
            HighParam param = symbolMap.getParam(i);
            String name = param.getName();
            if (useDataTypes) {
                dataType = param.getDataType();
            } else {
                dataType = Undefined.getUndefinedDataType(param.getSize());
                dataType = dataType.clone(dtm);
            }
            params.add(new ParameterImpl(name, dataType, param.getStorage(), program));
        }
        return params;
    }

    public static void commitParamsToDatabase(Function function, FunctionPrototype prototype, List<Parameter> params, boolean hasVarArgs, boolean renameConflicts, SourceType source) throws DuplicateNameException, InvalidInputException {
        String modelName = prototype != null ? prototype.getModelName() : null;
        try {
            function.updateFunction(modelName, null, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, source);
        }
        catch (DuplicateNameException e) {
            if (!renameConflicts) {
                throw e;
            }
            for (Variable variable : params) {
                HighFunctionDBUtil.changeConflictingSymbolNames(variable.getName(), null, function);
            }
            function.updateFunction(modelName, null, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, source);
        }
        if (!VariableUtilities.storageMatches(params, function.getParameters())) {
            function.updateFunction(modelName, null, params, Function.FunctionUpdateType.CUSTOM_STORAGE, true, source);
        }
        if (function.hasVarArgs() != hasVarArgs) {
            function.setVarArgs(hasVarArgs);
        }
    }

    private static void changeConflictingSymbolNames(String name, Variable ignoreVariable, Function func) {
        Object newName = name;
        Symbol sym = func.getProgram().getSymbolTable().getVariableSymbol((String)newName, func);
        if (sym == null || sym.isDynamic()) {
            return;
        }
        if (ignoreVariable != null && sym.equals(ignoreVariable.getSymbol())) {
            return;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            newName = name + "_" + i;
            try {
                sym.setName((String)newName, sym.getSource());
                break;
            }
            catch (DuplicateNameException duplicateNameException) {
                continue;
            }
            catch (InvalidInputException e) {
                break;
            }
        }
    }

    public static void commitLocalsToDatabase(HighFunction highFunction, SourceType source) {
        Function function = highFunction.getFunction();
        HighFunctionDBUtil.clearObsoleteDynamicLocalsFromDatabase(highFunction);
        Iterator<HighSymbol> iter = highFunction.getLocalSymbolMap().getSymbols();
        while (iter.hasNext()) {
            HighSymbol sym = iter.next();
            HighVariable high = sym.getHighVariable();
            if (high instanceof HighParam || !(high instanceof HighLocal)) continue;
            HighLocal local = (HighLocal)high;
            String name = local.getName();
            try {
                Variable var = HighFunctionDBUtil.clearConflictingLocalVariables(local);
                if (var == null) {
                    var = HighFunctionDBUtil.createLocalVariable(local, null, null, source);
                    if (name == null) continue;
                    var.setName(name, source);
                    continue;
                }
                var.setDataType(local.getDataType(), local.getStorage(), false, source);
                var.setName(name, source);
            }
            catch (UsrException e) {
                Msg.error(HighFunctionDBUtil.class, (Object)("Local variable commit failed for " + function.getName() + ":" + name + " : " + e.getMessage()));
            }
        }
    }

    private static Variable createLocalVariable(HighLocal local, DataType dt, VariableStorage storage, SourceType source) throws InvalidInputException {
        Function function = local.getHighFunction().getFunction();
        Program program = function.getProgram();
        if (storage == null || storage.isUniqueStorage()) {
            storage = local.getStorage();
        }
        if (dt == null) {
            dt = local.getDataType();
        }
        Variable var = new LocalVariableImpl(null, local.getFirstUseOffset(), dt, storage, program);
        try {
            var = function.addLocalVariable(var, SourceType.ANALYSIS);
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Unexpected exception with default name", (Throwable)e);
        }
        Register reg = var.getRegister();
        if (reg != null) {
            program.getReferenceManager().addRegisterReference(local.getPCAddress(), -1, reg, RefType.WRITE, source);
        }
        return var;
    }

    private static void clearObsoleteDynamicLocalsFromDatabase(HighFunction highFunction) {
        Variable[] variables;
        Function function = highFunction.getFunction();
        for (Variable var : variables = function.getLocalVariables()) {
            if (!var.isUniqueVariable() || HighFunctionDBUtil.isValidUniqueVariable(highFunction, var)) continue;
            function.removeVariable(var);
        }
    }

    private static boolean isValidUniqueVariable(HighFunction highFunction, Variable var) {
        if (!var.isUniqueVariable()) {
            return false;
        }
        long hash = var.getFirstStorageVarnode().getOffset();
        Iterator<HighSymbol> symbols = highFunction.getLocalSymbolMap().getSymbols();
        while (symbols.hasNext()) {
            HighVariable high = symbols.next().getHighVariable();
            if (!(high instanceof HighLocal) || ((HighLocal)high).buildDynamicHash() != hash) continue;
            return true;
        }
        return false;
    }

    private static Variable clearConflictingLocalVariables(HighLocal local) {
        if (local instanceof HighParam) {
            throw new IllegalArgumentException();
        }
        HighFunction highFunction = local.getHighFunction();
        Function func = highFunction.getFunction();
        HighSymbol symbol = local.getSymbol();
        VariableStorage storage = local.getStorage();
        int firstUseOffset = local.getFirstUseOffset();
        if (symbol instanceof DynamicSymbol || storage.isUniqueStorage()) {
            if (!(symbol instanceof DynamicSymbol)) {
                return null;
            }
            DynamicSymbol dynamicSym = (DynamicSymbol)symbol;
            for (Variable ul : func.getLocalVariables(VariableFilter.UNIQUE_VARIABLE_FILTER)) {
                if (ul.getFirstStorageVarnode().getOffset() != dynamicSym.getHash()) continue;
                return ul;
            }
            return null;
        }
        Variable matchingVariable = null;
        for (Variable otherVar : func.getLocalVariables()) {
            VariableStorage otherStorage;
            if (otherVar.getFirstUseOffset() != firstUseOffset || !(otherStorage = otherVar.getVariableStorage()).intersects(storage)) continue;
            if (matchingVariable == null && otherStorage.equals(storage)) {
                matchingVariable = otherVar;
                continue;
            }
            func.removeVariable(otherVar);
        }
        return matchingVariable;
    }

    private static Parameter getDatabaseParameter(HighParam param) throws InvalidInputException {
        Parameter[] parameters;
        HighFunction highFunction = param.getHighFunction();
        Function function = highFunction.getFunction();
        int slot = param.getSlot();
        if (slot < (parameters = function.getParameters()).length && parameters[slot].isAutoParameter()) {
            throw new InvalidInputException("Cannot modify auto-parameter: " + parameters[slot].getName());
        }
        if (slot >= parameters.length || !parameters[slot].getVariableStorage().equals(param.getStorage())) {
            try {
                HighFunctionDBUtil.commitParamsToDatabase(highFunction, true, SourceType.ANALYSIS);
            }
            catch (DuplicateNameException e) {
                throw new AssertException("Unexpected exception", (Throwable)e);
            }
            parameters = function.getParameters();
            if (slot >= parameters.length || !parameters[slot].getVariableStorage().equals(param.getStorage())) {
                throw new InvalidInputException("Parameter commit failed for function at " + function.getEntryPoint());
            }
        }
        return parameters[slot];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateDBVariable(HighVariable variable, String name, DataType dataType, SourceType source) throws InvalidInputException, DuplicateNameException {
        boolean isRename;
        HighFunction highFunction = variable.getHighFunction();
        Function function = highFunction.getFunction();
        Program program = function.getProgram();
        boolean resized = false;
        if (dataType != null) {
            if ((dataType = dataType.clone(program.getDataTypeManager())).getLength() <= 0) {
                throw new InvalidInputException("Data type is not fixed-length: " + dataType.getName());
            }
            resized = dataType.getLength() != variable.getSize();
        }
        boolean bl = isRename = name != null;
        if (variable instanceof HighParam) {
            HighParam param = (HighParam)variable;
            Parameter dbParam = HighFunctionDBUtil.getDatabaseParameter(param);
            VariableStorage storage = param.getStorage();
            if (dataType != null) {
                if (resized && function.hasCustomVariableStorage()) {
                    VariableStorage newStorage = VariableUtilities.resizeStorage(storage, dataType, true, function);
                    dbParam.setDataType(dataType, newStorage, false, source);
                } else {
                    dbParam.setDataType(dataType, source);
                }
            }
            if (name == null || name.equals(dbParam.getName())) return;
            dbParam.setName(name, source);
            return;
        }
        if (variable instanceof HighLocal) {
            HighLocal local = (HighLocal)variable;
            VariableStorage storage = local.getStorage();
            boolean usesHashStorage = storage.isHashStorage();
            Variable var = HighFunctionDBUtil.clearConflictingLocalVariables(local);
            if (dataType == null) {
                if (var != null) {
                    dataType = var.getDataType();
                } else {
                    dataType = Undefined.getUndefinedDataType(variable.getSize());
                    dataType = dataType.clone(program.getDataTypeManager());
                }
            }
            if (resized) {
                if (usesHashStorage) {
                    throw new InvalidInputException("Variable size (" + local.getSize() + ") may not be changed: type '" + dataType.getName() + "' length is " + dataType.getLength());
                }
                storage = VariableUtilities.resizeStorage(storage, dataType, true, function);
            }
            if (var == null) {
                var = HighFunctionDBUtil.createLocalVariable(local, dataType, storage, source);
            } else {
                var.setDataType(dataType, storage, true, source);
                if (name == null) {
                    name = local.getName();
                }
            }
            try {
                var.setName(name, source);
                return;
            }
            catch (DuplicateNameException e) {
                if (isRename) {
                    throw e;
                }
                try {
                    Msg.error(HighFunctionDBUtil.class, (Object)("Name conflict while naming local variable: " + function.getName() + ":" + name));
                    var.setName(null, SourceType.DEFAULT);
                    return;
                }
                catch (DuplicateNameException e1) {
                    throw new AssertException("Unexpected exception with default name", (Throwable)e);
                }
            }
        }
        if (!(variable instanceof HighGlobal)) throw new UnsupportedOperationException("Database support not provided for " + variable.getClass().getSimpleName());
        VariableStorage storage = variable.getStorage();
        if (!storage.isMemoryStorage()) {
            throw new UnsupportedOperationException("Database supports global memory variables only");
        }
        HighGlobal global = (HighGlobal)variable;
        if (name == null && (name = global.getName()) != null && SymbolUtilities.isDynamicSymbolPattern(name, true)) {
            name = null;
        }
        if (dataType != null) {
            HighFunctionDBUtil.setGlobalDataType(global, dataType);
        }
        if (name == null) return;
        try {
            HighFunctionDBUtil.setGlobalName((HighGlobal)variable, variable.getName(), source);
            return;
        }
        catch (DuplicateNameException e) {
            if (!isRename) return;
            throw e;
        }
    }

    private static void setGlobalName(HighGlobal global, String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        Program program = global.getHighFunction().getFunction().getProgram();
        VariableStorage storage = global.getStorage();
        if (!storage.isMemoryStorage()) {
            return;
        }
        Address addr = storage.getFirstVarnode().getAddress();
        SymbolTable symTable = program.getSymbolTable();
        Symbol sym = symTable.getPrimarySymbol(addr);
        if (sym == null) {
            symTable.createLabel(addr, name, source);
        } else if (!sym.getName().equals(name)) {
            sym.setName(name, source);
        }
    }

    private static Data setGlobalDataType(HighGlobal global, DataType dt) throws InvalidInputException {
        Listing listing;
        Data d;
        Program program = global.getHighFunction().getFunction().getProgram();
        VariableStorage storage = global.getStorage();
        if (!storage.isMemoryStorage()) {
            return null;
        }
        Address addr = storage.getFirstVarnode().getAddress();
        if (storage.size() != dt.getLength() && program.getMemory().isBigEndian()) {
            long delta = storage.size() - dt.getLength();
            try {
                addr = addr.addNoWrap(delta);
            }
            catch (AddressOverflowException e) {
                throw new InvalidInputException("Unable to resize global storage for " + dt.getName() + " at " + addr);
            }
        }
        if ((d = (listing = program.getListing()).getDataAt(addr)) != null && d.getDataType().isEquivalent(dt)) {
            return d;
        }
        try {
            return DataUtilities.createData(program, addr, dt, -1, false, DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
        }
        catch (CodeUnitInsertionException e) {
            throw new InvalidInputException(e.getMessage());
        }
    }

    public static void writeOverride(Function function, Address callsite, FunctionSignature sig) throws InvalidInputException, DuplicateNameException {
        ParameterDefinition[] params = sig.getArguments();
        FunctionSignatureImpl fsig = new FunctionSignatureImpl("tmpname");
        fsig.setGenericCallingConvention(sig.getGenericCallingConvention());
        fsig.setArguments(params);
        fsig.setReturnType(sig.getReturnType());
        fsig.setVarArgs(sig.hasVarArgs());
        FunctionDefinitionDataType dt = new FunctionDefinitionDataType(fsig);
        DataTypeSymbol datsym = new DataTypeSymbol(dt, "prt", AUTO_CAT);
        Program program = function.getProgram();
        SymbolTable symtab = program.getSymbolTable();
        DataTypeManager dtmanage = program.getDataTypeManager();
        Namespace space = HighFunction.findCreateOverrideSpace(function);
        if (space == null) {
            throw new InvalidInputException("Could not create \"override\" namespace");
        }
        datsym.writeSymbol(symtab, callsite, space, dtmanage, true);
    }

    public static DataTypeSymbol readOverride(Symbol sym) {
        DataTypeSymbol datsym = DataTypeSymbol.readSymbol(AUTO_CAT, sym);
        if (datsym == null) {
            return null;
        }
        DataType dt = datsym.getDataType();
        if (!(dt instanceof FunctionSignature)) {
            return null;
        }
        return datsym;
    }
}

