/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.data.AbstractDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class DataTypeImpl
extends AbstractDataType
implements ChangeListener {
    private static final SettingsDefinition[] EMPTY_DEFINITIONS = new SettingsDefinition[0];
    protected Settings defaultSettings = new SettingsImpl((ChangeListener)this, null);
    private ArrayList<DataType> parentList = new ArrayList();
    private UniversalID universalID;
    private SourceArchive sourceArchive;
    private long lastChangeTime;
    private long lastChangeTimeInSourceArchive;

    protected DataTypeImpl(CategoryPath path, String name, DataTypeManager dataMgr) {
        this(path, name, null, null, System.currentTimeMillis(), 0L, dataMgr);
    }

    DataTypeImpl(CategoryPath path, String name, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dataMgr) {
        super(path, name, dataMgr);
        this.universalID = universalID == null ? UniversalIdGenerator.nextID() : universalID;
        this.sourceArchive = sourceArchive;
        this.lastChangeTime = lastChangeTime;
        this.lastChangeTimeInSourceArchive = lastChangeTimeInSourceArchive;
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return null;
    }

    @Override
    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return EMPTY_DEFINITIONS;
    }

    void checkValidName(String checkedName) throws InvalidNameException {
        if (!DataUtilities.isValidDataTypeName(checkedName)) {
            throw new InvalidNameException("Invalid Name: " + checkedName);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void setDefaultSettings(Settings settings) {
        this.defaultSettings = settings;
    }

    @Override
    public String getPathName() {
        return this.getDataTypePath().getPath();
    }

    @Override
    public int getAlignment() {
        int length = this.getLength();
        if (length < 0) {
            return 1;
        }
        return this.getDataOrganization().getAlignment(this, length);
    }

    @Override
    public void addParent(DataType dt) {
        this.parentList.add(dt);
    }

    @Override
    public void removeParent(DataType dt) {
        this.parentList.remove(dt);
    }

    @Override
    public DataType[] getParents() {
        DataType[] dts = new DataType[this.parentList.size()];
        return this.parentList.toArray(dts);
    }

    protected void notifySizeChanged() {
        for (DataType dt : this.parentList) {
            dt.dataTypeSizeChanged(this);
        }
    }

    protected void notifyNameChanged(String oldName) {
        for (DataType dt : this.parentList) {
            dt.dataTypeNameChanged(this, oldName);
        }
    }

    protected void notifyDeleted() {
        for (DataType dt : this.parentList) {
            dt.dataTypeDeleted(this);
        }
    }

    protected void notifyReplaced(DataType replacement) {
        for (DataType dt : this.parentList) {
            dt.dataTypeReplaced(this, replacement);
        }
    }

    @Override
    public long getLastChangeTime() {
        return this.lastChangeTime;
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return this.lastChangeTimeInSourceArchive;
    }

    @Override
    public SourceArchive getSourceArchive() {
        return this.sourceArchive;
    }

    @Override
    public void setSourceArchive(SourceArchive archive) {
        this.sourceArchive = archive;
    }

    @Override
    public UniversalID getUniversalID() {
        return this.universalID;
    }

    @Override
    public void replaceWith(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLastChangeTime(long lastChangeTime) {
        this.lastChangeTime = lastChangeTime;
    }

    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTimeInSourceArchive) {
        this.lastChangeTimeInSourceArchive = lastChangeTimeInSourceArchive;
    }

    @Override
    public void setDescription(String description) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't allow the description to be changed.");
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof DataType)) {
            return false;
        }
        DataType otherDt = (DataType)obj;
        return otherDt.getDataTypeManager() == this.getDataTypeManager() && this.categoryPath.equals(otherDt.getCategoryPath()) && this.name.equals(otherDt.getName()) && this.isEquivalent(otherDt);
    }
}

