/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next.sectionprovider;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.bin.format.elf.ElfException;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.program.model.listing.Program;
import java.io.File;
import java.io.IOException;

public class ElfSectionProvider
implements DWARFSectionProvider {
    private ElfHeader header;
    private RandomAccessByteProvider provider;

    public static ElfSectionProvider createSectionProviderFor(Program program) {
        if ("Executable and Linking Format (ELF)".equals(program.getExecutableFormat())) {
            try {
                File exePath = new File(program.getExecutablePath());
                return new ElfSectionProvider(exePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public ElfSectionProvider(File exeFile) throws IOException {
        this.provider = new RandomAccessByteProvider(exeFile);
        try {
            this.header = ElfHeader.createElfHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, this.provider);
            this.header.parse();
        }
        catch (ElfException e) {
            this.provider.close();
            throw new IOException("Error parsing ELF", e);
        }
    }

    @Override
    public ByteProvider getSectionAsByteProvider(String sectionName) throws IOException {
        ElfSectionHeader section = this.header.getSection("." + sectionName);
        return section != null ? new ByteProviderWrapper(section.getReader().getByteProvider(), section.getOffset(), section.getSize()) : null;
    }

    @Override
    public void close() {
        try {
            this.provider.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasSection(String ... sectionNames) {
        for (String sectionName : sectionNames) {
            if (this.header.getSection("." + sectionName) != null) continue;
            return false;
        }
        return true;
    }
}

