/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.services.BlockModelServiceListener;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.NotFoundException;

@ServiceInfo(description="Provides registration and distribution of basic-block and subroutine models.")
public interface BlockModelService {
    public static final int BASIC_MODEL = 1;
    public static final int SUBROUTINE_MODEL = 2;
    public static final String SIMPLE_BLOCK_MODEL_NAME = "Simple Block";
    public static final String MULTI_ENTRY_SUBROUTINE_MODEL_NAME = "Multiple Entry";
    public static final String ISOLATED_ENTRY_SUBROUTINE_MODEL_NAME = "Isolated Entry";
    public static final String OVERLAPPED_SUBROUTINE_MODEL_NAME = "Overlapped Code";
    public static final String PARTITIONED_SUBROUTINE_MODEL_NAME = "Partitioned Code";
    public static final String DEFAULT_BLOCK_MODEL_NAME = "Simple Block";
    public static final String DEFAULT_SUBROUTINE_MODEL_NAME = "Multiple Entry";

    public void registerModel(Class<? extends CodeBlockModel> var1, String var2);

    public void unregisterModel(Class<? extends CodeBlockModel> var1);

    public CodeBlockModel getActiveBlockModel();

    public CodeBlockModel getActiveBlockModel(boolean var1);

    public CodeBlockModel getActiveBlockModel(Program var1);

    public CodeBlockModel getActiveBlockModel(Program var1, boolean var2);

    public String getActiveBlockModelName();

    public CodeBlockModel getActiveSubroutineModel();

    public CodeBlockModel getActiveSubroutineModel(boolean var1);

    public CodeBlockModel getActiveSubroutineModel(Program var1);

    public CodeBlockModel getActiveSubroutineModel(Program var1, boolean var2);

    public String getActiveSubroutineModelName();

    public CodeBlockModel getNewModelByName(String var1) throws NotFoundException;

    public CodeBlockModel getNewModelByName(String var1, boolean var2) throws NotFoundException;

    public CodeBlockModel getNewModelByName(String var1, Program var2) throws NotFoundException;

    public CodeBlockModel getNewModelByName(String var1, Program var2, boolean var3) throws NotFoundException;

    public String[] getAvailableModelNames(int var1);

    public void addListener(BlockModelServiceListener var1);

    public void removeListener(BlockModelServiceListener var1);
}

