/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.script.GhidraScriptMgrPlugin;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.ScriptInfo;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

class ScriptAction
extends DockingAction {
    private static final String SCRIPT_GROUP = "_SCRIPT_GROUP_";
    private GhidraScriptMgrPlugin plugin;
    private ResourceFile script;
    private boolean isUserDefinedKeyBinding = false;

    ScriptAction(GhidraScriptMgrPlugin plugin, ResourceFile script) {
        super(script.getName(), plugin.getName());
        this.plugin = plugin;
        this.script = script;
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation(plugin.getName(), plugin.getName()));
        this.refresh();
    }

    public void actionPerformed(ActionContext context) {
        this.plugin.runScript(this.script);
    }

    public void setUnvalidatedKeyBindingData(KeyBindingData keyBindingData) {
        KeyBindingData newKeyBindingData = this.checkForFallbackKeybindingCondition(keyBindingData);
        this.updateUserDefinedKeybindingStatus(newKeyBindingData);
        super.setUnvalidatedKeyBindingData(newKeyBindingData);
        this.plugin.getProvider().keyBindingUpdated();
    }

    public void setKeyBindingData(KeyBindingData keyBindingData) {
        this.isUserDefinedKeyBinding = false;
        if (keyBindingData == null) {
            super.setKeyBindingData(keyBindingData);
            return;
        }
        this.setUnvalidatedKeyBindingData(keyBindingData);
    }

    private KeyBindingData checkForFallbackKeybindingCondition(KeyBindingData keyBindingData) {
        KeyStroke newKeyStroke = keyBindingData.getKeyBinding();
        if (newKeyStroke != null) {
            return keyBindingData;
        }
        ScriptInfo info = GhidraScriptUtil.getScriptInfo(this.script);
        KeyStroke metadataKeyStroke = info.getKeyBinding();
        if (metadataKeyStroke == null) {
            return keyBindingData;
        }
        return new KeyBindingData(metadataKeyStroke, keyBindingData.getKeyBindingPrecedence());
    }

    private void updateUserDefinedKeybindingStatus(KeyBindingData keyBindingData) {
        ScriptInfo info;
        KeyStroke metadataKeyBinding;
        KeyStroke actionKeyStroke = keyBindingData.getKeyBinding();
        this.isUserDefinedKeyBinding = !SystemUtilities.isEqual((Object)actionKeyStroke, (Object)(metadataKeyBinding = (info = GhidraScriptUtil.getScriptInfo(this.script)).getKeyBinding()));
    }

    boolean isUserDefinedKeyBinding() {
        return this.isUserDefinedKeyBinding;
    }

    ResourceFile getScript() {
        return this.script;
    }

    void refresh() {
        ImageIcon icon;
        ScriptInfo info = GhidraScriptUtil.getScriptInfo(this.script);
        KeyStroke stroke = info.getKeyBinding();
        if (!this.isUserDefinedKeyBinding) {
            this.setKeyBindingData(new KeyBindingData(stroke));
        }
        if ((icon = info.getToolBarImage(false)) != null) {
            ToolBarData data = this.getToolBarData();
            if (data != null) {
                data.setIcon((Icon)icon);
            } else {
                this.setToolBarData(new ToolBarData((Icon)icon, SCRIPT_GROUP));
            }
        }
        this.setDescription(info.getDescription());
        MenuData menuData = this.getMenuBarData();
        Object[] oldMenuPath = menuData == null ? null : menuData.getMenuPath();
        Object[] newMenuPath = info.getMenuPath();
        if (SystemUtilities.isArrayEqual((Object[])oldMenuPath, (Object[])newMenuPath)) {
            return;
        }
        this.plugin.getTool().removeAction((DockingActionIf)this);
        if (newMenuPath != null && newMenuPath.length > 0) {
            MenuData data = this.getMenuBarData();
            if (data != null) {
                data.setMenuPath((String[])newMenuPath);
            } else {
                this.setMenuBarData(new MenuData((String[])newMenuPath, (Icon)icon, SCRIPT_GROUP));
            }
        } else {
            this.setMenuBarData(null);
        }
        this.plugin.getTool().addAction((DockingActionIf)this);
    }
}

