/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.actions.KeyBindingUtils;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class FunctionSignatureTextField
extends JTextPane {
    private static final String ENTER_ACTION_NAME = "ENTER";
    private static final String ESCAPE_ACTION_NAME = "ESCAPE";
    private static final String TAB_ACTION_NAME = "TAB";
    public static Color DEFAULT_COLOR = Color.black;
    public static Color PARAMETER_NAME_COLOR = new Color(155, 50, 155);
    public static Color FUNCTION_NAME_COLOR = Color.blue;
    public static Color ERROR_NAME_COLOR = Color.red;
    private StyledDocument doc;
    private SimpleAttributeSet paramNameAttributes;
    private SimpleAttributeSet functionNameAttributes;
    private SimpleAttributeSet defaultAttributes;
    private ActionListener actionListener;
    private ActionListener escapeListener;
    private ActionListener tabListener;
    private ChangeListener changeListener;
    private SimpleAttributeSet errorAttributes;

    FunctionSignatureTextField() {
        Font myFont = this.getFont();
        this.setFont(myFont.deriveFont(24.0f));
        this.doc = this.getStyledDocument();
        MutableAttributeSet inputAttributes = this.getInputAttributes();
        this.paramNameAttributes = new SimpleAttributeSet(inputAttributes);
        StyleConstants.setForeground(this.paramNameAttributes, PARAMETER_NAME_COLOR);
        this.functionNameAttributes = new SimpleAttributeSet(inputAttributes);
        StyleConstants.setForeground(this.functionNameAttributes, FUNCTION_NAME_COLOR);
        this.errorAttributes = new SimpleAttributeSet(inputAttributes);
        StyleConstants.setForeground(this.errorAttributes, ERROR_NAME_COLOR);
        this.defaultAttributes = new SimpleAttributeSet(inputAttributes);
        StyleConstants.setForeground(this.defaultAttributes, DEFAULT_COLOR);
        this.doc.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FunctionSignatureTextField.this.updateColors();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FunctionSignatureTextField.this.clearAttributes(e.getOffset(), e.getLength());
                FunctionSignatureTextField.this.updateColors();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        AbstractAction enterAction = new AbstractAction(ENTER_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FunctionSignatureTextField.this.actionListener != null) {
                    FunctionSignatureTextField.this.actionListener.actionPerformed(e);
                }
            }
        };
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyBindingUtils.registerAction((JComponent)this, (KeyStroke)enter, (Action)enterAction, (int)0);
        KeyBindingUtils.registerAction((JComponent)this, (KeyStroke)enter, (Action)enterAction, (int)2);
        AbstractAction escapeAction = new AbstractAction(ESCAPE_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FunctionSignatureTextField.this.escapeListener != null) {
                    FunctionSignatureTextField.this.escapeListener.actionPerformed(e);
                }
            }
        };
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        KeyBindingUtils.registerAction((JComponent)this, (KeyStroke)escape, (Action)escapeAction, (int)0);
        KeyBindingUtils.registerAction((JComponent)this, (KeyStroke)escape, (Action)escapeAction, (int)2);
        AbstractAction tabAction = new AbstractAction(TAB_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FunctionSignatureTextField.this.tabListener != null) {
                    FunctionSignatureTextField.this.tabListener.actionPerformed(e);
                }
            }
        };
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        KeyBindingUtils.registerAction((JComponent)this, (KeyStroke)tab, (Action)tabAction, (int)0);
        KeyBindingUtils.registerAction((JComponent)this, (KeyStroke)tab, (Action)tabAction, (int)2);
    }

    void setActionListener(ActionListener listener) {
        this.actionListener = listener;
    }

    void setEscapeListener(ActionListener listener) {
        this.escapeListener = listener;
    }

    void setTabListener(ActionListener listener) {
        this.tabListener = listener;
    }

    private void updateColors() {
        Swing.runLater(() -> {
            String text = this.getText();
            List<ColorField> computeColors = this.computeColors(text);
            if (computeColors != null) {
                this.doc.setCharacterAttributes(0, text.length(), this.defaultAttributes, true);
                for (ColorField colorField : computeColors) {
                    this.doc.setCharacterAttributes(colorField.start, colorField.length(), colorField.attributes, true);
                }
            }
            this.notifyChange();
        });
    }

    void clearAttributes(int start, int length) {
        Swing.runLater(() -> this.doc.setCharacterAttributes(start, length, this.defaultAttributes, true));
    }

    void notifyChange() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    void setChangeListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    List<ColorField> computeColors(String text) {
        ArrayList<ColorField> list = new ArrayList<ColorField>();
        int functionRightParenIndex = text.lastIndexOf(41);
        int functionLeftParenIndex = this.findMatchingLeftParenIndex(text, functionRightParenIndex);
        if (functionLeftParenIndex < 0) {
            return null;
        }
        List<Integer> paramStartStopIndexes = this.findParamStartStopindexes(text, functionLeftParenIndex, functionRightParenIndex);
        if (paramStartStopIndexes == null) {
            return null;
        }
        SubString substring = new SubString(text, 0, functionLeftParenIndex).trim();
        SubString functionName = this.getLastWord(substring);
        if (functionName == null) {
            return null;
        }
        list.add(new ColorField(functionName.getStart(), functionName.getEnd(), this.functionNameAttributes));
        for (int i = 0; i < paramStartStopIndexes.size() - 1; ++i) {
            SubString paramName;
            int start = paramStartStopIndexes.get(i) + 1;
            int end = paramStartStopIndexes.get(i + 1);
            SubString paramString = new SubString(text, start, end);
            if ((paramString = paramString.trim()).toString().equals("...") || paramString.toString().equals("void")) continue;
            if (paramString.length() == 0 && paramStartStopIndexes.size() == 2 || (paramName = this.getLastWord(paramString)) == null) break;
            while (paramName.length() > 0 && paramName.charAt(0) == '*') {
                paramName = paramName.substring(1);
            }
            list.add(new ColorField(paramName.getStart(), paramName.getEnd(), this.paramNameAttributes));
        }
        return list;
    }

    private SubString getLastWord(SubString string) {
        int lastIndexOf = string.lastIndexOf(' ');
        if (lastIndexOf < 0) {
            return null;
        }
        return string.substring(lastIndexOf + 1);
    }

    private List<Integer> findParamStartStopindexes(String text, int startIndex, int endIndex) {
        ArrayList<Integer> commaIndexes = new ArrayList<Integer>();
        int templateCount = 0;
        commaIndexes.add(startIndex);
        for (int i = startIndex + 1; i < endIndex; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                ++templateCount;
                continue;
            }
            if (c == '>') {
                --templateCount;
                continue;
            }
            if (c != ',' || templateCount != 0) continue;
            commaIndexes.add(i);
        }
        if (templateCount != 0) {
            return null;
        }
        commaIndexes.add(endIndex);
        return commaIndexes;
    }

    private int findMatchingLeftParenIndex(String text, int lastRightParenIndex) {
        int parenLevel = 1;
        for (int i = lastRightParenIndex - 1; i >= 0; --i) {
            char c = text.charAt(i);
            if (c == ')') {
                ++parenLevel;
                continue;
            }
            if (c != '(' || --parenLevel != 0) continue;
            return i;
        }
        return -1;
    }

    public static void main(String[] args) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        FunctionSignatureTextField field = new FunctionSignatureTextField();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jFrame.getContentPane().add(panel);
        panel.add(field);
        jFrame.setSize(400, 200);
        jFrame.setVisible(true);
    }

    void setError(int position, int length) {
        Swing.runLater(() -> this.doc.setCharacterAttributes(position, length, this.errorAttributes, true));
    }

    private class SubString {
        private String text;
        private int subStringStart;
        private int subStringEnd;

        SubString(String text, int start, int end) {
            this.text = text;
            this.subStringStart = start;
            this.subStringEnd = end;
        }

        public char charAt(int i) {
            return this.text.charAt(this.subStringStart + i);
        }

        public int length() {
            return this.subStringEnd - this.subStringStart;
        }

        public int getEnd() {
            return this.subStringEnd;
        }

        public int getStart() {
            return this.subStringStart;
        }

        public SubString substring(int start) {
            return new SubString(this.text, this.subStringStart + start, this.subStringEnd);
        }

        public String toString() {
            return this.text.substring(this.subStringStart, this.subStringEnd);
        }

        public int lastIndexOf(char c) {
            for (int i = this.subStringEnd - 1; i >= this.subStringStart; --i) {
                if (this.text.charAt(i) != c) continue;
                return i - this.subStringStart;
            }
            return -1;
        }

        public SubString trim() {
            int start;
            int end = this.subStringEnd;
            for (start = this.subStringStart; this.text.charAt(start) == ' ' && start < end; ++start) {
            }
            while (this.text.charAt(end - 1) == ' ' && start < end) {
                --end;
            }
            if (start == this.subStringStart && end == this.subStringEnd) {
                return this;
            }
            return new SubString(this.text, start, end);
        }
    }

    private static class ColorField {
        int start;
        int end;
        AttributeSet attributes;

        ColorField(int start, int end, AttributeSet attributes) {
            this.start = start;
            this.end = end;
            this.attributes = attributes;
        }

        public int length() {
            return this.end - this.start;
        }
    }
}

