/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import ghidra.app.plugin.core.compositeeditor.BitFieldEditorDialog;
import ghidra.app.plugin.core.compositeeditor.CompEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AddBitFieldAction
extends CompositeEditorTableAction {
    private static final String ACTION_NAME = "Add Bitfield";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Add a bitfield at the position of a selected component";
    private static String[] popupPath = new String[]{"Add Bitfield"};

    public AddBitFieldAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Add Bitfield", GROUP_NAME, popupPath, null, null);
        this.setDescription(DESCRIPTION);
        if (!(this.model instanceof CompEditorModel)) {
            throw new AssertException("unsupported use");
        }
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        CompEditorModel editorModel = (CompEditorModel)this.model;
        if (editorModel.getNumSelectedRows() != 1 || editorModel.isFlexibleArraySelection()) {
            return;
        }
        int rowIndex = this.model.getSelectedRows()[0];
        BitFieldEditorDialog dlg = new BitFieldEditorDialog(editorModel.viewComposite, this.provider.dtmService, -(rowIndex + 1), ordinal -> this.refreshTableAndSelection(editorModel, ordinal));
        JComponent c = this.provider.getComponent();
        Window w = SwingUtilities.windowForComponent(c);
        DockingWindowManager.showDialog((Window)w, (DialogComponentProvider)dlg, (Component)c);
        this.requestTableFocus();
    }

    private void refreshTableAndSelection(CompEditorModel editorModel, int ordinal) {
        editorModel.notifyCompositeChanged();
    }

    @Override
    public void adjustEnablement() {
        boolean enabled = true;
        CompEditorModel editorModel = (CompEditorModel)this.model;
        if (!(editorModel.viewComposite instanceof Structure) || editorModel.isAligned() || editorModel.getNumSelectedRows() != 1 || editorModel.isFlexibleArraySelection()) {
            enabled = false;
        }
        this.setEnabled(enabled);
    }
}

