
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 1189
 * transforms:
 *    ('imul', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b@32') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('udiv', 'a', '#b@32(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b@32(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fabs', 'a')) => ('fabs', 'a')
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('f2b', ('fneg', 'a')) => ('f2b', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('iadd', 'a', 0) => a
 *    ('usadd_4x8', 'a', 0) => a
 *    ('usadd_4x8', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8', 'a', 0) => 0
 *    ('umul_unorm_4x8', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd', 'a', 'b'), ('fadd', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', ('fadd', 'a', 'b'), ('fadd', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('~fadd', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('ffma', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~fadd', ('fmul', 'a', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i32', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 63))
 *    ('ishl@32', ('ushr@32', 'a', 1), 1) => ('iand', 'a', 4294967294)
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('ishl@32', ('ushr@32', 'a', 2), 2) => ('iand', 'a', 4294967292)
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('ishl@32', ('ushr@32', 'a', 3), 3) => ('iand', 'a', 4294967288)
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('ishl@32', ('ushr@32', 'a', 4), 4) => ('iand', 'a', 4294967280)
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('ishl@32', ('ushr@32', 'a', 5), 5) => ('iand', 'a', 4294967264)
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('ishl@32', ('ushr@32', 'a', 6), 6) => ('iand', 'a', 4294967232)
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('~inot', ('flt', 'a', 'b')) => ('fge', 'a', 'b')
 *    ('~inot', ('fge', 'a', 'b')) => ('flt', 'a', 'b')
 *    ('inot', ('feq', 'a', 'b')) => ('fne', 'a', 'b')
 *    ('inot', ('fne', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fne', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fne', ('fneg', 'a'), ('fneg', 'b')) => ('fne', 'b', 'a')
 *    ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a')
 *    ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0)
 *    ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a')
 *    ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0)
 *    ('fne', ('fneg', 'a'), -1.0) => ('fne', 1.0, 'a')
 *    ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0)
 *    ('flt', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('flt', 'a', 'b')
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('fge', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('fge', 'b', 'a')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fne', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fne', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', ('fsat(is_used_once)', 'a'), 1.0) => ('flt', 'a', 1.0)
 *    ('fge', 0.0, ('fsat(is_used_once)', 'a')) => ('fge', 0.0, 'a')
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fne', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fne', ('fmax', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fne', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fne', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fne', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fne', ('fmin', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fne', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fne', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fne', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fne', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmax', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fmin', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fne', ('fadd', 'a', 'b'), 'a') => ('fne', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fne', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fne', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fne', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fne', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('fge', ('fmin', ('fneg', ('b2f', 'a@1')), 'b@1'), 0.0) => ('iand', ('inot', 'a'), ('fge', 'b', 0.0))
 *    ('feq', ('fmin', ('fneg', ('b2f', 'a@1')), 'b@1'), 0.0) => ('iand', ('inot', 'a'), ('fge', 'b', 0.0))
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('~fne', ('b2f', 'a@1'), 0.0) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('fne', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fne', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fne', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fne', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('ior', ('flt', 'a', 0.0), ('flt', 1.0, 'a')) => ('fne', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umax', 'a', 'a') => a
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('~fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b@32(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('fmin', ('fsat', 'a'), '#b@32(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('~ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmax', 'b', 'c'))
 *    ('~ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmin', 'a', 'b'), 'c')
 *    ('~ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmin', 'b', 'c'))
 *    ('~ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmax', 'a', 'b'), 'c')
 *    ('~ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('fmax', 'b', 'c'))
 *    ('~ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('fmin', 'a', 'b'), 'c')
 *    ('~ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('fmin', 'b', 'c'))
 *    ('~ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('~iand', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('~ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('ior', 1065353216, ('iand', 'a', 2147483648))
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ine', ('ineg', ('b2i32', 'a@1')), ('ineg', ('b2i32', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i32', ('ine', 'a@1', 'b@1')) => ('b2i32', ('ixor', 'a', 'b'))
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a@32', 'b@32'), 0)
 *    ('~flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('~flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('~flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('~flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fne', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fne', ('fneg', 'a'), 'a') => ('fne', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', 0) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', True) => True
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('iand', 255, ('ushr@32', 'a', 24)) => ('ushr', 'a', 24)
 *    ('iand', 65535, ('ushr@32', 'a', 16)) => ('ushr', 'a', 16)
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0)
 *    ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0)
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('i2b', ('iabs', 'a')) => ('i2b', 'a')
 *    ('inot', ('f2b1', 'a')) => ('feq', 'a', 0.0)
 *    ('~i2f32', ('f2i32', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('ige', ('f2u', 'a'), 'b') => ('ige', ('f2i', 'a'), 'b')
 *    ('ige', 'b', ('f2u', 'a')) => ('ige', 'b', ('f2i', 'a'))
 *    ('ilt', ('f2u', 'a'), 'b') => ('ilt', ('f2i', 'a'), 'b')
 *    ('ilt', 'b', ('f2u', 'a')) => ('ilt', 'b', ('f2i', 'a'))
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fne', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('~fge', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('~flt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('~flt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ussub_4x8', 'a', 0) => a
 *    ('ussub_4x8', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('fmod@16', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('fmod@32', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry@32', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow@32', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('find_lsb', 'value') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('fsign', 'a') => ('fsub', ('b2f', ('flt', 0.0, 'a')), ('b2f', ('flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fne', 'a', 'b'), ('fne', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fne', 'a', 'b'), ('fne', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fne', 'c', 'd'))) => ('iand', ('fne', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fne', 'c', 'd'))) => ('ior', ('fne', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fne', 'a', 'b'), ('fne', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fne', 'a', 'b'), ('fne', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2b1', ('b2f', 'a@1')) => a
 *    ('i2b1', ('b2i', 'a@1')) => a
 *    ('f2b8', ('b2f', 'a@8')) => a
 *    ('i2b8', ('b2i', 'a@8')) => a
 *    ('f2b16', ('b2f', 'a@16')) => a
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('f2b32', ('b2f', 'a@32')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fne', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fne', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fne', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fne', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fne', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fne', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fne', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fne', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -28), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -28), 30), ('ishr', ('imin', ('imax', 'exp', -28), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -252), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -252), 254), ('ishr', ('imin', ('imax', 'exp', -252), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2044), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2044), 2046), ('ishr', ('imin', ('imax', 'exp', -2044), 2046), 1)), 1023), 20)))
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('feq', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('feq', 'd', 'b'), ('feq', 'd', 'c'))
 *    ('fne', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fne', 'b', 'd'), ('fne', 'c', 'd'))
 *    ('fne', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fne', 'd', 'b'), ('fne', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ieq', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ieq', 'd', 'b'), ('ieq', 'd', 'c'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('ine', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ine', 'd', 'b'), ('ine', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('fddx', 'a') => 0.0
 *    ('fddx_fine', 'a') => 0.0
 *    ('fddx_coarse', 'a') => 0.0
 *    ('fddy', 'a') => 0.0
 *    ('fddy_fine', 'a') => 0.0
 *    ('fddy_coarse', 'a') => 0.0
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('frcp(is_used_once)', 'b'), ('frcp', 'c')) => ('frcp', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('frcp', 'b'), ('frcp(is_used_once)', 'c')) => ('frcp', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('frsq(is_used_once)', 'b'), ('frsq', 'c')) => ('frsq', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('frsq', 'b'), ('frsq(is_used_once)', 'c')) => ('frsq', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('fsqrt(is_used_once)', 'b'), ('fsqrt', 'c')) => ('fsqrt', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('fsqrt', 'b'), ('fsqrt(is_used_once)', 'c')) => ('fsqrt', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('fexp2(is_used_once)', 'b'), ('fexp2', 'c')) => ('fexp2', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('fexp2', 'b'), ('fexp2(is_used_once)', 'c')) => ('fexp2', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('flog2(is_used_once)', 'b'), ('flog2', 'c')) => ('flog2', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('flog2', 'b'), ('flog2(is_used_once)', 'c')) => ('flog2', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('fsign(is_used_once)', 'b'), ('fsign', 'c')) => ('fsign', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('fsign', 'b'), ('fsign(is_used_once)', 'c')) => ('fsign', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('fsin(is_used_once)', 'b'), ('fsin', 'c')) => ('fsin', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('fsin', 'b'), ('fsin(is_used_once)', 'c')) => ('fsin', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('fcos(is_used_once)', 'b'), ('fcos', 'c')) => ('fcos', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('fcos', 'b'), ('fcos(is_used_once)', 'c')) => ('fcos', ('bcsel', 'a', 'b', 'c'))
 */


   static const nir_search_variable search0_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_pos_power_of_two),
   {0, 1, 2, 3},
};
static const nir_search_expression search0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace0_0 -> search0_0 in the cache */

static const nir_search_variable replace0_1_0 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression replace0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace0_1.value },
   NULL,
};

   /* search1_0 -> search0_0 in the cache */

static const nir_search_variable search1_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_neg_power_of_two),
   {0, 1, 2, 3},
};
static const nir_search_expression search1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &search1_1.value },
   NULL,
};

   /* replace1_0_0 -> search0_0 in the cache */

/* replace1_0_1_0_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace1_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &replace1_0_1_0.value },
   NULL,
};
static const nir_search_expression replace1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace1_0_1.value },
   NULL,
};
static const nir_search_expression replace1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace1_0.value },
   NULL,
};

   static const nir_search_variable search2_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search2_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search2_0.value, &search2_1.value },
   NULL,
};

   /* replace2_0 -> search2_0 in the cache */

static const nir_search_constant replace2_1_0 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x1 /* 1 */ },
};

/* replace2_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace2_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace2_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace2 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &replace2_1.value },
   NULL,
};

   /* search3_0_0 -> search0_0 in the cache */

/* search3_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search3_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imul_2x32_64,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search3 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search3_0.value },
   NULL,
};

   /* replace3_0 -> search0_0 in the cache */

/* replace3_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace3 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search4_0_0 -> search0_0 in the cache */

/* search4_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search4_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_umul_2x32_64,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search4 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search4_0.value },
   NULL,
};

   /* replace4_0 -> search0_0 in the cache */

/* replace4_1 -> replace0_1_0 in the cache */
/* replace4 -> replace3 in the cache */

   /* search5_0 -> search0_0 in the cache */

/* search5_1 -> replace0_1_0 in the cache */
static const nir_search_expression search5 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imul_2x32_64,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace5_0_0 -> search0_0 in the cache */

/* replace5_0_1 -> replace0_1_0 in the cache */
/* replace5_0 -> replace3 in the cache */

/* replace5_1_0 -> search0_0 in the cache */

/* replace5_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace5_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_imul_high,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace5 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_pack_64_2x32_split,
   { &replace3.value, &replace5_1.value },
   NULL,
};

   /* search6_0 -> search0_0 in the cache */

/* search6_1 -> replace0_1_0 in the cache */
static const nir_search_expression search6 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_umul_2x32_64,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace6_0_0 -> search0_0 in the cache */

/* replace6_0_1 -> replace0_1_0 in the cache */
/* replace6_0 -> replace3 in the cache */

/* replace6_1_0 -> search0_0 in the cache */

/* replace6_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace6_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_umul_high,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace6 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_pack_64_2x32_split,
   { &replace3.value, &replace6_1.value },
   NULL,
};

   /* search7_0 -> search2_0 in the cache */

/* search7_1 -> replace2_1_0 in the cache */
static const nir_search_expression search7 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_udiv,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace7 -> search2_0 in the cache */

   /* search8_0 -> search2_0 in the cache */

/* search8_1 -> replace2_1_0 in the cache */
static const nir_search_expression search8 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace8 -> search2_0 in the cache */

   /* search9_0 -> search2_0 in the cache */

/* search9_1 -> replace2_1_0 in the cache */
static const nir_search_expression search9 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umod,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   static const nir_search_constant replace9 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x0 /* 0 */ },
};

   /* search10_0 -> search2_0 in the cache */

/* search10_1 -> replace2_1_0 in the cache */
static const nir_search_expression search10 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace10 -> replace9 in the cache */

   /* search11_0 -> search0_0 in the cache */

/* search11_1 -> search0_1 in the cache */
static const nir_search_expression search11 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_udiv,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace11_0 -> search0_0 in the cache */

/* replace11_1_0 -> replace0_1_0 in the cache */
/* replace11_1 -> replace0_1 in the cache */
static const nir_search_expression replace11 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &replace0_1.value },
   NULL,
};

   /* search12_0 -> search0_0 in the cache */

/* search12_1 -> search0_1 in the cache */
static const nir_search_expression search12 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace12_0_0 -> search0_0 in the cache */
static const nir_search_expression replace12_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isign,
   { &search0_0.value },
   NULL,
};

/* replace12_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace12_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search0_0.value },
   NULL,
};

/* replace12_1_1_0 -> replace0_1_0 in the cache */
/* replace12_1_1 -> replace0_1 in the cache */
static const nir_search_expression replace12_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace12_1_0.value, &replace0_1.value },
   NULL,
};
static const nir_search_expression replace12 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace12_0.value, &replace12_1.value },
   NULL,
};

   /* search13_0 -> search0_0 in the cache */

/* search13_1 -> search1_1 in the cache */
static const nir_search_expression search13 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search0_0.value, &search1_1.value },
   NULL,
};

   /* replace13_0_0_0 -> search0_0 in the cache */
/* replace13_0_0 -> replace12_0 in the cache */

/* replace13_0_1_0_0 -> search0_0 in the cache */
/* replace13_0_1_0 -> replace12_1_0 in the cache */

/* replace13_0_1_1_0_0 -> replace0_1_0 in the cache */
/* replace13_0_1_1_0 -> replace1_0_1_0 in the cache */
/* replace13_0_1_1 -> replace1_0_1 in the cache */
static const nir_search_expression replace13_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace12_1_0.value, &replace1_0_1.value },
   NULL,
};
static const nir_search_expression replace13_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace12_0.value, &replace13_0_1.value },
   NULL,
};
static const nir_search_expression replace13 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace13_0.value },
   NULL,
};

   static const nir_search_variable search14_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search14_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_pos_power_of_two),
   {0, 1, 2, 3},
};
static const nir_search_expression search14 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_umod,
   { &search14_0.value, &search14_1.value },
   NULL,
};

   /* replace14_0 -> search14_0 in the cache */

static const nir_search_variable replace14_1_0 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_constant replace14_1_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace14_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace14_1_0.value, &replace14_1_1.value },
   NULL,
};
static const nir_search_expression replace14 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search14_0.value, &replace14_1.value },
   NULL,
};

   /* search15_0_0 -> search2_0 in the cache */
static const nir_search_expression search15_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search15 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fneg,
   { &search15_0.value },
   NULL,
};

   /* replace15 -> search2_0 in the cache */

   /* search16_0_0 -> search2_0 in the cache */
static const nir_search_expression search16_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search16 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search16_0.value },
   NULL,
};

   /* replace16 -> search2_0 in the cache */

   /* search17_0_0 -> search2_0 in the cache */
static const nir_search_expression search17_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search17 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search17_0.value },
   NULL,
};

   /* replace17_0 -> search2_0 in the cache */
/* replace17 -> search17_0 in the cache */

   /* search18_0_0 -> search2_0 in the cache */
/* search18_0 -> search15_0 in the cache */
static const nir_search_expression search18 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search15_0.value },
   NULL,
};

   /* replace18_0 -> search2_0 in the cache */
/* replace18 -> search17_0 in the cache */

   /* search19_0_0 -> search2_0 in the cache */
static const nir_search_expression search19_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search19 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search19_0.value },
   NULL,
};

   /* replace19_0 -> search2_0 in the cache */
/* replace19 -> search19_0 in the cache */

   /* search20_0_0 -> search2_0 in the cache */
static const nir_search_expression search20_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search20 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search20_0.value },
   NULL,
};

   /* replace20_0 -> search2_0 in the cache */
/* replace20 -> search20_0 in the cache */

   /* search21_0_0 -> search2_0 in the cache */
/* search21_0 -> search16_0 in the cache */
static const nir_search_expression search21 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search16_0.value },
   NULL,
};

   /* replace21_0 -> search2_0 in the cache */
/* replace21 -> search20_0 in the cache */

   /* search22_0_0 -> search2_0 in the cache */
/* search22_0 -> search15_0 in the cache */
static const nir_search_expression search22 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2b,
   { &search15_0.value },
   NULL,
};

   /* replace22_0 -> search2_0 in the cache */
static const nir_search_expression replace22 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2b,
   { &search2_0.value },
   NULL,
};

   /* search23_0_0 -> search2_0 in the cache */
/* search23_0 -> search16_0 in the cache */
static const nir_search_expression search23 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search16_0.value },
   NULL,
};

   /* replace23_0 -> search2_0 in the cache */
static const nir_search_expression replace23 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search2_0.value },
   NULL,
};

   /* search24_0 -> search2_0 in the cache */

static const nir_search_constant search24_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search24 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search2_0.value, &search24_1.value },
   NULL,
};

   /* replace24 -> search2_0 in the cache */

   /* search25_0 -> search2_0 in the cache */

/* search25_1 -> replace9 in the cache */
static const nir_search_expression search25 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace25 -> search2_0 in the cache */

   /* search26_0 -> search0_0 in the cache */

static const nir_search_constant search26_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression search26 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_usadd_4x8,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* replace26 -> search0_0 in the cache */

   /* search27_0 -> search0_0 in the cache */

static const nir_search_constant search27_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search27 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_usadd_4x8,
   { &search0_0.value, &search27_1.value },
   NULL,
};

   /* replace27 -> search27_1 in the cache */

   static const nir_search_variable search28_0_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search28_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search28_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* search28_1_0 -> search28_0_0 in the cache */

static const nir_search_variable search28_1_1 = {
   { nir_search_value_variable, -3 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search28_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search28 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search28_0.value, &search28_1.value },
   NULL,
};

   /* replace28_0 -> search28_0_0 in the cache */

/* replace28_1_0 -> search28_0_1 in the cache */

/* replace28_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace28_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace28 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &search28_0_0.value, &replace28_1.value },
   NULL,
};

   /* search29_0_0 -> search28_0_0 in the cache */

/* search29_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search29_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* search29_1_0 -> search28_0_0 in the cache */

/* search29_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search29_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_imul,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search29 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &search29_0.value, &search29_1.value },
   NULL,
};

   /* replace29_0 -> search28_0_0 in the cache */

/* replace29_1_0 -> search28_0_1 in the cache */

/* replace29_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace29_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace29 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search28_0_0.value, &replace29_1.value },
   NULL,
};

   /* search30_0_0 -> search2_0 in the cache */
/* search30_0 -> search15_0 in the cache */

/* search30_1 -> search2_0 in the cache */
static const nir_search_expression search30 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search15_0.value, &search2_0.value },
   NULL,
};

   /* replace30 -> search24_1 in the cache */

   /* search31_0_0 -> search2_0 in the cache */
/* search31_0 -> search16_0 in the cache */

/* search31_1 -> search2_0 in the cache */
static const nir_search_expression search31 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search16_0.value, &search2_0.value },
   NULL,
};

   /* replace31 -> replace9 in the cache */

   /* search32_0_0 -> search14_0 in the cache */
static const nir_search_expression search32_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search14_0.value },
   NULL,
};

/* search32_1_0 -> search14_0 in the cache */

/* search32_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search32_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search32 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search32_0.value, &search32_1.value },
   NULL,
};

   /* replace32 -> replace14_1_0 in the cache */

   /* search33_0 -> search14_0 in the cache */

/* search33_1_0_0 -> search14_0 in the cache */
/* search33_1_0 -> search32_0 in the cache */

/* search33_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search33_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search32_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search33 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search14_0.value, &search33_1.value },
   NULL,
};

   /* replace33 -> replace14_1_0 in the cache */

   /* search34_0_0 -> search14_0 in the cache */
static const nir_search_expression search34_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search14_0.value },
   NULL,
};

/* search34_1_0 -> search14_0 in the cache */

/* search34_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search34_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search34 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search34_0.value, &search34_1.value },
   NULL,
};

   /* replace34 -> replace14_1_0 in the cache */

   /* search35_0 -> search14_0 in the cache */

/* search35_1_0_0 -> search14_0 in the cache */
/* search35_1_0 -> search34_0 in the cache */

/* search35_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search35_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search34_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search35 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search14_0.value, &search35_1.value },
   NULL,
};

   /* replace35 -> replace14_1_0 in the cache */

   /* search36_0_0 -> search2_0 in the cache */
static const nir_search_expression search36_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search2_0.value },
   NULL,
};

/* search36_1_0_0 -> search2_0 in the cache */
/* search36_1_0 -> search15_0 in the cache */
static const nir_search_expression search36_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search15_0.value },
   NULL,
};
static const nir_search_expression search36 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search36_0.value, &search36_1.value },
   NULL,
};

   /* replace36_0_0 -> search2_0 in the cache */
/* replace36_0 -> search17_0 in the cache */
static const nir_search_expression replace36 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search17_0.value },
   NULL,
};

   /* search37_0 -> search2_0 in the cache */

/* search37_1 -> search24_1 in the cache */
static const nir_search_expression search37 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search24_1.value },
   NULL,
};

   /* replace37 -> search24_1 in the cache */

   /* search38_0 -> search2_0 in the cache */

/* search38_1 -> replace9 in the cache */
static const nir_search_expression search38 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace38 -> replace9 in the cache */

   /* search39_0 -> search0_0 in the cache */

/* search39_1 -> search26_1 in the cache */
static const nir_search_expression search39 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_umul_unorm_4x8,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* replace39 -> search26_1 in the cache */

   /* search40_0 -> search0_0 in the cache */

/* search40_1 -> search27_1 in the cache */
static const nir_search_expression search40 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_umul_unorm_4x8,
   { &search0_0.value, &search27_1.value },
   NULL,
};

   /* replace40 -> search0_0 in the cache */

   /* search41_0 -> search2_0 in the cache */

static const nir_search_constant search41_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};
static const nir_search_expression search41 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   /* replace41 -> search2_0 in the cache */

   /* search42_0 -> search2_0 in the cache */

/* search42_1 -> replace2_1_0 in the cache */
static const nir_search_expression search42 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace42 -> search2_0 in the cache */

   /* search43_0 -> search2_0 in the cache */

static const nir_search_constant search43_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0xbff0000000000000L /* -1.0 */ },
};
static const nir_search_expression search43 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search43_1.value },
   NULL,
};

   /* replace43_0 -> search2_0 in the cache */
/* replace43 -> search15_0 in the cache */

   /* search44_0 -> search2_0 in the cache */

static const nir_search_constant search44_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search44 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &search44_1.value },
   NULL,
};

   /* replace44_0 -> search2_0 in the cache */
/* replace44 -> search16_0 in the cache */

   /* search45_0_0 -> search2_0 in the cache */
static const nir_search_expression search45_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsign,
   { &search2_0.value },
   NULL,
};

/* search45_1_0 -> search2_0 in the cache */

/* search45_1_1 -> search2_0 in the cache */
static const nir_search_expression search45_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search2_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search45 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search45_0.value, &search45_1.value },
   NULL,
};

   /* replace45_0_0 -> search2_0 in the cache */
/* replace45_0 -> search17_0 in the cache */

/* replace45_1 -> search2_0 in the cache */
static const nir_search_expression replace45 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search17_0.value, &search2_0.value },
   NULL,
};

   /* search46_0_0_0 -> search2_0 in the cache */
/* search46_0_0 -> search45_0 in the cache */

/* search46_0_1 -> search2_0 in the cache */
static const nir_search_expression search46_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search45_0.value, &search2_0.value },
   NULL,
};

/* search46_1 -> search2_0 in the cache */
static const nir_search_expression search46 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &search46_0.value, &search2_0.value },
   NULL,
};

   /* replace46_0_0 -> search2_0 in the cache */
/* replace46_0 -> search17_0 in the cache */

/* replace46_1 -> search2_0 in the cache */
/* replace46 -> replace45 in the cache */

   static const nir_search_constant search47_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search47_1 -> search14_0 in the cache */

/* search47_2 -> replace14_1_0 in the cache */
static const nir_search_expression search47 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search47_0.value, &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace47 -> replace14_1_0 in the cache */

   /* search48_0 -> search14_0 in the cache */

/* search48_1 -> replace14_1_0 in the cache */

/* search48_2 -> search47_0 in the cache */
static const nir_search_expression search48 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search14_0.value, &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* replace48_0 -> search14_0 in the cache */

/* replace48_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace48 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   static const nir_search_constant search49_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* search49_1 -> search14_0 in the cache */

/* search49_2 -> replace14_1_0 in the cache */
static const nir_search_expression search49 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search49_0.value, &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace49_0 -> search14_0 in the cache */

/* replace49_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace49 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   static const nir_search_constant search50_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0xbff0000000000000L /* -1.0 */ },
};

/* search50_1 -> search14_0 in the cache */

/* search50_2 -> replace14_1_0 in the cache */
static const nir_search_expression search50 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search50_0.value, &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace50_0_0 -> search14_0 in the cache */
/* replace50_0 -> search34_0 in the cache */

/* replace50_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace50 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search34_0.value, &replace14_1_0.value },
   NULL,
};

   /* search51_0 -> search14_0 in the cache */

/* search51_1 -> replace14_1_0 in the cache */

/* search51_2 -> search47_0 in the cache */
static const nir_search_expression search51 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search14_0.value, &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* replace51 -> search14_0 in the cache */

   /* search52_0 -> search14_0 in the cache */

/* search52_1 -> replace14_1_0 in the cache */

/* search52_2 -> search49_0 in the cache */
static const nir_search_expression search52 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search14_0.value, &replace14_1_0.value, &search49_0.value },
   NULL,
};

   /* replace52 -> replace14_1_0 in the cache */

   /* search53_0 -> search14_0 in the cache */

/* search53_1 -> search14_0 in the cache */

/* search53_2 -> replace14_1_0 in the cache */
static const nir_search_expression search53 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search14_0.value, &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace53 -> search14_0 in the cache */

   /* search54_0 -> search47_0 in the cache */

/* search54_1 -> search14_0 in the cache */

/* search54_2 -> replace14_1_0 in the cache */
static const nir_search_expression search54 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search47_0.value, &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace54_0 -> search14_0 in the cache */

/* replace54_1 -> replace14_1_0 in the cache */
/* replace54 -> replace48 in the cache */

   /* search55_0 -> search28_0_0 in the cache */

/* search55_1_0 -> search28_0_0 in the cache */

/* search55_1_1 -> search28_0_1 in the cache */
static const nir_search_expression search55_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search55_2 -> search28_1_1 in the cache */
static const nir_search_expression search55 = {
   { nir_search_value_expression, -3 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search28_0_0.value, &search55_1.value, &search28_1_1.value },
   NULL,
};

   /* replace55_0_0 -> search28_0_1 in the cache */

/* replace55_0_1 -> search28_1_1 in the cache */
static const nir_search_expression replace55_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};

/* replace55_1 -> search28_0_0 in the cache */
static const nir_search_expression replace55 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace55_0.value, &search28_0_0.value },
   NULL,
};

   /* search56_0 -> search0_0 in the cache */

/* search56_1_0 -> search0_0 in the cache */

/* search56_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search56_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

static const nir_search_variable search56_2 = {
   { nir_search_value_variable, 32 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search56 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search0_0.value, &search56_1.value, &search56_2.value },
   NULL,
};

   /* replace56_0_0 -> replace0_1_0 in the cache */

/* replace56_0_1 -> search56_2 in the cache */
static const nir_search_expression replace56_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &search56_2.value },
   NULL,
};

/* replace56_1 -> search0_0 in the cache */
static const nir_search_expression replace56 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace56_0.value, &search0_0.value },
   NULL,
};

   static const nir_search_variable search57_0 = {
   { nir_search_value_variable, 64 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search57_1_0 -> search57_0 in the cache */

static const nir_search_variable search57_1_1 = {
   { nir_search_value_variable, 64 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search57_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

static const nir_search_variable search57_2 = {
   { nir_search_value_variable, 64 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search57 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search57_0.value, &search57_1.value, &search57_2.value },
   NULL,
};

   /* replace57_0_0 -> search57_1_1 in the cache */

/* replace57_0_1 -> search57_2 in the cache */
static const nir_search_expression replace57_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search57_1_1.value, &search57_2.value },
   NULL,
};

/* replace57_1 -> search57_0 in the cache */
static const nir_search_expression replace57 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace57_0.value, &search57_0.value },
   NULL,
};

   /* search58_0_0 -> search0_0 in the cache */

/* search58_0_1 -> replace0_1_0 in the cache */
/* search58_0 -> search56_1 in the cache */

/* search58_1_0 -> search0_0 in the cache */

/* search58_1_1 -> search56_2 in the cache */
static const nir_search_expression search58_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search0_0.value, &search56_2.value },
   NULL,
};

static const nir_search_variable search58_2 = {
   { nir_search_value_variable, 32 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search58 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search56_1.value, &search58_1.value, &search58_2.value },
   NULL,
};

   /* replace58_0_0 -> replace0_1_0 in the cache */

/* replace58_0_1 -> search56_2 in the cache */

/* replace58_0_2 -> search58_2 in the cache */
static const nir_search_expression replace58_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace0_1_0.value, &search56_2.value, &search58_2.value },
   NULL,
};

/* replace58_1 -> search0_0 in the cache */
static const nir_search_expression replace58 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &replace58_0.value, &search0_0.value },
   NULL,
};

   /* search59_0_0 -> search57_0 in the cache */

/* search59_0_1 -> search57_1_1 in the cache */
/* search59_0 -> search57_1 in the cache */

/* search59_1_0 -> search57_0 in the cache */

/* search59_1_1 -> search57_2 in the cache */
static const nir_search_expression search59_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search57_0.value, &search57_2.value },
   NULL,
};

static const nir_search_variable search59_2 = {
   { nir_search_value_variable, 64 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search59 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search57_1.value, &search59_1.value, &search59_2.value },
   NULL,
};

   /* replace59_0_0 -> search57_1_1 in the cache */

/* replace59_0_1 -> search57_2 in the cache */

/* replace59_0_2 -> search59_2 in the cache */
static const nir_search_expression replace59_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search57_1_1.value, &search57_2.value, &search59_2.value },
   NULL,
};

/* replace59_1 -> search57_0 in the cache */
static const nir_search_expression replace59 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &replace59_0.value, &search57_0.value },
   NULL,
};

   /* search60_0 -> search0_0 in the cache */

/* search60_1_0 -> search0_0 in the cache */

/* search60_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search60_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};

/* search60_2 -> search56_2 in the cache */
static const nir_search_expression search60 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search0_0.value, &search60_1.value, &search56_2.value },
   NULL,
};

   static const nir_search_constant replace60_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* replace60_0_1 -> replace0_1_0 in the cache */

/* replace60_0_2 -> search56_2 in the cache */
static const nir_search_expression replace60_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace60_0_0.value, &replace0_1_0.value, &search56_2.value },
   NULL,
};

/* replace60_1 -> search0_0 in the cache */
static const nir_search_expression replace60 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace60_0.value, &search0_0.value },
   NULL,
};

   /* search61_0 -> search57_0 in the cache */

/* search61_1_0 -> search57_0 in the cache */

/* search61_1_1 -> search57_1_1 in the cache */
static const nir_search_expression search61_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search57_0.value, &search57_1_1.value },
   (is_used_once),
};

/* search61_2 -> search57_2 in the cache */
static const nir_search_expression search61 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search57_0.value, &search61_1.value, &search57_2.value },
   NULL,
};

   static const nir_search_constant replace61_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* replace61_0_1 -> search57_1_1 in the cache */

/* replace61_0_2 -> search57_2 in the cache */
static const nir_search_expression replace61_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace61_0_0.value, &search57_1_1.value, &search57_2.value },
   NULL,
};

/* replace61_1 -> search57_0 in the cache */
static const nir_search_expression replace61 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace61_0.value, &search57_0.value },
   NULL,
};

   static const nir_search_variable search62_0_0 = {
   { nir_search_value_variable, -4 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search62_0_1 = {
   { nir_search_value_variable, -4 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search62_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search62_0_0.value, &search62_0_1.value },
   (is_used_once),
};

/* search62_1_0 -> search62_0_0 in the cache */

static const nir_search_variable search62_1_1 = {
   { nir_search_value_variable, -4 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search62_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search62_0_0.value, &search62_1_1.value },
   (is_used_once),
};

static const nir_search_variable search62_2 = {
   { nir_search_value_variable, -4 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search62 = {
   { nir_search_value_expression, -4 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search62_0.value, &search62_1.value, &search62_2.value },
   NULL,
};

   /* replace62_0_0 -> search62_0_1 in the cache */

/* replace62_0_1 -> search62_1_1 in the cache */

/* replace62_0_2 -> search62_2 in the cache */
static const nir_search_expression replace62_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search62_0_1.value, &search62_1_1.value, &search62_2.value },
   NULL,
};

/* replace62_1 -> search62_0_0 in the cache */
static const nir_search_expression replace62 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace62_0.value, &search62_0_0.value },
   NULL,
};

   /* search63_0 -> search14_0 in the cache */

/* search63_1 -> replace14_1_0 in the cache */

static const nir_search_variable search63_2_0 = {
   { nir_search_value_variable, 1 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search63_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search63_2_0.value },
   NULL,
};
static const nir_search_expression search63 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search14_0.value, &replace14_1_0.value, &search63_2.value },
   NULL,
};

   /* replace63_0 -> search63_2_0 in the cache */

/* replace63_1 -> replace14_1_0 in the cache */

/* replace63_2 -> search14_0 in the cache */
static const nir_search_expression replace63 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search63_2_0.value, &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search64_0 -> search14_0 in the cache */

/* search64_1 -> search47_0 in the cache */

static const nir_search_variable search64_2 = {
   { nir_search_value_variable, -2 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search64 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search14_0.value, &search47_0.value, &search64_2.value },
   NULL,
};

   /* replace64_0_0_0 -> search14_0 in the cache */
/* replace64_0_0 -> search34_0 in the cache */

/* replace64_0_1 -> search64_2 in the cache */
static const nir_search_expression replace64_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search34_0.value, &search64_2.value },
   NULL,
};

/* replace64_1 -> search14_0 in the cache */
static const nir_search_expression replace64 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace64_0.value, &search14_0.value },
   NULL,
};

   /* search65_0 -> search2_0 in the cache */
static const nir_search_expression search65 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search2_0.value },
   NULL,
};

   /* replace65_0_0 -> search2_0 in the cache */

/* replace65_0_1 -> search24_1 in the cache */
static const nir_search_expression replace65_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search24_1.value },
   NULL,
};

/* replace65_1_0_0_0 -> search2_0 in the cache */
/* replace65_1_0_0 -> search17_0 in the cache */
static const nir_search_expression replace65_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search17_0.value },
   NULL,
};
static const nir_search_expression replace65_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace65_1_0.value },
   NULL,
};

/* replace65_2_0_0 -> search2_0 in the cache */
/* replace65_2_0 -> search17_0 in the cache */
/* replace65_2 -> replace65_1_0 in the cache */
static const nir_search_expression replace65 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace65_0.value, &replace65_1.value, &replace65_1_0.value },
   NULL,
};

   /* search66_0 -> search2_0 in the cache */
static const nir_search_expression search66 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search2_0.value },
   NULL,
};

   /* replace66_0 -> search2_0 in the cache */

/* replace66_1_0 -> search2_0 in the cache */
static const nir_search_expression replace66_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffract,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression replace66 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search2_0.value, &replace66_1.value },
   NULL,
};

   /* search67_0 -> search2_0 in the cache */

/* search67_1_0_0 -> search2_0 in the cache */
/* search67_1_0 -> replace66_1 in the cache */
static const nir_search_expression search67_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace66_1.value },
   NULL,
};
static const nir_search_expression search67 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search2_0.value, &search67_1.value },
   NULL,
};

   /* replace67_0 -> search2_0 in the cache */
/* replace67 -> search66 in the cache */

   /* search68_0 -> search2_0 in the cache */
/* search68 -> replace66_1 in the cache */

   /* replace68_0 -> search2_0 in the cache */

/* replace68_1_0 -> search2_0 in the cache */
/* replace68_1 -> search66 in the cache */
static const nir_search_expression replace68 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search2_0.value, &search66.value },
   NULL,
};

   /* search69_0 -> search2_0 in the cache */
static const nir_search_expression search69 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fceil,
   { &search2_0.value },
   NULL,
};

   /* replace69_0_0_0 -> search2_0 in the cache */
/* replace69_0_0 -> search15_0 in the cache */
static const nir_search_expression replace69_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search15_0.value },
   NULL,
};
static const nir_search_expression replace69 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace69_0.value },
   NULL,
};

   /* search70_0_0 -> search28_0_0 in the cache */

static const nir_search_constant search70_0_1_0 = {
   { nir_search_value_constant, -3 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

static const nir_search_variable search70_0_1_1_0_0 = {
   { nir_search_value_variable, 1 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search70_0_1_1_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search70_0_1_1_0_0.value },
   NULL,
};
static const nir_search_expression search70_0_1_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search70_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search70_0_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search70_0_1_0.value, &search70_0_1_1.value },
   NULL,
};
static const nir_search_expression search70_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search28_0_0.value, &search70_0_1.value },
   NULL,
};

static const nir_search_variable search70_1_0 = {
   { nir_search_value_variable, -3 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search70_1_1_0 -> search70_0_1_1_0_0 in the cache */
/* search70_1_1 -> search70_0_1_1_0 in the cache */
static const nir_search_expression search70_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search70_1_0.value, &search70_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search70 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search70_0.value, &search70_1.value },
   NULL,
};

   /* replace70_0 -> search70_0_1_1_0_0 in the cache */

/* replace70_1 -> search70_1_0 in the cache */

/* replace70_2 -> search28_0_0 in the cache */
static const nir_search_expression replace70 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search70_0_1_1_0_0.value, &search70_1_0.value, &search28_0_0.value },
   NULL,
};

   /* search71_0_0 -> search0_0 in the cache */

/* search71_0_1_0 -> replace60_0_0 in the cache */

static const nir_search_variable search71_0_1_1_0 = {
   { nir_search_value_variable, 32 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search71_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search71_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search71_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace60_0_0.value, &search71_0_1_1.value },
   NULL,
};
static const nir_search_expression search71_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search0_0.value, &search71_0_1.value },
   NULL,
};

static const nir_search_variable search71_1_0 = {
   { nir_search_value_variable, 32 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search71_1_1 -> search71_0_1_1_0 in the cache */
static const nir_search_expression search71_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search71_1_0.value, &search71_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search71 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search71_0.value, &search71_1.value },
   NULL,
};

   /* replace71_0 -> search0_0 in the cache */

/* replace71_1 -> search71_1_0 in the cache */

/* replace71_2 -> search71_0_1_1_0 in the cache */
static const nir_search_expression replace71 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &search71_1_0.value, &search71_0_1_1_0.value },
   NULL,
};

   /* search72_0_0 -> search57_0 in the cache */

/* search72_0_1_0 -> replace61_0_0 in the cache */

static const nir_search_variable search72_0_1_1_0 = {
   { nir_search_value_variable, 64 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search72_0_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search72_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search72_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace61_0_0.value, &search72_0_1_1.value },
   NULL,
};
static const nir_search_expression search72_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search57_0.value, &search72_0_1.value },
   NULL,
};

static const nir_search_variable search72_1_0 = {
   { nir_search_value_variable, 64 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search72_1_1 -> search72_0_1_1_0 in the cache */
static const nir_search_expression search72_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search72_1_0.value, &search72_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search72 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search72_0.value, &search72_1.value },
   NULL,
};

   /* replace72_0 -> search57_0 in the cache */

/* replace72_1 -> search72_1_0 in the cache */

/* replace72_2 -> search72_0_1_1_0 in the cache */
static const nir_search_expression replace72 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search57_0.value, &search72_1_0.value, &search72_0_1_1_0.value },
   NULL,
};

   /* search73_0_0 -> search0_0 in the cache */

/* search73_0_1_0_0 -> replace60_0_0 in the cache */

/* search73_0_1_0_1_0 -> search71_0_1_1_0 in the cache */
/* search73_0_1_0_1 -> search71_0_1_1 in the cache */
/* search73_0_1_0 -> search71_0_1 in the cache */
static const nir_search_expression search73_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search71_0_1.value },
   NULL,
};
static const nir_search_expression search73_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search0_0.value, &search73_0_1.value },
   NULL,
};

/* search73_1_0 -> search71_1_0 in the cache */

/* search73_1_1_0 -> search71_0_1_1_0 in the cache */
static const nir_search_expression search73_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search71_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search73_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search71_1_0.value, &search73_1_1.value },
   NULL,
};
static const nir_search_expression search73 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search73_0.value, &search73_1.value },
   NULL,
};

   /* replace73_0 -> search0_0 in the cache */

/* replace73_1 -> search71_1_0 in the cache */

/* replace73_2_0 -> search71_0_1_1_0 in the cache */
/* replace73_2 -> search73_1_1 in the cache */
static const nir_search_expression replace73 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &search71_1_0.value, &search73_1_1.value },
   NULL,
};

   /* search74_0_0 -> search57_0 in the cache */

/* search74_0_1_0_0 -> replace61_0_0 in the cache */

/* search74_0_1_0_1_0 -> search72_0_1_1_0 in the cache */
/* search74_0_1_0_1 -> search72_0_1_1 in the cache */
/* search74_0_1_0 -> search72_0_1 in the cache */
static const nir_search_expression search74_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search72_0_1.value },
   NULL,
};
static const nir_search_expression search74_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search57_0.value, &search74_0_1.value },
   NULL,
};

/* search74_1_0 -> search72_1_0 in the cache */

/* search74_1_1_0 -> search72_0_1_1_0 in the cache */
static const nir_search_expression search74_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search72_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search74_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search72_1_0.value, &search74_1_1.value },
   NULL,
};
static const nir_search_expression search74 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search74_0.value, &search74_1.value },
   NULL,
};

   /* replace74_0 -> search57_0 in the cache */

/* replace74_1 -> search72_1_0 in the cache */

/* replace74_2_0 -> search72_0_1_1_0 in the cache */
/* replace74_2 -> search74_1_1 in the cache */
static const nir_search_expression replace74 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search57_0.value, &search72_1_0.value, &search74_1_1.value },
   NULL,
};

   /* search75_0 -> search2_0 in the cache */

/* search75_1_0_0 -> search70_0_1_1_0_0 in the cache */
static const nir_search_expression search75_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search70_0_1_1_0_0.value },
   NULL,
};

static const nir_search_variable search75_1_1_0 = {
   { nir_search_value_variable, -1 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search75_1_1_1_0 -> search2_0 in the cache */
/* search75_1_1_1 -> search15_0 in the cache */
static const nir_search_expression search75_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search75_1_1_0.value, &search15_0.value },
   NULL,
};
static const nir_search_expression search75_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search75_1_0.value, &search75_1_1.value },
   NULL,
};
static const nir_search_expression search75 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search2_0.value, &search75_1.value },
   NULL,
};

   /* replace75_0 -> search70_0_1_1_0_0 in the cache */

/* replace75_1 -> search75_1_1_0 in the cache */

/* replace75_2 -> search2_0 in the cache */
static const nir_search_expression replace75 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search70_0_1_1_0_0.value, &search75_1_1_0.value, &search2_0.value },
   NULL,
};

   /* search76_0 -> search0_0 in the cache */

/* search76_1_0 -> search71_0_1_1_0 in the cache */

/* search76_1_1_0 -> search71_1_0 in the cache */

/* search76_1_1_1_0 -> search0_0 in the cache */
static const nir_search_expression search76_1_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search76_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search71_1_0.value, &search76_1_1_1.value },
   NULL,
};
static const nir_search_expression search76_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search71_0_1_1_0.value, &search76_1_1.value },
   NULL,
};
static const nir_search_expression search76 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search0_0.value, &search76_1.value },
   NULL,
};

   /* replace76_0 -> search0_0 in the cache */

/* replace76_1 -> search71_1_0 in the cache */

/* replace76_2 -> search71_0_1_1_0 in the cache */
/* replace76 -> replace71 in the cache */

   /* search77_0 -> search57_0 in the cache */

/* search77_1_0 -> search72_0_1_1_0 in the cache */

/* search77_1_1_0 -> search72_1_0 in the cache */

/* search77_1_1_1_0 -> search57_0 in the cache */
static const nir_search_expression search77_1_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search57_0.value },
   NULL,
};
static const nir_search_expression search77_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search72_1_0.value, &search77_1_1_1.value },
   NULL,
};
static const nir_search_expression search77_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search72_0_1_1_0.value, &search77_1_1.value },
   NULL,
};
static const nir_search_expression search77 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search57_0.value, &search77_1.value },
   NULL,
};

   /* replace77_0 -> search57_0 in the cache */

/* replace77_1 -> search72_1_0 in the cache */

/* replace77_2 -> search72_0_1_1_0 in the cache */
/* replace77 -> replace72 in the cache */

   /* search78_0 -> search28_0_0 in the cache */

/* search78_1 -> search28_0_1 in the cache */

/* search78_2 -> search28_1_1 in the cache */
static const nir_search_expression search78 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search28_0_0.value, &search28_0_1.value, &search28_1_1.value },
   NULL,
};

   /* replace78_0_0 -> search28_0_0 in the cache */

/* replace78_0_1 -> search28_0_1 in the cache */
/* replace78_0 -> search28_0 in the cache */

/* replace78_1 -> search28_1_1 in the cache */
static const nir_search_expression replace78 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &search28_0.value, &search28_1_1.value },
   NULL,
};

   /* search79_0_0 -> search28_0_0 in the cache */

/* search79_0_1 -> search28_0_1 in the cache */
/* search79_0 -> search28_0 in the cache */

/* search79_1 -> search28_1_1 in the cache */
static const nir_search_expression search79 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search28_0.value, &search28_1_1.value },
   NULL,
};

   /* replace79_0 -> search28_0_0 in the cache */

/* replace79_1 -> search28_0_1 in the cache */

/* replace79_2 -> search28_1_1 in the cache */
/* replace79 -> search78 in the cache */

   static const nir_search_variable search80_0_0_0_0_0 = {
   { nir_search_value_variable, 1 },
   0, /* a */
   false,
   nir_type_bool,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search80_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search80_0_0_0_0_0.value },
   NULL,
};
static const nir_search_expression search80_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search80_0_0_0_0.value },
   NULL,
};

/* search80_0_0_1_0 -> replace0_1_0 in the cache */

/* search80_0_0_1_1 -> search56_2 in the cache */
static const nir_search_expression search80_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &search56_2.value },
   NULL,
};
static const nir_search_expression search80_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 2,
   nir_op_iand,
   { &search80_0_0_0.value, &search80_0_0_1.value },
   NULL,
};

static const nir_search_variable search80_0_1 = {
   { nir_search_value_variable, 32 },
   3, /* d */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search80_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_fadd,
   { &search80_0_0.value, &search80_0_1.value },
   NULL,
};

static const nir_search_variable search80_1 = {
   { nir_search_value_variable, 32 },
   4, /* e */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search80 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fmul,
   { &search80_0.value, &search80_1.value },
   NULL,
};

   static const nir_search_variable replace80_0 = {
   { nir_search_value_variable, 1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* replace80_1_0_0_0 -> replace0_1_0 in the cache */

/* replace80_1_0_0_1 -> search56_2 in the cache */
static const nir_search_expression replace80_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &search56_2.value },
   NULL,
};

/* replace80_1_0_1 -> search58_2 in the cache */
static const nir_search_expression replace80_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fadd,
   { &replace80_1_0_0.value, &search58_2.value },
   NULL,
};

static const nir_search_variable replace80_1_1 = {
   { nir_search_value_variable, 32 },
   4, /* e */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression replace80_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_fmul,
   { &replace80_1_0.value, &replace80_1_1.value },
   NULL,
};

/* replace80_2_0 -> search58_2 in the cache */

/* replace80_2_1 -> replace80_1_1 in the cache */
static const nir_search_expression replace80_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search58_2.value, &replace80_1_1.value },
   NULL,
};
static const nir_search_expression replace80 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace80_0.value, &replace80_1.value, &replace80_2.value },
   NULL,
};

   /* search81_0 -> search14_0 in the cache */

/* search81_1 -> replace14_1_0 in the cache */
static const nir_search_expression search81 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fdph,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   static const nir_search_variable replace81_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace81_0_1 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};

static const nir_search_variable replace81_0_2 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {2},
};

/* replace81_0_3 -> search49_0 in the cache */
static const nir_search_expression replace81_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &replace81_0_0.value, &replace81_0_1.value, &replace81_0_2.value, &search49_0.value },
   NULL,
};

/* replace81_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace81 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &replace81_0.value, &replace14_1_0.value },
   NULL,
};

   /* search82_0_0 -> search62_0_0 in the cache */

/* search82_0_1 -> search62_0_1 in the cache */

/* search82_0_2 -> search62_1_1 in the cache */

static const nir_search_constant search82_0_3 = {
   { nir_search_value_constant, -4 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};
static const nir_search_expression search82_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search62_0_0.value, &search62_0_1.value, &search62_1_1.value, &search82_0_3.value },
   NULL,
};

/* search82_1 -> search62_2 in the cache */
static const nir_search_expression search82 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search82_0.value, &search62_2.value },
   NULL,
};

   /* replace82_0_0 -> search62_0_0 in the cache */

/* replace82_0_1 -> search62_0_1 in the cache */

/* replace82_0_2 -> search62_1_1 in the cache */
static const nir_search_expression replace82_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search62_0_0.value, &search62_0_1.value, &search62_1_1.value },
   NULL,
};

/* replace82_1 -> search62_2 in the cache */
static const nir_search_expression replace82 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fdph,
   { &replace82_0.value, &search62_2.value },
   NULL,
};

   /* search83_0_0 -> search14_0 in the cache */

/* search83_0_1 -> search47_0 in the cache */

/* search83_0_2 -> search47_0 in the cache */

/* search83_0_3 -> search47_0 in the cache */
static const nir_search_expression search83_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search14_0.value, &search47_0.value, &search47_0.value, &search47_0.value },
   NULL,
};

/* search83_1 -> replace14_1_0 in the cache */
static const nir_search_expression search83 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search83_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace83_0 -> search14_0 in the cache */

/* replace83_1 -> replace14_1_0 in the cache */
/* replace83 -> replace48 in the cache */

   /* search84_0_0 -> search28_0_0 in the cache */

/* search84_0_1 -> search28_0_1 in the cache */

static const nir_search_constant search84_0_2 = {
   { nir_search_value_constant, -3 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search84_0_3 -> search84_0_2 in the cache */
static const nir_search_expression search84_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search28_0_0.value, &search28_0_1.value, &search84_0_2.value, &search84_0_2.value },
   NULL,
};

/* search84_1 -> search28_1_1 in the cache */
static const nir_search_expression search84 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search84_0.value, &search28_1_1.value },
   NULL,
};

   /* replace84_0_0 -> search28_0_0 in the cache */

/* replace84_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace84_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace84_1 -> search28_1_1 in the cache */
static const nir_search_expression replace84 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &replace84_0.value, &search28_1_1.value },
   NULL,
};

   /* search85_0_0 -> search62_0_0 in the cache */

/* search85_0_1 -> search62_0_1 in the cache */

/* search85_0_2 -> search62_1_1 in the cache */

static const nir_search_constant search85_0_3 = {
   { nir_search_value_constant, -4 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search85_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search62_0_0.value, &search62_0_1.value, &search62_1_1.value, &search85_0_3.value },
   NULL,
};

/* search85_1 -> search62_2 in the cache */
static const nir_search_expression search85 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search85_0.value, &search62_2.value },
   NULL,
};

   /* replace85_0_0 -> search62_0_0 in the cache */

/* replace85_0_1 -> search62_0_1 in the cache */

/* replace85_0_2 -> search62_1_1 in the cache */
/* replace85_0 -> replace82_0 in the cache */

/* replace85_1 -> search62_2 in the cache */
static const nir_search_expression replace85 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &replace82_0.value, &search62_2.value },
   NULL,
};

   /* search86_0_0 -> search14_0 in the cache */

/* search86_0_1 -> search47_0 in the cache */

/* search86_0_2 -> search47_0 in the cache */
static const nir_search_expression search86_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search14_0.value, &search47_0.value, &search47_0.value },
   NULL,
};

/* search86_1 -> replace14_1_0 in the cache */
static const nir_search_expression search86 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search86_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace86_0 -> search14_0 in the cache */

/* replace86_1 -> replace14_1_0 in the cache */
/* replace86 -> replace48 in the cache */

   /* search87_0_0 -> search28_0_0 in the cache */

/* search87_0_1 -> search28_0_1 in the cache */

/* search87_0_2 -> search84_0_2 in the cache */
static const nir_search_expression search87_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search28_0_0.value, &search28_0_1.value, &search84_0_2.value },
   NULL,
};

/* search87_1 -> search28_1_1 in the cache */
static const nir_search_expression search87 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search87_0.value, &search28_1_1.value },
   NULL,
};

   /* replace87_0_0 -> search28_0_0 in the cache */

/* replace87_0_1 -> search28_0_1 in the cache */
/* replace87_0 -> replace84_0 in the cache */

/* replace87_1 -> search28_1_1 in the cache */
/* replace87 -> replace84 in the cache */

   /* search88_0_0 -> search14_0 in the cache */

/* search88_0_1 -> search47_0 in the cache */
static const nir_search_expression search88_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search14_0.value, &search47_0.value },
   NULL,
};

/* search88_1 -> replace14_1_0 in the cache */
static const nir_search_expression search88 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search88_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace88_0 -> search14_0 in the cache */

/* replace88_1 -> replace14_1_0 in the cache */
/* replace88 -> replace48 in the cache */

   /* search89_0 -> search2_0 in the cache */

/* search89_1 -> search41_1 in the cache */
static const nir_search_expression search89 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   static const nir_search_variable replace89_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace89_1 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};
static const nir_search_expression replace89 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fadd,
   { &replace89_0.value, &replace89_1.value },
   NULL,
};

   /* search90_0 -> search14_0 in the cache */

/* search90_1 -> replace14_1_0 in the cache */
static const nir_search_expression search90 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace90_0_0 -> search14_0 in the cache */

/* replace90_0_1 -> replace14_1_0 in the cache */
/* replace90_0 -> replace48 in the cache */
static const nir_search_expression replace90 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum2,
   { &replace48.value },
   NULL,
};

   /* search91_0 -> search14_0 in the cache */

/* search91_1 -> replace14_1_0 in the cache */
static const nir_search_expression search91 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace91_0_0 -> search14_0 in the cache */

/* replace91_0_1 -> replace14_1_0 in the cache */
/* replace91_0 -> replace48 in the cache */
static const nir_search_expression replace91 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum3,
   { &replace48.value },
   NULL,
};

   /* search92_0 -> search14_0 in the cache */

/* search92_1 -> replace14_1_0 in the cache */
static const nir_search_expression search92 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace92_0_0 -> search14_0 in the cache */

/* replace92_0_1 -> replace14_1_0 in the cache */
/* replace92_0 -> replace48 in the cache */
static const nir_search_expression replace92 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum4,
   { &replace48.value },
   NULL,
};

   /* search93_0 -> search2_0 in the cache */
static const nir_search_expression search93 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsum2,
   { &search2_0.value },
   NULL,
};

   /* replace93_0 -> replace89_0 in the cache */

/* replace93_1 -> replace89_1 in the cache */
/* replace93 -> replace89 in the cache */

   static const nir_search_variable search94_0_0_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_fmul),
   {0, 1, 2, 3},
};
static const nir_search_expression search94_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search94_0_0_0.value },
   (is_used_once),
};
static const nir_search_expression search94_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search94_0_0.value },
   (is_used_once),
};

/* search94_1 -> search41_1 in the cache */
static const nir_search_expression search94 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search94_0.value, &search41_1.value },
   NULL,
};

   /* replace94_0_0 -> search41_1 in the cache */

/* replace94_0_1_0 -> search2_0 in the cache */
/* replace94_0_1 -> search15_0 in the cache */
static const nir_search_expression replace94_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search41_1.value, &search15_0.value },
   NULL,
};
static const nir_search_expression replace94 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace94_0.value },
   NULL,
};

   /* search95_0 -> replace60_0_0 in the cache */

/* search95_1_0_0_0 -> replace60_0_0 in the cache */

/* search95_1_0_0_1_0 -> search0_0 in the cache */
/* search95_1_0_0_1 -> search76_1_1_1 in the cache */
static const nir_search_expression search95_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace60_0_0.value, &search76_1_1_1.value },
   NULL,
};

/* search95_1_0_1_0 -> replace60_0_0 in the cache */

/* search95_1_0_1_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search95_1_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search95_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fadd,
   { &replace60_0_0.value, &search95_1_0_1_1.value },
   NULL,
};
static const nir_search_expression search95_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_fmul,
   { &search95_1_0_0.value, &search95_1_0_1.value },
   NULL,
};
static const nir_search_expression search95_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 3,
   nir_op_fneg,
   { &search95_1_0.value },
   NULL,
};
static const nir_search_expression search95 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &replace60_0_0.value, &search95_1.value },
   NULL,
};

   /* replace95_0 -> replace0_1_0 in the cache */

/* replace95_1 -> replace60_0_0 in the cache */

/* replace95_2 -> search0_0 in the cache */
static const nir_search_expression replace95 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace0_1_0.value, &replace60_0_0.value, &search0_0.value },
   NULL,
};

   /* search96_0_0_0 -> search28_0_0 in the cache */

static const nir_search_variable search96_0_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search96_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search28_0_0.value, &search96_0_0_1.value },
   NULL,
};

static const nir_search_variable search96_0_1 = {
   { nir_search_value_variable, -3 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search96_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search96_0_0.value, &search96_0_1.value },
   NULL,
};

/* search96_1 -> search80_0_1 in the cache */
static const nir_search_expression search96 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 2,
   nir_op_ishl,
   { &search96_0.value, &search80_0_1.value },
   NULL,
};

   /* replace96_0_0 -> search28_0_0 in the cache */

/* replace96_0_1_0 -> search28_0_1 in the cache */

/* replace96_0_1_1 -> search58_2 in the cache */
static const nir_search_expression replace96_0_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search28_0_1.value, &search58_2.value },
   NULL,
};
static const nir_search_expression replace96_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search28_0_0.value, &replace96_0_1.value },
   NULL,
};

/* replace96_1_0 -> search28_1_1 in the cache */

/* replace96_1_1 -> search58_2 in the cache */
static const nir_search_expression replace96_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search28_1_1.value, &search58_2.value },
   NULL,
};
static const nir_search_expression replace96 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace96_0.value, &replace96_1.value },
   NULL,
};

   /* search97_0_0 -> search14_0 in the cache */

static const nir_search_variable search97_0_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search97_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search14_0.value, &search97_0_1.value },
   NULL,
};

static const nir_search_variable search97_1 = {
   { nir_search_value_variable, 32 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search97 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search97_0.value, &search97_1.value },
   NULL,
};

   /* replace97_0 -> search14_0 in the cache */

/* replace97_1_0 -> replace14_1_0 in the cache */

/* replace97_1_1 -> search56_2 in the cache */
static const nir_search_expression replace97_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace14_1_0.value, &search56_2.value },
   NULL,
};
static const nir_search_expression replace97 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search14_0.value, &replace97_1.value },
   NULL,
};

   static const nir_search_variable search98_0_0 = {
   { nir_search_value_variable, 8 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search98_0_1 -> search2_1 in the cache */
static const nir_search_expression search98_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search98_0_0.value, &search2_1.value },
   NULL,
};

/* search98_1 -> search97_1 in the cache */
static const nir_search_expression search98 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search98_0.value, &search97_1.value },
   NULL,
};

   /* replace98_0_0_0_0 -> replace0_1_0 in the cache */

static const nir_search_constant replace98_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xff /* 255 */ },
};
static const nir_search_expression replace98_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace98_0_0_0_1.value },
   NULL,
};

/* replace98_0_0_1_0 -> search56_2 in the cache */

/* replace98_0_0_1_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace98_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search56_2.value, &replace98_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace98_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace98_0_0_0.value, &replace98_0_0_1.value },
   NULL,
};

static const nir_search_constant replace98_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x8 /* 8 */ },
};
static const nir_search_expression replace98_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace98_0_0.value, &replace98_0_1.value },
   NULL,
};

/* replace98_1_0 -> search98_0_0 in the cache */

/* replace98_1_1_0 -> replace0_1_0 in the cache */

/* replace98_1_1_1 -> search56_2 in the cache */
static const nir_search_expression replace98_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &replace0_1_0.value, &search56_2.value },
   NULL,
};
static const nir_search_expression replace98_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search98_0_0.value, &replace98_1_1.value },
   NULL,
};

static const nir_search_constant replace98_2 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace98 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace98_0.value, &replace98_1.value, &replace98_2.value },
   NULL,
};

   /* search99_0_0 -> search98_0_0 in the cache */

/* search99_0_1 -> search2_1 in the cache */
static const nir_search_expression search99_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search98_0_0.value, &search2_1.value },
   NULL,
};

/* search99_1 -> search97_1 in the cache */
static const nir_search_expression search99 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search99_0.value, &search97_1.value },
   NULL,
};

   /* replace99_0_0_0_0 -> replace0_1_0 in the cache */

/* replace99_0_0_0_1 -> replace98_0_0_0_1 in the cache */
/* replace99_0_0_0 -> replace98_0_0_0 in the cache */

/* replace99_0_0_1_0 -> search56_2 in the cache */

/* replace99_0_0_1_1 -> replace98_0_0_0_1 in the cache */
/* replace99_0_0_1 -> replace98_0_0_1 in the cache */
/* replace99_0_0 -> replace98_0_0 in the cache */

/* replace99_0_1 -> replace98_0_1 in the cache */
/* replace99_0 -> replace98_0 in the cache */

/* replace99_1_0 -> search98_0_0 in the cache */

/* replace99_1_1_0 -> replace0_1_0 in the cache */

/* replace99_1_1_1 -> search56_2 in the cache */
/* replace99_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace99_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search98_0_0.value, &replace98_1_1.value },
   NULL,
};

/* replace99_2 -> replace98_2 in the cache */
static const nir_search_expression replace99 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace98_0.value, &replace99_1.value, &replace98_2.value },
   NULL,
};

   /* search100_0_0 -> search98_0_0 in the cache */

/* search100_0_1 -> search2_1 in the cache */
static const nir_search_expression search100_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search98_0_0.value, &search2_1.value },
   NULL,
};

/* search100_1 -> search97_1 in the cache */
static const nir_search_expression search100 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search100_0.value, &search97_1.value },
   NULL,
};

   /* replace100_0 -> search98_0_0 in the cache */

/* replace100_1_0_0_0 -> replace0_1_0 in the cache */

/* replace100_1_0_0_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace100_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace98_0_0_0_1.value },
   NULL,
};

/* replace100_1_0_1_0 -> search56_2 in the cache */

/* replace100_1_0_1_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace100_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search56_2.value, &replace98_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace100_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace100_1_0_0.value, &replace100_1_0_1.value },
   NULL,
};

static const nir_search_constant replace100_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7 /* 7 */ },
};
static const nir_search_expression replace100_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace100_1_0.value, &replace100_1_1.value },
   NULL,
};
static const nir_search_expression replace100 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search98_0_0.value, &replace100_1.value },
   NULL,
};

   static const nir_search_variable search101_0_0 = {
   { nir_search_value_variable, 16 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search101_0_1 -> search2_1 in the cache */
static const nir_search_expression search101_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search101_0_0.value, &search2_1.value },
   NULL,
};

/* search101_1 -> search97_1 in the cache */
static const nir_search_expression search101 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search101_0.value, &search97_1.value },
   NULL,
};

   /* replace101_0_0_0_0 -> replace0_1_0 in the cache */

static const nir_search_constant replace101_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffff /* 65535 */ },
};
static const nir_search_expression replace101_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace101_0_0_0_1.value },
   NULL,
};

/* replace101_0_0_1_0 -> search56_2 in the cache */

/* replace101_0_0_1_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace101_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search56_2.value, &replace101_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace101_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace101_0_0_0.value, &replace101_0_0_1.value },
   NULL,
};

static const nir_search_constant replace101_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x10 /* 16 */ },
};
static const nir_search_expression replace101_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace101_0_0.value, &replace101_0_1.value },
   NULL,
};

/* replace101_1_0 -> search101_0_0 in the cache */

/* replace101_1_1_0 -> replace0_1_0 in the cache */

/* replace101_1_1_1 -> search56_2 in the cache */
/* replace101_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace101_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search101_0_0.value, &replace98_1_1.value },
   NULL,
};

static const nir_search_constant replace101_2 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace101 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace101_0.value, &replace101_1.value, &replace101_2.value },
   NULL,
};

   /* search102_0_0 -> search101_0_0 in the cache */

/* search102_0_1 -> search2_1 in the cache */
static const nir_search_expression search102_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search101_0_0.value, &search2_1.value },
   NULL,
};

/* search102_1 -> search97_1 in the cache */
static const nir_search_expression search102 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search102_0.value, &search97_1.value },
   NULL,
};

   /* replace102_0_0_0_0 -> replace0_1_0 in the cache */

/* replace102_0_0_0_1 -> replace101_0_0_0_1 in the cache */
/* replace102_0_0_0 -> replace101_0_0_0 in the cache */

/* replace102_0_0_1_0 -> search56_2 in the cache */

/* replace102_0_0_1_1 -> replace101_0_0_0_1 in the cache */
/* replace102_0_0_1 -> replace101_0_0_1 in the cache */
/* replace102_0_0 -> replace101_0_0 in the cache */

/* replace102_0_1 -> replace101_0_1 in the cache */
/* replace102_0 -> replace101_0 in the cache */

/* replace102_1_0 -> search101_0_0 in the cache */

/* replace102_1_1_0 -> replace0_1_0 in the cache */

/* replace102_1_1_1 -> search56_2 in the cache */
/* replace102_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace102_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search101_0_0.value, &replace98_1_1.value },
   NULL,
};

/* replace102_2 -> replace101_2 in the cache */
static const nir_search_expression replace102 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace101_0.value, &replace102_1.value, &replace101_2.value },
   NULL,
};

   /* search103_0_0 -> search101_0_0 in the cache */

/* search103_0_1 -> search2_1 in the cache */
static const nir_search_expression search103_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search101_0_0.value, &search2_1.value },
   NULL,
};

/* search103_1 -> search97_1 in the cache */
static const nir_search_expression search103 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search103_0.value, &search97_1.value },
   NULL,
};

   /* replace103_0 -> search101_0_0 in the cache */

/* replace103_1_0_0_0 -> replace0_1_0 in the cache */

/* replace103_1_0_0_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace103_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace101_0_0_0_1.value },
   NULL,
};

/* replace103_1_0_1_0 -> search56_2 in the cache */

/* replace103_1_0_1_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace103_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search56_2.value, &replace101_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace103_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace103_1_0_0.value, &replace103_1_0_1.value },
   NULL,
};

static const nir_search_constant replace103_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xf /* 15 */ },
};
static const nir_search_expression replace103_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace103_1_0.value, &replace103_1_1.value },
   NULL,
};
static const nir_search_expression replace103 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search101_0_0.value, &replace103_1.value },
   NULL,
};

   /* search104_0_0 -> search0_0 in the cache */

/* search104_0_1 -> search2_1 in the cache */
static const nir_search_expression search104_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &search2_1.value },
   NULL,
};

/* search104_1 -> search97_1 in the cache */
static const nir_search_expression search104 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search104_0.value, &search97_1.value },
   NULL,
};

   /* replace104_0_0_0_0 -> replace0_1_0 in the cache */

static const nir_search_constant replace104_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffff /* 4294967295 */ },
};
static const nir_search_expression replace104_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace104_0_0_0_1.value },
   NULL,
};

/* replace104_0_0_1_0 -> search56_2 in the cache */

/* replace104_0_0_1_1 -> replace104_0_0_0_1 in the cache */
static const nir_search_expression replace104_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search56_2.value, &replace104_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace104_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace104_0_0_0.value, &replace104_0_0_1.value },
   NULL,
};

static const nir_search_constant replace104_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x20 /* 32 */ },
};
static const nir_search_expression replace104_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace104_0_0.value, &replace104_0_1.value },
   NULL,
};

/* replace104_1_0 -> search0_0 in the cache */

/* replace104_1_1_0 -> replace0_1_0 in the cache */

/* replace104_1_1_1 -> search56_2 in the cache */
/* replace104_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace104_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search0_0.value, &replace98_1_1.value },
   NULL,
};

/* replace104_2 -> search26_1 in the cache */
static const nir_search_expression replace104 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace104_0.value, &replace104_1.value, &search26_1.value },
   NULL,
};

   /* search105_0_0 -> search0_0 in the cache */

/* search105_0_1 -> search2_1 in the cache */
static const nir_search_expression search105_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search2_1.value },
   NULL,
};

/* search105_1 -> search97_1 in the cache */
static const nir_search_expression search105 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search105_0.value, &search97_1.value },
   NULL,
};

   /* replace105_0_0_0_0 -> replace0_1_0 in the cache */

/* replace105_0_0_0_1 -> replace104_0_0_0_1 in the cache */
/* replace105_0_0_0 -> replace104_0_0_0 in the cache */

/* replace105_0_0_1_0 -> search56_2 in the cache */

/* replace105_0_0_1_1 -> replace104_0_0_0_1 in the cache */
/* replace105_0_0_1 -> replace104_0_0_1 in the cache */
/* replace105_0_0 -> replace104_0_0 in the cache */

/* replace105_0_1 -> replace104_0_1 in the cache */
/* replace105_0 -> replace104_0 in the cache */

/* replace105_1_0 -> search0_0 in the cache */

/* replace105_1_1_0 -> replace0_1_0 in the cache */

/* replace105_1_1_1 -> search56_2 in the cache */
/* replace105_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace105_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search0_0.value, &replace98_1_1.value },
   NULL,
};

/* replace105_2 -> search26_1 in the cache */
static const nir_search_expression replace105 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace104_0.value, &replace105_1.value, &search26_1.value },
   NULL,
};

   /* search106_0_0 -> search0_0 in the cache */

/* search106_0_1 -> search2_1 in the cache */
static const nir_search_expression search106_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &search2_1.value },
   NULL,
};

/* search106_1 -> search97_1 in the cache */
static const nir_search_expression search106 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search106_0.value, &search97_1.value },
   NULL,
};

   /* replace106_0 -> search0_0 in the cache */

/* replace106_1_0_0_0 -> replace0_1_0 in the cache */

/* replace106_1_0_0_1 -> replace104_0_0_0_1 in the cache */
static const nir_search_expression replace106_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace104_0_0_0_1.value },
   NULL,
};

/* replace106_1_0_1_0 -> search56_2 in the cache */

/* replace106_1_0_1_1 -> replace104_0_0_0_1 in the cache */
static const nir_search_expression replace106_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search56_2.value, &replace104_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace106_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace106_1_0_0.value, &replace106_1_0_1.value },
   NULL,
};

static const nir_search_constant replace106_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x1f /* 31 */ },
};
static const nir_search_expression replace106_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace106_1_0.value, &replace106_1_1.value },
   NULL,
};
static const nir_search_expression replace106 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search0_0.value, &replace106_1.value },
   NULL,
};

   /* search107_0_0 -> search57_0 in the cache */

/* search107_0_1 -> search2_1 in the cache */
static const nir_search_expression search107_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &search2_1.value },
   NULL,
};

/* search107_1 -> search97_1 in the cache */
static const nir_search_expression search107 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search107_0.value, &search97_1.value },
   NULL,
};

   /* replace107_0_0_0_0 -> replace0_1_0 in the cache */

static const nir_search_constant replace107_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
};
static const nir_search_expression replace107_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace107_0_0_0_1.value },
   NULL,
};

/* replace107_0_0_1_0 -> search56_2 in the cache */

/* replace107_0_0_1_1 -> replace107_0_0_0_1 in the cache */
static const nir_search_expression replace107_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search56_2.value, &replace107_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace107_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace107_0_0_0.value, &replace107_0_0_1.value },
   NULL,
};

static const nir_search_constant replace107_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x40 /* 64 */ },
};
static const nir_search_expression replace107_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace107_0_0.value, &replace107_0_1.value },
   NULL,
};

/* replace107_1_0 -> search57_0 in the cache */

/* replace107_1_1_0 -> replace0_1_0 in the cache */

/* replace107_1_1_1 -> search56_2 in the cache */
/* replace107_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace107_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search57_0.value, &replace98_1_1.value },
   NULL,
};

static const nir_search_constant replace107_2 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace107 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace107_0.value, &replace107_1.value, &replace107_2.value },
   NULL,
};

   /* search108_0_0 -> search57_0 in the cache */

/* search108_0_1 -> search2_1 in the cache */
static const nir_search_expression search108_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &search2_1.value },
   NULL,
};

/* search108_1 -> search97_1 in the cache */
static const nir_search_expression search108 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search108_0.value, &search97_1.value },
   NULL,
};

   /* replace108_0_0_0_0 -> replace0_1_0 in the cache */

/* replace108_0_0_0_1 -> replace107_0_0_0_1 in the cache */
/* replace108_0_0_0 -> replace107_0_0_0 in the cache */

/* replace108_0_0_1_0 -> search56_2 in the cache */

/* replace108_0_0_1_1 -> replace107_0_0_0_1 in the cache */
/* replace108_0_0_1 -> replace107_0_0_1 in the cache */
/* replace108_0_0 -> replace107_0_0 in the cache */

/* replace108_0_1 -> replace107_0_1 in the cache */
/* replace108_0 -> replace107_0 in the cache */

/* replace108_1_0 -> search57_0 in the cache */

/* replace108_1_1_0 -> replace0_1_0 in the cache */

/* replace108_1_1_1 -> search56_2 in the cache */
/* replace108_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace108_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search57_0.value, &replace98_1_1.value },
   NULL,
};

/* replace108_2 -> replace107_2 in the cache */
static const nir_search_expression replace108 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace107_0.value, &replace108_1.value, &replace107_2.value },
   NULL,
};

   /* search109_0_0 -> search57_0 in the cache */

/* search109_0_1 -> search2_1 in the cache */
static const nir_search_expression search109_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &search2_1.value },
   NULL,
};

/* search109_1 -> search97_1 in the cache */
static const nir_search_expression search109 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search109_0.value, &search97_1.value },
   NULL,
};

   /* replace109_0 -> search57_0 in the cache */

/* replace109_1_0_0_0 -> replace0_1_0 in the cache */

/* replace109_1_0_0_1 -> replace107_0_0_0_1 in the cache */
static const nir_search_expression replace109_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace107_0_0_0_1.value },
   NULL,
};

/* replace109_1_0_1_0 -> search56_2 in the cache */

/* replace109_1_0_1_1 -> replace107_0_0_0_1 in the cache */
static const nir_search_expression replace109_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search56_2.value, &replace107_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace109_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace109_1_0_0.value, &replace109_1_0_1.value },
   NULL,
};

static const nir_search_constant replace109_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3f /* 63 */ },
};
static const nir_search_expression replace109_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace109_1_0.value, &replace109_1_1.value },
   NULL,
};
static const nir_search_expression replace109 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search57_0.value, &replace109_1.value },
   NULL,
};

   /* search110_0_0 -> search0_0 in the cache */

static const nir_search_constant search110_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression search110_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search110_0_1.value },
   NULL,
};

/* search110_1 -> search110_0_1 in the cache */
static const nir_search_expression search110 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search110_0.value, &search110_0_1.value },
   NULL,
};

   /* replace110_0 -> search0_0 in the cache */

static const nir_search_constant replace110_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffffe /* 4294967294 */ },
};
static const nir_search_expression replace110 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace110_1.value },
   NULL,
};

   /* search111_0_0 -> search0_0 in the cache */

static const nir_search_variable search111_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_2),
   {0, 1, 2, 3},
};
static const nir_search_expression search111_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &search111_0_1.value },
   NULL,
};

/* search111_1 -> replace110_1 in the cache */
static const nir_search_expression search111 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search111_0.value, &replace110_1.value },
   NULL,
};

   /* replace111_0_0 -> search0_0 in the cache */

/* replace111_0_1 -> replace110_1 in the cache */
static const nir_search_expression replace111_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search0_0.value, &replace110_1.value },
   NULL,
};

/* replace111_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace111 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace111_0.value, &replace0_1_0.value },
   NULL,
};

   /* search112_0_0 -> search0_0 in the cache */

static const nir_search_constant search112_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression search112_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search112_0_1.value },
   NULL,
};

/* search112_1 -> search112_0_1 in the cache */
static const nir_search_expression search112 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search112_0.value, &search112_0_1.value },
   NULL,
};

   /* replace112_0 -> search0_0 in the cache */

static const nir_search_constant replace112_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffffc /* 4294967292 */ },
};
static const nir_search_expression replace112 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace112_1.value },
   NULL,
};

   /* search113_0_0 -> search0_0 in the cache */

static const nir_search_variable search113_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_4),
   {0, 1, 2, 3},
};
static const nir_search_expression search113_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &search113_0_1.value },
   NULL,
};

/* search113_1 -> replace112_1 in the cache */
static const nir_search_expression search113 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search113_0.value, &replace112_1.value },
   NULL,
};

   /* replace113_0_0 -> search0_0 in the cache */

/* replace113_0_1 -> replace112_1 in the cache */
static const nir_search_expression replace113_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search0_0.value, &replace112_1.value },
   NULL,
};

/* replace113_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace113 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace113_0.value, &replace0_1_0.value },
   NULL,
};

   /* search114_0_0 -> search0_0 in the cache */

static const nir_search_constant search114_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression search114_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search114_0_1.value },
   NULL,
};

/* search114_1 -> search114_0_1 in the cache */
static const nir_search_expression search114 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search114_0.value, &search114_0_1.value },
   NULL,
};

   /* replace114_0 -> search0_0 in the cache */

static const nir_search_constant replace114_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffff8 /* 4294967288 */ },
};
static const nir_search_expression replace114 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace114_1.value },
   NULL,
};

   /* search115_0_0 -> search0_0 in the cache */

static const nir_search_variable search115_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_8),
   {0, 1, 2, 3},
};
static const nir_search_expression search115_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &search115_0_1.value },
   NULL,
};

/* search115_1 -> replace114_1 in the cache */
static const nir_search_expression search115 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search115_0.value, &replace114_1.value },
   NULL,
};

   /* replace115_0_0 -> search0_0 in the cache */

/* replace115_0_1 -> replace114_1 in the cache */
static const nir_search_expression replace115_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search0_0.value, &replace114_1.value },
   NULL,
};

/* replace115_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace115 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace115_0.value, &replace0_1_0.value },
   NULL,
};

   /* search116_0_0 -> search0_0 in the cache */

static const nir_search_constant search116_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x4 /* 4 */ },
};
static const nir_search_expression search116_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search116_0_1.value },
   NULL,
};

/* search116_1 -> search116_0_1 in the cache */
static const nir_search_expression search116 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search116_0.value, &search116_0_1.value },
   NULL,
};

   /* replace116_0 -> search0_0 in the cache */

static const nir_search_constant replace116_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffff0 /* 4294967280 */ },
};
static const nir_search_expression replace116 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace116_1.value },
   NULL,
};

   /* search117_0_0 -> search0_0 in the cache */

static const nir_search_variable search117_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_16),
   {0, 1, 2, 3},
};
static const nir_search_expression search117_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &search117_0_1.value },
   NULL,
};

/* search117_1 -> replace116_1 in the cache */
static const nir_search_expression search117 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search117_0.value, &replace116_1.value },
   NULL,
};

   /* replace117_0_0 -> search0_0 in the cache */

/* replace117_0_1 -> replace116_1 in the cache */
static const nir_search_expression replace117_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search0_0.value, &replace116_1.value },
   NULL,
};

/* replace117_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace117 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace117_0.value, &replace0_1_0.value },
   NULL,
};

   /* search118_0_0 -> search0_0 in the cache */

static const nir_search_constant search118_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x5 /* 5 */ },
};
static const nir_search_expression search118_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search118_0_1.value },
   NULL,
};

/* search118_1 -> search118_0_1 in the cache */
static const nir_search_expression search118 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search118_0.value, &search118_0_1.value },
   NULL,
};

   /* replace118_0 -> search0_0 in the cache */

static const nir_search_constant replace118_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffe0 /* 4294967264 */ },
};
static const nir_search_expression replace118 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace118_1.value },
   NULL,
};

   /* search119_0_0 -> search0_0 in the cache */

static const nir_search_variable search119_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_32),
   {0, 1, 2, 3},
};
static const nir_search_expression search119_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &search119_0_1.value },
   NULL,
};

/* search119_1 -> replace118_1 in the cache */
static const nir_search_expression search119 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search119_0.value, &replace118_1.value },
   NULL,
};

   /* replace119_0_0 -> search0_0 in the cache */

/* replace119_0_1 -> replace118_1 in the cache */
static const nir_search_expression replace119_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search0_0.value, &replace118_1.value },
   NULL,
};

/* replace119_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace119 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace119_0.value, &replace0_1_0.value },
   NULL,
};

   /* search120_0_0 -> search0_0 in the cache */

static const nir_search_constant search120_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x6 /* 6 */ },
};
static const nir_search_expression search120_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search120_0_1.value },
   NULL,
};

/* search120_1 -> search120_0_1 in the cache */
static const nir_search_expression search120 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search120_0.value, &search120_0_1.value },
   NULL,
};

   /* replace120_0 -> search0_0 in the cache */

static const nir_search_constant replace120_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffc0 /* 4294967232 */ },
};
static const nir_search_expression replace120 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace120_1.value },
   NULL,
};

   /* search121_0_0 -> search0_0 in the cache */

static const nir_search_variable search121_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_64),
   {0, 1, 2, 3},
};
static const nir_search_expression search121_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &search121_0_1.value },
   NULL,
};

/* search121_1 -> replace120_1 in the cache */
static const nir_search_expression search121 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search121_0.value, &replace120_1.value },
   NULL,
};

   /* replace121_0_0 -> search0_0 in the cache */

/* replace121_0_1 -> replace120_1 in the cache */
static const nir_search_expression replace121_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search0_0.value, &replace120_1.value },
   NULL,
};

/* replace121_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace121 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace121_0.value, &replace0_1_0.value },
   NULL,
};

   /* search122_0_0 -> search14_0 in the cache */

/* search122_0_1 -> search97_0_1 in the cache */
static const nir_search_expression search122_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search14_0.value, &search97_0_1.value },
   NULL,
};

/* search122_1 -> search97_1 in the cache */
static const nir_search_expression search122 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search122_0.value, &search97_1.value },
   NULL,
};

   /* replace122_0_0 -> search14_0 in the cache */

/* replace122_0_1 -> search56_2 in the cache */
static const nir_search_expression replace122_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search14_0.value, &search56_2.value },
   NULL,
};

/* replace122_1_0 -> replace14_1_0 in the cache */

/* replace122_1_1 -> search56_2 in the cache */
/* replace122_1 -> replace97_1 in the cache */
static const nir_search_expression replace122 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace122_0.value, &replace97_1.value },
   NULL,
};

   /* search123_0_0 -> search14_0 in the cache */

/* search123_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search123_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search123 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_inot,
   { &search123_0.value },
   NULL,
};

   /* replace123_0 -> search14_0 in the cache */

/* replace123_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace123 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search124_0_0 -> search14_0 in the cache */

/* search124_0_1 -> replace14_1_0 in the cache */
/* search124_0 -> replace123 in the cache */
static const nir_search_expression search124 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_inot,
   { &replace123.value },
   NULL,
};

   /* replace124_0 -> search14_0 in the cache */

/* replace124_1 -> replace14_1_0 in the cache */
/* replace124 -> search123_0 in the cache */

   /* search125_0_0 -> search14_0 in the cache */

/* search125_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search125_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search125 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search125_0.value },
   NULL,
};

   /* replace125_0 -> search14_0 in the cache */

/* replace125_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace125 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search126_0_0 -> search14_0 in the cache */

/* search126_0_1 -> replace14_1_0 in the cache */
/* search126_0 -> replace125 in the cache */
static const nir_search_expression search126 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace125.value },
   NULL,
};

   /* replace126_0 -> search14_0 in the cache */

/* replace126_1 -> replace14_1_0 in the cache */
/* replace126 -> search125_0 in the cache */

   /* search127_0_0 -> search14_0 in the cache */

/* search127_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search127_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search127 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search127_0.value },
   NULL,
};

   /* replace127_0 -> search14_0 in the cache */

/* replace127_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace127 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search128_0_0 -> search14_0 in the cache */

/* search128_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search128_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search128 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search128_0.value },
   NULL,
};

   /* replace128_0 -> search14_0 in the cache */

/* replace128_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace128 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search129_0_0 -> search14_0 in the cache */

/* search129_0_1 -> replace14_1_0 in the cache */
/* search129_0 -> replace127 in the cache */
static const nir_search_expression search129 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace127.value },
   NULL,
};

   /* replace129_0 -> search14_0 in the cache */

/* replace129_1 -> replace14_1_0 in the cache */
/* replace129 -> search127_0 in the cache */

   /* search130_0_0 -> search14_0 in the cache */

/* search130_0_1 -> replace14_1_0 in the cache */
/* search130_0 -> replace128 in the cache */
static const nir_search_expression search130 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace128.value },
   NULL,
};

   /* replace130_0 -> search14_0 in the cache */

/* replace130_1 -> replace14_1_0 in the cache */
/* replace130 -> search128_0 in the cache */

   /* search131_0_0 -> search14_0 in the cache */

/* search131_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search131_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search131 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search131_0.value },
   NULL,
};

   /* replace131_0 -> search14_0 in the cache */

/* replace131_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace131 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search132_0_0 -> search14_0 in the cache */

/* search132_0_1 -> replace14_1_0 in the cache */
/* search132_0 -> replace131 in the cache */
static const nir_search_expression search132 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace131.value },
   NULL,
};

   /* replace132_0 -> search14_0 in the cache */

/* replace132_1 -> replace14_1_0 in the cache */
/* replace132 -> search131_0 in the cache */

   /* search133_0_0 -> search14_0 in the cache */

/* search133_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search133_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_feq,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search133_1_0 -> search14_0 in the cache */

/* search133_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search133_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_fne,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search133 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search133_0.value, &search133_1.value },
   NULL,
};

   static const nir_search_constant replace133 = {
   { nir_search_value_constant, 1 },
   nir_type_bool, { NIR_FALSE /* False */ },
};

   /* search134_0_0 -> search14_0 in the cache */

/* search134_0_1 -> replace14_1_0 in the cache */
/* search134_0 -> search123_0 in the cache */

/* search134_1_0 -> replace14_1_0 in the cache */

/* search134_1_1 -> search14_0 in the cache */
static const nir_search_expression search134_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};
static const nir_search_expression search134 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search123_0.value, &search134_1.value },
   NULL,
};

   /* replace134 -> replace133 in the cache */

   /* search135_0_0 -> search14_0 in the cache */

/* search135_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search135_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search135_1_0 -> search14_0 in the cache */

/* search135_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search135_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search135 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search135_0.value, &search135_1.value },
   NULL,
};

   /* replace135 -> replace133 in the cache */

   /* search136_0_0 -> search14_0 in the cache */

/* search136_0_1 -> replace14_1_0 in the cache */
/* search136_0 -> search127_0 in the cache */

/* search136_1_0 -> replace14_1_0 in the cache */

/* search136_1_1 -> search14_0 in the cache */
static const nir_search_expression search136_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};
static const nir_search_expression search136 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search127_0.value, &search136_1.value },
   NULL,
};

   /* replace136 -> replace133 in the cache */

   /* search137_0_0 -> search14_0 in the cache */

/* search137_0_1 -> replace14_1_0 in the cache */
/* search137_0 -> search128_0 in the cache */

/* search137_1_0 -> replace14_1_0 in the cache */

/* search137_1_1 -> search14_0 in the cache */
static const nir_search_expression search137_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};
static const nir_search_expression search137 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search128_0.value, &search137_1.value },
   NULL,
};

   /* replace137 -> replace133 in the cache */

   /* search138_0_0 -> search14_0 in the cache */
/* search138_0 -> search34_0 in the cache */

/* search138_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression search138_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search138 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search34_0.value, &search138_1.value },
   NULL,
};

   /* replace138_0 -> replace14_1_0 in the cache */

/* replace138_1 -> search14_0 in the cache */
/* replace138 -> search134_1 in the cache */

   /* search139_0_0 -> search14_0 in the cache */
/* search139_0 -> search34_0 in the cache */

/* search139_1_0 -> replace14_1_0 in the cache */
/* search139_1 -> search138_1 in the cache */
static const nir_search_expression search139 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search34_0.value, &search138_1.value },
   NULL,
};

   /* replace139_0 -> replace14_1_0 in the cache */

/* replace139_1 -> search14_0 in the cache */
static const nir_search_expression replace139 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search140_0_0 -> search14_0 in the cache */
/* search140_0 -> search34_0 in the cache */

/* search140_1_0 -> replace14_1_0 in the cache */
/* search140_1 -> search138_1 in the cache */
static const nir_search_expression search140 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search34_0.value, &search138_1.value },
   NULL,
};

   /* replace140_0 -> replace14_1_0 in the cache */

/* replace140_1 -> search14_0 in the cache */
static const nir_search_expression replace140 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search141_0_0 -> search14_0 in the cache */
/* search141_0 -> search34_0 in the cache */

/* search141_1_0 -> replace14_1_0 in the cache */
/* search141_1 -> search138_1 in the cache */
static const nir_search_expression search141 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search34_0.value, &search138_1.value },
   NULL,
};

   /* replace141_0 -> replace14_1_0 in the cache */

/* replace141_1 -> search14_0 in the cache */
static const nir_search_expression replace141 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search142_0_0 -> search2_0 in the cache */
/* search142_0 -> search15_0 in the cache */

/* search142_1 -> search43_1 in the cache */
static const nir_search_expression search142 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search15_0.value, &search43_1.value },
   NULL,
};

   /* replace142_0 -> search41_1 in the cache */

/* replace142_1 -> search2_0 in the cache */
static const nir_search_expression replace142 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search41_1.value, &search2_0.value },
   NULL,
};

   /* search143_0 -> search43_1 in the cache */

/* search143_1_0 -> search2_0 in the cache */
/* search143_1 -> search15_0 in the cache */
static const nir_search_expression search143 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search43_1.value, &search15_0.value },
   NULL,
};

   /* replace143_0 -> search2_0 in the cache */

/* replace143_1 -> search41_1 in the cache */
static const nir_search_expression replace143 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   /* search144_0_0 -> search2_0 in the cache */
/* search144_0 -> search15_0 in the cache */

/* search144_1 -> search43_1 in the cache */
static const nir_search_expression search144 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search15_0.value, &search43_1.value },
   NULL,
};

   /* replace144_0 -> search41_1 in the cache */

/* replace144_1 -> search2_0 in the cache */
static const nir_search_expression replace144 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search41_1.value, &search2_0.value },
   NULL,
};

   /* search145_0 -> search43_1 in the cache */

/* search145_1_0 -> search2_0 in the cache */
/* search145_1 -> search15_0 in the cache */
static const nir_search_expression search145 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search43_1.value, &search15_0.value },
   NULL,
};

   /* replace145_0 -> search2_0 in the cache */

/* replace145_1 -> search41_1 in the cache */
static const nir_search_expression replace145 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   /* search146_0_0 -> search2_0 in the cache */
/* search146_0 -> search15_0 in the cache */

/* search146_1 -> search43_1 in the cache */
static const nir_search_expression search146 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search15_0.value, &search43_1.value },
   NULL,
};

   /* replace146_0 -> search41_1 in the cache */

/* replace146_1 -> search2_0 in the cache */
static const nir_search_expression replace146 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search41_1.value, &search2_0.value },
   NULL,
};

   /* search147_0 -> search43_1 in the cache */

/* search147_1_0 -> search2_0 in the cache */
/* search147_1 -> search15_0 in the cache */
static const nir_search_expression search147 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search43_1.value, &search15_0.value },
   NULL,
};

   /* replace147_0 -> search2_0 in the cache */

/* replace147_1 -> search41_1 in the cache */
static const nir_search_expression replace147 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   /* search148_0_0 -> search14_0 in the cache */
static const nir_search_expression search148_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search14_0.value },
   (is_used_once),
};

static const nir_search_variable search148_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_gt_0_and_lt_1),
   {0, 1, 2, 3},
};
static const nir_search_expression search148 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search148_0.value, &search148_1.value },
   NULL,
};

   /* replace148_0 -> search14_0 in the cache */

/* replace148_1 -> replace14_1_0 in the cache */
/* replace148 -> search123_0 in the cache */

   static const nir_search_variable search149_0 = {
   { nir_search_value_variable, -2 },
   0, /* b */
   true,
   nir_type_invalid,
   (is_gt_0_and_lt_1),
   {0, 1, 2, 3},
};

static const nir_search_variable search149_1_0 = {
   { nir_search_value_variable, -2 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search149_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search149_1_0.value },
   (is_used_once),
};
static const nir_search_expression search149 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search149_0.value, &search149_1.value },
   NULL,
};

   static const nir_search_variable replace149_0 = {
   { nir_search_value_variable, -2 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* replace149_1 -> search149_1_0 in the cache */
static const nir_search_expression replace149 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace149_0.value, &search149_1_0.value },
   NULL,
};

   /* search150_0_0 -> search14_0 in the cache */
/* search150_0 -> search148_0 in the cache */

/* search150_1 -> search148_1 in the cache */
static const nir_search_expression search150 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search148_0.value, &search148_1.value },
   NULL,
};

   /* replace150_0 -> search14_0 in the cache */

/* replace150_1 -> replace14_1_0 in the cache */
/* replace150 -> replace123 in the cache */

   /* search151_0 -> search149_0 in the cache */

/* search151_1_0 -> search149_1_0 in the cache */
/* search151_1 -> search149_1 in the cache */
static const nir_search_expression search151 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search149_0.value, &search149_1.value },
   NULL,
};

   /* replace151_0 -> replace149_0 in the cache */

/* replace151_1 -> search149_1_0 in the cache */
static const nir_search_expression replace151 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace149_0.value, &search149_1_0.value },
   NULL,
};

   /* search152_0_0 -> search14_0 in the cache */
/* search152_0 -> search148_0 in the cache */

/* search152_1 -> search148_1 in the cache */
static const nir_search_expression search152 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search148_0.value, &search148_1.value },
   NULL,
};

   /* replace152_0 -> search14_0 in the cache */

/* replace152_1 -> replace14_1_0 in the cache */
/* replace152 -> search125_0 in the cache */

   /* search153_0_0 -> search14_0 in the cache */
/* search153_0 -> search148_0 in the cache */

/* search153_1 -> search148_1 in the cache */
static const nir_search_expression search153 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search148_0.value, &search148_1.value },
   NULL,
};

   /* replace153_0 -> search14_0 in the cache */

/* replace153_1 -> replace14_1_0 in the cache */
/* replace153 -> replace125 in the cache */

   /* search154_0_0 -> search2_0 in the cache */
static const nir_search_expression search154_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search2_0.value },
   (is_used_once),
};

/* search154_1 -> search41_1 in the cache */
static const nir_search_expression search154 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search154_0.value, &search41_1.value },
   NULL,
};

   /* replace154_0 -> search2_0 in the cache */

/* replace154_1 -> search41_1 in the cache */
/* replace154 -> replace145 in the cache */

   /* search155_0_0 -> search2_0 in the cache */
/* search155_0 -> search154_0 in the cache */

/* search155_1 -> search41_1 in the cache */
static const nir_search_expression search155 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search154_0.value, &search41_1.value },
   NULL,
};

   /* replace155_0 -> search2_0 in the cache */

/* replace155_1 -> search41_1 in the cache */
/* replace155 -> replace143 in the cache */

   /* search156_0 -> search24_1 in the cache */

/* search156_1_0 -> search2_0 in the cache */
/* search156_1 -> search154_0 in the cache */
static const nir_search_expression search156 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search24_1.value, &search154_0.value },
   NULL,
};

   /* replace156_0 -> search24_1 in the cache */

/* replace156_1 -> search2_0 in the cache */
static const nir_search_expression replace156 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search24_1.value, &search2_0.value },
   NULL,
};

   /* search157_0 -> search24_1 in the cache */

/* search157_1_0 -> search2_0 in the cache */
/* search157_1 -> search154_0 in the cache */
static const nir_search_expression search157 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search24_1.value, &search154_0.value },
   NULL,
};

   /* replace157_0 -> search24_1 in the cache */

/* replace157_1 -> search2_0 in the cache */
static const nir_search_expression replace157 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search24_1.value, &search2_0.value },
   NULL,
};

   static const nir_search_constant search158_0 = {
   { nir_search_value_constant, 0 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search158_1_0 -> replace80_0 in the cache */
static const nir_search_expression search158_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace80_0.value },
   NULL,
};
static const nir_search_expression search158 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search158_0.value, &search158_1.value },
   NULL,
};

   /* replace158_0 -> replace80_0 in the cache */
static const nir_search_expression replace158 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace80_0.value },
   NULL,
};

   /* search159_0_0_0 -> replace80_0 in the cache */
/* search159_0_0 -> search158_1 in the cache */
static const nir_search_expression search159_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search158_1.value },
   NULL,
};

/* search159_1 -> search158_0 in the cache */
static const nir_search_expression search159 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search159_0.value, &search158_0.value },
   NULL,
};

   /* replace159_0 -> replace80_0 in the cache */
/* replace159 -> replace158 in the cache */

   /* search160_0_0_0 -> replace80_0 in the cache */
/* search160_0_0 -> search158_1 in the cache */

static const nir_search_variable search160_0_1_0 = {
   { nir_search_value_variable, 1 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search160_0_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search160_0_1_0.value },
   NULL,
};
static const nir_search_expression search160_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search158_1.value, &search160_0_1.value },
   NULL,
};

/* search160_1 -> search158_0 in the cache */
static const nir_search_expression search160 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fne,
   { &search160_0.value, &search158_0.value },
   NULL,
};

   /* replace160_0 -> replace80_0 in the cache */

/* replace160_1 -> search160_0_1_0 in the cache */
static const nir_search_expression replace160 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace80_0.value, &search160_0_1_0.value },
   NULL,
};

   /* search161_0_0_0 -> replace80_0 in the cache */
/* search161_0_0 -> search158_1 in the cache */

/* search161_0_1_0 -> search160_0_1_0 in the cache */
/* search161_0_1 -> search160_0_1 in the cache */
static const nir_search_expression search161_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search158_1.value, &search160_0_1.value },
   NULL,
};

/* search161_1 -> search158_0 in the cache */
static const nir_search_expression search161 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search161_0.value, &search158_0.value },
   NULL,
};

   /* replace161_0 -> replace80_0 in the cache */

/* replace161_1 -> search160_0_1_0 in the cache */
/* replace161 -> replace160 in the cache */

   /* search162_0_0 -> replace80_0 in the cache */

static const nir_search_constant search162_0_1 = {
   { nir_search_value_constant, 0 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* search162_0_2_0 -> search160_0_1_0 in the cache */
/* search162_0_2 -> search160_0_1 in the cache */
static const nir_search_expression search162_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search162_0_1.value, &search160_0_1.value },
   NULL,
};

/* search162_1 -> search158_0 in the cache */
static const nir_search_expression search162 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search162_0.value, &search158_0.value },
   NULL,
};

   /* replace162_0 -> replace80_0 in the cache */

/* replace162_1 -> search160_0_1_0 in the cache */
/* replace162 -> replace160 in the cache */

   /* search163_0_0 -> replace80_0 in the cache */
/* search163_0 -> search158_1 in the cache */

/* search163_1_0_0 -> search160_0_1_0 in the cache */
/* search163_1_0 -> search160_0_1 in the cache */
static const nir_search_expression search163_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search160_0_1.value },
   NULL,
};
static const nir_search_expression search163 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search158_1.value, &search163_1.value },
   NULL,
};

   /* replace163_0 -> replace80_0 in the cache */

/* replace163_1 -> search160_0_1_0 in the cache */
/* replace163 -> replace160 in the cache */

   /* search164_0_0_0 -> replace80_0 in the cache */
/* search164_0_0 -> search158_1 in the cache */

/* search164_0_1_0 -> search160_0_1_0 in the cache */
/* search164_0_1 -> search160_0_1 in the cache */
static const nir_search_expression search164_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search158_1.value, &search160_0_1.value },
   NULL,
};

/* search164_1 -> search158_0 in the cache */
static const nir_search_expression search164 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fne,
   { &search164_0.value, &search158_0.value },
   NULL,
};

   /* replace164_0 -> replace80_0 in the cache */

/* replace164_1 -> search160_0_1_0 in the cache */
static const nir_search_expression replace164 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace80_0.value, &search160_0_1_0.value },
   NULL,
};

   /* search165_0_0_0 -> replace80_0 in the cache */
/* search165_0_0 -> search158_1 in the cache */

/* search165_0_1_0 -> search160_0_1_0 in the cache */
/* search165_0_1 -> search160_0_1 in the cache */
static const nir_search_expression search165_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search158_1.value, &search160_0_1.value },
   NULL,
};

/* search165_1 -> search158_0 in the cache */
static const nir_search_expression search165 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search165_0.value, &search158_0.value },
   NULL,
};

   /* replace165_0 -> replace80_0 in the cache */

/* replace165_1 -> search160_0_1_0 in the cache */
/* replace165 -> replace164 in the cache */

   /* search166_0_0 -> replace80_0 in the cache */

/* search166_0_1_0 -> search160_0_1_0 in the cache */
/* search166_0_1 -> search160_0_1 in the cache */

/* search166_0_2 -> search158_0 in the cache */
static const nir_search_expression search166_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search160_0_1.value, &search158_0.value },
   NULL,
};

/* search166_1 -> search158_0 in the cache */
static const nir_search_expression search166 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search166_0.value, &search158_0.value },
   NULL,
};

   /* replace166_0 -> replace80_0 in the cache */

/* replace166_1 -> search160_0_1_0 in the cache */
/* replace166 -> replace164 in the cache */

   /* search167_0_0_0 -> replace80_0 in the cache */
/* search167_0_0 -> search158_1 in the cache */

/* search167_0_1_0_0 -> search160_0_1_0 in the cache */
/* search167_0_1_0 -> search160_0_1 in the cache */
/* search167_0_1 -> search163_1 in the cache */
static const nir_search_expression search167_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search158_1.value, &search163_1.value },
   NULL,
};

/* search167_1 -> search158_0 in the cache */
static const nir_search_expression search167 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fne,
   { &search167_0.value, &search158_0.value },
   NULL,
};

   /* replace167_0 -> replace80_0 in the cache */

/* replace167_1 -> search160_0_1_0 in the cache */
static const nir_search_expression replace167 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &replace80_0.value, &search160_0_1_0.value },
   NULL,
};

   /* search168_0_0 -> replace80_0 in the cache */
/* search168_0 -> search158_1 in the cache */

/* search168_1_0 -> search160_0_1_0 in the cache */
/* search168_1 -> search160_0_1 in the cache */
static const nir_search_expression search168 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search158_1.value, &search160_0_1.value },
   NULL,
};

   /* replace168_0 -> replace80_0 in the cache */

/* replace168_1 -> search160_0_1_0 in the cache */
/* replace168 -> replace167 in the cache */

   /* search169_0_0_0 -> replace80_0 in the cache */
/* search169_0_0 -> search158_1 in the cache */
/* search169_0 -> search159_0 in the cache */

/* search169_1_0_0 -> search160_0_1_0 in the cache */
/* search169_1_0 -> search160_0_1 in the cache */
/* search169_1 -> search163_1 in the cache */
static const nir_search_expression search169 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search159_0.value, &search163_1.value },
   NULL,
};

   /* replace169_0 -> replace80_0 in the cache */

/* replace169_1 -> search160_0_1_0 in the cache */
/* replace169 -> replace167 in the cache */

   /* search170_0_0_0 -> replace80_0 in the cache */
/* search170_0_0 -> search158_1 in the cache */

/* search170_0_1_0 -> search160_0_1_0 in the cache */
/* search170_0_1 -> search160_0_1 in the cache */
/* search170_0 -> search160_0 in the cache */

/* search170_1 -> search158_0 in the cache */
static const nir_search_expression search170 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search160_0.value, &search158_0.value },
   NULL,
};

   /* replace170_0_0 -> replace80_0 in the cache */

/* replace170_0_1 -> search160_0_1_0 in the cache */
/* replace170_0 -> replace160 in the cache */
static const nir_search_expression replace170 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace160.value },
   NULL,
};

   /* search171_0_0_0 -> replace80_0 in the cache */
/* search171_0_0 -> search158_1 in the cache */

/* search171_0_1_0 -> search160_0_1_0 in the cache */
/* search171_0_1 -> search160_0_1 in the cache */
/* search171_0 -> search161_0 in the cache */

/* search171_1 -> search158_0 in the cache */
static const nir_search_expression search171 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search161_0.value, &search158_0.value },
   NULL,
};

   /* replace171_0_0 -> replace80_0 in the cache */

/* replace171_0_1 -> search160_0_1_0 in the cache */
/* replace171_0 -> replace160 in the cache */
/* replace171 -> replace170 in the cache */

   /* search172_0_0 -> replace80_0 in the cache */

/* search172_0_1 -> search162_0_1 in the cache */

/* search172_0_2_0 -> search160_0_1_0 in the cache */
/* search172_0_2 -> search160_0_1 in the cache */
/* search172_0 -> search162_0 in the cache */

/* search172_1 -> search158_0 in the cache */
static const nir_search_expression search172 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search162_0.value, &search158_0.value },
   NULL,
};

   /* replace172_0_0 -> replace80_0 in the cache */

/* replace172_0_1 -> search160_0_1_0 in the cache */
/* replace172_0 -> replace160 in the cache */
/* replace172 -> replace170 in the cache */

   /* search173_0_0 -> replace80_0 in the cache */
/* search173_0 -> search158_1 in the cache */

/* search173_1_0_0 -> search160_0_1_0 in the cache */
/* search173_1_0 -> search160_0_1 in the cache */
/* search173_1 -> search163_1 in the cache */
static const nir_search_expression search173 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search158_1.value, &search163_1.value },
   NULL,
};

   /* replace173_0_0 -> replace80_0 in the cache */

/* replace173_0_1 -> search160_0_1_0 in the cache */
/* replace173_0 -> replace160 in the cache */
/* replace173 -> replace170 in the cache */

   /* search174_0_0_0 -> replace80_0 in the cache */
/* search174_0_0 -> search158_1 in the cache */

/* search174_0_1_0 -> search160_0_1_0 in the cache */
/* search174_0_1 -> search160_0_1 in the cache */
/* search174_0 -> search164_0 in the cache */

/* search174_1 -> search158_0 in the cache */
static const nir_search_expression search174 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search164_0.value, &search158_0.value },
   NULL,
};

   /* replace174_0_0 -> replace80_0 in the cache */

/* replace174_0_1 -> search160_0_1_0 in the cache */
/* replace174_0 -> replace164 in the cache */
static const nir_search_expression replace174 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace164.value },
   NULL,
};

   /* search175_0_0_0 -> replace80_0 in the cache */
/* search175_0_0 -> search158_1 in the cache */

/* search175_0_1_0 -> search160_0_1_0 in the cache */
/* search175_0_1 -> search160_0_1 in the cache */
/* search175_0 -> search165_0 in the cache */

/* search175_1 -> search158_0 in the cache */
static const nir_search_expression search175 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search165_0.value, &search158_0.value },
   NULL,
};

   /* replace175_0_0 -> replace80_0 in the cache */

/* replace175_0_1 -> search160_0_1_0 in the cache */
/* replace175_0 -> replace164 in the cache */
/* replace175 -> replace174 in the cache */

   /* search176_0_0 -> replace80_0 in the cache */

/* search176_0_1_0 -> search160_0_1_0 in the cache */
/* search176_0_1 -> search160_0_1 in the cache */

/* search176_0_2 -> search158_0 in the cache */
/* search176_0 -> search166_0 in the cache */

/* search176_1 -> search158_0 in the cache */
static const nir_search_expression search176 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search166_0.value, &search158_0.value },
   NULL,
};

   /* replace176_0_0 -> replace80_0 in the cache */

/* replace176_0_1 -> search160_0_1_0 in the cache */
/* replace176_0 -> replace164 in the cache */
/* replace176 -> replace174 in the cache */

   /* search177_0_0_0 -> replace80_0 in the cache */
/* search177_0_0 -> search158_1 in the cache */

/* search177_0_1_0_0 -> search160_0_1_0 in the cache */
/* search177_0_1_0 -> search160_0_1 in the cache */
/* search177_0_1 -> search163_1 in the cache */
/* search177_0 -> search167_0 in the cache */

/* search177_1 -> search158_0 in the cache */
static const nir_search_expression search177 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search167_0.value, &search158_0.value },
   NULL,
};

   /* replace177_0 -> replace80_0 in the cache */

/* replace177_1 -> search160_0_1_0 in the cache */
static const nir_search_expression replace177 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace80_0.value, &search160_0_1_0.value },
   NULL,
};

   /* search178_0_0 -> replace80_0 in the cache */
/* search178_0 -> search158_1 in the cache */

/* search178_1_0 -> search160_0_1_0 in the cache */
/* search178_1 -> search160_0_1 in the cache */
static const nir_search_expression search178 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search158_1.value, &search160_0_1.value },
   NULL,
};

   /* replace178_0 -> replace80_0 in the cache */

/* replace178_1 -> search160_0_1_0 in the cache */
/* replace178 -> replace177 in the cache */

   /* search179_0_0_0 -> replace80_0 in the cache */
/* search179_0_0 -> search158_1 in the cache */
/* search179_0 -> search159_0 in the cache */

/* search179_1_0_0 -> search160_0_1_0 in the cache */
/* search179_1_0 -> search160_0_1 in the cache */
/* search179_1 -> search163_1 in the cache */
static const nir_search_expression search179 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search159_0.value, &search163_1.value },
   NULL,
};

   /* replace179_0 -> replace80_0 in the cache */

/* replace179_1 -> search160_0_1_0 in the cache */
/* replace179 -> replace177 in the cache */

   /* search180_0_0_0_0 -> replace80_0 in the cache */
/* search180_0_0_0 -> search158_1 in the cache */

/* search180_0_0_1_0 -> search160_0_1_0 in the cache */
/* search180_0_0_1 -> search160_0_1 in the cache */
static const nir_search_expression search180_0_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search158_1.value, &search160_0_1.value },
   NULL,
};
static const nir_search_expression search180_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search180_0_0.value },
   NULL,
};

/* search180_1 -> search158_0 in the cache */
static const nir_search_expression search180 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search180_0.value, &search158_0.value },
   NULL,
};

   /* replace180_0 -> replace80_0 in the cache */

/* replace180_1 -> search160_0_1_0 in the cache */
/* replace180 -> replace160 in the cache */

   /* search181_0 -> search158_0 in the cache */

/* search181_1_0_0 -> replace80_0 in the cache */
/* search181_1_0 -> search158_1 in the cache */

/* search181_1_1_0 -> search160_0_1_0 in the cache */
/* search181_1_1 -> search160_0_1 in the cache */
/* search181_1 -> search180_0_0 in the cache */
static const nir_search_expression search181 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search158_0.value, &search180_0_0.value },
   NULL,
};

   /* replace181_0 -> replace80_0 in the cache */

/* replace181_1 -> search160_0_1_0 in the cache */
/* replace181 -> replace160 in the cache */

   /* search182_0_0_0_0 -> replace80_0 in the cache */
/* search182_0_0_0 -> search158_1 in the cache */

/* search182_0_0_1_0 -> search160_0_1_0 in the cache */
/* search182_0_0_1 -> search160_0_1 in the cache */
/* search182_0_0 -> search180_0_0 in the cache */
/* search182_0 -> search180_0 in the cache */

/* search182_1 -> search158_0 in the cache */
static const nir_search_expression search182 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search180_0.value, &search158_0.value },
   NULL,
};

   /* replace182_0_0 -> replace80_0 in the cache */

/* replace182_0_1 -> search160_0_1_0 in the cache */
/* replace182_0 -> replace160 in the cache */
/* replace182 -> replace170 in the cache */

   /* search183_0 -> search158_0 in the cache */

/* search183_1_0_0 -> replace80_0 in the cache */
/* search183_1_0 -> search158_1 in the cache */

/* search183_1_1_0 -> search160_0_1_0 in the cache */
/* search183_1_1 -> search160_0_1 in the cache */
/* search183_1 -> search180_0_0 in the cache */
static const nir_search_expression search183 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search158_0.value, &search180_0_0.value },
   NULL,
};

   /* replace183_0_0 -> replace80_0 in the cache */

/* replace183_0_1 -> search160_0_1_0 in the cache */
/* replace183_0 -> replace160 in the cache */
/* replace183 -> replace170 in the cache */

   /* search184_0 -> search2_0 in the cache */

/* search184_1_0 -> search2_0 in the cache */
/* search184_1 -> search15_0 in the cache */
static const nir_search_expression search184 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search15_0.value },
   NULL,
};

   /* replace184_0 -> search2_0 in the cache */

/* replace184_1 -> search24_1 in the cache */
/* replace184 -> replace65_0 in the cache */

   /* search185_0 -> search2_0 in the cache */

/* search185_1_0 -> search2_0 in the cache */
/* search185_1 -> search15_0 in the cache */
static const nir_search_expression search185 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search15_0.value },
   NULL,
};

   /* replace185_0 -> search2_0 in the cache */

/* replace185_1 -> search24_1 in the cache */
static const nir_search_expression replace185 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search24_1.value },
   NULL,
};

   static const nir_search_variable search186_0_0 = {
   { nir_search_value_variable, -1 },
   0, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search186_0_1_0_0_0 = {
   { nir_search_value_variable, 1 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search186_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search186_0_1_0_0_0.value },
   NULL,
};

static const nir_search_variable search186_0_1_0_1_0 = {
   { nir_search_value_variable, 1 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search186_0_1_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search186_0_1_0_1_0.value },
   NULL,
};
static const nir_search_expression search186_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search186_0_1_0_0.value, &search186_0_1_0_1.value },
   NULL,
};
static const nir_search_expression search186_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search186_0_1_0.value },
   NULL,
};
static const nir_search_expression search186_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fmin,
   { &search186_0_0.value, &search186_0_1.value },
   NULL,
};

/* search186_1 -> search24_1 in the cache */
static const nir_search_expression search186 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search186_0.value, &search24_1.value },
   NULL,
};

   /* replace186_0_0 -> search186_0_0 in the cache */

/* replace186_0_1 -> search24_1 in the cache */
static const nir_search_expression replace186_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search186_0_0.value, &search24_1.value },
   NULL,
};

/* replace186_1_0 -> search186_0_1_0_0_0 in the cache */

/* replace186_1_1 -> search186_0_1_0_1_0 in the cache */
static const nir_search_expression replace186_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search186_0_1_0_0_0.value, &search186_0_1_0_1_0.value },
   NULL,
};
static const nir_search_expression replace186 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace186_0.value, &replace186_1.value },
   NULL,
};

   /* search187_0_0 -> search14_0 in the cache */

/* search187_0_1 -> replace14_1_0 in the cache */
/* search187_0 -> replace49 in the cache */

/* search187_1 -> search14_0 in the cache */
static const nir_search_expression search187 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &replace49.value, &search14_0.value },
   NULL,
};

   /* replace187_0 -> replace14_1_0 in the cache */

/* replace187_1 -> search47_0 in the cache */
static const nir_search_expression replace187 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* search188_0_0 -> search14_0 in the cache */

/* search188_0_1 -> replace14_1_0 in the cache */
/* search188_0 -> replace49 in the cache */

/* search188_1 -> search14_0 in the cache */
static const nir_search_expression search188 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &replace49.value, &search14_0.value },
   NULL,
};

   /* replace188_0 -> replace14_1_0 in the cache */

/* replace188_1 -> search47_0 in the cache */
static const nir_search_expression replace188 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* search189_0_0 -> search14_0 in the cache */

/* search189_0_1 -> replace14_1_0 in the cache */
/* search189_0 -> search34_1 in the cache */

/* search189_1 -> search14_0 in the cache */
static const nir_search_expression search189 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search34_1.value, &search14_0.value },
   NULL,
};

   /* replace189_0 -> replace14_1_0 in the cache */

/* replace189_1 -> search47_0 in the cache */
static const nir_search_expression replace189 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* search190_0_0 -> search14_0 in the cache */

/* search190_0_1 -> replace14_1_0 in the cache */
/* search190_0 -> search34_1 in the cache */

/* search190_1 -> search14_0 in the cache */
static const nir_search_expression search190 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fne,
   { &search34_1.value, &search14_0.value },
   NULL,
};

   /* replace190_0 -> replace14_1_0 in the cache */

/* replace190_1 -> search47_0 in the cache */
static const nir_search_expression replace190 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* search191_0_0 -> search28_0_0 in the cache */

/* search191_0_1 -> search96_0_0_1 in the cache */
static const nir_search_expression search191_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search28_0_0.value, &search96_0_0_1.value },
   (is_used_once),
};

/* search191_1 -> search96_0_1 in the cache */
static const nir_search_expression search191 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &search191_0.value, &search96_0_1.value },
   NULL,
};

   /* replace191_0 -> search28_0_0 in the cache */

/* replace191_1_0 -> search28_1_1 in the cache */

/* replace191_1_1_0 -> search28_0_1 in the cache */
static const nir_search_expression replace191_1_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search28_0_1.value },
   NULL,
};
static const nir_search_expression replace191_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search28_1_1.value, &replace191_1_1.value },
   NULL,
};
static const nir_search_expression replace191 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search28_0_0.value, &replace191_1.value },
   NULL,
};

   /* search192_0_0_0 -> search28_0_0 in the cache */

/* search192_0_0_1 -> search96_0_0_1 in the cache */
/* search192_0_0 -> search191_0 in the cache */
static const nir_search_expression search192_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search191_0.value },
   (is_used_once),
};

/* search192_1 -> search96_0_1 in the cache */
static const nir_search_expression search192 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &search192_0.value, &search96_0_1.value },
   NULL,
};

   /* replace192_0_0_0 -> search28_1_1 in the cache */

/* replace192_0_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace192_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search28_1_1.value, &search28_0_1.value },
   NULL,
};
static const nir_search_expression replace192_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace192_0_0.value },
   NULL,
};

/* replace192_1 -> search28_0_0 in the cache */
static const nir_search_expression replace192 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace192_0.value, &search28_0_0.value },
   NULL,
};

   /* search193_0_0 -> search28_0_0 in the cache */

/* search193_0_1 -> search96_0_0_1 in the cache */
/* search193_0 -> search191_0 in the cache */

/* search193_1 -> search96_0_1 in the cache */
static const nir_search_expression search193 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search191_0.value, &search96_0_1.value },
   NULL,
};

   /* replace193_0 -> search28_0_0 in the cache */

/* replace193_1_0 -> search28_1_1 in the cache */

/* replace193_1_1_0 -> search28_0_1 in the cache */
/* replace193_1_1 -> replace191_1_1 in the cache */
/* replace193_1 -> replace191_1 in the cache */
static const nir_search_expression replace193 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search28_0_0.value, &replace191_1.value },
   NULL,
};

   /* search194_0_0_0 -> search28_0_0 in the cache */

/* search194_0_0_1 -> search96_0_0_1 in the cache */
/* search194_0_0 -> search191_0 in the cache */
/* search194_0 -> search192_0 in the cache */

/* search194_1 -> search96_0_1 in the cache */
static const nir_search_expression search194 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search192_0.value, &search96_0_1.value },
   NULL,
};

   /* replace194_0_0_0 -> search28_1_1 in the cache */

/* replace194_0_0_1 -> search28_0_1 in the cache */
/* replace194_0_0 -> replace192_0_0 in the cache */
/* replace194_0 -> replace192_0 in the cache */

/* replace194_1 -> search28_0_0 in the cache */
static const nir_search_expression replace194 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &replace192_0.value, &search28_0_0.value },
   NULL,
};

   /* search195_0_0 -> search28_0_0 in the cache */

/* search195_0_1 -> search96_0_0_1 in the cache */
static const nir_search_expression search195_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_0_0.value, &search96_0_0_1.value },
   (is_used_once),
};

/* search195_1 -> search96_0_1 in the cache */
static const nir_search_expression search195 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search195_0.value, &search96_0_1.value },
   NULL,
};

   /* replace195_0 -> search28_0_0 in the cache */

/* replace195_1_0 -> search28_1_1 in the cache */

/* replace195_1_1_0 -> search28_0_1 in the cache */
/* replace195_1_1 -> replace191_1_1 in the cache */
static const nir_search_expression replace195_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_1_1.value, &replace191_1_1.value },
   NULL,
};
static const nir_search_expression replace195 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search28_0_0.value, &replace195_1.value },
   NULL,
};

   /* search196_0_0_0 -> search28_0_0 in the cache */

/* search196_0_0_1 -> search96_0_0_1 in the cache */
/* search196_0_0 -> search195_0 in the cache */
static const nir_search_expression search196_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search195_0.value },
   (is_used_once),
};

/* search196_1 -> search96_0_1 in the cache */
static const nir_search_expression search196 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search196_0.value, &search96_0_1.value },
   NULL,
};

   /* replace196_0_0_0 -> search28_1_1 in the cache */

/* replace196_0_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace196_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_1_1.value, &search28_0_1.value },
   NULL,
};
static const nir_search_expression replace196_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace196_0_0.value },
   NULL,
};

/* replace196_1 -> search28_0_0 in the cache */
static const nir_search_expression replace196 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &replace196_0.value, &search28_0_0.value },
   NULL,
};

   /* search197_0_0 -> search28_0_0 in the cache */

/* search197_0_1 -> search96_0_0_1 in the cache */
/* search197_0 -> search195_0 in the cache */

/* search197_1 -> search96_0_1 in the cache */
static const nir_search_expression search197 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fne,
   { &search195_0.value, &search96_0_1.value },
   NULL,
};

   /* replace197_0 -> search28_0_0 in the cache */

/* replace197_1_0 -> search28_1_1 in the cache */

/* replace197_1_1_0 -> search28_0_1 in the cache */
/* replace197_1_1 -> replace191_1_1 in the cache */
/* replace197_1 -> replace195_1 in the cache */
static const nir_search_expression replace197 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fne,
   { &search28_0_0.value, &replace195_1.value },
   NULL,
};

   /* search198_0_0_0 -> search28_0_0 in the cache */

/* search198_0_0_1 -> search96_0_0_1 in the cache */
/* search198_0_0 -> search195_0 in the cache */
/* search198_0 -> search196_0 in the cache */

/* search198_1 -> search96_0_1 in the cache */
static const nir_search_expression search198 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fne,
   { &search196_0.value, &search96_0_1.value },
   NULL,
};

   /* replace198_0_0_0 -> search28_1_1 in the cache */

/* replace198_0_0_1 -> search28_0_1 in the cache */
/* replace198_0_0 -> replace196_0_0 in the cache */
/* replace198_0 -> replace196_0 in the cache */

/* replace198_1 -> search28_0_0 in the cache */
static const nir_search_expression replace198 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fne,
   { &replace196_0.value, &search28_0_0.value },
   NULL,
};

   /* search199_0_0 -> search14_0 in the cache */

/* search199_0_1 -> replace14_1_0 in the cache */
/* search199_0 -> search32_1 in the cache */

/* search199_1 -> search14_0 in the cache */
static const nir_search_expression search199 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search32_1.value, &search14_0.value },
   NULL,
};

   /* replace199_0 -> replace14_1_0 in the cache */

static const nir_search_constant replace199_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace199 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace14_1_0.value, &replace199_1.value },
   NULL,
};

   /* search200_0_0 -> search14_0 in the cache */

/* search200_0_1 -> replace14_1_0 in the cache */
/* search200_0 -> search32_1 in the cache */

/* search200_1 -> search14_0 in the cache */
static const nir_search_expression search200 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search32_1.value, &search14_0.value },
   NULL,
};

   /* replace200_0 -> replace14_1_0 in the cache */

/* replace200_1 -> replace199_1 in the cache */
static const nir_search_expression replace200 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace14_1_0.value, &replace199_1.value },
   NULL,
};

   /* search201_0_0_0_0 -> replace80_0 in the cache */
static const nir_search_expression search201_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace80_0.value },
   NULL,
};
static const nir_search_expression search201_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search201_0_0_0.value },
   NULL,
};

/* search201_0_1 -> search160_0_1_0 in the cache */
static const nir_search_expression search201_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search201_0_0.value, &search160_0_1_0.value },
   NULL,
};

static const nir_search_constant search201_1 = {
   { nir_search_value_constant, 1 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search201 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search201_0.value, &search201_1.value },
   NULL,
};

   /* replace201_0_0 -> replace80_0 in the cache */
/* replace201_0 -> replace158 in the cache */

/* replace201_1_0 -> search160_0_1_0 in the cache */

/* replace201_1_1 -> search201_1 in the cache */
static const nir_search_expression replace201_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search160_0_1_0.value, &search201_1.value },
   NULL,
};
static const nir_search_expression replace201 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace158.value, &replace201_1.value },
   NULL,
};

   /* search202_0_0_0_0 -> replace80_0 in the cache */
/* search202_0_0_0 -> search201_0_0_0 in the cache */
/* search202_0_0 -> search201_0_0 in the cache */

/* search202_0_1 -> search160_0_1_0 in the cache */
/* search202_0 -> search201_0 in the cache */

/* search202_1 -> search201_1 in the cache */
static const nir_search_expression search202 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search201_0.value, &search201_1.value },
   NULL,
};

   /* replace202_0_0 -> replace80_0 in the cache */
/* replace202_0 -> replace158 in the cache */

/* replace202_1_0 -> search160_0_1_0 in the cache */

/* replace202_1_1 -> search201_1 in the cache */
/* replace202_1 -> replace201_1 in the cache */
/* replace202 -> replace201 in the cache */

   /* search203_0_0 -> replace80_0 in the cache */
/* search203_0 -> search158_1 in the cache */

/* search203_1 -> search158_0 in the cache */
static const nir_search_expression search203 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search158_1.value, &search158_0.value },
   NULL,
};

   /* replace203_0 -> replace80_0 in the cache */
/* replace203 -> replace158 in the cache */

   /* search204_0_0 -> replace80_0 in the cache */
/* search204_0 -> search158_1 in the cache */

/* search204_1 -> search158_0 in the cache */
static const nir_search_expression search204 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_fne,
   { &search158_1.value, &search158_0.value },
   NULL,
};

   /* replace204 -> replace80_0 in the cache */

   /* search205_0_0 -> replace80_0 in the cache */
static const nir_search_expression search205_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace80_0.value },
   NULL,
};

static const nir_search_constant search205_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression search205 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search205_0.value, &search205_1.value },
   NULL,
};

   /* replace205_0 -> replace80_0 in the cache */
/* replace205 -> replace158 in the cache */

   /* search206_0_0 -> replace80_0 in the cache */
/* search206_0 -> search205_0 in the cache */

/* search206_1 -> search205_1 in the cache */
static const nir_search_expression search206 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search205_0.value, &search205_1.value },
   NULL,
};

   /* replace206 -> replace80_0 in the cache */

   /* search207_0_0 -> search2_0 in the cache */
/* search207_0 -> search19_0 in the cache */

/* search207_1 -> search158_0 in the cache */
static const nir_search_expression search207 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search19_0.value, &search158_0.value },
   NULL,
};

   /* replace207_0 -> search2_0 in the cache */

/* replace207_1 -> replace9 in the cache */
static const nir_search_expression replace207 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search208_0_0 -> search2_0 in the cache */
/* search208_0 -> search19_0 in the cache */

/* search208_1 -> search158_0 in the cache */
static const nir_search_expression search208 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search19_0.value, &search158_0.value },
   NULL,
};

   /* replace208_0 -> search2_0 in the cache */

/* replace208_1 -> replace9 in the cache */
static const nir_search_expression replace208 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search209_0_0 -> search2_0 in the cache */
/* search209_0 -> search19_0 in the cache */

/* search209_1 -> search158_0 in the cache */
static const nir_search_expression search209 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search19_0.value, &search158_0.value },
   NULL,
};

   static const nir_search_constant replace209 = {
   { nir_search_value_constant, 1 },
   nir_type_bool, { NIR_TRUE /* True */ },
};

   /* search210_0 -> search158_0 in the cache */

/* search210_1_0 -> search2_0 in the cache */
/* search210_1 -> search19_0 in the cache */
static const nir_search_expression search210 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search158_0.value, &search19_0.value },
   NULL,
};

   /* replace210_0 -> replace9 in the cache */

/* replace210_1 -> search2_0 in the cache */
static const nir_search_expression replace210 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search211_0_0 -> search2_0 in the cache */
/* search211_0 -> search19_0 in the cache */

/* search211_1 -> search158_0 in the cache */
static const nir_search_expression search211 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search19_0.value, &search158_0.value },
   NULL,
};

   /* replace211 -> replace133 in the cache */

   /* search212_0 -> search158_0 in the cache */

/* search212_1_0 -> search2_0 in the cache */
/* search212_1 -> search19_0 in the cache */
static const nir_search_expression search212 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search158_0.value, &search19_0.value },
   NULL,
};

   /* replace212_0 -> replace9 in the cache */

/* replace212_1 -> search2_0 in the cache */
static const nir_search_expression replace212 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search213_0_0 -> search2_0 in the cache */
static const nir_search_expression search213_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search2_0.value },
   NULL,
};

/* search213_1 -> search158_0 in the cache */
static const nir_search_expression search213 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search213_0.value, &search158_0.value },
   NULL,
};

   /* replace213_0 -> search2_0 in the cache */

/* replace213_1 -> replace9 in the cache */
/* replace213 -> replace207 in the cache */

   /* search214_0_0 -> search2_0 in the cache */
/* search214_0 -> search213_0 in the cache */

/* search214_1 -> search158_0 in the cache */
static const nir_search_expression search214 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search213_0.value, &search158_0.value },
   NULL,
};

   /* replace214_0 -> search2_0 in the cache */

/* replace214_1 -> replace9 in the cache */
/* replace214 -> replace208 in the cache */

   /* search215_0_0 -> search2_0 in the cache */
/* search215_0 -> search213_0 in the cache */

/* search215_1 -> search158_0 in the cache */
static const nir_search_expression search215 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search213_0.value, &search158_0.value },
   NULL,
};

   /* replace215_0 -> search2_0 in the cache */

/* replace215_1 -> replace9 in the cache */
static const nir_search_expression replace215 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search216_0 -> search158_0 in the cache */

/* search216_1_0 -> search2_0 in the cache */
/* search216_1 -> search213_0 in the cache */
static const nir_search_expression search216 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search158_0.value, &search213_0.value },
   NULL,
};

   /* replace216_0 -> replace9 in the cache */

/* replace216_1 -> search2_0 in the cache */
static const nir_search_expression replace216 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search217_0_0 -> search2_0 in the cache */
/* search217_0 -> search213_0 in the cache */

/* search217_1 -> search158_0 in the cache */
static const nir_search_expression search217 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search213_0.value, &search158_0.value },
   NULL,
};

   /* replace217_0 -> search2_0 in the cache */

/* replace217_1 -> replace9 in the cache */
static const nir_search_expression replace217 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search218_0 -> search158_0 in the cache */

/* search218_1_0 -> search2_0 in the cache */
/* search218_1 -> search213_0 in the cache */
static const nir_search_expression search218 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search158_0.value, &search213_0.value },
   NULL,
};

   /* replace218_0 -> replace9 in the cache */

/* replace218_1 -> search2_0 in the cache */
static const nir_search_expression replace218 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search219_0 -> search24_1 in the cache */

/* search219_1_0 -> search2_0 in the cache */
/* search219_1 -> search17_0 in the cache */
static const nir_search_expression search219 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search24_1.value, &search17_0.value },
   NULL,
};

   /* replace219_0 -> search2_0 in the cache */

/* replace219_1 -> search24_1 in the cache */
static const nir_search_expression replace219 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search2_0.value, &search24_1.value },
   NULL,
};

   /* search220_0_0_0 -> search2_0 in the cache */
/* search220_0_0 -> search17_0 in the cache */
static const nir_search_expression search220_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search17_0.value },
   NULL,
};

/* search220_1 -> search24_1 in the cache */
static const nir_search_expression search220 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search220_0.value, &search24_1.value },
   NULL,
};

   /* replace220_0 -> search2_0 in the cache */

/* replace220_1 -> search24_1 in the cache */
/* replace220 -> replace219 in the cache */

   /* search221_0 -> search24_1 in the cache */

/* search221_1_0 -> search2_0 in the cache */
/* search221_1 -> search17_0 in the cache */
static const nir_search_expression search221 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search24_1.value, &search17_0.value },
   NULL,
};

   /* replace221_0 -> search2_0 in the cache */

/* replace221_1 -> search24_1 in the cache */
static const nir_search_expression replace221 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search2_0.value, &search24_1.value },
   NULL,
};

   /* search222_0_0_0 -> search2_0 in the cache */
/* search222_0_0 -> search17_0 in the cache */
/* search222_0 -> search220_0 in the cache */

/* search222_1 -> search24_1 in the cache */
static const nir_search_expression search222 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search220_0.value, &search24_1.value },
   NULL,
};

   /* replace222_0 -> search2_0 in the cache */

/* replace222_1 -> search24_1 in the cache */
/* replace222 -> replace221 in the cache */

   /* search223_0_0 -> search2_0 in the cache */

/* search223_0_1 -> search24_1 in the cache */
/* search223_0 -> replace185 in the cache */

/* search223_1_0 -> search41_1 in the cache */

/* search223_1_1 -> search2_0 in the cache */
/* search223_1 -> replace144 in the cache */
static const nir_search_expression search223 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace185.value, &replace144.value },
   NULL,
};

   /* replace223_0 -> search2_0 in the cache */

/* replace223_1_0 -> search2_0 in the cache */
/* replace223_1 -> search36_0 in the cache */
static const nir_search_expression replace223 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search2_0.value, &search36_0.value },
   NULL,
};

   /* search224_0_0 -> search2_0 in the cache */

/* search224_0_1 -> search24_1 in the cache */
/* search224_0 -> replace65_0 in the cache */

/* search224_1_0 -> search41_1 in the cache */

/* search224_1_1 -> search2_0 in the cache */
/* search224_1 -> replace142 in the cache */
static const nir_search_expression search224 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace65_0.value, &replace142.value },
   NULL,
};

   /* replace224_0 -> search2_0 in the cache */

/* replace224_1_0 -> search2_0 in the cache */
/* replace224_1 -> search36_0 in the cache */
static const nir_search_expression replace224 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search2_0.value, &search36_0.value },
   NULL,
};

   /* search225_0_0 -> replace80_0 in the cache */
static const nir_search_expression search225_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace80_0.value },
   (is_used_once),
};

/* search225_1_0 -> search160_0_1_0 in the cache */
/* search225_1 -> search160_0_1 in the cache */
static const nir_search_expression search225 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search225_0.value, &search160_0_1.value },
   NULL,
};

   /* replace225_0_0 -> replace80_0 in the cache */

/* replace225_0_1 -> search160_0_1_0 in the cache */
/* replace225_0 -> replace160 in the cache */
static const nir_search_expression replace225 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace160.value },
   NULL,
};

   /* search226_0_0_0 -> replace80_0 in the cache */
/* search226_0_0 -> search225_0 in the cache */
static const nir_search_expression search226_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search225_0.value },
   (is_used_once),
};

/* search226_1_0_0 -> search160_0_1_0 in the cache */
/* search226_1_0 -> search160_0_1 in the cache */
/* search226_1 -> search163_1 in the cache */
static const nir_search_expression search226 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search226_0.value, &search163_1.value },
   NULL,
};

   /* replace226_0_0_0 -> replace80_0 in the cache */

/* replace226_0_0_1 -> search160_0_1_0 in the cache */
/* replace226_0_0 -> replace160 in the cache */
/* replace226_0 -> replace225 in the cache */
static const nir_search_expression replace226 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace225.value },
   NULL,
};

   /* search227_0_0 -> replace80_0 in the cache */
/* search227_0 -> search225_0 in the cache */

/* search227_1_0 -> search160_0_1_0 in the cache */
/* search227_1 -> search160_0_1 in the cache */
static const nir_search_expression search227 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search225_0.value, &search160_0_1.value },
   NULL,
};

   /* replace227_0_0 -> replace80_0 in the cache */

/* replace227_0_1 -> search160_0_1_0 in the cache */
/* replace227_0 -> replace164 in the cache */
static const nir_search_expression replace227 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace164.value },
   NULL,
};

   /* search228_0_0_0 -> replace80_0 in the cache */
/* search228_0_0 -> search225_0 in the cache */
/* search228_0 -> search226_0 in the cache */

/* search228_1_0_0 -> search160_0_1_0 in the cache */
/* search228_1_0 -> search160_0_1 in the cache */
/* search228_1 -> search163_1 in the cache */
static const nir_search_expression search228 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search226_0.value, &search163_1.value },
   NULL,
};

   /* replace228_0_0_0 -> replace80_0 in the cache */

/* replace228_0_0_1 -> search160_0_1_0 in the cache */
/* replace228_0_0 -> replace164 in the cache */
/* replace228_0 -> replace227 in the cache */
static const nir_search_expression replace228 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace227.value },
   NULL,
};

   /* search229_0_0 -> replace80_0 in the cache */
static const nir_search_expression search229_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace80_0.value },
   NULL,
};

/* search229_1 -> search97_0_1 in the cache */
static const nir_search_expression search229 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search229_0.value, &search97_0_1.value },
   NULL,
};

   /* replace229_0 -> replace80_0 in the cache */

/* replace229_1_0 -> replace14_1_0 in the cache */

/* replace229_1_1 -> search49_0 in the cache */
static const nir_search_expression replace229_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace14_1_0.value, &search49_0.value },
   NULL,
};

/* replace229_2_0 -> replace14_1_0 in the cache */

/* replace229_2_1 -> search47_0 in the cache */
static const nir_search_expression replace229_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace14_1_0.value, &search47_0.value },
   NULL,
};
static const nir_search_expression replace229 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace229_1.value, &replace229_2.value },
   NULL,
};

   /* search230_0_0 -> search14_0 in the cache */

/* search230_0_1_0 -> replace14_1_0 in the cache */
/* search230_0_1 -> search138_1 in the cache */
static const nir_search_expression search230_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search14_0.value, &search138_1.value },
   (is_used_once),
};

/* search230_1 -> search47_0 in the cache */
static const nir_search_expression search230 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search230_0.value, &search47_0.value },
   NULL,
};

   /* replace230_0 -> search14_0 in the cache */

/* replace230_1 -> replace14_1_0 in the cache */
/* replace230 -> search123_0 in the cache */

   /* search231_0_0_0 -> search2_0 in the cache */
/* search231_0_0 -> search17_0 in the cache */
/* search231_0 -> search220_0 in the cache */

/* search231_1 -> search24_1 in the cache */
/* search231 -> search222 in the cache */

   /* replace231_0 -> search2_0 in the cache */

/* replace231_1 -> search24_1 in the cache */
/* replace231 -> replace221 in the cache */

   /* search232_0_0 -> replace149_0 in the cache */

/* search232_0_1 -> search149_1_0 in the cache */
/* search232_0 -> replace149 in the cache */

/* search232_1 -> replace149_0 in the cache */

/* search232_2 -> search149_1_0 in the cache */
static const nir_search_expression search232 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace149.value, &replace149_0.value, &search149_1_0.value },
   NULL,
};

   /* replace232_0 -> search149_1_0 in the cache */

/* replace232_1 -> replace149_0 in the cache */
static const nir_search_expression replace232 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search149_1_0.value, &replace149_0.value },
   NULL,
};

   /* search233_0_0 -> search14_0 in the cache */

/* search233_0_1 -> replace14_1_0 in the cache */
/* search233_0 -> search123_0 in the cache */

/* search233_1 -> replace14_1_0 in the cache */

/* search233_2 -> search14_0 in the cache */
static const nir_search_expression search233 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &search123_0.value, &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* replace233_0 -> search14_0 in the cache */

/* replace233_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace233 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search234_0_0 -> search14_0 in the cache */

/* search234_0_1 -> replace14_1_0 in the cache */
/* search234_0 -> replace123 in the cache */

/* search234_1 -> replace14_1_0 in the cache */

/* search234_2 -> search14_0 in the cache */
static const nir_search_expression search234 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace123.value, &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* replace234_0 -> search14_0 in the cache */

/* replace234_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace234 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search235_0_0 -> replace149_0 in the cache */

/* search235_0_1 -> search149_1_0 in the cache */
/* search235_0 -> replace151 in the cache */

/* search235_1 -> replace149_0 in the cache */

/* search235_2 -> search149_1_0 in the cache */
static const nir_search_expression search235 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace151.value, &replace149_0.value, &search149_1_0.value },
   NULL,
};

   /* replace235_0 -> search149_1_0 in the cache */

/* replace235_1 -> replace149_0 in the cache */
static const nir_search_expression replace235 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search149_1_0.value, &replace149_0.value },
   NULL,
};

   /* search236_0_0 -> search2_0 in the cache */
static const nir_search_expression search236_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search2_0.value },
   NULL,
};

/* search236_1 -> search28_0_1 in the cache */

/* search236_2 -> search28_1_1 in the cache */
static const nir_search_expression search236 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search236_0.value, &search28_0_1.value, &search28_1_1.value },
   NULL,
};

   /* replace236_0_0 -> search2_0 in the cache */

/* replace236_0_1 -> replace9 in the cache */
/* replace236_0 -> replace207 in the cache */

/* replace236_1 -> search28_0_1 in the cache */

/* replace236_2 -> search28_1_1 in the cache */
static const nir_search_expression replace236 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace207.value, &search28_0_1.value, &search28_1_1.value },
   NULL,
};

   /* search237_0_0 -> replace80_0 in the cache */
/* search237_0 -> replace158 in the cache */

/* search237_1 -> search28_0_1 in the cache */

/* search237_2 -> search28_1_1 in the cache */
static const nir_search_expression search237 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace158.value, &search28_0_1.value, &search28_1_1.value },
   NULL,
};

   /* replace237_0 -> replace80_0 in the cache */

/* replace237_1 -> search28_1_1 in the cache */

/* replace237_2 -> search28_0_1 in the cache */
static const nir_search_expression replace237 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search28_1_1.value, &search28_0_1.value },
   NULL,
};

   /* search238_0 -> replace80_0 in the cache */

/* search238_1_0 -> replace80_0 in the cache */

/* search238_1_1 -> search62_0_1 in the cache */

/* search238_1_2 -> search62_1_1 in the cache */
static const nir_search_expression search238_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search62_0_1.value, &search62_1_1.value },
   NULL,
};

/* search238_2 -> search62_2 in the cache */
static const nir_search_expression search238 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search238_1.value, &search62_2.value },
   NULL,
};

   /* replace238_0 -> replace80_0 in the cache */

/* replace238_1 -> search62_0_1 in the cache */

/* replace238_2 -> search62_2 in the cache */
static const nir_search_expression replace238 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search62_0_1.value, &search62_2.value },
   NULL,
};

   /* search239_0 -> replace80_0 in the cache */

/* search239_1 -> search62_0_1 in the cache */

/* search239_2_0 -> replace80_0 in the cache */

/* search239_2_1 -> search62_1_1 in the cache */

/* search239_2_2 -> search62_2 in the cache */
static const nir_search_expression search239_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search62_1_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression search239 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search62_0_1.value, &search239_2.value },
   NULL,
};

   /* replace239_0 -> replace80_0 in the cache */

/* replace239_1 -> search62_0_1 in the cache */

/* replace239_2 -> search62_2 in the cache */
/* replace239 -> replace238 in the cache */

   /* search240_0 -> replace80_0 in the cache */

/* search240_1_0 -> search160_0_1_0 in the cache */

static const nir_search_variable search240_1_1 = {
   { nir_search_value_variable, -5 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search240_1_2 = {
   { nir_search_value_variable, -5 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search240_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search160_0_1_0.value, &search240_1_1.value, &search240_1_2.value },
   NULL,
};

/* search240_2_0 -> search160_0_1_0 in the cache */

/* search240_2_1 -> search240_1_1 in the cache */

static const nir_search_variable search240_2_2 = {
   { nir_search_value_variable, -5 },
   4, /* e */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search240_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search160_0_1_0.value, &search240_1_1.value, &search240_2_2.value },
   (is_used_once),
};
static const nir_search_expression search240 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search240_1.value, &search240_2.value },
   NULL,
};

   /* replace240_0 -> search160_0_1_0 in the cache */

/* replace240_1 -> search240_1_1 in the cache */

/* replace240_2_0 -> replace80_0 in the cache */

/* replace240_2_1 -> search240_1_2 in the cache */

/* replace240_2_2 -> search240_2_2 in the cache */
static const nir_search_expression replace240_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search240_1_2.value, &search240_2_2.value },
   NULL,
};
static const nir_search_expression replace240 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search160_0_1_0.value, &search240_1_1.value, &replace240_2.value },
   NULL,
};

   /* search241_0 -> replace80_0 in the cache */

/* search241_1_0 -> search160_0_1_0 in the cache */

/* search241_1_1 -> search240_1_1 in the cache */

/* search241_1_2 -> search240_1_2 in the cache */
static const nir_search_expression search241_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search160_0_1_0.value, &search240_1_1.value, &search240_1_2.value },
   (is_used_once),
};

/* search241_2_0 -> search160_0_1_0 in the cache */

/* search241_2_1 -> search240_1_1 in the cache */

/* search241_2_2 -> search240_2_2 in the cache */
static const nir_search_expression search241_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search160_0_1_0.value, &search240_1_1.value, &search240_2_2.value },
   NULL,
};
static const nir_search_expression search241 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search241_1.value, &search241_2.value },
   NULL,
};

   /* replace241_0 -> search160_0_1_0 in the cache */

/* replace241_1 -> search240_1_1 in the cache */

/* replace241_2_0 -> replace80_0 in the cache */

/* replace241_2_1 -> search240_1_2 in the cache */

/* replace241_2_2 -> search240_2_2 in the cache */
/* replace241_2 -> replace240_2 in the cache */
/* replace241 -> replace240 in the cache */

   /* search242_0 -> replace80_0 in the cache */

/* search242_1_0 -> search160_0_1_0 in the cache */

/* search242_1_1 -> search62_1_1 in the cache */

/* search242_1_2 -> search62_2 in the cache */
static const nir_search_expression search242_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search160_0_1_0.value, &search62_1_1.value, &search62_2.value },
   NULL,
};

/* search242_2_0 -> search160_0_1_0 in the cache */

static const nir_search_variable search242_2_1 = {
   { nir_search_value_variable, -4 },
   4, /* e */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search242_2_2 -> search62_2 in the cache */
static const nir_search_expression search242_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search160_0_1_0.value, &search242_2_1.value, &search62_2.value },
   (is_used_once),
};
static const nir_search_expression search242 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search242_1.value, &search242_2.value },
   NULL,
};

   /* replace242_0 -> search160_0_1_0 in the cache */

/* replace242_1_0 -> replace80_0 in the cache */

/* replace242_1_1 -> search62_1_1 in the cache */

/* replace242_1_2 -> search242_2_1 in the cache */
static const nir_search_expression replace242_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search62_1_1.value, &search242_2_1.value },
   NULL,
};

/* replace242_2 -> search62_2 in the cache */
static const nir_search_expression replace242 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search160_0_1_0.value, &replace242_1.value, &search62_2.value },
   NULL,
};

   /* search243_0 -> replace80_0 in the cache */

/* search243_1_0 -> search160_0_1_0 in the cache */

/* search243_1_1 -> search62_1_1 in the cache */

/* search243_1_2 -> search62_2 in the cache */
static const nir_search_expression search243_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search160_0_1_0.value, &search62_1_1.value, &search62_2.value },
   (is_used_once),
};

/* search243_2_0 -> search160_0_1_0 in the cache */

/* search243_2_1 -> search242_2_1 in the cache */

/* search243_2_2 -> search62_2 in the cache */
static const nir_search_expression search243_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search160_0_1_0.value, &search242_2_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression search243 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search243_1.value, &search243_2.value },
   NULL,
};

   /* replace243_0 -> search160_0_1_0 in the cache */

/* replace243_1_0 -> replace80_0 in the cache */

/* replace243_1_1 -> search62_1_1 in the cache */

/* replace243_1_2 -> search242_2_1 in the cache */
/* replace243_1 -> replace242_1 in the cache */

/* replace243_2 -> search62_2 in the cache */
/* replace243 -> replace242 in the cache */

   /* search244_0 -> replace80_0 in the cache */

/* search244_1 -> replace209 in the cache */

/* search244_2 -> search160_0_1_0 in the cache */
static const nir_search_expression search244 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace209.value, &search160_0_1_0.value },
   NULL,
};

   /* replace244_0 -> replace80_0 in the cache */

/* replace244_1 -> search160_0_1_0 in the cache */
/* replace244 -> replace160 in the cache */

   /* search245_0 -> replace80_0 in the cache */

/* search245_1 -> replace80_0 in the cache */

/* search245_2 -> search160_0_1_0 in the cache */
static const nir_search_expression search245 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace80_0.value, &search160_0_1_0.value },
   NULL,
};

   /* replace245_0 -> replace80_0 in the cache */

/* replace245_1 -> search160_0_1_0 in the cache */
/* replace245 -> replace160 in the cache */

   /* search246_0 -> replace80_0 in the cache */

/* search246_1 -> search160_0_1_0 in the cache */

/* search246_2 -> replace133 in the cache */
static const nir_search_expression search246 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search160_0_1_0.value, &replace133.value },
   NULL,
};

   /* replace246_0 -> replace80_0 in the cache */

/* replace246_1 -> search160_0_1_0 in the cache */
/* replace246 -> replace164 in the cache */

   /* search247_0 -> replace80_0 in the cache */

/* search247_1 -> search160_0_1_0 in the cache */

/* search247_2 -> replace80_0 in the cache */
static const nir_search_expression search247 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search160_0_1_0.value, &replace80_0.value },
   NULL,
};

   /* replace247_0 -> replace80_0 in the cache */

/* replace247_1 -> search160_0_1_0 in the cache */
/* replace247 -> replace164 in the cache */

   /* search248_0 -> search2_0 in the cache */

/* search248_1 -> search2_0 in the cache */
static const nir_search_expression search248 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace248 -> search2_0 in the cache */

   /* search249_0 -> search2_0 in the cache */

/* search249_1 -> search2_0 in the cache */
static const nir_search_expression search249 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace249 -> search2_0 in the cache */

   /* search250_0 -> search2_0 in the cache */

/* search250_1 -> search2_0 in the cache */
static const nir_search_expression search250 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imin,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace250 -> search2_0 in the cache */

   /* search251_0 -> search2_0 in the cache */

/* search251_1 -> search2_0 in the cache */
static const nir_search_expression search251 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imax,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace251 -> search2_0 in the cache */

   /* search252_0 -> search2_0 in the cache */

/* search252_1 -> search2_0 in the cache */
static const nir_search_expression search252 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umin,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace252 -> search2_0 in the cache */

   /* search253_0 -> search2_0 in the cache */

/* search253_1 -> search2_0 in the cache */
static const nir_search_expression search253 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umax,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace253 -> search2_0 in the cache */

   /* search254_0_0 -> search14_0 in the cache */

/* search254_0_1 -> replace14_1_0 in the cache */
/* search254_0 -> replace233 in the cache */

/* search254_1 -> replace14_1_0 in the cache */
static const nir_search_expression search254 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &replace233.value, &replace14_1_0.value },
   NULL,
};

   /* replace254_0 -> search14_0 in the cache */

/* replace254_1 -> replace14_1_0 in the cache */
/* replace254 -> replace233 in the cache */

   /* search255_0_0 -> search14_0 in the cache */

/* search255_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search255_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search255_1 -> replace14_1_0 in the cache */
static const nir_search_expression search255 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_umax,
   { &search255_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace255_0 -> search14_0 in the cache */

/* replace255_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace255 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search256_0_0 -> search14_0 in the cache */

/* search256_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search256_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search256_1 -> replace14_1_0 in the cache */
static const nir_search_expression search256 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_imax,
   { &search256_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace256_0 -> search14_0 in the cache */

/* replace256_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace256 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search257_0_0 -> search14_0 in the cache */

/* search257_0_1 -> replace14_1_0 in the cache */
/* search257_0 -> replace234 in the cache */

/* search257_1 -> replace14_1_0 in the cache */
static const nir_search_expression search257 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace234.value, &replace14_1_0.value },
   NULL,
};

   /* replace257_0 -> search14_0 in the cache */

/* replace257_1 -> replace14_1_0 in the cache */
/* replace257 -> replace234 in the cache */

   /* search258_0_0 -> search14_0 in the cache */

/* search258_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search258_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search258_1 -> replace14_1_0 in the cache */
static const nir_search_expression search258 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_umin,
   { &search258_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace258_0 -> search14_0 in the cache */

/* replace258_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace258 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search259_0_0 -> search14_0 in the cache */

/* search259_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search259_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_imin,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search259_1 -> replace14_1_0 in the cache */
static const nir_search_expression search259 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_imin,
   { &search259_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace259_0 -> search14_0 in the cache */

/* replace259_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace259 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search260_0 -> search0_0 in the cache */

/* search260_1_0_0 -> search0_0 in the cache */

/* search260_1_0_1 -> replace106_1_1 in the cache */
static const nir_search_expression search260_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &replace106_1_1.value },
   NULL,
};
static const nir_search_expression search260_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search260_1_0.value },
   NULL,
};
static const nir_search_expression search260 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &search260_1.value },
   NULL,
};

   /* replace260_0 -> search0_0 in the cache */

/* replace260_1 -> search26_1 in the cache */
static const nir_search_expression replace260 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* search261_0 -> search2_0 in the cache */

/* search261_1_0 -> search2_0 in the cache */
/* search261_1 -> search15_0 in the cache */
static const nir_search_expression search261 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search15_0.value },
   NULL,
};

   /* replace261_0_0 -> search2_0 in the cache */
/* replace261_0 -> search17_0 in the cache */
/* replace261 -> search220_0 in the cache */

   /* search262_0 -> search2_0 in the cache */

/* search262_1_0 -> search2_0 in the cache */
/* search262_1 -> search16_0 in the cache */
static const nir_search_expression search262 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search2_0.value, &search16_0.value },
   NULL,
};

   /* replace262_0_0 -> search2_0 in the cache */
/* replace262_0 -> search20_0 in the cache */
static const nir_search_expression replace262 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search20_0.value },
   NULL,
};

   /* search263_0 -> search2_0 in the cache */

/* search263_1_0_0 -> search2_0 in the cache */
/* search263_1_0 -> search17_0 in the cache */
/* search263_1 -> search220_0 in the cache */
static const nir_search_expression search263 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search220_0.value },
   NULL,
};

   /* replace263_0_0 -> search2_0 in the cache */
/* replace263_0 -> search17_0 in the cache */
/* replace263 -> search220_0 in the cache */

   /* search264_0 -> search2_0 in the cache */

/* search264_1_0_0 -> search2_0 in the cache */
/* search264_1_0 -> search20_0 in the cache */
/* search264_1 -> replace262 in the cache */
static const nir_search_expression search264 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search2_0.value, &replace262.value },
   NULL,
};

   /* replace264_0_0 -> search2_0 in the cache */
/* replace264_0 -> search20_0 in the cache */
/* replace264 -> replace262 in the cache */

   /* search265_0 -> search2_0 in the cache */

/* search265_1_0 -> search2_0 in the cache */
/* search265_1 -> search17_0 in the cache */
static const nir_search_expression search265 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search17_0.value },
   NULL,
};

   /* replace265 -> search2_0 in the cache */

   /* search266_0 -> search2_0 in the cache */

/* search266_1_0 -> search2_0 in the cache */
/* search266_1 -> search20_0 in the cache */
static const nir_search_expression search266 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search2_0.value, &search20_0.value },
   NULL,
};

   /* replace266 -> search2_0 in the cache */

   /* search267_0 -> search2_0 in the cache */

/* search267_1_0_0 -> search2_0 in the cache */
/* search267_1_0 -> search17_0 in the cache */
/* search267_1 -> search220_0 in the cache */
static const nir_search_expression search267 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search220_0.value },
   NULL,
};

   /* replace267 -> search2_0 in the cache */

   /* search268_0 -> search2_0 in the cache */

/* search268_1_0_0 -> search2_0 in the cache */
/* search268_1_0 -> search20_0 in the cache */
/* search268_1 -> replace262 in the cache */
static const nir_search_expression search268 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search2_0.value, &replace262.value },
   NULL,
};

   /* replace268 -> search2_0 in the cache */

   /* search269_0 -> search2_0 in the cache */

/* search269_1_0 -> search2_0 in the cache */
/* search269_1 -> search17_0 in the cache */
static const nir_search_expression search269 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search17_0.value },
   NULL,
};

   /* replace269_0 -> search2_0 in the cache */
/* replace269 -> search17_0 in the cache */

   /* search270_0 -> search2_0 in the cache */

/* search270_1_0 -> search2_0 in the cache */
/* search270_1 -> search20_0 in the cache */
static const nir_search_expression search270 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search2_0.value, &search20_0.value },
   NULL,
};

   /* replace270_0 -> search2_0 in the cache */
/* replace270 -> search20_0 in the cache */

   /* search271_0 -> search2_0 in the cache */

/* search271_1_0 -> search2_0 in the cache */
/* search271_1 -> search15_0 in the cache */
static const nir_search_expression search271 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search15_0.value },
   NULL,
};

   /* replace271_0 -> search2_0 in the cache */
/* replace271 -> search17_0 in the cache */

   /* search272_0 -> search2_0 in the cache */

/* search272_1_0 -> search2_0 in the cache */
/* search272_1 -> search16_0 in the cache */
static const nir_search_expression search272 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search2_0.value, &search16_0.value },
   NULL,
};

   /* replace272_0 -> search2_0 in the cache */
/* replace272 -> search20_0 in the cache */

   /* search273_0_0 -> search2_0 in the cache */
/* search273_0 -> search17_0 in the cache */

/* search273_1 -> search24_1 in the cache */
static const nir_search_expression search273 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmax,
   { &search17_0.value, &search24_1.value },
   NULL,
};

   /* replace273_0 -> search2_0 in the cache */
/* replace273 -> search17_0 in the cache */

   /* search274_0_0 -> search2_0 in the cache */

/* search274_0_1 -> search24_1 in the cache */
static const nir_search_expression search274_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search24_1.value },
   NULL,
};

/* search274_1 -> search41_1 in the cache */
static const nir_search_expression search274 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmin,
   { &search274_0.value, &search41_1.value },
   NULL,
};

   /* replace274_0 -> search2_0 in the cache */
/* replace274 -> search36_0 in the cache */

   /* search275_0_0 -> search2_0 in the cache */

/* search275_0_1 -> search41_1 in the cache */
static const nir_search_expression search275_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search41_1.value },
   NULL,
};

/* search275_1 -> search24_1 in the cache */
static const nir_search_expression search275 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmax,
   { &search275_0.value, &search24_1.value },
   NULL,
};

   /* replace275_0 -> search2_0 in the cache */
/* replace275 -> search36_0 in the cache */

   /* search276_0_0 -> search2_0 in the cache */

/* search276_0_1 -> search43_1 in the cache */
static const nir_search_expression search276_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search43_1.value },
   NULL,
};

/* search276_1 -> search24_1 in the cache */
static const nir_search_expression search276 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmin,
   { &search276_0.value, &search24_1.value },
   NULL,
};

   /* replace276_0_0_0 -> search2_0 in the cache */
/* replace276_0_0 -> search15_0 in the cache */
/* replace276_0 -> search36_1 in the cache */
static const nir_search_expression replace276 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search36_1.value },
   NULL,
};

   /* search277_0_0 -> search2_0 in the cache */

/* search277_0_1 -> search24_1 in the cache */
static const nir_search_expression search277_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search24_1.value },
   NULL,
};

/* search277_1 -> search43_1 in the cache */
static const nir_search_expression search277 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmax,
   { &search277_0.value, &search43_1.value },
   NULL,
};

   /* replace277_0_0_0 -> search2_0 in the cache */
/* replace277_0_0 -> search15_0 in the cache */
/* replace277_0 -> search36_1 in the cache */
/* replace277 -> replace276 in the cache */

   /* search278_0_0 -> search2_0 in the cache */
/* search278_0 -> search45_0 in the cache */
static const nir_search_expression search278 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search45_0.value },
   NULL,
};

   /* replace278_0_0 -> search24_1 in the cache */

/* replace278_0_1 -> search2_0 in the cache */
/* replace278_0 -> replace157 in the cache */
static const nir_search_expression replace278 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace157.value },
   NULL,
};

   /* search279_0_0 -> search2_0 in the cache */
static const nir_search_expression search279_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search279 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search279_0.value },
   NULL,
};

   /* replace279_0 -> search2_0 in the cache */
/* replace279 -> search279_0 in the cache */

   /* search280_0 -> search2_0 in the cache */
/* search280 -> search36_0 in the cache */

   /* replace280_0_0 -> search2_0 in the cache */

/* replace280_0_1 -> search24_1 in the cache */
/* replace280_0 -> search274_0 in the cache */

/* replace280_1 -> search41_1 in the cache */
static const nir_search_expression replace280 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search274_0.value, &search41_1.value },
   NULL,
};

   /* search281_0_0 -> search2_0 in the cache */
/* search281_0 -> search36_0 in the cache */
static const nir_search_expression search281 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search36_0.value },
   NULL,
};

   /* replace281_0 -> search2_0 in the cache */
/* replace281 -> search36_0 in the cache */

   /* search282_0_0_0 -> search14_0 in the cache */

/* search282_0_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search282_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search14_0.value, &replace14_1_0.value },
   (is_used_once),
};
static const nir_search_expression search282_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search282_0_0.value },
   (is_used_once),
};
static const nir_search_expression search282 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search282_0.value },
   NULL,
};

   /* replace282_0_0_0 -> search14_0 in the cache */
/* replace282_0_0 -> search34_0 in the cache */

/* replace282_0_1_0 -> replace14_1_0 in the cache */
/* replace282_0_1 -> search138_1 in the cache */
static const nir_search_expression replace282_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search34_0.value, &search138_1.value },
   NULL,
};
static const nir_search_expression replace282 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace282_0.value },
   NULL,
};

   /* search283_0_0_0 -> search14_0 in the cache */

/* search283_0_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search283_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search14_0.value, &replace14_1_0.value },
   (is_used_once),
};
static const nir_search_expression search283_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search283_0_0.value },
   (is_used_once),
};
static const nir_search_expression search283 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search283_0.value },
   NULL,
};

   /* replace283_0_0_0 -> search14_0 in the cache */
/* replace283_0_0 -> search34_0 in the cache */

/* replace283_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace283_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search34_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace283 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace283_0.value },
   NULL,
};

   /* search284_0_0_0 -> search14_0 in the cache */

/* search284_0_0_1 -> replace14_1_0 in the cache */
/* search284_0_0 -> search283_0_0 in the cache */
static const nir_search_expression search284_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search283_0_0.value },
   (is_used_once),
};
static const nir_search_expression search284 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search284_0.value },
   NULL,
};

   /* replace284_0_0_0 -> search14_0 in the cache */
static const nir_search_expression replace284_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search14_0.value },
   NULL,
};

/* replace284_0_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression replace284_0_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace284_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace284_0_0.value, &replace284_0_1.value },
   NULL,
};
static const nir_search_expression replace284 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace284_0.value },
   NULL,
};

   /* search285_0_0_0_0 -> search28_0_0 in the cache */

/* search285_0_0_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search285_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* search285_0_0_1 -> search28_1_1 in the cache */
static const nir_search_expression search285_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search285_0_0_0.value, &search28_1_1.value },
   NULL,
};

/* search285_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search285_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search285_0_0.value, &search28_0_1.value },
   NULL,
};

/* search285_1 -> search28_1_1 in the cache */
static const nir_search_expression search285 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search285_0.value, &search28_1_1.value },
   NULL,
};

   /* replace285_0_0 -> search28_0_0 in the cache */

/* replace285_0_1 -> search28_0_1 in the cache */
/* replace285_0 -> search285_0_0_0 in the cache */

/* replace285_1 -> search28_1_1 in the cache */
/* replace285 -> search285_0_0 in the cache */

   /* search286_0_0_0_0 -> search28_0_0 in the cache */

/* search286_0_0_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search286_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_imax,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* search286_0_0_1 -> search28_1_1 in the cache */
static const nir_search_expression search286_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 2,
   nir_op_imin,
   { &search286_0_0_0.value, &search28_1_1.value },
   NULL,
};

/* search286_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search286_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 3,
   nir_op_imax,
   { &search286_0_0.value, &search28_0_1.value },
   NULL,
};

/* search286_1 -> search28_1_1 in the cache */
static const nir_search_expression search286 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 4,
   nir_op_imin,
   { &search286_0.value, &search28_1_1.value },
   NULL,
};

   /* replace286_0_0 -> search28_0_0 in the cache */

/* replace286_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace286_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace286_1 -> search28_1_1 in the cache */
static const nir_search_expression replace286 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imin,
   { &replace286_0.value, &search28_1_1.value },
   NULL,
};

   /* search287_0_0_0_0 -> search28_0_0 in the cache */

/* search287_0_0_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search287_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_umax,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* search287_0_0_1 -> search28_1_1 in the cache */
static const nir_search_expression search287_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 2,
   nir_op_umin,
   { &search287_0_0_0.value, &search28_1_1.value },
   NULL,
};

/* search287_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search287_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 3,
   nir_op_umax,
   { &search287_0_0.value, &search28_0_1.value },
   NULL,
};

/* search287_1 -> search28_1_1 in the cache */
static const nir_search_expression search287 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 4,
   nir_op_umin,
   { &search287_0.value, &search28_1_1.value },
   NULL,
};

   /* replace287_0_0 -> search28_0_0 in the cache */

/* replace287_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace287_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace287_1 -> search28_1_1 in the cache */
static const nir_search_expression replace287 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_umin,
   { &replace287_0.value, &search28_1_1.value },
   NULL,
};

   /* search288_0_0 -> search0_0 in the cache */
static const nir_search_expression search288_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search0_0.value },
   NULL,
};

static const nir_search_variable search288_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_zero_to_one),
   {0, 1, 2, 3},
};
static const nir_search_expression search288 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search288_0.value, &search288_1.value },
   NULL,
};

   /* replace288_0_0 -> search0_0 in the cache */

/* replace288_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace288_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace288 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &replace288_0.value },
   NULL,
};

   /* search289_0_0 -> search0_0 in the cache */
/* search289_0 -> search288_0 in the cache */

/* search289_1 -> search288_1 in the cache */
static const nir_search_expression search289 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search288_0.value, &search288_1.value },
   NULL,
};

   /* replace289_0_0 -> search0_0 in the cache */

/* replace289_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace289_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace289 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &replace289_0.value },
   NULL,
};

   /* search290_0_0_0 -> search2_0 in the cache */

/* search290_0_0_1 -> replace9 in the cache */
static const nir_search_expression search290_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search2_0.value, &replace9.value },
   NULL,
};

static const nir_search_constant search290_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0xff /* 255 */ },
};
static const nir_search_expression search290_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_imin,
   { &search290_0_0.value, &search290_0_1.value },
   NULL,
};

/* search290_1 -> replace9 in the cache */
static const nir_search_expression search290 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_extract_u8,
   { &search290_0.value, &replace9.value },
   NULL,
};

   /* replace290_0_0 -> search2_0 in the cache */

/* replace290_0_1 -> replace9 in the cache */
/* replace290_0 -> search290_0_0 in the cache */

/* replace290_1 -> search290_0_1 in the cache */
/* replace290 -> search290_0 in the cache */

   /* search291_0_0 -> search28_0_0 in the cache */

/* search291_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search291_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search291_1_0 -> search28_0_0 in the cache */

/* search291_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search291_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search291 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search291_0.value, &search291_1.value },
   NULL,
};

   /* replace291_0 -> search28_0_0 in the cache */

/* replace291_1_0 -> search28_0_1 in the cache */

/* replace291_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace291_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace291 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &replace291_1.value },
   NULL,
};

   /* search292_0_0 -> search14_0 in the cache */

/* search292_0_1 -> search64_2 in the cache */
static const nir_search_expression search292_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

static const nir_search_variable search292_1_0 = {
   { nir_search_value_variable, -2 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search292_1_1 -> search64_2 in the cache */
static const nir_search_expression search292_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search292_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search292 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search292_0.value, &search292_1.value },
   NULL,
};

   /* replace292_0_0 -> search14_0 in the cache */

/* replace292_0_1 -> search292_1_0 in the cache */
static const nir_search_expression replace292_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search14_0.value, &search292_1_0.value },
   NULL,
};

/* replace292_1 -> search64_2 in the cache */
static const nir_search_expression replace292 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace292_0.value, &search64_2.value },
   NULL,
};

   /* search293_0_0 -> search28_0_0 in the cache */

/* search293_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search293_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search293_1_0 -> search28_0_0 in the cache */

/* search293_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search293_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search293 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search293_0.value, &search293_1.value },
   NULL,
};

   /* replace293_0 -> search28_0_0 in the cache */

/* replace293_1_0 -> search28_0_1 in the cache */

/* replace293_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace293_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace293 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &replace293_1.value },
   NULL,
};

   /* search294_0_0 -> search14_0 in the cache */

/* search294_0_1 -> search64_2 in the cache */
static const nir_search_expression search294_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

/* search294_1_0 -> search292_1_0 in the cache */

/* search294_1_1 -> search64_2 in the cache */
static const nir_search_expression search294_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search292_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search294 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search294_0.value, &search294_1.value },
   NULL,
};

   /* replace294_0_0 -> search14_0 in the cache */

/* replace294_0_1 -> search292_1_0 in the cache */
static const nir_search_expression replace294_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search14_0.value, &search292_1_0.value },
   NULL,
};

/* replace294_1 -> search64_2 in the cache */
static const nir_search_expression replace294 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace294_0.value, &search64_2.value },
   NULL,
};

   /* search295_0_0 -> search28_0_0 in the cache */

/* search295_0_1 -> search96_0_0_1 in the cache */
static const nir_search_expression search295_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &search96_0_0_1.value },
   NULL,
};

/* search295_1_0 -> search28_0_0 in the cache */

/* search295_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search295_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search295 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search295_0.value, &search295_1.value },
   NULL,
};

   /* replace295_0 -> search28_0_0 in the cache */

/* replace295_1_0 -> search28_0_1 in the cache */

/* replace295_1_1 -> search28_1_1 in the cache */
/* replace295_1 -> replace291_1 in the cache */
/* replace295 -> replace291 in the cache */

   static const nir_search_variable search296_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search296_0_1 -> search64_2 in the cache */
static const nir_search_expression search296_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search296_0_0.value, &search64_2.value },
   NULL,
};

static const nir_search_variable search296_1_0 = {
   { nir_search_value_variable, -2 },
   2, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search296_1_1 -> search64_2 in the cache */
static const nir_search_expression search296_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search296_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search296 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search296_0.value, &search296_1.value },
   NULL,
};

   /* replace296_0_0 -> search14_0 in the cache */

/* replace296_0_1 -> search292_1_0 in the cache */
/* replace296_0 -> replace292_0 in the cache */

/* replace296_1 -> search64_2 in the cache */
/* replace296 -> replace292 in the cache */

   /* search297_0_0 -> search28_0_0 in the cache */

/* search297_0_1 -> search96_0_0_1 in the cache */
static const nir_search_expression search297_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &search96_0_0_1.value },
   NULL,
};

/* search297_1_0 -> search28_0_0 in the cache */

/* search297_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search297_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search297 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search297_0.value, &search297_1.value },
   NULL,
};

   /* replace297_0 -> search28_0_0 in the cache */

/* replace297_1_0 -> search28_0_1 in the cache */

/* replace297_1_1 -> search28_1_1 in the cache */
/* replace297_1 -> replace293_1 in the cache */
/* replace297 -> replace293 in the cache */

   /* search298_0_0 -> search296_0_0 in the cache */

/* search298_0_1 -> search64_2 in the cache */
static const nir_search_expression search298_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search296_0_0.value, &search64_2.value },
   NULL,
};

/* search298_1_0 -> search296_1_0 in the cache */

/* search298_1_1 -> search64_2 in the cache */
static const nir_search_expression search298_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search296_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search298 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search298_0.value, &search298_1.value },
   NULL,
};

   /* replace298_0_0 -> search14_0 in the cache */

/* replace298_0_1 -> search292_1_0 in the cache */
/* replace298_0 -> replace294_0 in the cache */

/* replace298_1 -> search64_2 in the cache */
/* replace298 -> replace294 in the cache */

   /* search299_0_0 -> search28_0_0 in the cache */

/* search299_0_1 -> search28_0_1 in the cache */
/* search299_0 -> search291_0 in the cache */

/* search299_1_0 -> search28_0_0 in the cache */

/* search299_1_1 -> search28_1_1 in the cache */
/* search299_1 -> search291_1 in the cache */
static const nir_search_expression search299 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search291_0.value, &search291_1.value },
   NULL,
};

   /* replace299_0 -> search28_0_0 in the cache */

/* replace299_1_0 -> search28_0_1 in the cache */

/* replace299_1_1 -> search28_1_1 in the cache */
/* replace299_1 -> replace293_1 in the cache */
static const nir_search_expression replace299 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &replace293_1.value },
   NULL,
};

   /* search300_0_0 -> search14_0 in the cache */

/* search300_0_1 -> search64_2 in the cache */
/* search300_0 -> search292_0 in the cache */

/* search300_1_0 -> search292_1_0 in the cache */

/* search300_1_1 -> search64_2 in the cache */
/* search300_1 -> search292_1 in the cache */
static const nir_search_expression search300 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search292_0.value, &search292_1.value },
   NULL,
};

   /* replace300_0_0 -> search14_0 in the cache */

/* replace300_0_1 -> search292_1_0 in the cache */
/* replace300_0 -> replace294_0 in the cache */

/* replace300_1 -> search64_2 in the cache */
static const nir_search_expression replace300 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace294_0.value, &search64_2.value },
   NULL,
};

   /* search301_0_0 -> search28_0_0 in the cache */

/* search301_0_1 -> search28_0_1 in the cache */
/* search301_0 -> search293_0 in the cache */

/* search301_1_0 -> search28_0_0 in the cache */

/* search301_1_1 -> search28_1_1 in the cache */
/* search301_1 -> search293_1 in the cache */
static const nir_search_expression search301 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search293_0.value, &search293_1.value },
   NULL,
};

   /* replace301_0 -> search28_0_0 in the cache */

/* replace301_1_0 -> search28_0_1 in the cache */

/* replace301_1_1 -> search28_1_1 in the cache */
/* replace301_1 -> replace291_1 in the cache */
static const nir_search_expression replace301 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &replace291_1.value },
   NULL,
};

   /* search302_0_0 -> search14_0 in the cache */

/* search302_0_1 -> search64_2 in the cache */
/* search302_0 -> search294_0 in the cache */

/* search302_1_0 -> search292_1_0 in the cache */

/* search302_1_1 -> search64_2 in the cache */
/* search302_1 -> search294_1 in the cache */
static const nir_search_expression search302 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search294_0.value, &search294_1.value },
   NULL,
};

   /* replace302_0_0 -> search14_0 in the cache */

/* replace302_0_1 -> search292_1_0 in the cache */
/* replace302_0 -> replace292_0 in the cache */

/* replace302_1 -> search64_2 in the cache */
static const nir_search_expression replace302 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace292_0.value, &search64_2.value },
   NULL,
};

   /* search303_0_0 -> search28_0_0 in the cache */

/* search303_0_1 -> search96_0_0_1 in the cache */
/* search303_0 -> search295_0 in the cache */

/* search303_1_0 -> search28_0_0 in the cache */

/* search303_1_1 -> search96_0_1 in the cache */
/* search303_1 -> search295_1 in the cache */
static const nir_search_expression search303 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search295_0.value, &search295_1.value },
   NULL,
};

   /* replace303_0 -> search28_0_0 in the cache */

/* replace303_1_0 -> search28_0_1 in the cache */

/* replace303_1_1 -> search28_1_1 in the cache */
/* replace303_1 -> replace293_1 in the cache */
/* replace303 -> replace299 in the cache */

   /* search304_0_0 -> search296_0_0 in the cache */

/* search304_0_1 -> search64_2 in the cache */
/* search304_0 -> search296_0 in the cache */

/* search304_1_0 -> search296_1_0 in the cache */

/* search304_1_1 -> search64_2 in the cache */
/* search304_1 -> search296_1 in the cache */
static const nir_search_expression search304 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search296_0.value, &search296_1.value },
   NULL,
};

   /* replace304_0_0 -> search14_0 in the cache */

/* replace304_0_1 -> search292_1_0 in the cache */
/* replace304_0 -> replace294_0 in the cache */

/* replace304_1 -> search64_2 in the cache */
/* replace304 -> replace300 in the cache */

   /* search305_0_0 -> search28_0_0 in the cache */

/* search305_0_1 -> search96_0_0_1 in the cache */
/* search305_0 -> search297_0 in the cache */

/* search305_1_0 -> search28_0_0 in the cache */

/* search305_1_1 -> search96_0_1 in the cache */
/* search305_1 -> search297_1 in the cache */
static const nir_search_expression search305 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search297_0.value, &search297_1.value },
   NULL,
};

   /* replace305_0 -> search28_0_0 in the cache */

/* replace305_1_0 -> search28_0_1 in the cache */

/* replace305_1_1 -> search28_1_1 in the cache */
/* replace305_1 -> replace291_1 in the cache */
/* replace305 -> replace301 in the cache */

   /* search306_0_0 -> search296_0_0 in the cache */

/* search306_0_1 -> search64_2 in the cache */
/* search306_0 -> search298_0 in the cache */

/* search306_1_0 -> search296_1_0 in the cache */

/* search306_1_1 -> search64_2 in the cache */
/* search306_1 -> search298_1 in the cache */
static const nir_search_expression search306 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search298_0.value, &search298_1.value },
   NULL,
};

   /* replace306_0_0 -> search14_0 in the cache */

/* replace306_0_1 -> search292_1_0 in the cache */
/* replace306_0 -> replace292_0 in the cache */

/* replace306_1 -> search64_2 in the cache */
/* replace306 -> replace302 in the cache */

   /* search307_0_0 -> search28_0_0 in the cache */

/* search307_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search307_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search307_1_0 -> search28_0_0 in the cache */

/* search307_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search307_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search307 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search307_0.value, &search307_1.value },
   NULL,
};

   /* replace307_0 -> search28_0_0 in the cache */

/* replace307_1_0 -> search28_0_1 in the cache */

/* replace307_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace307_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace307 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search28_0_0.value, &replace307_1.value },
   NULL,
};

   /* search308_0_0 -> search14_0 in the cache */

/* search308_0_1 -> search64_2 in the cache */
static const nir_search_expression search308_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

/* search308_1_0 -> search292_1_0 in the cache */

/* search308_1_1 -> search64_2 in the cache */
static const nir_search_expression search308_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search292_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search308 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search308_0.value, &search308_1.value },
   NULL,
};

   /* replace308_0_0 -> search14_0 in the cache */

/* replace308_0_1 -> search292_1_0 in the cache */
static const nir_search_expression replace308_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search14_0.value, &search292_1_0.value },
   NULL,
};

/* replace308_1 -> search64_2 in the cache */
static const nir_search_expression replace308 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace308_0.value, &search64_2.value },
   NULL,
};

   /* search309_0_0 -> search28_0_0 in the cache */

/* search309_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search309_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search309_1_0 -> search28_0_0 in the cache */

/* search309_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search309_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search309 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search309_0.value, &search309_1.value },
   NULL,
};

   /* replace309_0 -> search28_0_0 in the cache */

/* replace309_1_0 -> search28_0_1 in the cache */

/* replace309_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace309_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace309 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search28_0_0.value, &replace309_1.value },
   NULL,
};

   /* search310_0_0 -> search14_0 in the cache */

/* search310_0_1 -> search64_2 in the cache */
static const nir_search_expression search310_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

/* search310_1_0 -> search292_1_0 in the cache */

/* search310_1_1 -> search64_2 in the cache */
static const nir_search_expression search310_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search292_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search310 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search310_0.value, &search310_1.value },
   NULL,
};

   /* replace310_0_0 -> search14_0 in the cache */

/* replace310_0_1 -> search292_1_0 in the cache */
static const nir_search_expression replace310_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search14_0.value, &search292_1_0.value },
   NULL,
};

/* replace310_1 -> search64_2 in the cache */
static const nir_search_expression replace310 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace310_0.value, &search64_2.value },
   NULL,
};

   /* search311_0_0 -> search28_0_0 in the cache */

/* search311_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search311_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search311_1_0 -> search28_0_0 in the cache */

/* search311_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search311_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search311 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search311_0.value, &search311_1.value },
   NULL,
};

   /* replace311_0 -> search28_0_0 in the cache */

/* replace311_1_0 -> search28_0_1 in the cache */

/* replace311_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace311_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace311 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search28_0_0.value, &replace311_1.value },
   NULL,
};

   /* search312_0_0 -> search14_0 in the cache */

/* search312_0_1 -> search64_2 in the cache */
static const nir_search_expression search312_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

/* search312_1_0 -> search292_1_0 in the cache */

/* search312_1_1 -> search64_2 in the cache */
static const nir_search_expression search312_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search292_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search312 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search312_0.value, &search312_1.value },
   NULL,
};

   /* replace312_0_0 -> search14_0 in the cache */

/* replace312_0_1 -> search292_1_0 in the cache */
static const nir_search_expression replace312_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search14_0.value, &search292_1_0.value },
   NULL,
};

/* replace312_1 -> search64_2 in the cache */
static const nir_search_expression replace312 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace312_0.value, &search64_2.value },
   NULL,
};

   /* search313_0_0 -> search28_0_0 in the cache */

/* search313_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search313_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search313_1_0 -> search28_0_0 in the cache */

/* search313_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search313_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search313 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search313_0.value, &search313_1.value },
   NULL,
};

   /* replace313_0 -> search28_0_0 in the cache */

/* replace313_1_0 -> search28_0_1 in the cache */

/* replace313_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace313_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace313 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search28_0_0.value, &replace313_1.value },
   NULL,
};

   /* search314_0_0 -> search14_0 in the cache */

/* search314_0_1 -> search64_2 in the cache */
static const nir_search_expression search314_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

/* search314_1_0 -> search292_1_0 in the cache */

/* search314_1_1 -> search64_2 in the cache */
static const nir_search_expression search314_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search292_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search314 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search314_0.value, &search314_1.value },
   NULL,
};

   /* replace314_0_0 -> search14_0 in the cache */

/* replace314_0_1 -> search292_1_0 in the cache */
static const nir_search_expression replace314_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search14_0.value, &search292_1_0.value },
   NULL,
};

/* replace314_1 -> search64_2 in the cache */
static const nir_search_expression replace314 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace314_0.value, &search64_2.value },
   NULL,
};

   /* search315_0_0 -> search28_0_0 in the cache */

/* search315_0_1 -> search28_0_1 in the cache */
/* search315_0 -> search307_0 in the cache */

/* search315_1_0 -> search28_0_0 in the cache */

/* search315_1_1 -> search28_1_1 in the cache */
/* search315_1 -> search307_1 in the cache */
static const nir_search_expression search315 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search307_0.value, &search307_1.value },
   NULL,
};

   /* replace315_0 -> search28_0_0 in the cache */

/* replace315_1_0 -> search28_0_1 in the cache */

/* replace315_1_1 -> search28_1_1 in the cache */
/* replace315_1 -> replace309_1 in the cache */
static const nir_search_expression replace315 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search28_0_0.value, &replace309_1.value },
   NULL,
};

   /* search316_0_0 -> search14_0 in the cache */

/* search316_0_1 -> search64_2 in the cache */
/* search316_0 -> search308_0 in the cache */

/* search316_1_0 -> search292_1_0 in the cache */

/* search316_1_1 -> search64_2 in the cache */
/* search316_1 -> search308_1 in the cache */
static const nir_search_expression search316 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search308_0.value, &search308_1.value },
   NULL,
};

   /* replace316_0_0 -> search14_0 in the cache */

/* replace316_0_1 -> search292_1_0 in the cache */
/* replace316_0 -> replace310_0 in the cache */

/* replace316_1 -> search64_2 in the cache */
static const nir_search_expression replace316 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace310_0.value, &search64_2.value },
   NULL,
};

   /* search317_0_0 -> search28_0_0 in the cache */

/* search317_0_1 -> search28_0_1 in the cache */
/* search317_0 -> search309_0 in the cache */

/* search317_1_0 -> search28_0_0 in the cache */

/* search317_1_1 -> search28_1_1 in the cache */
/* search317_1 -> search309_1 in the cache */
static const nir_search_expression search317 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search309_0.value, &search309_1.value },
   NULL,
};

   /* replace317_0 -> search28_0_0 in the cache */

/* replace317_1_0 -> search28_0_1 in the cache */

/* replace317_1_1 -> search28_1_1 in the cache */
/* replace317_1 -> replace307_1 in the cache */
static const nir_search_expression replace317 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search28_0_0.value, &replace307_1.value },
   NULL,
};

   /* search318_0_0 -> search14_0 in the cache */

/* search318_0_1 -> search64_2 in the cache */
/* search318_0 -> search310_0 in the cache */

/* search318_1_0 -> search292_1_0 in the cache */

/* search318_1_1 -> search64_2 in the cache */
/* search318_1 -> search310_1 in the cache */
static const nir_search_expression search318 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search310_0.value, &search310_1.value },
   NULL,
};

   /* replace318_0_0 -> search14_0 in the cache */

/* replace318_0_1 -> search292_1_0 in the cache */
/* replace318_0 -> replace308_0 in the cache */

/* replace318_1 -> search64_2 in the cache */
static const nir_search_expression replace318 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace308_0.value, &search64_2.value },
   NULL,
};

   /* search319_0_0 -> search28_0_0 in the cache */

/* search319_0_1 -> search28_0_1 in the cache */
/* search319_0 -> search311_0 in the cache */

/* search319_1_0 -> search28_0_0 in the cache */

/* search319_1_1 -> search28_1_1 in the cache */
/* search319_1 -> search311_1 in the cache */
static const nir_search_expression search319 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search311_0.value, &search311_1.value },
   NULL,
};

   /* replace319_0 -> search28_0_0 in the cache */

/* replace319_1_0 -> search28_0_1 in the cache */

/* replace319_1_1 -> search28_1_1 in the cache */
/* replace319_1 -> replace313_1 in the cache */
static const nir_search_expression replace319 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search28_0_0.value, &replace313_1.value },
   NULL,
};

   /* search320_0_0 -> search14_0 in the cache */

/* search320_0_1 -> search64_2 in the cache */
/* search320_0 -> search312_0 in the cache */

/* search320_1_0 -> search292_1_0 in the cache */

/* search320_1_1 -> search64_2 in the cache */
/* search320_1 -> search312_1 in the cache */
static const nir_search_expression search320 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search312_0.value, &search312_1.value },
   NULL,
};

   /* replace320_0_0 -> search14_0 in the cache */

/* replace320_0_1 -> search292_1_0 in the cache */
/* replace320_0 -> replace314_0 in the cache */

/* replace320_1 -> search64_2 in the cache */
static const nir_search_expression replace320 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace314_0.value, &search64_2.value },
   NULL,
};

   /* search321_0_0 -> search28_0_0 in the cache */

/* search321_0_1 -> search28_0_1 in the cache */
/* search321_0 -> search313_0 in the cache */

/* search321_1_0 -> search28_0_0 in the cache */

/* search321_1_1 -> search28_1_1 in the cache */
/* search321_1 -> search313_1 in the cache */
static const nir_search_expression search321 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search313_0.value, &search313_1.value },
   NULL,
};

   /* replace321_0 -> search28_0_0 in the cache */

/* replace321_1_0 -> search28_0_1 in the cache */

/* replace321_1_1 -> search28_1_1 in the cache */
/* replace321_1 -> replace311_1 in the cache */
static const nir_search_expression replace321 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search28_0_0.value, &replace311_1.value },
   NULL,
};

   /* search322_0_0 -> search14_0 in the cache */

/* search322_0_1 -> search64_2 in the cache */
/* search322_0 -> search314_0 in the cache */

/* search322_1_0 -> search292_1_0 in the cache */

/* search322_1_1 -> search64_2 in the cache */
/* search322_1 -> search314_1 in the cache */
static const nir_search_expression search322 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search314_0.value, &search314_1.value },
   NULL,
};

   /* replace322_0_0 -> search14_0 in the cache */

/* replace322_0_1 -> search292_1_0 in the cache */
/* replace322_0 -> replace312_0 in the cache */

/* replace322_1 -> search64_2 in the cache */
static const nir_search_expression replace322 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace312_0.value, &search64_2.value },
   NULL,
};

   static const nir_search_constant search323_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search323_0_1 -> search0_0 in the cache */
static const nir_search_expression search323_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search323_0_0.value, &search0_0.value },
   (is_used_once),
};

/* search323_1_0 -> replace0_1_0 in the cache */

/* search323_1_1 -> search323_0_0 in the cache */
static const nir_search_expression search323_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace0_1_0.value, &search323_0_0.value },
   NULL,
};
static const nir_search_expression search323 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search323_0.value, &search323_1.value },
   NULL,
};

   /* replace323_0 -> search323_0_0 in the cache */

/* replace323_1_0 -> search0_0 in the cache */

/* replace323_1_1_0 -> replace0_1_0 in the cache */
/* replace323_1_1 -> search95_1_0_1_1 in the cache */
static const nir_search_expression replace323_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search0_0.value, &search95_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace323 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search323_0_0.value, &replace323_1.value },
   NULL,
};

   /* search324_0_0 -> search323_0_0 in the cache */

/* search324_0_1 -> search0_0 in the cache */
static const nir_search_expression search324_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search323_0_0.value, &search0_0.value },
   NULL,
};

/* search324_1_0 -> replace0_1_0 in the cache */

/* search324_1_1 -> search323_0_0 in the cache */
static const nir_search_expression search324_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace0_1_0.value, &search323_0_0.value },
   (is_used_once),
};
static const nir_search_expression search324 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search324_0.value, &search324_1.value },
   NULL,
};

   /* replace324_0 -> search323_0_0 in the cache */

/* replace324_1_0 -> search0_0 in the cache */

/* replace324_1_1_0 -> replace0_1_0 in the cache */
/* replace324_1_1 -> search95_1_0_1_1 in the cache */
/* replace324_1 -> replace323_1 in the cache */
/* replace324 -> replace323 in the cache */

   /* search325_0_0 -> search323_0_0 in the cache */

/* search325_0_1 -> search0_0 in the cache */
static const nir_search_expression search325_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search323_0_0.value, &search0_0.value },
   (is_used_once),
};

/* search325_1_0 -> replace0_1_0 in the cache */

/* search325_1_1 -> search323_0_0 in the cache */
static const nir_search_expression search325_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace0_1_0.value, &search323_0_0.value },
   NULL,
};
static const nir_search_expression search325 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search325_0.value, &search325_1.value },
   NULL,
};

   /* replace325_0 -> search323_0_0 in the cache */

/* replace325_1_0 -> search0_0 in the cache */

/* replace325_1_1_0 -> replace0_1_0 in the cache */
/* replace325_1_1 -> search95_1_0_1_1 in the cache */
static const nir_search_expression replace325_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search0_0.value, &search95_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace325 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search323_0_0.value, &replace325_1.value },
   NULL,
};

   /* search326_0_0 -> search323_0_0 in the cache */

/* search326_0_1 -> search0_0 in the cache */
static const nir_search_expression search326_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search323_0_0.value, &search0_0.value },
   NULL,
};

/* search326_1_0 -> replace0_1_0 in the cache */

/* search326_1_1 -> search323_0_0 in the cache */
static const nir_search_expression search326_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace0_1_0.value, &search323_0_0.value },
   (is_used_once),
};
static const nir_search_expression search326 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search326_0.value, &search326_1.value },
   NULL,
};

   /* replace326_0 -> search323_0_0 in the cache */

/* replace326_1_0 -> search0_0 in the cache */

/* replace326_1_1_0 -> replace0_1_0 in the cache */
/* replace326_1_1 -> search95_1_0_1_1 in the cache */
/* replace326_1 -> replace325_1 in the cache */
/* replace326 -> replace325 in the cache */

   /* search327_0_0 -> search323_0_0 in the cache */

/* search327_0_1 -> search0_0 in the cache */
/* search327_0 -> search323_0 in the cache */

/* search327_1_0 -> replace0_1_0 in the cache */

/* search327_1_1 -> search323_0_0 in the cache */
/* search327_1 -> search323_1 in the cache */
static const nir_search_expression search327 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search323_0.value, &search323_1.value },
   NULL,
};

   /* replace327_0 -> search323_0_0 in the cache */

/* replace327_1_0 -> search0_0 in the cache */

/* replace327_1_1_0 -> replace0_1_0 in the cache */
/* replace327_1_1 -> search95_1_0_1_1 in the cache */
/* replace327_1 -> replace325_1 in the cache */
static const nir_search_expression replace327 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search323_0_0.value, &replace325_1.value },
   NULL,
};

   /* search328_0_0 -> search323_0_0 in the cache */

/* search328_0_1 -> search0_0 in the cache */
/* search328_0 -> search324_0 in the cache */

/* search328_1_0 -> replace0_1_0 in the cache */

/* search328_1_1 -> search323_0_0 in the cache */
/* search328_1 -> search324_1 in the cache */
static const nir_search_expression search328 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search324_0.value, &search324_1.value },
   NULL,
};

   /* replace328_0 -> search323_0_0 in the cache */

/* replace328_1_0 -> search0_0 in the cache */

/* replace328_1_1_0 -> replace0_1_0 in the cache */
/* replace328_1_1 -> search95_1_0_1_1 in the cache */
/* replace328_1 -> replace325_1 in the cache */
/* replace328 -> replace327 in the cache */

   /* search329_0_0 -> search323_0_0 in the cache */

/* search329_0_1 -> search0_0 in the cache */
/* search329_0 -> search325_0 in the cache */

/* search329_1_0 -> replace0_1_0 in the cache */

/* search329_1_1 -> search323_0_0 in the cache */
/* search329_1 -> search325_1 in the cache */
static const nir_search_expression search329 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search325_0.value, &search325_1.value },
   NULL,
};

   /* replace329_0 -> search323_0_0 in the cache */

/* replace329_1_0 -> search0_0 in the cache */

/* replace329_1_1_0 -> replace0_1_0 in the cache */
/* replace329_1_1 -> search95_1_0_1_1 in the cache */
/* replace329_1 -> replace323_1 in the cache */
static const nir_search_expression replace329 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search323_0_0.value, &replace323_1.value },
   NULL,
};

   /* search330_0_0 -> search323_0_0 in the cache */

/* search330_0_1 -> search0_0 in the cache */
/* search330_0 -> search326_0 in the cache */

/* search330_1_0 -> replace0_1_0 in the cache */

/* search330_1_1 -> search323_0_0 in the cache */
/* search330_1 -> search326_1 in the cache */
static const nir_search_expression search330 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search326_0.value, &search326_1.value },
   NULL,
};

   /* replace330_0 -> search323_0_0 in the cache */

/* replace330_1_0 -> search0_0 in the cache */

/* replace330_1_1_0 -> replace0_1_0 in the cache */
/* replace330_1_1 -> search95_1_0_1_1 in the cache */
/* replace330_1 -> replace323_1 in the cache */
/* replace330 -> replace329 in the cache */

   /* search331_0_0 -> search2_0 in the cache */

/* search331_0_1 -> replace9 in the cache */
static const nir_search_expression search331_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search2_0.value, &replace9.value },
   NULL,
};

/* search331_1_0 -> search2_0 in the cache */

/* search331_1_1 -> replace2_1_0 in the cache */
static const nir_search_expression search331_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};
static const nir_search_expression search331 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search331_0.value, &search331_1.value },
   NULL,
};

   /* replace331_0 -> replace2_1_0 in the cache */

/* replace331_1 -> search2_0 in the cache */
static const nir_search_expression replace331 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace2_1_0.value, &search2_0.value },
   NULL,
};

   /* search332_0_0 -> replace2_1_0 in the cache */

/* search332_0_1 -> search2_0 in the cache */
/* search332_0 -> replace331 in the cache */

/* search332_1_0 -> search2_0 in the cache */

static const nir_search_constant search332_1_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression search332_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search2_0.value, &search332_1_1.value },
   NULL,
};
static const nir_search_expression search332 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace331.value, &search332_1.value },
   NULL,
};

   /* replace332_0 -> search332_1_1 in the cache */

/* replace332_1 -> search2_0 in the cache */
static const nir_search_expression replace332 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search332_1_1.value, &search2_0.value },
   NULL,
};

   /* search333_0_0 -> search332_1_1 in the cache */

/* search333_0_1 -> search2_0 in the cache */
/* search333_0 -> replace332 in the cache */

/* search333_1_0 -> search2_0 in the cache */

static const nir_search_constant search333_1_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression search333_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search2_0.value, &search333_1_1.value },
   NULL,
};
static const nir_search_expression search333 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace332.value, &search333_1.value },
   NULL,
};

   /* replace333_0 -> search333_1_1 in the cache */

/* replace333_1 -> search2_0 in the cache */
static const nir_search_expression replace333 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search333_1_1.value, &search2_0.value },
   NULL,
};

   /* search334_0_0 -> search0_0 in the cache */

/* search334_0_1 -> search323_0_0 in the cache */
static const nir_search_expression search334_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search0_0.value, &search323_0_0.value },
   NULL,
};

/* search334_1 -> replace60_0_0 in the cache */

/* search334_2_0_0_0_0 -> search323_0_0 in the cache */

/* search334_2_0_0_0_1 -> search0_0 in the cache */
/* search334_2_0_0_0 -> search324_0 in the cache */
static const nir_search_expression search334_2_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search324_0.value },
   NULL,
};

/* search334_2_0_1_0_0_0 -> search0_0 in the cache */

/* search334_2_0_1_0_0_1 -> search323_0_0 in the cache */
static const nir_search_expression search334_2_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &search323_0_0.value },
   NULL,
};
static const nir_search_expression search334_2_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search334_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search334_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search334_2_0_1_0.value },
   NULL,
};
static const nir_search_expression search334_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search334_2_0_0.value, &search334_2_0_1.value },
   NULL,
};
static const nir_search_expression search334_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_i2f32,
   { &search334_2_0.value },
   NULL,
};
static const nir_search_expression search334 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &search334_0.value, &replace60_0_0.value, &search334_2.value },
   NULL,
};

   static const nir_search_constant replace334_0 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3f800000 /* 1065353216 */ },
};

/* replace334_1_0 -> search0_0 in the cache */

static const nir_search_constant replace334_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x80000000 /* 2147483648 */ },
};
static const nir_search_expression replace334_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search0_0.value, &replace334_1_1.value },
   NULL,
};
static const nir_search_expression replace334 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace334_0.value, &replace334_1.value },
   NULL,
};

   /* search335_0 -> replace80_0 in the cache */

/* search335_1_0 -> replace80_0 in the cache */

/* search335_1_1 -> replace133 in the cache */
static const nir_search_expression search335_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &replace80_0.value, &replace133.value },
   NULL,
};
static const nir_search_expression search335 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace80_0.value, &search335_1.value },
   NULL,
};

   /* replace335 -> replace209 in the cache */

   /* search336_0 -> search2_0 in the cache */

/* search336_1_0 -> search2_0 in the cache */
static const nir_search_expression search336_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search336 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search2_0.value, &search336_1.value },
   NULL,
};

   /* replace336 -> search44_1 in the cache */

   /* search337_0_0_0 -> replace80_0 in the cache */
static const nir_search_expression search337_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace80_0.value },
   NULL,
};
static const nir_search_expression search337_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search337_0_0.value },
   NULL,
};

/* search337_1_0_0 -> search160_0_1_0 in the cache */
static const nir_search_expression search337_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search160_0_1_0.value },
   NULL,
};
static const nir_search_expression search337_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search337_1_0.value },
   NULL,
};
static const nir_search_expression search337 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search337_0.value, &search337_1.value },
   NULL,
};

   /* replace337_0 -> replace80_0 in the cache */

/* replace337_1 -> search160_0_1_0 in the cache */
static const nir_search_expression replace337 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace80_0.value, &search160_0_1_0.value },
   NULL,
};

   /* search338_0_0 -> replace80_0 in the cache */

/* search338_0_1 -> search160_0_1_0 in the cache */
/* search338_0 -> replace337 in the cache */
static const nir_search_expression search338 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_b2i32,
   { &replace337.value },
   NULL,
};

   /* replace338_0_0 -> replace80_0 in the cache */

/* replace338_0_1 -> search160_0_1_0 in the cache */
/* replace338_0 -> replace167 in the cache */
static const nir_search_expression replace338 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_b2i32,
   { &replace167.value },
   NULL,
};

   /* search339_0_0 -> search0_0 in the cache */

/* search339_0_1 -> search26_1 in the cache */
static const nir_search_expression search339_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search0_0.value, &search26_1.value },
   NULL,
};

/* search339_1_0 -> replace0_1_0 in the cache */

/* search339_1_1 -> search26_1 in the cache */
static const nir_search_expression search339_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace0_1_0.value, &search26_1.value },
   NULL,
};
static const nir_search_expression search339 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search339_0.value, &search339_1.value },
   NULL,
};

   /* replace339_0_0 -> search0_0 in the cache */

/* replace339_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace339_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace339_1 -> search26_1 in the cache */
static const nir_search_expression replace339 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace339_0.value, &search26_1.value },
   NULL,
};

   /* search340_0 -> search2_0 in the cache */

static const nir_search_variable search340_1_0 = {
   { nir_search_value_variable, -1 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search340_1_1 -> search2_0 in the cache */
static const nir_search_expression search340_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search340_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search340 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search340_1.value },
   NULL,
};

   /* replace340_0 -> search2_0 in the cache */

/* replace340_1 -> search340_1_0 in the cache */
static const nir_search_expression replace340 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search340_1_0.value },
   NULL,
};

   /* search341_0_0 -> search14_0 in the cache */

/* search341_0_1 -> replace14_1_0 in the cache */
/* search341_0 -> replace234 in the cache */

/* search341_1 -> search14_0 in the cache */
static const nir_search_expression search341 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &replace234.value, &search14_0.value },
   NULL,
};

   /* replace341_0 -> replace14_1_0 in the cache */

/* replace341_1 -> search14_0 in the cache */
/* replace341 -> search134_1 in the cache */

   /* search342_0 -> search2_0 in the cache */

/* search342_1_0 -> search340_1_0 in the cache */

/* search342_1_1 -> search2_0 in the cache */
static const nir_search_expression search342_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search340_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search342 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search342_1.value },
   NULL,
};

   /* replace342 -> replace209 in the cache */

   /* search343_0_0 -> search14_0 in the cache */

/* search343_0_1 -> replace14_1_0 in the cache */
/* search343_0 -> replace233 in the cache */

/* search343_1 -> search14_0 in the cache */
static const nir_search_expression search343 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &replace233.value, &search14_0.value },
   NULL,
};

   /* replace343 -> replace209 in the cache */

   /* search344_0 -> search2_0 in the cache */

/* search344_1_0 -> search340_1_0 in the cache */

/* search344_1_1 -> search2_0 in the cache */
/* search344_1 -> search342_1 in the cache */
static const nir_search_expression search344 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search342_1.value },
   NULL,
};

   /* replace344 -> replace133 in the cache */

   /* search345_0_0 -> search14_0 in the cache */

/* search345_0_1 -> replace14_1_0 in the cache */
/* search345_0 -> replace233 in the cache */

/* search345_1 -> search14_0 in the cache */
static const nir_search_expression search345 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &replace233.value, &search14_0.value },
   NULL,
};

   /* replace345 -> replace133 in the cache */

   /* search346_0 -> search2_0 in the cache */

/* search346_1_0 -> search340_1_0 in the cache */

/* search346_1_1 -> search2_0 in the cache */
/* search346_1 -> search340_1 in the cache */
static const nir_search_expression search346 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search340_1.value },
   NULL,
};

   /* replace346_0 -> search2_0 in the cache */

/* replace346_1 -> search340_1_0 in the cache */
static const nir_search_expression replace346 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search340_1_0.value },
   NULL,
};

   /* search347_0_0 -> search14_0 in the cache */

/* search347_0_1 -> replace14_1_0 in the cache */
/* search347_0 -> replace234 in the cache */

/* search347_1 -> search14_0 in the cache */
static const nir_search_expression search347 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &replace234.value, &search14_0.value },
   NULL,
};

   /* replace347_0 -> replace14_1_0 in the cache */

/* replace347_1 -> search14_0 in the cache */
/* replace347 -> replace139 in the cache */

   /* search348_0 -> search2_0 in the cache */

/* search348_1_0 -> search340_1_0 in the cache */

/* search348_1_1 -> search2_0 in the cache */
static const nir_search_expression search348_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search340_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search348 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search2_0.value, &search348_1.value },
   NULL,
};

   /* replace348_0 -> search2_0 in the cache */

/* replace348_1 -> search340_1_0 in the cache */
static const nir_search_expression replace348 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search2_0.value, &search340_1_0.value },
   NULL,
};

   /* search349_0_0 -> search14_0 in the cache */

/* search349_0_1 -> replace14_1_0 in the cache */
/* search349_0 -> replace259 in the cache */

/* search349_1 -> search14_0 in the cache */
static const nir_search_expression search349 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace259.value, &search14_0.value },
   NULL,
};

   /* replace349_0 -> replace14_1_0 in the cache */

/* replace349_1 -> search14_0 in the cache */
/* replace349 -> search136_1 in the cache */

   /* search350_0 -> search2_0 in the cache */

/* search350_1_0 -> search340_1_0 in the cache */

/* search350_1_1 -> search2_0 in the cache */
static const nir_search_expression search350_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search340_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search350 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search2_0.value, &search350_1.value },
   NULL,
};

   /* replace350 -> replace209 in the cache */

   /* search351_0_0 -> search14_0 in the cache */

/* search351_0_1 -> replace14_1_0 in the cache */
/* search351_0 -> replace256 in the cache */

/* search351_1 -> search14_0 in the cache */
static const nir_search_expression search351 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace256.value, &search14_0.value },
   NULL,
};

   /* replace351 -> replace209 in the cache */

   /* search352_0 -> search2_0 in the cache */

/* search352_1_0 -> search340_1_0 in the cache */

/* search352_1_1 -> search2_0 in the cache */
static const nir_search_expression search352_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search340_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search352 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search2_0.value, &search352_1.value },
   NULL,
};

   /* replace352_0 -> search2_0 in the cache */

/* replace352_1 -> search340_1_0 in the cache */
static const nir_search_expression replace352 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search2_0.value, &search340_1_0.value },
   NULL,
};

   /* search353_0_0 -> search14_0 in the cache */

/* search353_0_1 -> replace14_1_0 in the cache */
/* search353_0 -> replace258 in the cache */

/* search353_1 -> search14_0 in the cache */
static const nir_search_expression search353 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace258.value, &search14_0.value },
   NULL,
};

   /* replace353_0 -> replace14_1_0 in the cache */

/* replace353_1 -> search14_0 in the cache */
/* replace353 -> search137_1 in the cache */

   /* search354_0 -> search2_0 in the cache */

/* search354_1_0 -> search340_1_0 in the cache */

/* search354_1_1 -> search2_0 in the cache */
static const nir_search_expression search354_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search340_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search354 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search2_0.value, &search354_1.value },
   NULL,
};

   /* replace354 -> replace209 in the cache */

   /* search355_0_0 -> search14_0 in the cache */

/* search355_0_1 -> replace14_1_0 in the cache */
/* search355_0 -> replace255 in the cache */

/* search355_1 -> search14_0 in the cache */
static const nir_search_expression search355 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace255.value, &search14_0.value },
   NULL,
};

   /* replace355 -> replace209 in the cache */

   /* search356_0 -> search2_0 in the cache */

/* search356_1_0 -> search340_1_0 in the cache */

/* search356_1_1 -> search2_0 in the cache */
/* search356_1 -> search350_1 in the cache */
static const nir_search_expression search356 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search2_0.value, &search350_1.value },
   NULL,
};

   /* replace356 -> replace133 in the cache */

   /* search357_0_0 -> search14_0 in the cache */

/* search357_0_1 -> replace14_1_0 in the cache */
/* search357_0 -> replace256 in the cache */

/* search357_1 -> search14_0 in the cache */
static const nir_search_expression search357 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace256.value, &search14_0.value },
   NULL,
};

   /* replace357 -> replace133 in the cache */

   /* search358_0 -> search2_0 in the cache */

/* search358_1_0 -> search340_1_0 in the cache */

/* search358_1_1 -> search2_0 in the cache */
/* search358_1 -> search348_1 in the cache */
static const nir_search_expression search358 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search2_0.value, &search348_1.value },
   NULL,
};

   /* replace358_0 -> search2_0 in the cache */

/* replace358_1 -> search340_1_0 in the cache */
static const nir_search_expression replace358 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search2_0.value, &search340_1_0.value },
   NULL,
};

   /* search359_0_0 -> search14_0 in the cache */

/* search359_0_1 -> replace14_1_0 in the cache */
/* search359_0 -> replace259 in the cache */

/* search359_1 -> search14_0 in the cache */
static const nir_search_expression search359 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace259.value, &search14_0.value },
   NULL,
};

   /* replace359_0 -> replace14_1_0 in the cache */

/* replace359_1 -> search14_0 in the cache */
static const nir_search_expression replace359 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search360_0 -> search2_0 in the cache */

/* search360_1_0 -> search340_1_0 in the cache */

/* search360_1_1 -> search2_0 in the cache */
/* search360_1 -> search354_1 in the cache */
static const nir_search_expression search360 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search2_0.value, &search354_1.value },
   NULL,
};

   /* replace360 -> replace133 in the cache */

   /* search361_0_0 -> search14_0 in the cache */

/* search361_0_1 -> replace14_1_0 in the cache */
/* search361_0 -> replace255 in the cache */

/* search361_1 -> search14_0 in the cache */
static const nir_search_expression search361 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace255.value, &search14_0.value },
   NULL,
};

   /* replace361 -> replace133 in the cache */

   /* search362_0 -> search2_0 in the cache */

/* search362_1_0 -> search340_1_0 in the cache */

/* search362_1_1 -> search2_0 in the cache */
/* search362_1 -> search352_1 in the cache */
static const nir_search_expression search362 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search2_0.value, &search352_1.value },
   NULL,
};

   /* replace362_0 -> search2_0 in the cache */

/* replace362_1 -> search340_1_0 in the cache */
static const nir_search_expression replace362 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search2_0.value, &search340_1_0.value },
   NULL,
};

   /* search363_0_0 -> search14_0 in the cache */

/* search363_0_1 -> replace14_1_0 in the cache */
/* search363_0 -> replace258 in the cache */

/* search363_1 -> search14_0 in the cache */
static const nir_search_expression search363 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace258.value, &search14_0.value },
   NULL,
};

   /* replace363_0 -> replace14_1_0 in the cache */

/* replace363_1 -> search14_0 in the cache */
static const nir_search_expression replace363 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search364_0 -> search2_0 in the cache */

/* search364_1_0 -> search340_1_0 in the cache */

/* search364_1_1 -> search2_0 in the cache */
static const nir_search_expression search364_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search340_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search364 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search2_0.value, &search364_1.value },
   NULL,
};

   /* replace364 -> replace133 in the cache */

   /* search365_0_0 -> search14_0 in the cache */

/* search365_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search365_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search365_1 -> search14_0 in the cache */
static const nir_search_expression search365 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search365_0.value, &search14_0.value },
   NULL,
};

   /* replace365 -> replace133 in the cache */

   /* search366_0 -> search2_0 in the cache */

/* search366_1_0 -> search340_1_0 in the cache */

/* search366_1_1 -> search2_0 in the cache */
/* search366_1 -> search364_1 in the cache */
static const nir_search_expression search366 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search2_0.value, &search364_1.value },
   NULL,
};

   /* replace366 -> replace209 in the cache */

   /* search367_0_0 -> search14_0 in the cache */

/* search367_0_1 -> replace14_1_0 in the cache */
/* search367_0 -> search365_0 in the cache */

/* search367_1 -> search14_0 in the cache */
static const nir_search_expression search367 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search365_0.value, &search14_0.value },
   NULL,
};

   /* replace367 -> replace209 in the cache */

   static const nir_search_variable search368_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search368_1_0 -> search96_0_0_1 in the cache */

/* search368_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search368_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search96_0_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search368 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search368_0.value, &search368_1.value },
   NULL,
};

   /* replace368_0_0 -> search28_0_0 in the cache */

/* replace368_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace368_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace368_1_0 -> search28_0_0 in the cache */

/* replace368_1_1 -> search28_1_1 in the cache */
/* replace368_1 -> search307_1 in the cache */
static const nir_search_expression replace368 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace368_0.value, &search307_1.value },
   NULL,
};

   /* search369_0_0 -> search368_0 in the cache */

/* search369_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search369_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search368_0.value, &search28_0_1.value },
   NULL,
};

/* search369_1 -> search96_0_1 in the cache */
static const nir_search_expression search369 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search369_0.value, &search96_0_1.value },
   NULL,
};

   /* replace369_0_0 -> search28_0_0 in the cache */

/* replace369_0_1 -> search28_1_1 in the cache */
/* replace369_0 -> search307_1 in the cache */

/* replace369_1_0 -> search28_0_1 in the cache */

/* replace369_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace369_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace369 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search307_1.value, &replace369_1.value },
   NULL,
};

   /* search370_0 -> search368_0 in the cache */

/* search370_1_0 -> search96_0_0_1 in the cache */

/* search370_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search370_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search96_0_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search370 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search368_0.value, &search370_1.value },
   NULL,
};

   /* replace370_0_0 -> search28_0_0 in the cache */

/* replace370_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace370_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace370_1_0 -> search28_0_0 in the cache */

/* replace370_1_1 -> search28_1_1 in the cache */
/* replace370_1 -> search309_1 in the cache */
static const nir_search_expression replace370 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace370_0.value, &search309_1.value },
   NULL,
};

   /* search371_0_0 -> search368_0 in the cache */

/* search371_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search371_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search368_0.value, &search28_0_1.value },
   NULL,
};

/* search371_1 -> search96_0_1 in the cache */
static const nir_search_expression search371 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search371_0.value, &search96_0_1.value },
   NULL,
};

   /* replace371_0_0 -> search28_0_0 in the cache */

/* replace371_0_1 -> search28_1_1 in the cache */
/* replace371_0 -> search309_1 in the cache */

/* replace371_1_0 -> search28_0_1 in the cache */

/* replace371_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace371_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace371 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search309_1.value, &replace371_1.value },
   NULL,
};

   /* search372_0 -> search368_0 in the cache */

/* search372_1_0 -> search96_0_0_1 in the cache */

/* search372_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search372_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search96_0_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search372 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search368_0.value, &search372_1.value },
   NULL,
};

   /* replace372_0_0 -> search28_0_0 in the cache */

/* replace372_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace372_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace372_1_0 -> search28_0_0 in the cache */

/* replace372_1_1 -> search28_1_1 in the cache */
/* replace372_1 -> search311_1 in the cache */
static const nir_search_expression replace372 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace372_0.value, &search311_1.value },
   NULL,
};

   /* search373_0_0 -> search368_0 in the cache */

/* search373_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search373_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search368_0.value, &search28_0_1.value },
   NULL,
};

/* search373_1 -> search96_0_1 in the cache */
static const nir_search_expression search373 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search373_0.value, &search96_0_1.value },
   NULL,
};

   /* replace373_0_0 -> search28_0_0 in the cache */

/* replace373_0_1 -> search28_1_1 in the cache */
/* replace373_0 -> search311_1 in the cache */

/* replace373_1_0 -> search28_0_1 in the cache */

/* replace373_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace373_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace373 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search311_1.value, &replace373_1.value },
   NULL,
};

   /* search374_0 -> search368_0 in the cache */

/* search374_1_0 -> search96_0_0_1 in the cache */

/* search374_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search374_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search96_0_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search374 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search368_0.value, &search374_1.value },
   NULL,
};

   /* replace374_0_0 -> search28_0_0 in the cache */

/* replace374_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace374_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace374_1_0 -> search28_0_0 in the cache */

/* replace374_1_1 -> search28_1_1 in the cache */
/* replace374_1 -> search313_1 in the cache */
static const nir_search_expression replace374 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace374_0.value, &search313_1.value },
   NULL,
};

   /* search375_0_0 -> search368_0 in the cache */

/* search375_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search375_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search368_0.value, &search28_0_1.value },
   NULL,
};

/* search375_1 -> search96_0_1 in the cache */
static const nir_search_expression search375 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search375_0.value, &search96_0_1.value },
   NULL,
};

   /* replace375_0_0 -> search28_0_0 in the cache */

/* replace375_0_1 -> search28_1_1 in the cache */
/* replace375_0 -> search313_1 in the cache */

/* replace375_1_0 -> search28_0_1 in the cache */

/* replace375_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace375_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace375 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search313_1.value, &replace375_1.value },
   NULL,
};

   /* search376_0 -> search368_0 in the cache */

/* search376_1_0 -> search96_0_0_1 in the cache */

/* search376_1_1 -> search28_1_1 in the cache */
/* search376_1 -> search370_1 in the cache */
static const nir_search_expression search376 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search368_0.value, &search370_1.value },
   NULL,
};

   /* replace376_0_0 -> search28_0_0 in the cache */

/* replace376_0_1 -> search28_0_1 in the cache */
/* replace376_0 -> replace368_0 in the cache */

/* replace376_1_0 -> search28_0_0 in the cache */

/* replace376_1_1 -> search28_1_1 in the cache */
/* replace376_1 -> search307_1 in the cache */
static const nir_search_expression replace376 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace368_0.value, &search307_1.value },
   NULL,
};

   /* search377_0_0 -> search368_0 in the cache */

/* search377_0_1 -> search28_0_1 in the cache */
/* search377_0 -> search371_0 in the cache */

/* search377_1 -> search96_0_1 in the cache */
static const nir_search_expression search377 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search371_0.value, &search96_0_1.value },
   NULL,
};

   /* replace377_0_0 -> search28_0_0 in the cache */

/* replace377_0_1 -> search28_1_1 in the cache */
/* replace377_0 -> search307_1 in the cache */

/* replace377_1_0 -> search28_0_1 in the cache */

/* replace377_1_1 -> search28_1_1 in the cache */
/* replace377_1 -> replace369_1 in the cache */
static const nir_search_expression replace377 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search307_1.value, &replace369_1.value },
   NULL,
};

   /* search378_0 -> search368_0 in the cache */

/* search378_1_0 -> search96_0_0_1 in the cache */

/* search378_1_1 -> search28_1_1 in the cache */
/* search378_1 -> search368_1 in the cache */
static const nir_search_expression search378 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search368_0.value, &search368_1.value },
   NULL,
};

   /* replace378_0_0 -> search28_0_0 in the cache */

/* replace378_0_1 -> search28_0_1 in the cache */
/* replace378_0 -> replace370_0 in the cache */

/* replace378_1_0 -> search28_0_0 in the cache */

/* replace378_1_1 -> search28_1_1 in the cache */
/* replace378_1 -> search309_1 in the cache */
static const nir_search_expression replace378 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace370_0.value, &search309_1.value },
   NULL,
};

   /* search379_0_0 -> search368_0 in the cache */

/* search379_0_1 -> search28_0_1 in the cache */
/* search379_0 -> search369_0 in the cache */

/* search379_1 -> search96_0_1 in the cache */
static const nir_search_expression search379 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search369_0.value, &search96_0_1.value },
   NULL,
};

   /* replace379_0_0 -> search28_0_0 in the cache */

/* replace379_0_1 -> search28_1_1 in the cache */
/* replace379_0 -> search309_1 in the cache */

/* replace379_1_0 -> search28_0_1 in the cache */

/* replace379_1_1 -> search28_1_1 in the cache */
/* replace379_1 -> replace371_1 in the cache */
static const nir_search_expression replace379 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search309_1.value, &replace371_1.value },
   NULL,
};

   /* search380_0 -> search368_0 in the cache */

/* search380_1_0 -> search96_0_0_1 in the cache */

/* search380_1_1 -> search28_1_1 in the cache */
/* search380_1 -> search374_1 in the cache */
static const nir_search_expression search380 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search368_0.value, &search374_1.value },
   NULL,
};

   /* replace380_0_0 -> search28_0_0 in the cache */

/* replace380_0_1 -> search28_0_1 in the cache */
/* replace380_0 -> replace372_0 in the cache */

/* replace380_1_0 -> search28_0_0 in the cache */

/* replace380_1_1 -> search28_1_1 in the cache */
/* replace380_1 -> search311_1 in the cache */
static const nir_search_expression replace380 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace372_0.value, &search311_1.value },
   NULL,
};

   /* search381_0_0 -> search368_0 in the cache */

/* search381_0_1 -> search28_0_1 in the cache */
/* search381_0 -> search375_0 in the cache */

/* search381_1 -> search96_0_1 in the cache */
static const nir_search_expression search381 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search375_0.value, &search96_0_1.value },
   NULL,
};

   /* replace381_0_0 -> search28_0_0 in the cache */

/* replace381_0_1 -> search28_1_1 in the cache */
/* replace381_0 -> search311_1 in the cache */

/* replace381_1_0 -> search28_0_1 in the cache */

/* replace381_1_1 -> search28_1_1 in the cache */
/* replace381_1 -> replace373_1 in the cache */
static const nir_search_expression replace381 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search311_1.value, &replace373_1.value },
   NULL,
};

   /* search382_0 -> search368_0 in the cache */

/* search382_1_0 -> search96_0_0_1 in the cache */

/* search382_1_1 -> search28_1_1 in the cache */
/* search382_1 -> search372_1 in the cache */
static const nir_search_expression search382 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search368_0.value, &search372_1.value },
   NULL,
};

   /* replace382_0_0 -> search28_0_0 in the cache */

/* replace382_0_1 -> search28_0_1 in the cache */
/* replace382_0 -> replace374_0 in the cache */

/* replace382_1_0 -> search28_0_0 in the cache */

/* replace382_1_1 -> search28_1_1 in the cache */
/* replace382_1 -> search313_1 in the cache */
static const nir_search_expression replace382 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace374_0.value, &search313_1.value },
   NULL,
};

   /* search383_0_0 -> search368_0 in the cache */

/* search383_0_1 -> search28_0_1 in the cache */
/* search383_0 -> search373_0 in the cache */

/* search383_1 -> search96_0_1 in the cache */
static const nir_search_expression search383 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search373_0.value, &search96_0_1.value },
   NULL,
};

   /* replace383_0_0 -> search28_0_0 in the cache */

/* replace383_0_1 -> search28_1_1 in the cache */
/* replace383_0 -> search313_1 in the cache */

/* replace383_1_0 -> search28_0_1 in the cache */

/* replace383_1_1 -> search28_1_1 in the cache */
/* replace383_1 -> replace375_1 in the cache */
static const nir_search_expression replace383 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search313_1.value, &replace375_1.value },
   NULL,
};

   /* search384_0_0 -> search2_0 in the cache */

/* search384_0_1 -> replace9 in the cache */
/* search384_0 -> replace217 in the cache */

/* search384_1_0_0 -> search2_0 in the cache */

/* search384_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search384_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search2_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search384_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search384_1_0.value },
   NULL,
};

/* search384_2_0 -> search2_0 in the cache */

/* search384_2_1 -> replace0_1_0 in the cache */
/* search384_2 -> search384_1_0 in the cache */
static const nir_search_expression search384 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace217.value, &search384_1.value, &search384_1_0.value },
   NULL,
};

   /* replace384_0_0 -> search2_0 in the cache */

/* replace384_0_1 -> replace0_1_0 in the cache */
/* replace384_0 -> search384_1_0 in the cache */
static const nir_search_expression replace384 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search384_1_0.value },
   NULL,
};

   /* search385_0_0_0 -> search2_0 in the cache */
/* search385_0_0 -> search20_0 in the cache */

/* search385_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search385_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search20_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search385 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search385_0.value },
   NULL,
};

   /* replace385_0_0 -> search2_0 in the cache */
/* replace385_0 -> search20_0 in the cache */

/* replace385_1 -> replace0_1_0 in the cache */
/* replace385 -> search385_0 in the cache */

   /* search386_0_0 -> search0_0 in the cache */

/* search386_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search386_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_slt,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search386 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search386_0.value },
   NULL,
};

   /* replace386_0 -> search0_0 in the cache */

/* replace386_1 -> replace0_1_0 in the cache */
/* replace386 -> search386_0 in the cache */

   /* search387_0_0 -> search14_0 in the cache */

/* search387_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search387_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_sge,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search387 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search387_0.value },
   NULL,
};

   /* replace387_0 -> search14_0 in the cache */

/* replace387_1 -> replace14_1_0 in the cache */
/* replace387 -> search387_0 in the cache */

   /* search388_0_0 -> search0_0 in the cache */

/* search388_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search388_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search388 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search388_0.value },
   NULL,
};

   /* replace388_0 -> search0_0 in the cache */

/* replace388_1 -> replace0_1_0 in the cache */
/* replace388 -> search388_0 in the cache */

   /* search389_0_0 -> search0_0 in the cache */

/* search389_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search389_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search389 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search389_0.value },
   NULL,
};

   /* replace389_0 -> search0_0 in the cache */

/* replace389_1 -> replace0_1_0 in the cache */
/* replace389 -> search389_0 in the cache */

   /* search390_0 -> search0_0 in the cache */

/* search390_1 -> replace0_1_0 in the cache */
/* search390 -> search386_0 in the cache */

   /* replace390_0_0 -> search0_0 in the cache */

/* replace390_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace390_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace390 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace390_0.value },
   NULL,
};

   /* search391_0 -> search14_0 in the cache */

/* search391_1 -> replace14_1_0 in the cache */
/* search391 -> search387_0 in the cache */

   /* replace391_0_0 -> search14_0 in the cache */

/* replace391_0_1 -> replace14_1_0 in the cache */
/* replace391_0 -> replace123 in the cache */
static const nir_search_expression replace391 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace123.value },
   NULL,
};

   /* search392_0 -> search0_0 in the cache */

/* search392_1 -> replace0_1_0 in the cache */
/* search392 -> search388_0 in the cache */

   /* replace392_0_0 -> search0_0 in the cache */

/* replace392_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace392_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace392 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace392_0.value },
   NULL,
};

   /* search393_0 -> search0_0 in the cache */

/* search393_1 -> replace0_1_0 in the cache */
/* search393 -> search389_0 in the cache */

   /* replace393_0_0 -> search0_0 in the cache */

/* replace393_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace393_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace393 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace393_0.value },
   NULL,
};

   /* search394_0_0 -> search0_0 in the cache */

/* search394_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search394_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_seq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search394_1 -> replace60_0_0 in the cache */
static const nir_search_expression search394 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search394_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace394_0 -> search0_0 in the cache */

/* replace394_1 -> replace0_1_0 in the cache */
/* replace394 -> search388_0 in the cache */

   /* search395_0_0 -> search0_0 in the cache */

/* search395_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search395_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sne,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search395_1 -> replace60_0_0 in the cache */
static const nir_search_expression search395 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search395_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace395_0 -> search0_0 in the cache */

/* replace395_1 -> replace0_1_0 in the cache */
/* replace395 -> search389_0 in the cache */

   /* search396_0_0 -> search0_0 in the cache */

/* search396_0_1 -> replace0_1_0 in the cache */
/* search396_0 -> search386_0 in the cache */

/* search396_1 -> replace60_0_0 in the cache */
static const nir_search_expression search396 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search386_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace396_0 -> search0_0 in the cache */

/* replace396_1 -> replace0_1_0 in the cache */
/* replace396 -> search386_0 in the cache */

   /* search397_0_0 -> search0_0 in the cache */

/* search397_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search397_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sge,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search397_1 -> replace60_0_0 in the cache */
static const nir_search_expression search397 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search397_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace397_0 -> search0_0 in the cache */

/* replace397_1 -> replace0_1_0 in the cache */
/* replace397 -> search397_0 in the cache */

   /* search398_0_0 -> search0_0 in the cache */

/* search398_0_1 -> replace0_1_0 in the cache */
/* search398_0 -> search394_0 in the cache */

/* search398_1 -> search323_0_0 in the cache */
static const nir_search_expression search398 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search394_0.value, &search323_0_0.value },
   NULL,
};

   /* replace398_0 -> search0_0 in the cache */

/* replace398_1 -> replace0_1_0 in the cache */
/* replace398 -> search388_0 in the cache */

   /* search399_0_0 -> search0_0 in the cache */

/* search399_0_1 -> replace0_1_0 in the cache */
/* search399_0 -> search395_0 in the cache */

/* search399_1 -> search323_0_0 in the cache */
static const nir_search_expression search399 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search395_0.value, &search323_0_0.value },
   NULL,
};

   /* replace399_0 -> search0_0 in the cache */

/* replace399_1 -> replace0_1_0 in the cache */
/* replace399 -> search389_0 in the cache */

   /* search400_0_0 -> search0_0 in the cache */

/* search400_0_1 -> replace0_1_0 in the cache */
/* search400_0 -> search386_0 in the cache */

/* search400_1 -> search323_0_0 in the cache */
static const nir_search_expression search400 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search386_0.value, &search323_0_0.value },
   NULL,
};

   /* replace400_0 -> search0_0 in the cache */

/* replace400_1 -> replace0_1_0 in the cache */
/* replace400 -> search386_0 in the cache */

   /* search401_0_0 -> search0_0 in the cache */

/* search401_0_1 -> replace0_1_0 in the cache */
/* search401_0 -> search397_0 in the cache */

/* search401_1 -> search323_0_0 in the cache */
static const nir_search_expression search401 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search397_0.value, &search323_0_0.value },
   NULL,
};

   /* replace401_0 -> search0_0 in the cache */

/* replace401_1 -> replace0_1_0 in the cache */
/* replace401 -> search397_0 in the cache */

   /* search402_0_0 -> search0_0 in the cache */

/* search402_0_1 -> replace0_1_0 in the cache */
/* search402_0 -> search394_0 in the cache */

/* search402_1 -> search323_0_0 in the cache */
static const nir_search_expression search402 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search394_0.value, &search323_0_0.value },
   NULL,
};

   /* replace402_0 -> search0_0 in the cache */

/* replace402_1 -> replace0_1_0 in the cache */
/* replace402 -> search389_0 in the cache */

   /* search403_0_0 -> search0_0 in the cache */

/* search403_0_1 -> replace0_1_0 in the cache */
/* search403_0 -> search395_0 in the cache */

/* search403_1 -> search323_0_0 in the cache */
static const nir_search_expression search403 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search395_0.value, &search323_0_0.value },
   NULL,
};

   /* replace403_0 -> search0_0 in the cache */

/* replace403_1 -> replace0_1_0 in the cache */
/* replace403 -> search388_0 in the cache */

   /* search404_0_0 -> search0_0 in the cache */

/* search404_0_1 -> replace0_1_0 in the cache */
/* search404_0 -> search386_0 in the cache */

/* search404_1 -> search323_0_0 in the cache */
static const nir_search_expression search404 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search386_0.value, &search323_0_0.value },
   NULL,
};

   /* replace404_0 -> search0_0 in the cache */

/* replace404_1 -> replace0_1_0 in the cache */
/* replace404 -> search397_0 in the cache */

   /* search405_0_0 -> search0_0 in the cache */

/* search405_0_1 -> replace0_1_0 in the cache */
/* search405_0 -> search397_0 in the cache */

/* search405_1 -> search323_0_0 in the cache */
static const nir_search_expression search405 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search397_0.value, &search323_0_0.value },
   NULL,
};

   /* replace405_0 -> search0_0 in the cache */

/* replace405_1 -> replace0_1_0 in the cache */
/* replace405 -> search386_0 in the cache */

   /* search406_0_0 -> search0_0 in the cache */

/* search406_0_1 -> replace0_1_0 in the cache */
/* search406_0 -> search394_0 in the cache */

/* search406_1 -> replace60_0_0 in the cache */
static const nir_search_expression search406 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search394_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace406_0 -> search0_0 in the cache */

/* replace406_1 -> replace0_1_0 in the cache */
/* replace406 -> search389_0 in the cache */

   /* search407_0_0 -> search0_0 in the cache */

/* search407_0_1 -> replace0_1_0 in the cache */
/* search407_0 -> search395_0 in the cache */

/* search407_1 -> replace60_0_0 in the cache */
static const nir_search_expression search407 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search395_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace407_0 -> search0_0 in the cache */

/* replace407_1 -> replace0_1_0 in the cache */
/* replace407 -> search388_0 in the cache */

   /* search408_0_0 -> search0_0 in the cache */

/* search408_0_1 -> replace0_1_0 in the cache */
/* search408_0 -> search386_0 in the cache */

/* search408_1 -> replace60_0_0 in the cache */
static const nir_search_expression search408 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search386_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace408_0 -> search0_0 in the cache */

/* replace408_1 -> replace0_1_0 in the cache */
/* replace408 -> search397_0 in the cache */

   /* search409_0_0 -> search0_0 in the cache */

/* search409_0_1 -> replace0_1_0 in the cache */
/* search409_0 -> search397_0 in the cache */

/* search409_1 -> replace60_0_0 in the cache */
static const nir_search_expression search409 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search397_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace409_0 -> search0_0 in the cache */

/* replace409_1 -> replace0_1_0 in the cache */
/* replace409 -> search386_0 in the cache */

   /* search410_0 -> search0_0 in the cache */

/* search410_1 -> replace0_1_0 in the cache */
static const nir_search_expression search410 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   static const nir_search_variable replace410_0_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace410_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0},
};
static const nir_search_expression replace410_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &replace410_0_0.value, &replace410_0_1.value },
   NULL,
};

static const nir_search_variable replace410_1_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};

static const nir_search_variable replace410_1_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {1},
};
static const nir_search_expression replace410_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_seq,
   { &replace410_1_0.value, &replace410_1_1.value },
   NULL,
};
static const nir_search_expression replace410 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fmin,
   { &replace410_0.value, &replace410_1.value },
   NULL,
};

   /* search411_0 -> search0_0 in the cache */

/* search411_1 -> replace0_1_0 in the cache */
static const nir_search_expression search411 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace411_0_0 -> search0_0 in the cache */

/* replace411_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace411_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fany_nequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace411_1 -> search323_0_0 in the cache */
static const nir_search_expression replace411 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &replace411_0.value, &search323_0_0.value },
   NULL,
};

   /* search412_0 -> search0_0 in the cache */

/* search412_1 -> replace0_1_0 in the cache */
static const nir_search_expression search412 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace412_0_0 -> search0_0 in the cache */

/* replace412_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace412_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fany_nequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace412_1 -> search323_0_0 in the cache */
static const nir_search_expression replace412 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &replace412_0.value, &search323_0_0.value },
   NULL,
};

   /* search413_0 -> search0_0 in the cache */

/* search413_1 -> replace0_1_0 in the cache */
static const nir_search_expression search413 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace413_0_0 -> replace410_0_0 in the cache */

/* replace413_0_1 -> replace410_0_1 in the cache */
static const nir_search_expression replace413_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &replace410_0_0.value, &replace410_0_1.value },
   NULL,
};

/* replace413_1_0 -> replace410_1_0 in the cache */

/* replace413_1_1 -> replace410_1_1 in the cache */
static const nir_search_expression replace413_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sne,
   { &replace410_1_0.value, &replace410_1_1.value },
   NULL,
};
static const nir_search_expression replace413 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fmax,
   { &replace413_0.value, &replace413_1.value },
   NULL,
};

   /* search414_0 -> search0_0 in the cache */

/* search414_1 -> replace0_1_0 in the cache */
static const nir_search_expression search414 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace414_0_0_0 -> search0_0 in the cache */

/* replace414_0_0_1 -> replace0_1_0 in the cache */
/* replace414_0_0 -> search389_0 in the cache */

/* replace414_0_1_0 -> search0_0 in the cache */

/* replace414_0_1_1 -> replace0_1_0 in the cache */
/* replace414_0_1 -> search395_0 in the cache */
static const nir_search_expression replace414_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fdot3,
   { &search389_0.value, &search395_0.value },
   NULL,
};
static const nir_search_expression replace414 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fsat,
   { &replace414_0.value },
   NULL,
};

   /* search415_0 -> search0_0 in the cache */

/* search415_1 -> replace0_1_0 in the cache */
static const nir_search_expression search415 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace415_0_0_0 -> search0_0 in the cache */

/* replace415_0_0_1 -> replace0_1_0 in the cache */
/* replace415_0_0 -> search389_0 in the cache */

/* replace415_0_1_0 -> search0_0 in the cache */

/* replace415_0_1_1 -> replace0_1_0 in the cache */
/* replace415_0_1 -> search395_0 in the cache */
static const nir_search_expression replace415_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fdot4,
   { &search389_0.value, &search395_0.value },
   NULL,
};
static const nir_search_expression replace415 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fsat,
   { &replace415_0.value },
   NULL,
};

   /* search416_0_0 -> search2_0 in the cache */
/* search416_0 -> search15_0 in the cache */

/* search416_1 -> search2_0 in the cache */
static const nir_search_expression search416 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search15_0.value, &search2_0.value },
   NULL,
};

   /* replace416_0 -> search2_0 in the cache */

/* replace416_1 -> search24_1 in the cache */
/* replace416 -> replace219 in the cache */

   /* search417_0_0 -> search2_0 in the cache */
/* search417_0 -> search15_0 in the cache */

/* search417_1 -> search2_0 in the cache */
static const nir_search_expression search417 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search15_0.value, &search2_0.value },
   NULL,
};

   /* replace417_0 -> search2_0 in the cache */

/* replace417_1 -> search24_1 in the cache */
/* replace417 -> replace221 in the cache */

   /* search418_0_0 -> replace80_0 in the cache */
/* search418_0 -> search205_0 in the cache */

/* search418_1_0 -> search160_0_1_0 in the cache */
static const nir_search_expression search418_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search160_0_1_0.value },
   NULL,
};
static const nir_search_expression search418 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search205_0.value, &search418_1.value },
   NULL,
};

   /* replace418_0_0 -> replace80_0 in the cache */

/* replace418_0_1 -> search160_0_1_0 in the cache */
/* replace418_0 -> replace164 in the cache */
static const nir_search_expression replace418 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace164.value },
   NULL,
};

   /* search419_0_0 -> replace80_0 in the cache */
/* search419_0 -> search158_1 in the cache */

/* search419_1_0 -> search160_0_1_0 in the cache */
/* search419_1 -> search160_0_1 in the cache */
static const nir_search_expression search419 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search158_1.value, &search160_0_1.value },
   NULL,
};

   /* replace419_0_0 -> replace80_0 in the cache */

/* replace419_0_1 -> search160_0_1_0 in the cache */
/* replace419_0 -> replace164 in the cache */
/* replace419 -> replace227 in the cache */

   /* search420_0_0_0 -> replace80_0 in the cache */
/* search420_0_0 -> search158_1 in the cache */

/* search420_0_1_0 -> search160_0_1_0 in the cache */
/* search420_0_1 -> search160_0_1 in the cache */
/* search420_0 -> search180_0_0 in the cache */
static const nir_search_expression search420 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search180_0_0.value },
   NULL,
};

   /* replace420_0_0 -> replace80_0 in the cache */

/* replace420_0_1 -> search160_0_1_0 in the cache */
/* replace420_0 -> replace160 in the cache */
/* replace420 -> replace225 in the cache */

   static const nir_search_variable search421_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_bool,
   NULL,
   {0, 1, 2, 3},
};

/* search421_1 -> replace60_0_0 in the cache */
static const nir_search_expression search421 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search421_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace421_0 -> search0_0 in the cache */
static const nir_search_expression replace421 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search0_0.value },
   NULL,
};

   /* search422_0_0 -> search0_0 in the cache */
static const nir_search_expression search422_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search422 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search422_0.value },
   NULL,
};

   /* replace422 -> search0_0 in the cache */

   /* search423_0_0_0 -> replace80_0 in the cache */
/* search423_0_0 -> search158_1 in the cache */
/* search423_0 -> search159_0 in the cache */

/* search423_1 -> search205_1 in the cache */
static const nir_search_expression search423 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search159_0.value, &search205_1.value },
   NULL,
};

   /* replace423 -> replace80_0 in the cache */

   /* search424_0 -> search2_0 in the cache */

/* search424_1 -> search2_0 in the cache */
static const nir_search_expression search424 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace424 -> replace133 in the cache */

   /* search425_0 -> search2_0 in the cache */

/* search425_1 -> search2_0 in the cache */
static const nir_search_expression search425 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace425 -> replace209 in the cache */

   /* search426_0 -> search2_0 in the cache */

/* search426_1 -> search2_0 in the cache */
static const nir_search_expression search426 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ieq,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace426 -> replace209 in the cache */

   /* search427_0 -> search2_0 in the cache */

/* search427_1 -> search2_0 in the cache */
static const nir_search_expression search427 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ine,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace427 -> replace133 in the cache */

   /* search428_0 -> search2_0 in the cache */

/* search428_1 -> search2_0 in the cache */
static const nir_search_expression search428 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace428 -> replace133 in the cache */

   /* search429_0 -> search2_0 in the cache */

/* search429_1 -> search2_0 in the cache */
static const nir_search_expression search429 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace429 -> replace209 in the cache */

   /* search430_0 -> search2_0 in the cache */

/* search430_1 -> search2_0 in the cache */
static const nir_search_expression search430 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iand,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace430 -> search2_0 in the cache */

   /* search431_0 -> search2_0 in the cache */

/* search431_1 -> search44_1 in the cache */
static const nir_search_expression search431 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &search44_1.value },
   NULL,
};

   /* replace431 -> search2_0 in the cache */

   /* search432_0 -> search2_0 in the cache */

/* search432_1 -> replace9 in the cache */
static const nir_search_expression search432 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace432 -> replace9 in the cache */

   /* search433_0 -> search2_0 in the cache */

/* search433_1 -> search2_0 in the cache */
static const nir_search_expression search433 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ior,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace433 -> search2_0 in the cache */

   /* search434_0 -> search2_0 in the cache */

/* search434_1 -> replace9 in the cache */
static const nir_search_expression search434 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace434 -> search2_0 in the cache */

   /* search435_0 -> replace80_0 in the cache */

/* search435_1 -> replace209 in the cache */
static const nir_search_expression search435 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace80_0.value, &replace209.value },
   NULL,
};

   /* replace435 -> replace209 in the cache */

   /* search436_0 -> search2_0 in the cache */

/* search436_1 -> search2_0 in the cache */
static const nir_search_expression search436 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ixor,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace436 -> replace9 in the cache */

   /* search437_0 -> search2_0 in the cache */

/* search437_1 -> replace9 in the cache */
static const nir_search_expression search437 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace437 -> search2_0 in the cache */

   /* search438_0_0 -> search2_0 in the cache */
/* search438_0 -> search336_1 in the cache */
static const nir_search_expression search438 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search336_1.value },
   NULL,
};

   /* replace438 -> search2_0 in the cache */

   /* search439_0_0 -> search14_0 in the cache */

/* search439_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search439_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search439_1 -> replace14_1_0 in the cache */
static const nir_search_expression search439 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search439_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace439 -> replace14_1_0 in the cache */

   /* search440_0_0 -> search14_0 in the cache */

/* search440_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search440_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search440_1 -> replace14_1_0 in the cache */
static const nir_search_expression search440 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search440_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace440_0 -> search14_0 in the cache */

/* replace440_1 -> replace14_1_0 in the cache */
/* replace440 -> search365_0 in the cache */

   /* search441_0_0 -> search14_0 in the cache */

/* search441_0_1 -> replace14_1_0 in the cache */
/* search441_0 -> search440_0 in the cache */

/* search441_1 -> replace14_1_0 in the cache */
static const nir_search_expression search441 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search440_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace441 -> replace14_1_0 in the cache */

   /* search442_0_0 -> search14_0 in the cache */

/* search442_0_1 -> replace14_1_0 in the cache */
/* search442_0 -> search439_0 in the cache */

/* search442_1 -> replace14_1_0 in the cache */
static const nir_search_expression search442 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search439_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace442_0 -> search14_0 in the cache */

/* replace442_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace442 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search443_0_0 -> search14_0 in the cache */
static const nir_search_expression search443_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search14_0.value },
   NULL,
};

/* search443_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression search443_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search443 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search443_0.value, &search443_1.value },
   NULL,
};

   /* replace443_0_0 -> search14_0 in the cache */

/* replace443_0_1 -> replace14_1_0 in the cache */
/* replace443_0 -> search365_0 in the cache */
static const nir_search_expression replace443 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search365_0.value },
   NULL,
};

   /* search444_0_0 -> search14_0 in the cache */
/* search444_0 -> search443_0 in the cache */

/* search444_1_0 -> replace14_1_0 in the cache */
/* search444_1 -> search443_1 in the cache */
static const nir_search_expression search444 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search443_0.value, &search443_1.value },
   NULL,
};

   /* replace444_0_0 -> search14_0 in the cache */

/* replace444_0_1 -> replace14_1_0 in the cache */
/* replace444_0 -> replace442 in the cache */
static const nir_search_expression replace444 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace442.value },
   NULL,
};

   /* search445_0 -> search205_1 in the cache */

/* search445_1 -> search0_0 in the cache */
static const nir_search_expression search445 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search205_1.value, &search0_0.value },
   NULL,
};

   /* replace445 -> search205_1 in the cache */

   /* search446_0 -> search2_0 in the cache */

/* search446_1 -> search26_1 in the cache */
static const nir_search_expression search446 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search2_0.value, &search26_1.value },
   NULL,
};

   /* replace446 -> search2_0 in the cache */

   /* search447_0 -> search205_1 in the cache */

/* search447_1 -> search0_0 in the cache */
static const nir_search_expression search447 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search205_1.value, &search0_0.value },
   NULL,
};

   /* replace447 -> search205_1 in the cache */

   /* search448_0 -> search2_0 in the cache */

/* search448_1 -> search26_1 in the cache */
static const nir_search_expression search448 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search2_0.value, &search26_1.value },
   NULL,
};

   /* replace448 -> search2_0 in the cache */

   /* search449_0 -> search205_1 in the cache */

/* search449_1 -> search0_0 in the cache */
static const nir_search_expression search449 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search205_1.value, &search0_0.value },
   NULL,
};

   /* replace449 -> search205_1 in the cache */

   /* search450_0 -> search2_0 in the cache */

/* search450_1 -> search26_1 in the cache */
static const nir_search_expression search450 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search2_0.value, &search26_1.value },
   NULL,
};

   /* replace450 -> search2_0 in the cache */

   /* search451_0 -> replace98_0_0_0_1 in the cache */

/* search451_1_0 -> search0_0 in the cache */

static const nir_search_constant search451_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x18 /* 24 */ },
};
static const nir_search_expression search451_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search451_1_1.value },
   NULL,
};
static const nir_search_expression search451 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace98_0_0_0_1.value, &search451_1.value },
   NULL,
};

   /* replace451_0 -> search0_0 in the cache */

/* replace451_1 -> search451_1_1 in the cache */
/* replace451 -> search451_1 in the cache */

   /* search452_0 -> replace101_0_0_0_1 in the cache */

/* search452_1_0 -> search0_0 in the cache */

/* search452_1_1 -> replace101_0_1 in the cache */
static const nir_search_expression search452_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &replace101_0_1.value },
   NULL,
};
static const nir_search_expression search452 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace101_0_0_0_1.value, &search452_1.value },
   NULL,
};

   /* replace452_0 -> search0_0 in the cache */

/* replace452_1 -> replace101_0_1 in the cache */
/* replace452 -> search452_1 in the cache */

   /* search453_0_0 -> search101_0_0 in the cache */

/* search453_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search453_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search101_0_0.value, &replace0_1_0.value },
   NULL,
};

/* search453_1_0 -> search101_0_0 in the cache */

/* search453_1_1_0 -> replace101_0_1 in the cache */

/* search453_1_1_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search453_1_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search453_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &replace101_0_1.value, &search453_1_1_1.value },
   NULL,
};
static const nir_search_expression search453_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search101_0_0.value, &search453_1_1.value },
   NULL,
};
static const nir_search_expression search453 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search453_0.value, &search453_1.value },
   NULL,
};

   /* replace453_0 -> search101_0_0 in the cache */

/* replace453_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace453 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_urol,
   { &search101_0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search454_0_0 -> search101_0_0 in the cache */

/* search454_0_1 -> replace0_1_0 in the cache */
/* search454_0 -> search453_0 in the cache */

/* search454_1_0 -> search101_0_0 in the cache */

/* search454_1_1_0 -> replace101_0_1 in the cache */

/* search454_1_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search454_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace101_0_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search454_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search101_0_0.value, &search454_1_1.value },
   NULL,
};
static const nir_search_expression search454 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search453_0.value, &search454_1.value },
   NULL,
};

   /* replace454_0 -> search101_0_0 in the cache */

/* replace454_1 -> replace0_1_0 in the cache */
/* replace454 -> replace453 in the cache */

   /* search455_0_0 -> search0_0 in the cache */

/* search455_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search455_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search455_1_0 -> search0_0 in the cache */

/* search455_1_1_0 -> replace104_0_1 in the cache */

/* search455_1_1_1_0 -> replace0_1_0 in the cache */
/* search455_1_1_1 -> search453_1_1_1 in the cache */
static const nir_search_expression search455_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &replace104_0_1.value, &search453_1_1_1.value },
   NULL,
};
static const nir_search_expression search455_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search0_0.value, &search455_1_1.value },
   NULL,
};
static const nir_search_expression search455 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search455_0.value, &search455_1.value },
   NULL,
};

   /* replace455_0 -> search0_0 in the cache */

/* replace455_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace455 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_urol,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search456_0_0 -> search0_0 in the cache */

/* search456_0_1 -> replace0_1_0 in the cache */
/* search456_0 -> search455_0 in the cache */

/* search456_1_0 -> search0_0 in the cache */

/* search456_1_1_0 -> replace104_0_1 in the cache */

/* search456_1_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search456_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace104_0_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search456_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search456_1_1.value },
   NULL,
};
static const nir_search_expression search456 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search455_0.value, &search456_1.value },
   NULL,
};

   /* replace456_0 -> search0_0 in the cache */

/* replace456_1 -> replace0_1_0 in the cache */
/* replace456 -> replace455 in the cache */

   /* search457_0_0 -> search101_0_0 in the cache */

/* search457_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search457_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search101_0_0.value, &replace0_1_0.value },
   NULL,
};

/* search457_1_0 -> search101_0_0 in the cache */

/* search457_1_1_0 -> replace101_0_1 in the cache */

/* search457_1_1_1_0 -> replace0_1_0 in the cache */
/* search457_1_1_1 -> search453_1_1_1 in the cache */
/* search457_1_1 -> search453_1_1 in the cache */
static const nir_search_expression search457_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search101_0_0.value, &search453_1_1.value },
   NULL,
};
static const nir_search_expression search457 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search457_0.value, &search457_1.value },
   NULL,
};

   /* replace457_0 -> search101_0_0 in the cache */

/* replace457_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace457 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_uror,
   { &search101_0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search458_0_0 -> search101_0_0 in the cache */

/* search458_0_1 -> replace0_1_0 in the cache */
/* search458_0 -> search457_0 in the cache */

/* search458_1_0 -> search101_0_0 in the cache */

/* search458_1_1_0 -> replace101_0_1 in the cache */

/* search458_1_1_1 -> replace0_1_0 in the cache */
/* search458_1_1 -> search454_1_1 in the cache */
static const nir_search_expression search458_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search101_0_0.value, &search454_1_1.value },
   NULL,
};
static const nir_search_expression search458 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search457_0.value, &search458_1.value },
   NULL,
};

   /* replace458_0 -> search101_0_0 in the cache */

/* replace458_1 -> replace0_1_0 in the cache */
/* replace458 -> replace457 in the cache */

   /* search459_0_0 -> search0_0 in the cache */

/* search459_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search459_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search459_1_0 -> search0_0 in the cache */

/* search459_1_1_0 -> replace104_0_1 in the cache */

/* search459_1_1_1_0 -> replace0_1_0 in the cache */
/* search459_1_1_1 -> search453_1_1_1 in the cache */
/* search459_1_1 -> search455_1_1 in the cache */
static const nir_search_expression search459_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search0_0.value, &search455_1_1.value },
   NULL,
};
static const nir_search_expression search459 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search459_0.value, &search459_1.value },
   NULL,
};

   /* replace459_0 -> search0_0 in the cache */

/* replace459_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace459 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_uror,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search460_0_0 -> search0_0 in the cache */

/* search460_0_1 -> replace0_1_0 in the cache */
/* search460_0 -> search459_0 in the cache */

/* search460_1_0 -> search0_0 in the cache */

/* search460_1_1_0 -> replace104_0_1 in the cache */

/* search460_1_1_1 -> replace0_1_0 in the cache */
/* search460_1_1 -> search456_1_1 in the cache */
static const nir_search_expression search460_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &search456_1_1.value },
   NULL,
};
static const nir_search_expression search460 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search459_0.value, &search460_1.value },
   NULL,
};

   /* replace460_0 -> search0_0 in the cache */

/* replace460_1 -> replace0_1_0 in the cache */
/* replace460 -> replace459 in the cache */

   /* search461_0 -> search101_0_0 in the cache */

/* search461_1 -> replace0_1_0 in the cache */
/* search461 -> replace453 in the cache */

   /* replace461_0_0 -> search101_0_0 in the cache */

/* replace461_0_1 -> replace0_1_0 in the cache */
/* replace461_0 -> search453_0 in the cache */

/* replace461_1_0 -> search101_0_0 in the cache */

/* replace461_1_1_0 -> replace101_0_1 in the cache */

/* replace461_1_1_1 -> replace0_1_0 in the cache */
/* replace461_1_1 -> search454_1_1 in the cache */
/* replace461_1 -> search454_1 in the cache */
/* replace461 -> search454 in the cache */

   /* search462_0 -> search0_0 in the cache */

/* search462_1 -> replace0_1_0 in the cache */
/* search462 -> replace455 in the cache */

   /* replace462_0_0 -> search0_0 in the cache */

/* replace462_0_1 -> replace0_1_0 in the cache */
/* replace462_0 -> search455_0 in the cache */

/* replace462_1_0 -> search0_0 in the cache */

/* replace462_1_1_0 -> replace104_0_1 in the cache */

/* replace462_1_1_1 -> replace0_1_0 in the cache */
/* replace462_1_1 -> search456_1_1 in the cache */
/* replace462_1 -> search456_1 in the cache */
/* replace462 -> search456 in the cache */

   /* search463_0 -> search101_0_0 in the cache */

/* search463_1 -> replace0_1_0 in the cache */
/* search463 -> replace457 in the cache */

   /* replace463_0_0 -> search101_0_0 in the cache */

/* replace463_0_1 -> replace0_1_0 in the cache */
/* replace463_0 -> search457_0 in the cache */

/* replace463_1_0 -> search101_0_0 in the cache */

/* replace463_1_1_0 -> replace101_0_1 in the cache */

/* replace463_1_1_1 -> replace0_1_0 in the cache */
/* replace463_1_1 -> search454_1_1 in the cache */
/* replace463_1 -> search458_1 in the cache */
/* replace463 -> search458 in the cache */

   /* search464_0 -> search0_0 in the cache */

/* search464_1 -> replace0_1_0 in the cache */
/* search464 -> replace459 in the cache */

   /* replace464_0_0 -> search0_0 in the cache */

/* replace464_0_1 -> replace0_1_0 in the cache */
/* replace464_0 -> search459_0 in the cache */

/* replace464_1_0 -> search0_0 in the cache */

/* replace464_1_1_0 -> replace104_0_1 in the cache */

/* replace464_1_1_1 -> replace0_1_0 in the cache */
/* replace464_1_1 -> search456_1_1 in the cache */
/* replace464_1 -> search460_1 in the cache */
/* replace464 -> search460 in the cache */

   /* search465_0_0 -> search2_0 in the cache */
static const nir_search_expression search465_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search465 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fexp2,
   { &search465_0.value },
   NULL,
};

   /* replace465 -> search2_0 in the cache */

   /* search466_0_0 -> search2_0 in the cache */
static const nir_search_expression search466_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search466 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search466_0.value },
   NULL,
};

   /* replace466 -> search2_0 in the cache */

   /* search467_0 -> search14_0 in the cache */

/* search467_1 -> replace14_1_0 in the cache */
static const nir_search_expression search467 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace467_0_0_0 -> search14_0 in the cache */
static const nir_search_expression replace467_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search14_0.value },
   NULL,
};

/* replace467_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace467_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace467_0_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace467 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace467_0.value },
   NULL,
};

   /* search468_0_0_0 -> search14_0 in the cache */
/* search468_0_0 -> replace467_0_0 in the cache */

/* search468_0_1 -> replace14_1_0 in the cache */
/* search468_0 -> replace467_0 in the cache */
static const nir_search_expression search468 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &replace467_0.value },
   NULL,
};

   /* replace468_0 -> search14_0 in the cache */

/* replace468_1 -> replace14_1_0 in the cache */
/* replace468 -> search467 in the cache */

   /* search469_0_0_0_0 -> search62_0_0 in the cache */
static const nir_search_expression search469_0_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search62_0_0.value },
   NULL,
};

/* search469_0_0_1 -> search62_0_1 in the cache */
static const nir_search_expression search469_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search469_0_0_0.value, &search62_0_1.value },
   NULL,
};

/* search469_0_1_0_0 -> search62_1_1 in the cache */
static const nir_search_expression search469_0_1_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search62_1_1.value },
   NULL,
};

/* search469_0_1_1 -> search62_2 in the cache */
static const nir_search_expression search469_0_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search469_0_1_0.value, &search62_2.value },
   NULL,
};
static const nir_search_expression search469_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 3,
   nir_op_fadd,
   { &search469_0_0.value, &search469_0_1.value },
   NULL,
};
static const nir_search_expression search469 = {
   { nir_search_value_expression, -4 },
   true, false,
   -1, 3,
   nir_op_fexp2,
   { &search469_0.value },
   NULL,
};

   /* replace469_0_0 -> search62_0_0 in the cache */

/* replace469_0_1 -> search62_0_1 in the cache */
static const nir_search_expression replace469_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search62_0_0.value, &search62_0_1.value },
   NULL,
};

/* replace469_1_0 -> search62_1_1 in the cache */

/* replace469_1_1 -> search62_2 in the cache */
static const nir_search_expression replace469_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search62_1_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression replace469 = {
   { nir_search_value_expression, -4 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &replace469_0.value, &replace469_1.value },
   NULL,
};

   /* search470_0_0_0 -> search2_0 in the cache */
/* search470_0_0 -> search465_0 in the cache */

static const nir_search_constant search470_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x4000000000000000 /* 2.0 */ },
};
static const nir_search_expression search470_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search465_0.value, &search470_0_1.value },
   NULL,
};
static const nir_search_expression search470 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &search470_0.value },
   NULL,
};

   /* replace470_0 -> search2_0 in the cache */

/* replace470_1 -> search2_0 in the cache */
/* replace470 -> search45_1 in the cache */

   /* search471_0_0_0 -> search2_0 in the cache */
/* search471_0_0 -> search465_0 in the cache */

static const nir_search_constant search471_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x4010000000000000 /* 4.0 */ },
};
static const nir_search_expression search471_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search465_0.value, &search471_0_1.value },
   NULL,
};
static const nir_search_expression search471 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &search471_0.value },
   NULL,
};

   /* replace471_0_0 -> search2_0 in the cache */

/* replace471_0_1 -> search2_0 in the cache */
/* replace471_0 -> search45_1 in the cache */

/* replace471_1_0 -> search2_0 in the cache */

/* replace471_1_1 -> search2_0 in the cache */
/* replace471_1 -> search45_1 in the cache */
static const nir_search_expression replace471 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search45_1.value, &search45_1.value },
   NULL,
};

   /* search472_0 -> search2_0 in the cache */

/* search472_1 -> search41_1 in the cache */
static const nir_search_expression search472 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   /* replace472 -> search2_0 in the cache */

   /* search473_0 -> search2_0 in the cache */

/* search473_1 -> search470_0_1 in the cache */
static const nir_search_expression search473 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search470_0_1.value },
   NULL,
};

   /* replace473_0 -> search2_0 in the cache */

/* replace473_1 -> search2_0 in the cache */
/* replace473 -> search45_1 in the cache */

   /* search474_0 -> search2_0 in the cache */

/* search474_1 -> search471_0_1 in the cache */
static const nir_search_expression search474 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search471_0_1.value },
   NULL,
};

   /* replace474_0_0 -> search2_0 in the cache */

/* replace474_0_1 -> search2_0 in the cache */
/* replace474_0 -> search45_1 in the cache */

/* replace474_1_0 -> search2_0 in the cache */

/* replace474_1_1 -> search2_0 in the cache */
/* replace474_1 -> search45_1 in the cache */
/* replace474 -> replace471 in the cache */

   /* search475_0 -> search470_0_1 in the cache */

/* search475_1 -> search2_0 in the cache */
static const nir_search_expression search475 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search470_0_1.value, &search2_0.value },
   NULL,
};

   /* replace475_0 -> search2_0 in the cache */
/* replace475 -> search466_0 in the cache */

   /* search476_0_0 -> search2_0 in the cache */

static const nir_search_constant search476_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x400199999999999a /* 2.2 */ },
};
static const nir_search_expression search476_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search476_0_1.value },
   NULL,
};

static const nir_search_constant search476_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fdd1743e963dc48 /* 0.454545 */ },
};
static const nir_search_expression search476 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search476_0.value, &search476_1.value },
   NULL,
};

   /* replace476 -> search2_0 in the cache */

   /* search477_0_0_0 -> search2_0 in the cache */

/* search477_0_0_1 -> search476_0_1 in the cache */
/* search477_0_0 -> search476_0 in the cache */
static const nir_search_expression search477_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search476_0.value },
   NULL,
};

/* search477_1 -> search476_1 in the cache */
static const nir_search_expression search477 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search477_0.value, &search476_1.value },
   NULL,
};

   /* replace477_0 -> search2_0 in the cache */
/* replace477 -> search17_0 in the cache */

   /* search478_0_0 -> search2_0 in the cache */
/* search478_0 -> search466_0 in the cache */
static const nir_search_expression search478 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fsqrt,
   { &search466_0.value },
   NULL,
};

   static const nir_search_constant replace478_0_0 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fe0000000000000 /* 0.5 */ },
};

/* replace478_0_1 -> search2_0 in the cache */
static const nir_search_expression replace478_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace478_0_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression replace478 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace478_0.value },
   NULL,
};

   /* search479_0_0 -> search2_0 in the cache */
/* search479_0 -> search466_0 in the cache */
static const nir_search_expression search479 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search466_0.value },
   NULL,
};

   /* replace479_0_0 -> search2_0 in the cache */
/* replace479_0 -> search15_0 in the cache */
static const nir_search_expression replace479 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search15_0.value },
   NULL,
};

   /* search480_0_0 -> search2_0 in the cache */
/* search480_0 -> search466_0 in the cache */
static const nir_search_expression search480 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frsq,
   { &search466_0.value },
   NULL,
};

   static const nir_search_constant replace480_0_0 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0xbfe0000000000000L /* -0.5 */ },
};

/* replace480_0_1 -> search2_0 in the cache */
static const nir_search_expression replace480_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace480_0_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression replace480 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace480_0.value },
   NULL,
};

   /* search481_0_0 -> search2_0 in the cache */
static const nir_search_expression search481_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsqrt,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search481 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search481_0.value },
   NULL,
};

   /* replace481_0 -> replace478_0_0 in the cache */

/* replace481_1_0 -> search2_0 in the cache */
/* replace481_1 -> search465_0 in the cache */
static const nir_search_expression replace481 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace478_0_0.value, &search465_0.value },
   NULL,
};

   /* search482_0_0 -> search2_0 in the cache */
static const nir_search_expression search482_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search482 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search482_0.value },
   NULL,
};

   /* replace482_0_0 -> search2_0 in the cache */
/* replace482_0 -> search465_0 in the cache */
static const nir_search_expression replace482 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search465_0.value },
   NULL,
};

   /* search483_0_0 -> search2_0 in the cache */
static const nir_search_expression search483_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frsq,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search483 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search483_0.value },
   NULL,
};

   /* replace483_0 -> replace480_0_0 in the cache */

/* replace483_1_0 -> search2_0 in the cache */
/* replace483_1 -> search465_0 in the cache */
static const nir_search_expression replace483 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace480_0_0.value, &search465_0.value },
   NULL,
};

   /* search484_0_0 -> search14_0 in the cache */

/* search484_0_1 -> replace14_1_0 in the cache */
/* search484_0 -> search467 in the cache */
static const nir_search_expression search484 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search467.value },
   NULL,
};

   /* replace484_0 -> replace14_1_0 in the cache */

/* replace484_1_0 -> search14_0 in the cache */
/* replace484_1 -> replace467_0_0 in the cache */
static const nir_search_expression replace484 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace14_1_0.value, &replace467_0_0.value },
   NULL,
};

   /* search485_0_0 -> search14_0 in the cache */
static const nir_search_expression search485_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search14_0.value },
   (is_used_once),
};

/* search485_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression search485_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &replace14_1_0.value },
   (is_used_once),
};
static const nir_search_expression search485 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search485_0.value, &search485_1.value },
   NULL,
};

   /* replace485_0_0 -> search14_0 in the cache */

/* replace485_0_1 -> replace14_1_0 in the cache */
/* replace485_0 -> replace49 in the cache */
static const nir_search_expression replace485 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace49.value },
   NULL,
};

   /* search486_0_0 -> search2_0 in the cache */

/* search486_0_1 -> search24_1 in the cache */
/* search486_0 -> replace65_0 in the cache */

/* search486_1 -> search24_1 in the cache */

/* search486_2_0 -> search2_0 in the cache */
/* search486_2 -> search481_0 in the cache */
static const nir_search_expression search486 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace65_0.value, &search24_1.value, &search481_0.value },
   NULL,
};

   /* replace486_0_0 -> search2_0 in the cache */

/* replace486_0_1 -> search24_1 in the cache */
/* replace486_0 -> search274_0 in the cache */
static const nir_search_expression replace486 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsqrt,
   { &search274_0.value },
   NULL,
};

   /* search487_0_0 -> search2_0 in the cache */
/* search487_0 -> search481_0 in the cache */

/* search487_1_0 -> search2_0 in the cache */
/* search487_1 -> search481_0 in the cache */
static const nir_search_expression search487 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmul,
   { &search481_0.value, &search481_0.value },
   NULL,
};

   /* replace487_0 -> search2_0 in the cache */
/* replace487 -> search17_0 in the cache */

   /* search488_0 -> search41_1 in the cache */

/* search488_1 -> search2_0 in the cache */
static const nir_search_expression search488 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fdiv,
   { &search41_1.value, &search2_0.value },
   NULL,
};

   /* replace488_0 -> search2_0 in the cache */
/* replace488 -> search482_0 in the cache */

   /* search489_0 -> search14_0 in the cache */

/* search489_1 -> replace14_1_0 in the cache */
static const nir_search_expression search489 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace489_0 -> search14_0 in the cache */

/* replace489_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression replace489_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace489 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search14_0.value, &replace489_1.value },
   NULL,
};

   /* search490_0_0 -> search2_0 in the cache */
/* search490_0 -> search482_0 in the cache */
static const nir_search_expression search490 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search482_0.value },
   NULL,
};

   /* replace490 -> search2_0 in the cache */

   /* search491_0_0 -> search2_0 in the cache */
/* search491_0 -> search481_0 in the cache */
static const nir_search_expression search491 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search481_0.value },
   NULL,
};

   /* replace491_0 -> search2_0 in the cache */
/* replace491 -> search483_0 in the cache */

   /* search492_0 -> search2_0 in the cache */
/* search492 -> search481_0 in the cache */

   /* replace492_0_0 -> search2_0 in the cache */
/* replace492_0 -> search483_0 in the cache */
static const nir_search_expression replace492 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &search483_0.value },
   NULL,
};

   /* search493_0_0 -> search2_0 in the cache */
/* search493_0 -> search483_0 in the cache */
static const nir_search_expression search493 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search483_0.value },
   NULL,
};

   /* replace493_0 -> search2_0 in the cache */
/* replace493 -> search481_0 in the cache */

   /* search494_0 -> search2_0 in the cache */
static const nir_search_expression search494 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsin,
   { &search2_0.value },
   NULL,
};

   /* replace494_0_0_0_0_0_0 -> search470_0_1 in the cache */

static const nir_search_constant replace494_0_0_0_0_0_1_0_0_0 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fc45f306dc9c883 /* 0.15915494309189535 */ },
};

/* replace494_0_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_0_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   5, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_0_0_0_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_0_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   4, 2,
   nir_op_fadd,
   { &replace494_0_0_0_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_0_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_0_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   3, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_0_0_0_0_0_1.value },
   NULL,
};

/* replace494_0_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_0_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace494_0_0_0_1_0_0_0 -> search470_0_1 in the cache */

/* replace494_0_0_0_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_0_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_0_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   9, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_0_0_0_1_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_0_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   8, 2,
   nir_op_fadd,
   { &replace494_0_0_0_1_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_0_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_0_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   7, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_0_0_0_1_0_0_1.value },
   NULL,
};

/* replace494_0_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_0_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace494_0_0_0_1_1_0_0_0 -> search470_0_1 in the cache */

/* replace494_0_0_0_1_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_0_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_0_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   12, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_0_0_0_1_1_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_0_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   11, 2,
   nir_op_fadd,
   { &replace494_0_0_0_1_1_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_0_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_0_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   10, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_0_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace494_0_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_0_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_0_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace494_0_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace494_0_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   6, 7,
   nir_op_fmul,
   { &replace494_0_0_0_1_0.value, &replace494_0_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace494_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace494_0_0_0_0.value, &replace494_0_0_0_1.value },
   NULL,
};

/* replace494_0_0_1 -> search471_0_1 in the cache */
static const nir_search_expression replace494_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 11,
   nir_op_fmul,
   { &replace494_0_0_0.value, &search471_0_1.value },
   NULL,
};

/* replace494_0_1_0_0_0_0_0 -> search470_0_1 in the cache */

/* replace494_0_1_0_0_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_0_1_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_0_1_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   16, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_0_1_0_0_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_0_1_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   15, 2,
   nir_op_fadd,
   { &replace494_0_1_0_0_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_0_1_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_0_1_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_1_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   14, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace494_0_1_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_0_1_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_0_1_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace494_0_1_0_0_1_0_0_0 -> search470_0_1 in the cache */

/* replace494_0_1_0_0_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_0_1_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_0_1_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   20, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_0_1_0_0_1_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_0_1_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   19, 2,
   nir_op_fadd,
   { &replace494_0_1_0_0_1_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_0_1_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_0_1_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   18, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_0_1_0_0_1_0_0_1.value },
   NULL,
};

/* replace494_0_1_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_0_1_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace494_0_1_0_0_1_1_0_0_0 -> search470_0_1 in the cache */

/* replace494_0_1_0_0_1_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_0_1_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_0_1_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   23, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_0_1_0_0_1_1_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_0_1_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   22, 2,
   nir_op_fadd,
   { &replace494_0_1_0_0_1_1_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_0_1_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_0_1_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_1_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   21, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_0_1_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace494_0_1_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_0_1_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_0_1_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace494_0_1_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace494_0_1_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   17, 7,
   nir_op_fmul,
   { &replace494_0_1_0_0_1_0.value, &replace494_0_1_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace494_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace494_0_1_0_0_0.value, &replace494_0_1_0_0_1.value },
   NULL,
};

/* replace494_0_1_0_1 -> search471_0_1 in the cache */
static const nir_search_expression replace494_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   13, 11,
   nir_op_fmul,
   { &replace494_0_1_0_0.value, &search471_0_1.value },
   NULL,
};
static const nir_search_expression replace494_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fabs,
   { &replace494_0_1_0.value },
   NULL,
};

/* replace494_0_2_0_0_0_0_0 -> search470_0_1 in the cache */

/* replace494_0_2_0_0_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_0_2_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_0_2_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   27, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_0_2_0_0_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_0_2_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   26, 2,
   nir_op_fadd,
   { &replace494_0_2_0_0_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_0_2_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_0_2_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_2_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   25, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_0_2_0_0_0_0_1.value },
   NULL,
};

/* replace494_0_2_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_0_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_0_2_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace494_0_2_0_0_1_0_0_0 -> search470_0_1 in the cache */

/* replace494_0_2_0_0_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_0_2_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_0_2_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   31, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_0_2_0_0_1_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_0_2_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   30, 2,
   nir_op_fadd,
   { &replace494_0_2_0_0_1_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_0_2_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_0_2_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_2_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   29, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_0_2_0_0_1_0_0_1.value },
   NULL,
};

/* replace494_0_2_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_0_2_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_0_2_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace494_0_2_0_0_1_1_0_0_0 -> search470_0_1 in the cache */

/* replace494_0_2_0_0_1_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_0_2_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_0_2_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   34, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_0_2_0_0_1_1_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_0_2_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   33, 2,
   nir_op_fadd,
   { &replace494_0_2_0_0_1_1_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_0_2_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_0_2_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_2_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   32, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_0_2_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace494_0_2_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_0_2_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_0_2_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace494_0_2_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace494_0_2_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace494_0_2_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   28, 7,
   nir_op_fmul,
   { &replace494_0_2_0_0_1_0.value, &replace494_0_2_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace494_0_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace494_0_2_0_0_0.value, &replace494_0_2_0_0_1.value },
   NULL,
};

/* replace494_0_2_0_1 -> search471_0_1 in the cache */
static const nir_search_expression replace494_0_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   24, 11,
   nir_op_fmul,
   { &replace494_0_2_0_0.value, &search471_0_1.value },
   NULL,
};
static const nir_search_expression replace494_0_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fneg,
   { &replace494_0_2_0.value },
   NULL,
};
static const nir_search_expression replace494_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 34,
   nir_op_ffma,
   { &replace494_0_0.value, &replace494_0_1.value, &replace494_0_2.value },
   NULL,
};

static const nir_search_constant replace494_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fcccccccccccccd /* 0.225 */ },
};

/* replace494_2_0_0_0_0 -> search470_0_1 in the cache */

/* replace494_2_0_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_2_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_2_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   38, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_2_0_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_2_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   37, 2,
   nir_op_fadd,
   { &replace494_2_0_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_2_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_2_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   36, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_2_0_0_0_1.value },
   NULL,
};

/* replace494_2_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_2_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace494_2_0_1_0_0_0 -> search470_0_1 in the cache */

/* replace494_2_0_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_2_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_2_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   42, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_2_0_1_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_2_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   41, 2,
   nir_op_fadd,
   { &replace494_2_0_1_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_2_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_2_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_2_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   40, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_2_0_1_0_0_1.value },
   NULL,
};

/* replace494_2_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_2_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_2_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace494_2_0_1_1_0_0_0 -> search470_0_1 in the cache */

/* replace494_2_0_1_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace494_2_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace494_2_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   45, 1,
   nir_op_fmul,
   { &replace494_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace494_2_0_1_1_0_0_1_0_1 -> replace478_0_0 in the cache */
static const nir_search_expression replace494_2_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   44, 2,
   nir_op_fadd,
   { &replace494_2_0_1_1_0_0_1_0_0.value, &replace478_0_0.value },
   NULL,
};
static const nir_search_expression replace494_2_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace494_2_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace494_2_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   43, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace494_2_0_1_1_0_0_1.value },
   NULL,
};

/* replace494_2_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace494_2_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace494_2_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace494_2_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace494_2_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace494_2_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   39, 7,
   nir_op_fmul,
   { &replace494_2_0_1_0.value, &replace494_2_0_1_1.value },
   NULL,
};
static const nir_search_expression replace494_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace494_2_0_0.value, &replace494_2_0_1.value },
   NULL,
};

/* replace494_2_1 -> search471_0_1 in the cache */
static const nir_search_expression replace494_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   35, 11,
   nir_op_fmul,
   { &replace494_2_0.value, &search471_0_1.value },
   NULL,
};
static const nir_search_expression replace494 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 46,
   nir_op_ffma,
   { &replace494_0.value, &replace494_1.value, &replace494_2.value },
   NULL,
};

   /* search495_0 -> search2_0 in the cache */
static const nir_search_expression search495 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fcos,
   { &search2_0.value },
   NULL,
};

   /* replace495_0_0_0_0_0_0 -> search470_0_1 in the cache */

/* replace495_0_0_0_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_0_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_0_0_0_0_0_1_0_0 -> replace494_0_0_0_0_0_1_0_0 in the cache */

static const nir_search_constant replace495_0_0_0_0_0_1_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fe8000000000000 /* 0.75 */ },
};
static const nir_search_expression replace495_0_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   4, 2,
   nir_op_fadd,
   { &replace494_0_0_0_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_0_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   3, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_0_0_0_0_0_1.value },
   NULL,
};

/* replace495_0_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_0_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace495_0_0_0_1_0_0_0 -> search470_0_1 in the cache */

/* replace495_0_0_0_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_0_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_0_0_0_1_0_0_1_0_0 -> replace494_0_0_0_1_0_0_1_0_0 in the cache */

/* replace495_0_0_0_1_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_0_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   8, 2,
   nir_op_fadd,
   { &replace494_0_0_0_1_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_0_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   7, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_0_0_0_1_0_0_1.value },
   NULL,
};

/* replace495_0_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_0_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace495_0_0_0_1_1_0_0_0 -> search470_0_1 in the cache */

/* replace495_0_0_0_1_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_0_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_0_0_0_1_1_0_0_1_0_0 -> replace494_0_0_0_1_1_0_0_1_0_0 in the cache */

/* replace495_0_0_0_1_1_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_0_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   11, 2,
   nir_op_fadd,
   { &replace494_0_0_0_1_1_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_0_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   10, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_0_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace495_0_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_0_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_0_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace495_0_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace495_0_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   6, 7,
   nir_op_fmul,
   { &replace495_0_0_0_1_0.value, &replace495_0_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace495_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace495_0_0_0_0.value, &replace495_0_0_0_1.value },
   NULL,
};

/* replace495_0_0_1 -> search471_0_1 in the cache */
static const nir_search_expression replace495_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 11,
   nir_op_fmul,
   { &replace495_0_0_0.value, &search471_0_1.value },
   NULL,
};

/* replace495_0_1_0_0_0_0_0 -> search470_0_1 in the cache */

/* replace495_0_1_0_0_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_0_1_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_0_1_0_0_0_0_1_0_0 -> replace494_0_1_0_0_0_0_1_0_0 in the cache */

/* replace495_0_1_0_0_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_0_1_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   15, 2,
   nir_op_fadd,
   { &replace494_0_1_0_0_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_1_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_0_1_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_1_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   14, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace495_0_1_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_0_1_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_0_1_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace495_0_1_0_0_1_0_0_0 -> search470_0_1 in the cache */

/* replace495_0_1_0_0_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_0_1_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_0_1_0_0_1_0_0_1_0_0 -> replace494_0_1_0_0_1_0_0_1_0_0 in the cache */

/* replace495_0_1_0_0_1_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_0_1_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   19, 2,
   nir_op_fadd,
   { &replace494_0_1_0_0_1_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_1_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_0_1_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   18, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_0_1_0_0_1_0_0_1.value },
   NULL,
};

/* replace495_0_1_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_0_1_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace495_0_1_0_0_1_1_0_0_0 -> search470_0_1 in the cache */

/* replace495_0_1_0_0_1_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_0_1_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_0_1_0_0_1_1_0_0_1_0_0 -> replace494_0_1_0_0_1_1_0_0_1_0_0 in the cache */

/* replace495_0_1_0_0_1_1_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_0_1_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   22, 2,
   nir_op_fadd,
   { &replace494_0_1_0_0_1_1_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_1_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_0_1_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_1_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   21, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_0_1_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace495_0_1_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_0_1_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_0_1_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace495_0_1_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace495_0_1_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   17, 7,
   nir_op_fmul,
   { &replace495_0_1_0_0_1_0.value, &replace495_0_1_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace495_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace495_0_1_0_0_0.value, &replace495_0_1_0_0_1.value },
   NULL,
};

/* replace495_0_1_0_1 -> search471_0_1 in the cache */
static const nir_search_expression replace495_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   13, 11,
   nir_op_fmul,
   { &replace495_0_1_0_0.value, &search471_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fabs,
   { &replace495_0_1_0.value },
   NULL,
};

/* replace495_0_2_0_0_0_0_0 -> search470_0_1 in the cache */

/* replace495_0_2_0_0_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_0_2_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_0_2_0_0_0_0_1_0_0 -> replace494_0_2_0_0_0_0_1_0_0 in the cache */

/* replace495_0_2_0_0_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_0_2_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   26, 2,
   nir_op_fadd,
   { &replace494_0_2_0_0_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_2_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_0_2_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_2_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   25, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_0_2_0_0_0_0_1.value },
   NULL,
};

/* replace495_0_2_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_0_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_0_2_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace495_0_2_0_0_1_0_0_0 -> search470_0_1 in the cache */

/* replace495_0_2_0_0_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_0_2_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_0_2_0_0_1_0_0_1_0_0 -> replace494_0_2_0_0_1_0_0_1_0_0 in the cache */

/* replace495_0_2_0_0_1_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_0_2_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   30, 2,
   nir_op_fadd,
   { &replace494_0_2_0_0_1_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_2_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_0_2_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_2_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   29, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_0_2_0_0_1_0_0_1.value },
   NULL,
};

/* replace495_0_2_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_0_2_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_0_2_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace495_0_2_0_0_1_1_0_0_0 -> search470_0_1 in the cache */

/* replace495_0_2_0_0_1_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_0_2_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_0_2_0_0_1_1_0_0_1_0_0 -> replace494_0_2_0_0_1_1_0_0_1_0_0 in the cache */

/* replace495_0_2_0_0_1_1_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_0_2_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   33, 2,
   nir_op_fadd,
   { &replace494_0_2_0_0_1_1_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_2_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_0_2_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_2_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   32, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_0_2_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace495_0_2_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_0_2_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_0_2_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace495_0_2_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace495_0_2_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace495_0_2_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   28, 7,
   nir_op_fmul,
   { &replace495_0_2_0_0_1_0.value, &replace495_0_2_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace495_0_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace495_0_2_0_0_0.value, &replace495_0_2_0_0_1.value },
   NULL,
};

/* replace495_0_2_0_1 -> search471_0_1 in the cache */
static const nir_search_expression replace495_0_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   24, 11,
   nir_op_fmul,
   { &replace495_0_2_0_0.value, &search471_0_1.value },
   NULL,
};
static const nir_search_expression replace495_0_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fneg,
   { &replace495_0_2_0.value },
   NULL,
};
static const nir_search_expression replace495_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 34,
   nir_op_ffma,
   { &replace495_0_0.value, &replace495_0_1.value, &replace495_0_2.value },
   NULL,
};

/* replace495_1 -> replace494_1 in the cache */

/* replace495_2_0_0_0_0 -> search470_0_1 in the cache */

/* replace495_2_0_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_2_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_2_0_0_0_1_0_0 -> replace494_2_0_0_0_1_0_0 in the cache */

/* replace495_2_0_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_2_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   37, 2,
   nir_op_fadd,
   { &replace494_2_0_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_2_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_2_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   36, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_2_0_0_0_1.value },
   NULL,
};

/* replace495_2_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_2_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace495_2_0_1_0_0_0 -> search470_0_1 in the cache */

/* replace495_2_0_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_2_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_2_0_1_0_0_1_0_0 -> replace494_2_0_1_0_0_1_0_0 in the cache */

/* replace495_2_0_1_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_2_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   41, 2,
   nir_op_fadd,
   { &replace494_2_0_1_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_2_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_2_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_2_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   40, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_2_0_1_0_0_1.value },
   NULL,
};

/* replace495_2_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_2_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_2_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace495_2_0_1_1_0_0_0 -> search470_0_1 in the cache */

/* replace495_2_0_1_1_0_0_1_0_0_0 -> replace494_0_0_0_0_0_1_0_0_0 in the cache */

/* replace495_2_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace495_2_0_1_1_0_0_1_0_0 -> replace494_2_0_1_1_0_0_1_0_0 in the cache */

/* replace495_2_0_1_1_0_0_1_0_1 -> replace495_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace495_2_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   44, 2,
   nir_op_fadd,
   { &replace494_2_0_1_1_0_0_1_0_0.value, &replace495_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace495_2_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace495_2_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace495_2_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   43, 3,
   nir_op_fmul,
   { &search470_0_1.value, &replace495_2_0_1_1_0_0_1.value },
   NULL,
};

/* replace495_2_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace495_2_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace495_2_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace495_2_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace495_2_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace495_2_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   39, 7,
   nir_op_fmul,
   { &replace495_2_0_1_0.value, &replace495_2_0_1_1.value },
   NULL,
};
static const nir_search_expression replace495_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace495_2_0_0.value, &replace495_2_0_1.value },
   NULL,
};

/* replace495_2_1 -> search471_0_1 in the cache */
static const nir_search_expression replace495_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   35, 11,
   nir_op_fmul,
   { &replace495_2_0.value, &search471_0_1.value },
   NULL,
};
static const nir_search_expression replace495 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 46,
   nir_op_ffma,
   { &replace495_0.value, &replace494_1.value, &replace495_2.value },
   NULL,
};

   /* search496_0 -> search2_0 in the cache */
static const nir_search_expression search496 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2b32,
   { &search2_0.value },
   (is_used_by_if),
};

   /* replace496_0 -> search2_0 in the cache */

/* replace496_1 -> replace9 in the cache */
static const nir_search_expression replace496 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ine32,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search497_0 -> search2_0 in the cache */
static const nir_search_expression search497 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2b1,
   { &search2_0.value },
   (is_used_by_if),
};

   /* replace497_0 -> search2_0 in the cache */

/* replace497_1 -> replace9 in the cache */
/* replace497 -> replace207 in the cache */

   /* search498_0 -> replace80_0 in the cache */

/* search498_1 -> replace209 in the cache */
static const nir_search_expression search498 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace80_0.value, &replace209.value },
   NULL,
};

   /* replace498 -> replace80_0 in the cache */

   /* search499_0 -> replace80_0 in the cache */

/* search499_1 -> replace209 in the cache */
static const nir_search_expression search499 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace80_0.value, &replace209.value },
   (is_not_used_by_if),
};

   /* replace499_0 -> replace80_0 in the cache */
/* replace499 -> replace158 in the cache */

   /* search500_0 -> replace80_0 in the cache */

/* search500_1 -> replace133 in the cache */
static const nir_search_expression search500 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace80_0.value, &replace133.value },
   NULL,
};

   /* replace500 -> replace80_0 in the cache */

   /* search501_0 -> replace80_0 in the cache */

/* search501_1 -> replace133 in the cache */
static const nir_search_expression search501 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace80_0.value, &replace133.value },
   (is_not_used_by_if),
};

   /* replace501_0 -> replace80_0 in the cache */
/* replace501 -> replace158 in the cache */

   /* search502_0 -> replace80_0 in the cache */

/* search502_1 -> replace209 in the cache */

/* search502_2 -> replace133 in the cache */
static const nir_search_expression search502 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace209.value, &replace133.value },
   NULL,
};

   /* replace502 -> replace80_0 in the cache */

   /* search503_0 -> replace80_0 in the cache */

/* search503_1 -> replace133 in the cache */

/* search503_2 -> replace209 in the cache */
static const nir_search_expression search503 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace133.value, &replace209.value },
   NULL,
};

   /* replace503_0 -> replace80_0 in the cache */
/* replace503 -> replace158 in the cache */

   /* search504_0 -> replace80_0 in the cache */

/* search504_1 -> replace60_0_0 in the cache */

/* search504_2 -> search323_0_0 in the cache */
static const nir_search_expression search504 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace60_0_0.value, &search323_0_0.value },
   NULL,
};

   /* replace504_0 -> replace80_0 in the cache */
static const nir_search_expression replace504 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace80_0.value },
   NULL,
};

   /* search505_0 -> replace80_0 in the cache */

/* search505_1 -> search323_0_0 in the cache */

/* search505_2 -> replace60_0_0 in the cache */
static const nir_search_expression search505 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search323_0_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace505_0_0 -> replace80_0 in the cache */
/* replace505_0 -> replace158 in the cache */
static const nir_search_expression replace505 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace158.value },
   NULL,
};

   /* search506_0 -> replace80_0 in the cache */

static const nir_search_constant search506_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0xbff0000000000000L /* -1.0 */ },
};

static const nir_search_constant search506_2 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x8000000000000000L /* -0.0 */ },
};
static const nir_search_expression search506 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search506_1.value, &search506_2.value },
   NULL,
};

   /* replace506_0_0 -> replace80_0 in the cache */
/* replace506_0 -> replace504 in the cache */
static const nir_search_expression replace506 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace504.value },
   NULL,
};

   /* search507_0 -> replace80_0 in the cache */

/* search507_1 -> search506_2 in the cache */

/* search507_2 -> search506_1 in the cache */
static const nir_search_expression search507 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search506_2.value, &search506_1.value },
   NULL,
};

   /* replace507_0_0_0 -> replace80_0 in the cache */
/* replace507_0_0 -> replace158 in the cache */
/* replace507_0 -> replace505 in the cache */
static const nir_search_expression replace507 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace505.value },
   NULL,
};

   /* search508_0 -> replace209 in the cache */

/* search508_1 -> replace149_0 in the cache */

/* search508_2 -> search64_2 in the cache */
static const nir_search_expression search508 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace209.value, &replace149_0.value, &search64_2.value },
   NULL,
};

   /* replace508 -> replace149_0 in the cache */

   /* search509_0 -> replace133 in the cache */

/* search509_1 -> replace149_0 in the cache */

/* search509_2 -> search64_2 in the cache */
static const nir_search_expression search509 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace133.value, &replace149_0.value, &search64_2.value },
   NULL,
};

   /* replace509 -> search64_2 in the cache */

   /* search510_0 -> replace80_0 in the cache */

/* search510_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search510_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace0_1_0.value },
   (is_used_once),
};

/* search510_2_0 -> search56_2 in the cache */
static const nir_search_expression search510_2 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search56_2.value },
   NULL,
};
static const nir_search_expression search510 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search510_1.value, &search510_2.value },
   NULL,
};

   /* replace510_0_0 -> replace80_0 in the cache */

/* replace510_0_1 -> replace0_1_0 in the cache */

/* replace510_0_2 -> search56_2 in the cache */
static const nir_search_expression replace510_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace0_1_0.value, &search56_2.value },
   NULL,
};
static const nir_search_expression replace510 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace510_0.value },
   NULL,
};

   /* search511_0 -> replace80_0 in the cache */

/* search511_1 -> replace14_1_0 in the cache */

/* search511_2 -> replace14_1_0 in the cache */
static const nir_search_expression search511 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace14_1_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace511 -> replace14_1_0 in the cache */

   /* search512_0 -> search0_0 in the cache */

/* search512_1 -> replace0_1_0 in the cache */

/* search512_2 -> replace0_1_0 in the cache */
static const nir_search_expression search512 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_fcsel,
   { &search0_0.value, &replace0_1_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace512 -> replace0_1_0 in the cache */

   /* search513_0 -> replace80_0 in the cache */

static const nir_search_constant search513_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { -0x1 /* -1 */ },
};

/* search513_2 -> search205_1 in the cache */
static const nir_search_expression search513 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search513_1.value, &search205_1.value },
   NULL,
};

   /* replace513_0_0 -> replace80_0 in the cache */
/* replace513_0 -> search205_0 in the cache */
static const nir_search_expression replace513 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search205_0.value },
   NULL,
};

   /* search514_0 -> replace80_0 in the cache */

/* search514_1 -> search205_1 in the cache */

/* search514_2 -> search513_1 in the cache */
static const nir_search_expression search514 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search205_1.value, &search513_1.value },
   NULL,
};

   /* replace514_0_0_0 -> replace80_0 in the cache */
/* replace514_0_0 -> replace158 in the cache */
static const nir_search_expression replace514_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace158.value },
   NULL,
};
static const nir_search_expression replace514 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace514_0.value },
   NULL,
};

   /* search515_0_0_0 -> replace80_0 in the cache */
/* search515_0_0 -> search205_0 in the cache */
/* search515_0 -> replace513 in the cache */

/* search515_1_0_0 -> search160_0_1_0 in the cache */
/* search515_1_0 -> search418_1 in the cache */
static const nir_search_expression search515_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search418_1.value },
   NULL,
};
static const nir_search_expression search515 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace513.value, &search515_1.value },
   NULL,
};

   /* replace515_0_0_0 -> replace80_0 in the cache */

/* replace515_0_0_1 -> search160_0_1_0 in the cache */
/* replace515_0_0 -> replace164 in the cache */
/* replace515_0 -> replace418 in the cache */
static const nir_search_expression replace515 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace418.value },
   NULL,
};

   /* search516_0_0_0 -> replace80_0 in the cache */
/* search516_0_0 -> search205_0 in the cache */
/* search516_0 -> replace513 in the cache */

/* search516_1_0_0 -> search160_0_1_0 in the cache */
/* search516_1_0 -> search418_1 in the cache */
/* search516_1 -> search515_1 in the cache */
static const nir_search_expression search516 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace513.value, &search515_1.value },
   NULL,
};

   /* replace516_0_0_0 -> replace80_0 in the cache */

/* replace516_0_0_1 -> search160_0_1_0 in the cache */
/* replace516_0_0 -> replace160 in the cache */
static const nir_search_expression replace516_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace160.value },
   NULL,
};
static const nir_search_expression replace516 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace516_0.value },
   NULL,
};

   /* search517_0_0_0 -> replace80_0 in the cache */
/* search517_0_0 -> search205_0 in the cache */
/* search517_0 -> replace513 in the cache */

/* search517_1 -> search205_1 in the cache */
static const nir_search_expression search517 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace513.value, &search205_1.value },
   NULL,
};

   /* replace517_0 -> replace80_0 in the cache */
/* replace517 -> replace158 in the cache */

   /* search518_0_0_0 -> replace80_0 in the cache */
/* search518_0_0 -> search205_0 in the cache */
/* search518_0 -> replace513 in the cache */

/* search518_1 -> search513_1 in the cache */
static const nir_search_expression search518 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace513.value, &search513_1.value },
   NULL,
};

   /* replace518 -> replace80_0 in the cache */

   /* search519_0_0_0 -> replace80_0 in the cache */
/* search519_0_0 -> search205_0 in the cache */
/* search519_0 -> replace513 in the cache */

/* search519_1 -> search205_1 in the cache */
static const nir_search_expression search519 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace513.value, &search205_1.value },
   NULL,
};

   /* replace519 -> replace80_0 in the cache */

   /* search520_0_0_0 -> replace80_0 in the cache */
/* search520_0_0 -> search205_0 in the cache */
/* search520_0 -> replace513 in the cache */

/* search520_1 -> search513_1 in the cache */
static const nir_search_expression search520 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace513.value, &search513_1.value },
   NULL,
};

   /* replace520_0 -> replace80_0 in the cache */
/* replace520 -> replace158 in the cache */

   /* search521_0_0_0 -> search2_0 in the cache */
static const nir_search_expression search521_0_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search521_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search521_0_0.value },
   NULL,
};

/* search521_1 -> search162_0_1 in the cache */
static const nir_search_expression search521 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search521_0.value, &search162_0_1.value },
   NULL,
};

   /* replace521_0 -> search2_0 in the cache */
/* replace521 -> search279_0 in the cache */

   /* search522_0_0_0 -> search2_0 in the cache */
/* search522_0_0 -> search521_0_0 in the cache */
/* search522_0 -> search521_0 in the cache */

static const nir_search_constant search522_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression search522 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search521_0.value, &search522_1.value },
   NULL,
};

   /* replace522_0 -> search2_0 in the cache */
/* replace522 -> search521_0_0 in the cache */

   /* search523_0 -> search0_0 in the cache */

/* search523_1_0 -> replace106_1_1 in the cache */

/* search523_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search523_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace106_1_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search523 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search0_0.value, &search523_1.value },
   NULL,
};

   /* replace523_0 -> search0_0 in the cache */

/* replace523_1 -> replace0_1_0 in the cache */
/* replace523 -> search455_0 in the cache */

   /* search524_0 -> search0_0 in the cache */

/* search524_1_0 -> replace106_1_1 in the cache */

/* search524_1_1 -> replace0_1_0 in the cache */
/* search524_1 -> search523_1 in the cache */
static const nir_search_expression search524 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &search0_0.value, &search523_1.value },
   NULL,
};

   /* replace524_0 -> search0_0 in the cache */

/* replace524_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace524 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search525_0 -> search0_0 in the cache */

/* search525_1_0 -> replace106_1_1 in the cache */

/* search525_1_1 -> replace0_1_0 in the cache */
/* search525_1 -> search523_1 in the cache */
static const nir_search_expression search525 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search0_0.value, &search523_1.value },
   NULL,
};

   /* replace525_0 -> search0_0 in the cache */

/* replace525_1 -> replace0_1_0 in the cache */
/* replace525 -> search459_0 in the cache */

   /* search526_0_0 -> search0_0 in the cache */
static const nir_search_expression search526_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search526 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2b32,
   { &search526_0.value },
   NULL,
};

   /* replace526 -> search0_0 in the cache */

   /* search527_0_0 -> search2_0 in the cache */
/* search527_0 -> search65 in the cache */
static const nir_search_expression search527 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search65.value },
   NULL,
};

   /* replace527_0 -> search2_0 in the cache */
static const nir_search_expression replace527 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search2_0.value },
   NULL,
};

   /* search528_0_0 -> search2_0 in the cache */
/* search528_0 -> search65 in the cache */
static const nir_search_expression search528 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search65.value },
   NULL,
};

   /* replace528_0 -> search2_0 in the cache */
static const nir_search_expression replace528 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search2_0.value },
   NULL,
};

   /* search529_0_0 -> search2_0 in the cache */
/* search529_0 -> search16_0 in the cache */
/* search529 -> search23 in the cache */

   /* replace529_0 -> search2_0 in the cache */
/* replace529 -> replace23 in the cache */

   /* search530_0_0 -> search2_0 in the cache */
/* search530_0 -> search20_0 in the cache */
static const nir_search_expression search530 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search20_0.value },
   NULL,
};

   /* replace530_0 -> search2_0 in the cache */
/* replace530 -> replace23 in the cache */

   /* search531_0_0 -> search2_0 in the cache */
static const nir_search_expression search531_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_f2b1,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search531 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search531_0.value },
   NULL,
};

   /* replace531_0 -> search2_0 in the cache */

/* replace531_1 -> search24_1 in the cache */
/* replace531 -> replace221 in the cache */

   /* search532_0_0 -> search0_0 in the cache */
static const nir_search_expression search532_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2i32,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search532 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_i2f32,
   { &search532_0.value },
   NULL,
};

   /* replace532_0 -> search0_0 in the cache */
static const nir_search_expression replace532 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search0_0.value },
   NULL,
};

   /* search533_0_0 -> search0_0 in the cache */
static const nir_search_expression search533_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search533 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2i32,
   { &search533_0.value },
   NULL,
};

   /* replace533 -> search0_0 in the cache */

   /* search534_0_0 -> search0_0 in the cache */
static const nir_search_expression search534_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search534 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2i32,
   { &search534_0.value },
   NULL,
};

   /* replace534 -> search0_0 in the cache */

   /* search535_0_0 -> search0_0 in the cache */
/* search535_0 -> search533_0 in the cache */
static const nir_search_expression search535 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2u32,
   { &search533_0.value },
   NULL,
};

   /* replace535 -> search0_0 in the cache */

   /* search536_0_0 -> search0_0 in the cache */
/* search536_0 -> search534_0 in the cache */
static const nir_search_expression search536 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2u32,
   { &search534_0.value },
   NULL,
};

   /* replace536 -> search0_0 in the cache */

   static const nir_search_variable search537_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_integral),
   {0, 1, 2, 3},
};
static const nir_search_expression search537 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search537_0.value },
   NULL,
};

   /* replace537 -> search2_0 in the cache */

   /* search538_0 -> search537_0 in the cache */
static const nir_search_expression search538 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fceil,
   { &search537_0.value },
   NULL,
};

   /* replace538 -> search2_0 in the cache */

   /* search539_0 -> search537_0 in the cache */
static const nir_search_expression search539 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search537_0.value },
   NULL,
};

   /* replace539 -> search2_0 in the cache */

   /* search540_0 -> search537_0 in the cache */
static const nir_search_expression search540 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_ffract,
   { &search537_0.value },
   NULL,
};

   /* replace540 -> search24_1 in the cache */

   static const nir_search_variable search541_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3},
};
static const nir_search_expression search541 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search541_0.value },
   NULL,
};

   /* replace541 -> search2_0 in the cache */

   /* search542_0 -> search541_0 in the cache */
static const nir_search_expression search542 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search541_0.value },
   NULL,
};

   /* replace542 -> search2_0 in the cache */

   static const nir_search_variable search543_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3},
};
static const nir_search_expression search543 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search543_0.value },
   NULL,
};

   /* replace543 -> search24_1 in the cache */

   /* search544_0_0 -> search2_0 in the cache */
static const nir_search_expression search544_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search2_0.value },
   NULL,
};

/* search544_1 -> replace14_1_0 in the cache */
static const nir_search_expression search544 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search544_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace544_0_0 -> search2_0 in the cache */
static const nir_search_expression replace544_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search2_0.value },
   NULL,
};

/* replace544_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace544 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace544_0.value, &replace14_1_0.value },
   NULL,
};

   static const nir_search_variable search545_0 = {
   { nir_search_value_variable, -1 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search545_1_0 -> search149_1_0 in the cache */
static const nir_search_expression search545_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search149_1_0.value },
   NULL,
};
static const nir_search_expression search545 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search545_0.value, &search545_1.value },
   NULL,
};

   /* replace545_0 -> search545_0 in the cache */

/* replace545_1_0 -> search149_1_0 in the cache */
static const nir_search_expression replace545_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search149_1_0.value },
   NULL,
};
static const nir_search_expression replace545 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search545_0.value, &replace545_1.value },
   NULL,
};

   /* search546_0_0 -> search2_0 in the cache */
/* search546_0 -> search544_0 in the cache */

/* search546_1 -> replace14_1_0 in the cache */
static const nir_search_expression search546 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search544_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace546_0_0 -> search2_0 in the cache */
/* replace546_0 -> replace544_0 in the cache */

/* replace546_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace546 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace544_0.value, &replace14_1_0.value },
   NULL,
};

   /* search547_0 -> search545_0 in the cache */

/* search547_1_0 -> search149_1_0 in the cache */
/* search547_1 -> search545_1 in the cache */
static const nir_search_expression search547 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search545_0.value, &search545_1.value },
   NULL,
};

   /* replace547_0 -> search545_0 in the cache */

/* replace547_1_0 -> search149_1_0 in the cache */
/* replace547_1 -> replace545_1 in the cache */
static const nir_search_expression replace547 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search545_0.value, &replace545_1.value },
   NULL,
};

   /* search548_0 -> search541_0 in the cache */

/* search548_1 -> search41_1 in the cache */
static const nir_search_expression search548 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmin,
   { &search541_0.value, &search41_1.value },
   NULL,
};

   /* replace548_0 -> search2_0 in the cache */
/* replace548 -> search36_0 in the cache */

   /* search549_0_0_0_0 -> search2_0 in the cache */
/* search549_0_0_0 -> search36_0 in the cache */

/* search549_0_0_1_0_0 -> search2_0 in the cache */
/* search549_0_0_1_0 -> search36_0 in the cache */
static const nir_search_expression search549_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search36_0.value },
   NULL,
};
static const nir_search_expression search549_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search36_0.value, &search549_0_0_1.value },
   NULL,
};

/* search549_0_1 -> search41_1 in the cache */
static const nir_search_expression search549_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &search549_0_0.value, &search41_1.value },
   NULL,
};

/* search549_1 -> search24_1 in the cache */
static const nir_search_expression search549 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_flt,
   { &search549_0.value, &search24_1.value },
   NULL,
};

   /* replace549 -> replace133 in the cache */

   /* search550_0_0_0_0_0 -> search2_0 in the cache */
/* search550_0_0_0_0 -> search36_0 in the cache */

/* search550_0_0_0_1_0 -> search2_0 in the cache */
/* search550_0_0_0_1 -> search36_0 in the cache */
static const nir_search_expression search550_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search36_0.value, &search36_0.value },
   NULL,
};
static const nir_search_expression search550_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search550_0_0_0.value },
   NULL,
};

/* search550_0_1 -> search41_1 in the cache */
static const nir_search_expression search550_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search550_0_0.value, &search41_1.value },
   NULL,
};

/* search550_1 -> search24_1 in the cache */
static const nir_search_expression search550 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search550_0.value, &search24_1.value },
   NULL,
};

   /* replace550 -> replace133 in the cache */

   /* search551_0_0_0_0 -> search2_0 in the cache */
/* search551_0_0_0 -> search36_0 in the cache */

/* search551_0_0_1_0_0 -> search2_0 in the cache */
/* search551_0_0_1_0 -> search36_0 in the cache */
/* search551_0_0_1 -> search549_0_0_1 in the cache */
/* search551_0_0 -> search549_0_0 in the cache */

/* search551_0_1 -> search41_1 in the cache */
/* search551_0 -> search549_0 in the cache */

/* search551_1 -> search24_1 in the cache */
static const nir_search_expression search551 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_fmax,
   { &search549_0.value, &search24_1.value },
   NULL,
};

   /* replace551_0_0_0 -> search2_0 in the cache */
/* replace551_0_0 -> search36_0 in the cache */

/* replace551_0_1_0_0 -> search2_0 in the cache */
/* replace551_0_1_0 -> search36_0 in the cache */
/* replace551_0_1 -> search549_0_0_1 in the cache */
/* replace551_0 -> search549_0_0 in the cache */

/* replace551_1 -> search41_1 in the cache */
/* replace551 -> search549_0 in the cache */

   /* search552_0_0_0_0_0 -> search2_0 in the cache */
/* search552_0_0_0_0 -> search36_0 in the cache */

/* search552_0_0_0_1_0 -> search2_0 in the cache */
/* search552_0_0_0_1 -> search36_0 in the cache */
/* search552_0_0_0 -> search550_0_0_0 in the cache */
/* search552_0_0 -> search550_0_0 in the cache */

/* search552_0_1 -> search41_1 in the cache */
/* search552_0 -> search550_0 in the cache */

/* search552_1 -> search24_1 in the cache */
static const nir_search_expression search552 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fmax,
   { &search550_0.value, &search24_1.value },
   NULL,
};

   /* replace552_0_0_0_0 -> search2_0 in the cache */
/* replace552_0_0_0 -> search36_0 in the cache */

/* replace552_0_0_1_0 -> search2_0 in the cache */
/* replace552_0_0_1 -> search36_0 in the cache */
/* replace552_0_0 -> search550_0_0_0 in the cache */
/* replace552_0 -> search550_0_0 in the cache */

/* replace552_1 -> search41_1 in the cache */
/* replace552 -> search550_0 in the cache */

   static const nir_search_variable search553_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_zero),
   {0, 1, 2, 3},
};

/* search553_1 -> search24_1 in the cache */
static const nir_search_expression search553 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search553_0.value, &search24_1.value },
   NULL,
};

   /* replace553 -> replace209 in the cache */

   /* search554_0 -> search553_0 in the cache */

/* search554_1 -> search24_1 in the cache */
static const nir_search_expression search554 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search553_0.value, &search24_1.value },
   NULL,
};

   /* replace554 -> replace133 in the cache */

   static const nir_search_variable search555_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3},
};

static const nir_search_variable search555_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3},
};
static const nir_search_expression search555 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &search555_0.value, &search555_1.value },
   NULL,
};

   /* replace555 -> replace209 in the cache */

   static const nir_search_variable search556_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3},
};

static const nir_search_variable search556_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_gt_zero),
   {0, 1, 2, 3},
};
static const nir_search_expression search556 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search556_0.value, &search556_1.value },
   NULL,
};

   /* replace556 -> replace133 in the cache */

   static const nir_search_variable search557_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_lt_zero),
   {0, 1, 2, 3},
};

static const nir_search_variable search557_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3},
};
static const nir_search_expression search557 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search557_0.value, &search557_1.value },
   NULL,
};

   /* replace557 -> replace133 in the cache */

   /* search558_0 -> search555_0 in the cache */

/* search558_1 -> search555_1 in the cache */
static const nir_search_expression search558 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search555_0.value, &search555_1.value },
   NULL,
};

   /* replace558 -> replace133 in the cache */

   /* search559_0 -> search556_0 in the cache */

/* search559_1 -> search556_1 in the cache */
static const nir_search_expression search559 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search556_0.value, &search556_1.value },
   NULL,
};

   /* replace559 -> replace209 in the cache */

   /* search560_0 -> search557_0 in the cache */

/* search560_1 -> search557_1 in the cache */
static const nir_search_expression search560 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search557_0.value, &search557_1.value },
   NULL,
};

   /* replace560 -> replace209 in the cache */

   /* search561_0 -> search553_0 in the cache */

/* search561_1 -> replace9 in the cache */
static const nir_search_expression search561 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search553_0.value, &replace9.value },
   NULL,
};

   /* replace561 -> replace209 in the cache */

   /* search562_0 -> search553_0 in the cache */

/* search562_1 -> replace9 in the cache */
static const nir_search_expression search562 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search553_0.value, &replace9.value },
   NULL,
};

   /* replace562 -> replace133 in the cache */

   /* search563_0 -> search555_0 in the cache */

/* search563_1 -> search555_1 in the cache */
static const nir_search_expression search563 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search555_0.value, &search555_1.value },
   NULL,
};

   /* replace563 -> replace209 in the cache */

   /* search564_0 -> search556_0 in the cache */

/* search564_1 -> search556_1 in the cache */
static const nir_search_expression search564 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search556_0.value, &search556_1.value },
   NULL,
};

   /* replace564 -> replace133 in the cache */

   /* search565_0 -> search557_0 in the cache */

/* search565_1 -> search557_1 in the cache */
static const nir_search_expression search565 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search557_0.value, &search557_1.value },
   NULL,
};

   /* replace565 -> replace133 in the cache */

   /* search566_0 -> search555_0 in the cache */

/* search566_1 -> search555_1 in the cache */
static const nir_search_expression search566 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search555_0.value, &search555_1.value },
   NULL,
};

   /* replace566 -> replace133 in the cache */

   /* search567_0 -> search556_0 in the cache */

/* search567_1 -> search556_1 in the cache */
static const nir_search_expression search567 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search556_0.value, &search556_1.value },
   NULL,
};

   /* replace567 -> replace209 in the cache */

   /* search568_0 -> search557_0 in the cache */

/* search568_1 -> search557_1 in the cache */
static const nir_search_expression search568 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search557_0.value, &search557_1.value },
   NULL,
};

   /* replace568 -> replace209 in the cache */

   /* search569_0 -> replace9 in the cache */

static const nir_search_variable search569_1 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_gt_zero),
   {0, 1, 2, 3},
};
static const nir_search_expression search569 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace9.value, &search569_1.value },
   NULL,
};

   /* replace569 -> replace209 in the cache */

   /* search570_0_0 -> search0_0 in the cache */

/* search570_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search570_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_64_2x32_split,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search570 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_x,
   { &search570_0.value },
   NULL,
};

   /* replace570 -> search0_0 in the cache */

   /* search571_0_0 -> search0_0 in the cache */

/* search571_0_1 -> replace0_1_0 in the cache */
/* search571_0 -> search570_0 in the cache */
static const nir_search_expression search571 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_y,
   { &search570_0.value },
   NULL,
};

   /* replace571 -> replace0_1_0 in the cache */

   /* search572_0_0 -> search57_0 in the cache */
static const nir_search_expression search572_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_x,
   { &search57_0.value },
   NULL,
};

/* search572_1_0 -> search57_0 in the cache */
static const nir_search_expression search572_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_y,
   { &search57_0.value },
   NULL,
};
static const nir_search_expression search572 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_64_2x32_split,
   { &search572_0.value, &search572_1.value },
   NULL,
};

   /* replace572 -> search57_0 in the cache */

   /* search573_0_0_0 -> search0_0 in the cache */
static const nir_search_expression search573_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_unpack_32_2x16_split_x,
   { &search0_0.value },
   NULL,
};

static const nir_search_variable search573_0_1 = {
   { nir_search_value_variable, 16 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search573_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search573_0_0.value, &search573_0_1.value },
   NULL,
};

/* search573_1_0_0 -> search0_0 in the cache */
static const nir_search_expression search573_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_unpack_32_2x16_split_y,
   { &search0_0.value },
   NULL,
};

static const nir_search_variable search573_1_1 = {
   { nir_search_value_variable, 16 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search573_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search573_1_0.value, &search573_1_1.value },
   NULL,
};
static const nir_search_expression search573 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search573_0.value, &search573_1.value },
   NULL,
};

   /* replace573_0 -> search0_0 in the cache */

static const nir_search_variable replace573_1_0 = {
   { nir_search_value_variable, 16 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable replace573_1_1 = {
   { nir_search_value_variable, 16 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression replace573_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_32_2x16_split,
   { &replace573_1_0.value, &replace573_1_1.value },
   NULL,
};
static const nir_search_expression replace573 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &replace573_1.value },
   NULL,
};

   /* search574_0 -> search101_0_0 in the cache */

/* search574_1 -> replace98_0_1 in the cache */
static const nir_search_expression search574 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search101_0_0.value, &replace98_0_1.value },
   NULL,
};

   /* replace574_0 -> search101_0_0 in the cache */

static const nir_search_constant replace574_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace574 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search101_0_0.value, &replace574_1.value },
   NULL,
};

   /* search575_0 -> search0_0 in the cache */

/* search575_1 -> search451_1_1 in the cache */
/* search575 -> search451_1 in the cache */

   /* replace575_0 -> search0_0 in the cache */

/* replace575_1 -> search114_0_1 in the cache */
static const nir_search_expression replace575 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &search114_0_1.value },
   NULL,
};

   /* search576_0 -> search57_0 in the cache */

static const nir_search_constant search576_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x38 /* 56 */ },
};
static const nir_search_expression search576 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &search576_1.value },
   NULL,
};

   /* replace576_0 -> search57_0 in the cache */

static const nir_search_constant replace576_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7 /* 7 */ },
};
static const nir_search_expression replace576 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace576_1.value },
   NULL,
};

   /* search577_0 -> search101_0_0 in the cache */

/* search577_1 -> replace98_0_1 in the cache */
static const nir_search_expression search577 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search101_0_0.value, &replace98_0_1.value },
   NULL,
};

   /* replace577_0 -> search101_0_0 in the cache */

/* replace577_1 -> replace574_1 in the cache */
static const nir_search_expression replace577 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search101_0_0.value, &replace574_1.value },
   NULL,
};

   /* search578_0 -> search0_0 in the cache */

/* search578_1 -> search451_1_1 in the cache */
static const nir_search_expression search578 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &search451_1_1.value },
   NULL,
};

   /* replace578_0 -> search0_0 in the cache */

/* replace578_1 -> search114_0_1 in the cache */
static const nir_search_expression replace578 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &search114_0_1.value },
   NULL,
};

   /* search579_0 -> search57_0 in the cache */

/* search579_1 -> search576_1 in the cache */
static const nir_search_expression search579 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &search576_1.value },
   NULL,
};

   /* replace579_0 -> search57_0 in the cache */

/* replace579_1 -> replace576_1 in the cache */
static const nir_search_expression replace579 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace576_1.value },
   NULL,
};

   /* search580_0 -> search290_0_1 in the cache */

/* search580_1 -> search2_0 in the cache */
static const nir_search_expression search580 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search290_0_1.value, &search2_0.value },
   NULL,
};

   /* replace580_0 -> search2_0 in the cache */

/* replace580_1 -> replace9 in the cache */
static const nir_search_expression replace580 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search581_0_0 -> search0_0 in the cache */

/* search581_0_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression search581_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace101_0_0_0_1.value },
   NULL,
};
static const nir_search_expression search581 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_half_2x16_split_x,
   { &search581_0.value },
   NULL,
};

   /* replace581_0 -> search0_0 in the cache */
static const nir_search_expression replace581 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_half_2x16_split_x,
   { &search0_0.value },
   NULL,
};

   /* search582_0_0 -> search0_0 in the cache */

/* search582_0_1 -> replace101_0_0_0_1 in the cache */
/* search582_0 -> search581_0 in the cache */
static const nir_search_expression search582 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_unpack_32_2x16_split_x,
   { &search581_0.value },
   NULL,
};

   /* replace582_0 -> search0_0 in the cache */
/* replace582 -> search573_0_0 in the cache */

   /* search583_0_0 -> search57_0 in the cache */

static const nir_search_constant search583_0_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xffffffff /* 4294967295 */ },
};
static const nir_search_expression search583_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search57_0.value, &search583_0_1.value },
   NULL,
};
static const nir_search_expression search583 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search583_0.value },
   NULL,
};

   /* replace583_0 -> search57_0 in the cache */
/* replace583 -> search572_0 in the cache */

   /* search584_0_0 -> search0_0 in the cache */

static const nir_search_constant search584_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffff0000 /* 4294901760 */ },
};
static const nir_search_expression search584_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &search584_0_1.value },
   NULL,
};
static const nir_search_expression search584 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_half_2x16_split_y,
   { &search584_0.value },
   NULL,
};

   /* replace584_0 -> search0_0 in the cache */
static const nir_search_expression replace584 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_half_2x16_split_y,
   { &search0_0.value },
   NULL,
};

   /* search585_0_0 -> search0_0 in the cache */

/* search585_0_1 -> search584_0_1 in the cache */
/* search585_0 -> search584_0 in the cache */
static const nir_search_expression search585 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_unpack_32_2x16_split_y,
   { &search584_0.value },
   NULL,
};

   /* replace585_0 -> search0_0 in the cache */
/* replace585 -> search573_1_0 in the cache */

   /* search586_0_0 -> search57_0 in the cache */

static const nir_search_constant search586_0_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xffffffff00000000 /* 18446744069414584320 */ },
};
static const nir_search_expression search586_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search57_0.value, &search586_0_1.value },
   NULL,
};
static const nir_search_expression search586 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_y,
   { &search586_0.value },
   NULL,
};

   /* replace586_0 -> search57_0 in the cache */
/* replace586 -> search572_1 in the cache */

   /* search587_0_0_0 -> search0_0 in the cache */

/* search587_0_0_1 -> search26_1 in the cache */
static const nir_search_expression search587_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search0_0.value, &search26_1.value },
   NULL,
};
static const nir_search_expression search587_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16,
   { &search587_0_0.value },
   NULL,
};

/* search587_1 -> replace101_0_1 in the cache */
static const nir_search_expression search587 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search587_0.value, &replace101_0_1.value },
   NULL,
};

   /* replace587_0_0 -> search26_1 in the cache */

/* replace587_0_1 -> search0_0 in the cache */
static const nir_search_expression replace587_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search26_1.value, &search0_0.value },
   NULL,
};
static const nir_search_expression replace587 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16,
   { &replace587_0.value },
   NULL,
};

   /* search588_0_0_0 -> search26_1 in the cache */

/* search588_0_0_1 -> search0_0 in the cache */
/* search588_0_0 -> replace587_0 in the cache */
/* search588_0 -> replace587 in the cache */

/* search588_1 -> replace101_0_1 in the cache */
static const nir_search_expression search588 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace587.value, &replace101_0_1.value },
   NULL,
};

   /* replace588_0_0 -> search0_0 in the cache */

/* replace588_0_1 -> search26_1 in the cache */
/* replace588_0 -> search587_0_0 in the cache */
/* replace588 -> search587_0 in the cache */

   /* search589_0_0_0 -> search0_0 in the cache */

/* search589_0_0_1 -> search26_1 in the cache */
/* search589_0_0 -> search587_0_0 in the cache */
/* search589_0 -> search587_0 in the cache */

/* search589_1_0_0 -> search26_1 in the cache */

/* search589_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search589_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search26_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search589_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16,
   { &search589_1_0.value },
   NULL,
};
static const nir_search_expression search589 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search587_0.value, &search589_1.value },
   NULL,
};

   /* replace589_0_0 -> search0_0 in the cache */

/* replace589_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace589_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace589 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16,
   { &replace589_0.value },
   NULL,
};

   /* search590_0_0_0 -> search0_0 in the cache */

/* search590_0_0_1 -> search26_1 in the cache */
/* search590_0_0 -> search587_0_0 in the cache */
/* search590_0 -> search587_0 in the cache */

/* search590_1_0_0 -> search26_1 in the cache */

/* search590_1_0_1 -> replace0_1_0 in the cache */
/* search590_1_0 -> search589_1_0 in the cache */
/* search590_1 -> search589_1 in the cache */
static const nir_search_expression search590 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search587_0.value, &search589_1.value },
   NULL,
};

   /* replace590_0_0 -> search0_0 in the cache */

/* replace590_0_1 -> replace0_1_0 in the cache */
/* replace590_0 -> replace589_0 in the cache */
/* replace590 -> replace589 in the cache */

   /* search591_0_0 -> search101_0_0 in the cache */

/* search591_0_1 -> replace98_0_1 in the cache */
/* search591_0 -> search574 in the cache */

/* search591_1 -> replace101_2 in the cache */
static const nir_search_expression search591 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search574.value, &replace101_2.value },
   NULL,
};

   /* replace591_0 -> search101_0_0 in the cache */

/* replace591_1 -> replace574_1 in the cache */
/* replace591 -> replace574 in the cache */

   /* search592_0_0 -> search0_0 in the cache */

/* search592_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search592_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &replace98_0_1.value },
   NULL,
};

/* search592_1 -> search26_1 in the cache */
static const nir_search_expression search592 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search592_0.value, &search26_1.value },
   NULL,
};

   /* replace592_0 -> search0_0 in the cache */

/* replace592_1 -> search110_0_1 in the cache */
static const nir_search_expression replace592 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &search110_0_1.value },
   NULL,
};

   /* search593_0_0 -> search0_0 in the cache */

/* search593_0_1 -> replace101_0_1 in the cache */
/* search593_0 -> search452_1 in the cache */

/* search593_1 -> search26_1 in the cache */
static const nir_search_expression search593 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search452_1.value, &search26_1.value },
   NULL,
};

   /* replace593_0 -> search0_0 in the cache */

/* replace593_1 -> search112_0_1 in the cache */
static const nir_search_expression replace593 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &search112_0_1.value },
   NULL,
};

   /* search594_0_0 -> search0_0 in the cache */

/* search594_0_1 -> search451_1_1 in the cache */
/* search594_0 -> search451_1 in the cache */

/* search594_1 -> search26_1 in the cache */
static const nir_search_expression search594 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search451_1.value, &search26_1.value },
   NULL,
};

   /* replace594_0 -> search0_0 in the cache */

/* replace594_1 -> search114_0_1 in the cache */
/* replace594 -> replace575 in the cache */

   /* search595_0_0 -> search57_0 in the cache */

/* search595_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search595_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &replace98_0_1.value },
   NULL,
};

/* search595_1 -> replace107_2 in the cache */
static const nir_search_expression search595 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search595_0.value, &replace107_2.value },
   NULL,
};

   /* replace595_0 -> search57_0 in the cache */

static const nir_search_constant replace595_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace595 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace595_1.value },
   NULL,
};

   /* search596_0_0 -> search57_0 in the cache */

/* search596_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression search596_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &replace101_0_1.value },
   NULL,
};

/* search596_1 -> replace107_2 in the cache */
static const nir_search_expression search596 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search596_0.value, &replace107_2.value },
   NULL,
};

   /* replace596_0 -> search57_0 in the cache */

static const nir_search_constant replace596_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression replace596 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace596_1.value },
   NULL,
};

   /* search597_0_0 -> search57_0 in the cache */

/* search597_0_1 -> search451_1_1 in the cache */
static const nir_search_expression search597_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &search451_1_1.value },
   NULL,
};

/* search597_1 -> replace107_2 in the cache */
static const nir_search_expression search597 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search597_0.value, &replace107_2.value },
   NULL,
};

   /* replace597_0 -> search57_0 in the cache */

static const nir_search_constant replace597_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression replace597 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace597_1.value },
   NULL,
};

   /* search598_0_0 -> search57_0 in the cache */

/* search598_0_1 -> replace104_0_1 in the cache */
static const nir_search_expression search598_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &replace104_0_1.value },
   NULL,
};

/* search598_1 -> replace107_2 in the cache */
static const nir_search_expression search598 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search598_0.value, &replace107_2.value },
   NULL,
};

   /* replace598_0 -> search57_0 in the cache */

static const nir_search_constant replace598_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x4 /* 4 */ },
};
static const nir_search_expression replace598 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace598_1.value },
   NULL,
};

   /* search599_0_0 -> search57_0 in the cache */

static const nir_search_constant search599_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x28 /* 40 */ },
};
static const nir_search_expression search599_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &search599_0_1.value },
   NULL,
};

/* search599_1 -> replace107_2 in the cache */
static const nir_search_expression search599 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search599_0.value, &replace107_2.value },
   NULL,
};

   /* replace599_0 -> search57_0 in the cache */

static const nir_search_constant replace599_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x5 /* 5 */ },
};
static const nir_search_expression replace599 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace599_1.value },
   NULL,
};

   /* search600_0_0 -> search57_0 in the cache */

static const nir_search_constant search600_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x30 /* 48 */ },
};
static const nir_search_expression search600_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &search600_0_1.value },
   NULL,
};

/* search600_1 -> replace107_2 in the cache */
static const nir_search_expression search600 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search600_0.value, &replace107_2.value },
   NULL,
};

   /* replace600_0 -> search57_0 in the cache */

static const nir_search_constant replace600_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x6 /* 6 */ },
};
static const nir_search_expression replace600 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace600_1.value },
   NULL,
};

   /* search601_0_0 -> search57_0 in the cache */

/* search601_0_1 -> search576_1 in the cache */
/* search601_0 -> search576 in the cache */

/* search601_1 -> replace107_2 in the cache */
static const nir_search_expression search601 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search576.value, &replace107_2.value },
   NULL,
};

   /* replace601_0 -> search57_0 in the cache */

/* replace601_1 -> replace576_1 in the cache */
/* replace601 -> replace576 in the cache */

   /* search602_0_0 -> search101_0_0 in the cache */

/* search602_0_1 -> replace98_0_1 in the cache */
/* search602_0 -> search577 in the cache */

/* search602_1 -> replace101_2 in the cache */
static const nir_search_expression search602 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search577.value, &replace101_2.value },
   NULL,
};

   /* replace602_0 -> search101_0_0 in the cache */

/* replace602_1 -> replace574_1 in the cache */
/* replace602 -> replace574 in the cache */

   /* search603_0_0 -> search0_0 in the cache */

/* search603_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search603_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &replace98_0_1.value },
   NULL,
};

/* search603_1 -> search26_1 in the cache */
static const nir_search_expression search603 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search603_0.value, &search26_1.value },
   NULL,
};

   /* replace603_0 -> search0_0 in the cache */

/* replace603_1 -> search110_0_1 in the cache */
/* replace603 -> replace592 in the cache */

   /* search604_0_0 -> search0_0 in the cache */

/* search604_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression search604_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &replace101_0_1.value },
   NULL,
};

/* search604_1 -> search26_1 in the cache */
static const nir_search_expression search604 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search604_0.value, &search26_1.value },
   NULL,
};

   /* replace604_0 -> search0_0 in the cache */

/* replace604_1 -> search112_0_1 in the cache */
/* replace604 -> replace593 in the cache */

   /* search605_0_0 -> search0_0 in the cache */

/* search605_0_1 -> search451_1_1 in the cache */
/* search605_0 -> search578 in the cache */

/* search605_1 -> search26_1 in the cache */
static const nir_search_expression search605 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search578.value, &search26_1.value },
   NULL,
};

   /* replace605_0 -> search0_0 in the cache */

/* replace605_1 -> search114_0_1 in the cache */
/* replace605 -> replace575 in the cache */

   /* search606_0_0 -> search57_0 in the cache */

/* search606_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search606_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &replace98_0_1.value },
   NULL,
};

/* search606_1 -> replace107_2 in the cache */
static const nir_search_expression search606 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search606_0.value, &replace107_2.value },
   NULL,
};

   /* replace606_0 -> search57_0 in the cache */

/* replace606_1 -> replace595_1 in the cache */
/* replace606 -> replace595 in the cache */

   /* search607_0_0 -> search57_0 in the cache */

/* search607_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression search607_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &replace101_0_1.value },
   NULL,
};

/* search607_1 -> replace107_2 in the cache */
static const nir_search_expression search607 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search607_0.value, &replace107_2.value },
   NULL,
};

   /* replace607_0 -> search57_0 in the cache */

/* replace607_1 -> replace596_1 in the cache */
/* replace607 -> replace596 in the cache */

   /* search608_0_0 -> search57_0 in the cache */

/* search608_0_1 -> search451_1_1 in the cache */
static const nir_search_expression search608_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &search451_1_1.value },
   NULL,
};

/* search608_1 -> replace107_2 in the cache */
static const nir_search_expression search608 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search608_0.value, &replace107_2.value },
   NULL,
};

   /* replace608_0 -> search57_0 in the cache */

/* replace608_1 -> replace597_1 in the cache */
/* replace608 -> replace597 in the cache */

   /* search609_0_0 -> search57_0 in the cache */

/* search609_0_1 -> replace104_0_1 in the cache */
static const nir_search_expression search609_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &replace104_0_1.value },
   NULL,
};

/* search609_1 -> replace107_2 in the cache */
static const nir_search_expression search609 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search609_0.value, &replace107_2.value },
   NULL,
};

   /* replace609_0 -> search57_0 in the cache */

/* replace609_1 -> replace598_1 in the cache */
/* replace609 -> replace598 in the cache */

   /* search610_0_0 -> search57_0 in the cache */

/* search610_0_1 -> search599_0_1 in the cache */
static const nir_search_expression search610_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &search599_0_1.value },
   NULL,
};

/* search610_1 -> replace107_2 in the cache */
static const nir_search_expression search610 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search610_0.value, &replace107_2.value },
   NULL,
};

   /* replace610_0 -> search57_0 in the cache */

/* replace610_1 -> replace599_1 in the cache */
/* replace610 -> replace599 in the cache */

   /* search611_0_0 -> search57_0 in the cache */

/* search611_0_1 -> search600_0_1 in the cache */
static const nir_search_expression search611_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &search600_0_1.value },
   NULL,
};

/* search611_1 -> replace107_2 in the cache */
static const nir_search_expression search611 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search611_0.value, &replace107_2.value },
   NULL,
};

   /* replace611_0 -> search57_0 in the cache */

/* replace611_1 -> replace600_1 in the cache */
/* replace611 -> replace600 in the cache */

   /* search612_0_0 -> search57_0 in the cache */

/* search612_0_1 -> search576_1 in the cache */
/* search612_0 -> search579 in the cache */

/* search612_1 -> replace107_2 in the cache */
static const nir_search_expression search612 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search579.value, &replace107_2.value },
   NULL,
};

   /* replace612_0 -> search57_0 in the cache */

/* replace612_1 -> replace576_1 in the cache */
/* replace612 -> replace576 in the cache */

   /* search613_0_0 -> search2_0 in the cache */

/* search613_0_1 -> replace2_1_0 in the cache */
static const nir_search_expression search613_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

/* search613_1 -> replace9 in the cache */
static const nir_search_expression search613 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search613_0.value, &replace9.value },
   NULL,
};

   /* replace613_0 -> search2_0 in the cache */

/* replace613_1 -> search332_1_1 in the cache */
static const nir_search_expression replace613 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search2_0.value, &search332_1_1.value },
   NULL,
};

   /* search614_0_0 -> search101_0_0 in the cache */

/* search614_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search614_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search101_0_0.value, &replace98_0_1.value },
   NULL,
};

/* search614_1 -> replace574_1 in the cache */
static const nir_search_expression search614 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search614_0.value, &replace574_1.value },
   NULL,
};

   /* replace614_0 -> search101_0_0 in the cache */

/* replace614_1 -> replace101_2 in the cache */
static const nir_search_expression replace614 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search101_0_0.value, &replace101_2.value },
   NULL,
};

   /* search615_0_0 -> search0_0 in the cache */

/* search615_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search615_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace98_0_1.value },
   NULL,
};

/* search615_1 -> search114_0_1 in the cache */
static const nir_search_expression search615 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search615_0.value, &search114_0_1.value },
   NULL,
};

   /* replace615_0 -> search0_0 in the cache */

/* replace615_1 -> search112_0_1 in the cache */
/* replace615 -> replace593 in the cache */

   /* search616_0_0 -> search0_0 in the cache */

/* search616_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression search616_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace101_0_1.value },
   NULL,
};

/* search616_1 -> search114_0_1 in the cache */
static const nir_search_expression search616 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search616_0.value, &search114_0_1.value },
   NULL,
};

   /* replace616_0 -> search0_0 in the cache */

/* replace616_1 -> search110_0_1 in the cache */
/* replace616 -> replace592 in the cache */

   /* search617_0_0 -> search0_0 in the cache */

/* search617_0_1 -> search451_1_1 in the cache */
static const nir_search_expression search617_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &search451_1_1.value },
   NULL,
};

/* search617_1 -> search114_0_1 in the cache */
static const nir_search_expression search617 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search617_0.value, &search114_0_1.value },
   NULL,
};

   /* replace617_0 -> search0_0 in the cache */

/* replace617_1 -> search26_1 in the cache */
static const nir_search_expression replace617 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* search618_0_0 -> search57_0 in the cache */

/* search618_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search618_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &replace98_0_1.value },
   NULL,
};

/* search618_1 -> replace576_1 in the cache */
static const nir_search_expression search618 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search618_0.value, &replace576_1.value },
   NULL,
};

   /* replace618_0 -> search57_0 in the cache */

/* replace618_1 -> replace600_1 in the cache */
/* replace618 -> replace600 in the cache */

   /* search619_0_0 -> search57_0 in the cache */

/* search619_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression search619_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &replace101_0_1.value },
   NULL,
};

/* search619_1 -> replace576_1 in the cache */
static const nir_search_expression search619 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search619_0.value, &replace576_1.value },
   NULL,
};

   /* replace619_0 -> search57_0 in the cache */

/* replace619_1 -> replace599_1 in the cache */
/* replace619 -> replace599 in the cache */

   /* search620_0_0 -> search57_0 in the cache */

/* search620_0_1 -> search451_1_1 in the cache */
static const nir_search_expression search620_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &search451_1_1.value },
   NULL,
};

/* search620_1 -> replace576_1 in the cache */
static const nir_search_expression search620 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search620_0.value, &replace576_1.value },
   NULL,
};

   /* replace620_0 -> search57_0 in the cache */

/* replace620_1 -> replace598_1 in the cache */
/* replace620 -> replace598 in the cache */

   /* search621_0_0 -> search57_0 in the cache */

/* search621_0_1 -> replace104_0_1 in the cache */
static const nir_search_expression search621_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &replace104_0_1.value },
   NULL,
};

/* search621_1 -> replace576_1 in the cache */
static const nir_search_expression search621 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search621_0.value, &replace576_1.value },
   NULL,
};

   /* replace621_0 -> search57_0 in the cache */

/* replace621_1 -> replace597_1 in the cache */
/* replace621 -> replace597 in the cache */

   /* search622_0_0 -> search57_0 in the cache */

/* search622_0_1 -> search599_0_1 in the cache */
static const nir_search_expression search622_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &search599_0_1.value },
   NULL,
};

/* search622_1 -> replace576_1 in the cache */
static const nir_search_expression search622 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search622_0.value, &replace576_1.value },
   NULL,
};

   /* replace622_0 -> search57_0 in the cache */

/* replace622_1 -> replace596_1 in the cache */
/* replace622 -> replace596 in the cache */

   /* search623_0_0 -> search57_0 in the cache */

/* search623_0_1 -> search600_0_1 in the cache */
static const nir_search_expression search623_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &search600_0_1.value },
   NULL,
};

/* search623_1 -> replace576_1 in the cache */
static const nir_search_expression search623 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search623_0.value, &replace576_1.value },
   NULL,
};

   /* replace623_0 -> search57_0 in the cache */

/* replace623_1 -> replace595_1 in the cache */
/* replace623 -> replace595 in the cache */

   /* search624_0_0 -> search57_0 in the cache */

/* search624_0_1 -> search576_1 in the cache */
static const nir_search_expression search624_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &search576_1.value },
   NULL,
};

/* search624_1 -> replace576_1 in the cache */
static const nir_search_expression search624 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search624_0.value, &replace576_1.value },
   NULL,
};

   /* replace624_0 -> search57_0 in the cache */

/* replace624_1 -> replace107_2 in the cache */
static const nir_search_expression replace624 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

   /* search625_0_0 -> search101_0_0 in the cache */

/* search625_0_1 -> replace98_0_1 in the cache */
/* search625_0 -> search614_0 in the cache */

/* search625_1 -> replace574_1 in the cache */
static const nir_search_expression search625 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search614_0.value, &replace574_1.value },
   NULL,
};

   /* replace625_0 -> search101_0_0 in the cache */

/* replace625_1 -> replace101_2 in the cache */
static const nir_search_expression replace625 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search101_0_0.value, &replace101_2.value },
   NULL,
};

   /* search626_0_0 -> search0_0 in the cache */

/* search626_0_1 -> replace98_0_1 in the cache */
/* search626_0 -> search615_0 in the cache */

/* search626_1 -> search114_0_1 in the cache */
static const nir_search_expression search626 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search615_0.value, &search114_0_1.value },
   NULL,
};

   /* replace626_0 -> search0_0 in the cache */

/* replace626_1 -> search112_0_1 in the cache */
static const nir_search_expression replace626 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &search112_0_1.value },
   NULL,
};

   /* search627_0_0 -> search0_0 in the cache */

/* search627_0_1 -> replace101_0_1 in the cache */
/* search627_0 -> search616_0 in the cache */

/* search627_1 -> search114_0_1 in the cache */
static const nir_search_expression search627 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search616_0.value, &search114_0_1.value },
   NULL,
};

   /* replace627_0 -> search0_0 in the cache */

/* replace627_1 -> search110_0_1 in the cache */
static const nir_search_expression replace627 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &search110_0_1.value },
   NULL,
};

   /* search628_0_0 -> search0_0 in the cache */

/* search628_0_1 -> search451_1_1 in the cache */
/* search628_0 -> search617_0 in the cache */

/* search628_1 -> search114_0_1 in the cache */
static const nir_search_expression search628 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search617_0.value, &search114_0_1.value },
   NULL,
};

   /* replace628_0 -> search0_0 in the cache */

/* replace628_1 -> search26_1 in the cache */
static const nir_search_expression replace628 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* search629_0_0 -> search57_0 in the cache */

/* search629_0_1 -> replace98_0_1 in the cache */
/* search629_0 -> search618_0 in the cache */

/* search629_1 -> replace576_1 in the cache */
static const nir_search_expression search629 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search618_0.value, &replace576_1.value },
   NULL,
};

   /* replace629_0 -> search57_0 in the cache */

/* replace629_1 -> replace600_1 in the cache */
static const nir_search_expression replace629 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace600_1.value },
   NULL,
};

   /* search630_0_0 -> search57_0 in the cache */

/* search630_0_1 -> replace101_0_1 in the cache */
/* search630_0 -> search619_0 in the cache */

/* search630_1 -> replace576_1 in the cache */
static const nir_search_expression search630 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search619_0.value, &replace576_1.value },
   NULL,
};

   /* replace630_0 -> search57_0 in the cache */

/* replace630_1 -> replace599_1 in the cache */
static const nir_search_expression replace630 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace599_1.value },
   NULL,
};

   /* search631_0_0 -> search57_0 in the cache */

/* search631_0_1 -> search451_1_1 in the cache */
/* search631_0 -> search620_0 in the cache */

/* search631_1 -> replace576_1 in the cache */
static const nir_search_expression search631 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search620_0.value, &replace576_1.value },
   NULL,
};

   /* replace631_0 -> search57_0 in the cache */

/* replace631_1 -> replace598_1 in the cache */
static const nir_search_expression replace631 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace598_1.value },
   NULL,
};

   /* search632_0_0 -> search57_0 in the cache */

/* search632_0_1 -> replace104_0_1 in the cache */
/* search632_0 -> search621_0 in the cache */

/* search632_1 -> replace576_1 in the cache */
static const nir_search_expression search632 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search621_0.value, &replace576_1.value },
   NULL,
};

   /* replace632_0 -> search57_0 in the cache */

/* replace632_1 -> replace597_1 in the cache */
static const nir_search_expression replace632 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace597_1.value },
   NULL,
};

   /* search633_0_0 -> search57_0 in the cache */

/* search633_0_1 -> search599_0_1 in the cache */
/* search633_0 -> search622_0 in the cache */

/* search633_1 -> replace576_1 in the cache */
static const nir_search_expression search633 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search622_0.value, &replace576_1.value },
   NULL,
};

   /* replace633_0 -> search57_0 in the cache */

/* replace633_1 -> replace596_1 in the cache */
static const nir_search_expression replace633 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace596_1.value },
   NULL,
};

   /* search634_0_0 -> search57_0 in the cache */

/* search634_0_1 -> search600_0_1 in the cache */
/* search634_0 -> search623_0 in the cache */

/* search634_1 -> replace576_1 in the cache */
static const nir_search_expression search634 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search623_0.value, &replace576_1.value },
   NULL,
};

   /* replace634_0 -> search57_0 in the cache */

/* replace634_1 -> replace595_1 in the cache */
static const nir_search_expression replace634 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace595_1.value },
   NULL,
};

   /* search635_0_0 -> search57_0 in the cache */

/* search635_0_1 -> search576_1 in the cache */
/* search635_0 -> search624_0 in the cache */

/* search635_1 -> replace576_1 in the cache */
static const nir_search_expression search635 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search624_0.value, &replace576_1.value },
   NULL,
};

   /* replace635_0 -> search57_0 in the cache */

/* replace635_1 -> replace107_2 in the cache */
static const nir_search_expression replace635 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

   /* search636_0_0 -> search0_0 in the cache */

/* search636_0_1 -> replace101_0_1 in the cache */
/* search636_0 -> search616_0 in the cache */

/* search636_1 -> replace101_0_1 in the cache */
static const nir_search_expression search636 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search616_0.value, &replace101_0_1.value },
   NULL,
};

   /* replace636_0 -> search0_0 in the cache */

/* replace636_1 -> search26_1 in the cache */
static const nir_search_expression replace636 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* search637_0 -> search0_0 in the cache */

/* search637_1 -> replace101_0_1 in the cache */
/* search637 -> search452_1 in the cache */

   /* replace637_0 -> search0_0 in the cache */

/* replace637_1 -> search110_0_1 in the cache */
static const nir_search_expression replace637 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search0_0.value, &search110_0_1.value },
   NULL,
};

   /* search638_0_0 -> search0_0 in the cache */

/* search638_0_1 -> replace101_0_1 in the cache */
/* search638_0 -> search616_0 in the cache */

/* search638_1 -> replace101_0_1 in the cache */
static const nir_search_expression search638 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search616_0.value, &replace101_0_1.value },
   NULL,
};

   /* replace638_0 -> search0_0 in the cache */

/* replace638_1 -> search26_1 in the cache */
static const nir_search_expression replace638 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* search639_0 -> search0_0 in the cache */

/* search639_1 -> replace101_0_1 in the cache */
/* search639 -> search604_0 in the cache */

   /* replace639_0 -> search0_0 in the cache */

/* replace639_1 -> search110_0_1 in the cache */
static const nir_search_expression replace639 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search0_0.value, &search110_0_1.value },
   NULL,
};

   static const nir_search_constant search640_0 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0xffff /* 65535 */ },
};

/* search640_1 -> search2_0 in the cache */
static const nir_search_expression search640 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search640_0.value, &search2_0.value },
   NULL,
};

   /* replace640_0 -> search2_0 in the cache */

/* replace640_1 -> replace9 in the cache */
static const nir_search_expression replace640 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search641_0 -> search0_0 in the cache */

/* search641_1 -> search26_1 in the cache */
static const nir_search_expression search641 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ussub_4x8,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* replace641 -> search0_0 in the cache */

   /* search642_0 -> search0_0 in the cache */

/* search642_1 -> search27_1 in the cache */
static const nir_search_expression search642 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ussub_4x8,
   { &search0_0.value, &search27_1.value },
   NULL,
};

   /* replace642 -> search26_1 in the cache */

   /* search643_0 -> search14_0 in the cache */

/* search643_1 -> replace14_1_0 in the cache */
static const nir_search_expression search643 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace643_0 -> search14_0 in the cache */

/* replace643_1_0 -> replace14_1_0 in the cache */
/* replace643_1 -> search138_1 in the cache */
static const nir_search_expression replace643 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search14_0.value, &search138_1.value },
   NULL,
};

   /* search644_0 -> search14_0 in the cache */

/* search644_1 -> replace14_1_0 in the cache */
static const nir_search_expression search644 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace644_0 -> search14_0 in the cache */

/* replace644_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression replace644_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace644 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search14_0.value, &replace644_1.value },
   NULL,
};

   /* search645_0 -> search14_0 in the cache */

/* search645_1 -> replace14_1_0 in the cache */
static const nir_search_expression search645 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_uabs_usub,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace645_0_0 -> search14_0 in the cache */

/* replace645_0_1 -> replace14_1_0 in the cache */
/* replace645_0 -> search128_0 in the cache */

/* replace645_1_0_0 -> search14_0 in the cache */

/* replace645_1_0_1 -> replace14_1_0 in the cache */
/* replace645_1_0 -> search644 in the cache */
static const nir_search_expression replace645_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search644.value },
   NULL,
};

/* replace645_2_0 -> search14_0 in the cache */

/* replace645_2_1 -> replace14_1_0 in the cache */
/* replace645_2 -> search644 in the cache */
static const nir_search_expression replace645 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search128_0.value, &replace645_1.value, &search644.value },
   NULL,
};

   /* search646_0 -> search14_0 in the cache */

/* search646_1 -> replace14_1_0 in the cache */
static const nir_search_expression search646 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_uabs_isub,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace646_0_0 -> search14_0 in the cache */

/* replace646_0_1 -> replace14_1_0 in the cache */
/* replace646_0 -> search127_0 in the cache */

/* replace646_1_0_0 -> search14_0 in the cache */

/* replace646_1_0_1 -> replace14_1_0 in the cache */
/* replace646_1_0 -> search644 in the cache */
/* replace646_1 -> replace645_1 in the cache */

/* replace646_2_0 -> search14_0 in the cache */

/* replace646_2_1 -> replace14_1_0 in the cache */
/* replace646_2 -> search644 in the cache */
static const nir_search_expression replace646 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search127_0.value, &replace645_1.value, &search644.value },
   NULL,
};

   /* search647_0_0 -> search14_0 in the cache */
/* search647_0 -> search34_0 in the cache */

/* search647_1 -> replace14_1_0 in the cache */
static const nir_search_expression search647 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search34_0.value, &replace14_1_0.value },
   (is_used_by_non_fsat),
};

   /* replace647_0_0 -> search14_0 in the cache */

/* replace647_0_1 -> replace14_1_0 in the cache */
/* replace647_0 -> replace48 in the cache */
static const nir_search_expression replace647 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace48.value },
   NULL,
};

   /* search648_0_0 -> search14_0 in the cache */
/* search648_0 -> search32_0 in the cache */

/* search648_1 -> replace14_1_0 in the cache */
static const nir_search_expression search648 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search32_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace648_0_0 -> search14_0 in the cache */

/* replace648_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace648_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace648 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace648_0.value },
   NULL,
};

   static const nir_search_variable search649_0_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_const),
   {0, 1, 2, 3},
};

static const nir_search_variable search649_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_const),
   {0, 1, 2, 3},
};
static const nir_search_expression search649_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search649_0_0.value, &search649_0_1.value },
   (is_used_once),
};

/* search649_1 -> search96_0_1 in the cache */
static const nir_search_expression search649 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fmul,
   { &search649_0.value, &search96_0_1.value },
   (is_used_once),
};

   /* replace649_0_0 -> search28_0_0 in the cache */

/* replace649_0_1 -> search28_1_1 in the cache */
static const nir_search_expression replace649_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};

/* replace649_1 -> search28_0_1 in the cache */
static const nir_search_expression replace649 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &replace649_0.value, &search28_0_1.value },
   NULL,
};

   /* search650_0_0 -> search649_0_0 in the cache */

/* search650_0_1 -> search649_0_1 in the cache */
static const nir_search_expression search650_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search649_0_0.value, &search649_0_1.value },
   (is_used_once),
};

/* search650_1 -> search96_0_1 in the cache */
static const nir_search_expression search650 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search650_0.value, &search96_0_1.value },
   (is_used_once),
};

   /* replace650_0_0 -> search28_0_0 in the cache */

/* replace650_0_1 -> search28_1_1 in the cache */
static const nir_search_expression replace650_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};

/* replace650_1 -> search28_0_1 in the cache */
static const nir_search_expression replace650 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &replace650_0.value, &search28_0_1.value },
   NULL,
};

   /* search651_0_0 -> search649_0_0 in the cache */

/* search651_0_1 -> search649_0_1 in the cache */
static const nir_search_expression search651_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search649_0_0.value, &search649_0_1.value },
   (is_used_once),
};

/* search651_1 -> search96_0_1 in the cache */
static const nir_search_expression search651 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search651_0.value, &search96_0_1.value },
   (is_used_once),
};

   /* replace651_0_0 -> search28_0_0 in the cache */

/* replace651_0_1 -> search28_1_1 in the cache */
static const nir_search_expression replace651_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};

/* replace651_1 -> search28_0_1 in the cache */
static const nir_search_expression replace651 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace651_0.value, &search28_0_1.value },
   NULL,
};

   /* search652_0_0 -> search649_0_0 in the cache */

/* search652_0_1 -> search649_0_1 in the cache */
static const nir_search_expression search652_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search649_0_0.value, &search649_0_1.value },
   (is_used_once),
};

/* search652_1 -> search96_0_1 in the cache */
static const nir_search_expression search652 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search652_0.value, &search96_0_1.value },
   (is_used_once),
};

   /* replace652_0_0 -> search28_0_0 in the cache */

/* replace652_0_1 -> search28_1_1 in the cache */
static const nir_search_expression replace652_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};

/* replace652_1 -> search28_0_1 in the cache */
static const nir_search_expression replace652 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace652_0.value, &search28_0_1.value },
   NULL,
};

   /* search653_0 -> search368_0 in the cache */

/* search653_1_0 -> search649_0_1 in the cache */

/* search653_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search653_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search649_0_1.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search653 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fmul,
   { &search368_0.value, &search653_1.value },
   NULL,
};

   /* replace653_0_0 -> search28_0_0 in the cache */

/* replace653_0_1 -> search28_1_1 in the cache */
/* replace653_0 -> replace649_0 in the cache */

/* replace653_1 -> search28_0_1 in the cache */
/* replace653 -> replace649 in the cache */

   /* search654_0 -> search368_0 in the cache */

/* search654_1_0 -> search649_0_1 in the cache */

/* search654_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search654_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search649_0_1.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search654 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search368_0.value, &search654_1.value },
   NULL,
};

   /* replace654_0_0 -> search28_0_0 in the cache */

/* replace654_0_1 -> search28_1_1 in the cache */
/* replace654_0 -> replace650_0 in the cache */

/* replace654_1 -> search28_0_1 in the cache */
/* replace654 -> replace650 in the cache */

   /* search655_0 -> search368_0 in the cache */

/* search655_1_0 -> search649_0_1 in the cache */

/* search655_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search655_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search649_0_1.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search655 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search368_0.value, &search655_1.value },
   NULL,
};

   /* replace655_0_0 -> search28_0_0 in the cache */

/* replace655_0_1 -> search28_1_1 in the cache */
/* replace655_0 -> replace651_0 in the cache */

/* replace655_1 -> search28_0_1 in the cache */
/* replace655 -> replace651 in the cache */

   /* search656_0 -> search368_0 in the cache */

/* search656_1_0_0 -> search649_0_1 in the cache */

/* search656_1_0_1 -> search96_0_1 in the cache */
/* search656_1_0 -> search655_1 in the cache */
static const nir_search_expression search656_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search655_1.value },
   NULL,
};
static const nir_search_expression search656 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search368_0.value, &search656_1.value },
   NULL,
};

   /* replace656_0_0 -> search28_0_0 in the cache */

/* replace656_0_1_0 -> search28_1_1 in the cache */
static const nir_search_expression replace656_0_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace656_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_0_0.value, &replace656_0_1.value },
   NULL,
};

/* replace656_1_0 -> search28_0_1 in the cache */
/* replace656_1 -> replace191_1_1 in the cache */
static const nir_search_expression replace656 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace656_0.value, &replace191_1_1.value },
   NULL,
};

   /* search657_0 -> search368_0 in the cache */

/* search657_1_0 -> search649_0_1 in the cache */

/* search657_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search657_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search649_0_1.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search657 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search368_0.value, &search657_1.value },
   NULL,
};

   /* replace657_0_0 -> search28_0_0 in the cache */

/* replace657_0_1 -> search28_1_1 in the cache */
/* replace657_0 -> replace652_0 in the cache */

/* replace657_1 -> search28_0_1 in the cache */
/* replace657 -> replace652 in the cache */

   /* search658_0_0 -> search14_0 in the cache */

/* search658_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search658_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search14_0.value, &replace14_1_0.value },
   (no_signed_wrap),
};

/* search658_1 -> replace14_1_0 in the cache */
static const nir_search_expression search658 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_idiv,
   { &search658_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace658 -> search14_0 in the cache */

   /* search659_0_0_0 -> search2_0 in the cache */
static const nir_search_expression search659_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &search2_0.value },
   NULL,
};

/* search659_0_1 -> search26_1 in the cache */
static const nir_search_expression search659_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search659_0_0.value, &search26_1.value },
   NULL,
};

/* search659_1_0 -> search2_0 in the cache */
/* search659_1 -> search659_0_0 in the cache */

/* search659_2 -> search27_1 in the cache */
static const nir_search_expression search659 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search659_0.value, &search659_0_0.value, &search27_1.value },
   NULL,
};

   /* replace659_0 -> search2_0 in the cache */
/* replace659 -> search659_0_0 in the cache */

   /* search660_0_0_0 -> search0_0 in the cache */
static const nir_search_expression search660_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ifind_msb,
   { &search0_0.value },
   NULL,
};

/* search660_0_1 -> search26_1 in the cache */
static const nir_search_expression search660_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search660_0_0.value, &search26_1.value },
   NULL,
};

/* search660_1_0 -> search0_0 in the cache */
/* search660_1 -> search660_0_0 in the cache */

/* search660_2 -> search27_1 in the cache */
static const nir_search_expression search660 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search660_0.value, &search660_0_0.value, &search27_1.value },
   NULL,
};

   /* replace660_0 -> search0_0 in the cache */
/* replace660 -> search660_0_0 in the cache */

   /* search661_0_0_0 -> search2_0 in the cache */
static const nir_search_expression search661_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ufind_msb,
   { &search2_0.value },
   NULL,
};

/* search661_0_1 -> search26_1 in the cache */
static const nir_search_expression search661_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search661_0_0.value, &search26_1.value },
   NULL,
};

/* search661_1_0 -> search2_0 in the cache */
/* search661_1 -> search661_0_0 in the cache */

/* search661_2 -> search27_1 in the cache */
static const nir_search_expression search661 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search661_0.value, &search661_0_0.value, &search27_1.value },
   NULL,
};

   /* replace661_0 -> search2_0 in the cache */
/* replace661 -> search661_0_0 in the cache */

   /* search662_0_0 -> search2_0 in the cache */

/* search662_0_1 -> replace9 in the cache */
/* search662_0 -> replace207 in the cache */

/* search662_1_0 -> search2_0 in the cache */
/* search662_1 -> search659_0_0 in the cache */

/* search662_2 -> search27_1 in the cache */
static const nir_search_expression search662 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace207.value, &search659_0_0.value, &search27_1.value },
   NULL,
};

   /* replace662_0 -> search2_0 in the cache */
/* replace662 -> search659_0_0 in the cache */

   /* search663_0_0 -> search0_0 in the cache */

/* search663_0_1 -> search26_1 in the cache */
static const nir_search_expression search663_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search26_1.value },
   NULL,
};

/* search663_1_0 -> search0_0 in the cache */
/* search663_1 -> search660_0_0 in the cache */

/* search663_2 -> search27_1 in the cache */
static const nir_search_expression search663 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &search663_0.value, &search660_0_0.value, &search27_1.value },
   NULL,
};

   /* replace663_0 -> search0_0 in the cache */
/* replace663 -> search660_0_0 in the cache */

   /* search664_0_0 -> search2_0 in the cache */

/* search664_0_1 -> replace9 in the cache */
/* search664_0 -> replace207 in the cache */

/* search664_1_0 -> search2_0 in the cache */
/* search664_1 -> search661_0_0 in the cache */

/* search664_2 -> search27_1 in the cache */
static const nir_search_expression search664 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace207.value, &search661_0_0.value, &search27_1.value },
   NULL,
};

   /* replace664_0 -> search2_0 in the cache */
/* replace664 -> search661_0_0 in the cache */

   /* search665_0_0 -> search0_0 in the cache */

/* search665_0_1 -> search27_1 in the cache */
static const nir_search_expression search665_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search27_1.value },
   NULL,
};

/* search665_1_0 -> search0_0 in the cache */
/* search665_1 -> search660_0_0 in the cache */

/* search665_2 -> search27_1 in the cache */
static const nir_search_expression search665 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &search665_0.value, &search660_0_0.value, &search27_1.value },
   NULL,
};

   /* replace665_0 -> search0_0 in the cache */
/* replace665 -> search660_0_0 in the cache */

   /* search666_0 -> search101_0_0 in the cache */

/* search666_1 -> replace573_1_0 in the cache */
static const nir_search_expression search666 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fmod,
   { &search101_0_0.value, &replace573_1_0.value },
   NULL,
};

   /* replace666_0 -> search101_0_0 in the cache */

/* replace666_1_0 -> replace573_1_0 in the cache */

/* replace666_1_1_0_0 -> search101_0_0 in the cache */

/* replace666_1_1_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace666_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &search101_0_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace666_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &replace666_1_1_0.value },
   NULL,
};
static const nir_search_expression replace666_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace573_1_0.value, &replace666_1_1.value },
   NULL,
};
static const nir_search_expression replace666 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_fsub,
   { &search101_0_0.value, &replace666_1.value },
   NULL,
};

   /* search667_0 -> search0_0 in the cache */

/* search667_1 -> replace0_1_0 in the cache */
static const nir_search_expression search667 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmod,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace667_0 -> search0_0 in the cache */

/* replace667_1_0 -> replace0_1_0 in the cache */

/* replace667_1_1_0_0 -> search0_0 in the cache */

/* replace667_1_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace667_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace667_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &replace667_1_1_0.value },
   NULL,
};
static const nir_search_expression replace667_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &replace667_1_1.value },
   NULL,
};
static const nir_search_expression replace667 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fsub,
   { &search0_0.value, &replace667_1.value },
   NULL,
};

   /* search668_0 -> search14_0 in the cache */

/* search668_1 -> replace14_1_0 in the cache */
static const nir_search_expression search668 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_frem,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace668_0 -> search14_0 in the cache */

/* replace668_1_0 -> replace14_1_0 in the cache */

/* replace668_1_1_0_0 -> search14_0 in the cache */

/* replace668_1_1_0_1 -> replace14_1_0 in the cache */
/* replace668_1_1_0 -> search489 in the cache */
static const nir_search_expression replace668_1_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search489.value },
   NULL,
};
static const nir_search_expression replace668_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace14_1_0.value, &replace668_1_1.value },
   NULL,
};
static const nir_search_expression replace668 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsub,
   { &search14_0.value, &replace668_1.value },
   NULL,
};

   /* search669_0 -> search0_0 in the cache */

/* search669_1 -> replace0_1_0 in the cache */
static const nir_search_expression search669 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_uadd_carry,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace669_0_0_0 -> search0_0 in the cache */

/* replace669_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace669_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace669_0_1 -> search0_0 in the cache */
static const nir_search_expression replace669_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace669_0_0.value, &search0_0.value },
   NULL,
};
static const nir_search_expression replace669 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace669_0.value },
   NULL,
};

   /* search670_0 -> search0_0 in the cache */

/* search670_1 -> replace0_1_0 in the cache */
static const nir_search_expression search670 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_usub_borrow,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace670_0_0 -> search0_0 in the cache */

/* replace670_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace670_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace670 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace670_0.value },
   NULL,
};

   static const nir_search_variable search671_0 = {
   { nir_search_value_variable, 32 },
   0, /* base */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search671_1 = {
   { nir_search_value_variable, 32 },
   1, /* insert */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search671_2 = {
   { nir_search_value_variable, 32 },
   2, /* offset */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search671_3 = {
   { nir_search_value_variable, 32 },
   3, /* bits */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search671 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bitfield_insert,
   { &search671_0.value, &search671_1.value, &search671_2.value, &search671_3.value },
   NULL,
};

   /* replace671_0_0 -> replace106_1_1 in the cache */

/* replace671_0_1 -> search671_3 in the cache */
static const nir_search_expression replace671_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace106_1_1.value, &search671_3.value },
   NULL,
};

/* replace671_1 -> search671_1 in the cache */

/* replace671_2_0_0 -> search671_3 in the cache */

/* replace671_2_0_1 -> search671_2 in the cache */
static const nir_search_expression replace671_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bfm,
   { &search671_3.value, &search671_2.value },
   NULL,
};

/* replace671_2_1 -> search671_1 in the cache */

/* replace671_2_2 -> search671_0 in the cache */
static const nir_search_expression replace671_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bfi,
   { &replace671_2_0.value, &search671_1.value, &search671_0.value },
   NULL,
};
static const nir_search_expression replace671 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace671_0.value, &search671_1.value, &replace671_2.value },
   NULL,
};

   /* search672_0 -> search14_0 in the cache */

/* search672_1 -> replace14_1_0 in the cache */
static const nir_search_expression search672 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ihadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace672_0_0 -> search14_0 in the cache */

/* replace672_0_1 -> replace14_1_0 in the cache */
/* replace672_0 -> search439_0 in the cache */

/* replace672_1_0_0 -> search14_0 in the cache */

/* replace672_1_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace672_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   2, 1,
   nir_op_ixor,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* replace672_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace672_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace672_1_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace672 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &search439_0.value, &replace672_1.value },
   NULL,
};

   /* search673_0 -> search14_0 in the cache */

/* search673_1 -> replace14_1_0 in the cache */
static const nir_search_expression search673 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_uhadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace673_0_0 -> search14_0 in the cache */

/* replace673_0_1 -> replace14_1_0 in the cache */
/* replace673_0 -> search439_0 in the cache */

/* replace673_1_0_0 -> search14_0 in the cache */

/* replace673_1_0_1 -> replace14_1_0 in the cache */
/* replace673_1_0 -> replace672_1_0 in the cache */

/* replace673_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace673_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace672_1_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace673 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &search439_0.value, &replace673_1.value },
   NULL,
};

   /* search674_0 -> search14_0 in the cache */

/* search674_1 -> replace14_1_0 in the cache */
static const nir_search_expression search674 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_irhadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace674_0_0 -> search14_0 in the cache */

/* replace674_0_1 -> replace14_1_0 in the cache */
/* replace674_0 -> search365_0 in the cache */

/* replace674_1_0_0 -> search14_0 in the cache */

/* replace674_1_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace674_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_ixor,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* replace674_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace674_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace674_1_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace674 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &search365_0.value, &replace674_1.value },
   NULL,
};

   /* search675_0 -> search14_0 in the cache */

/* search675_1 -> replace14_1_0 in the cache */
static const nir_search_expression search675 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_urhadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace675_0_0 -> search14_0 in the cache */

/* replace675_0_1 -> replace14_1_0 in the cache */
/* replace675_0 -> search365_0 in the cache */

/* replace675_1_0_0 -> search14_0 in the cache */

/* replace675_1_0_1 -> replace14_1_0 in the cache */
/* replace675_1_0 -> replace674_1_0 in the cache */

/* replace675_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace675_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace674_1_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace675 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &search365_0.value, &replace675_1.value },
   NULL,
};

   /* search676_0 -> search57_0 in the cache */

/* search676_1 -> search57_1_1 in the cache */
static const nir_search_expression search676 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_ihadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

   /* replace676_0_0 -> search57_0 in the cache */

/* replace676_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace676_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

/* replace676_1_0_0 -> search57_0 in the cache */

/* replace676_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace676_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_ixor,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

/* replace676_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace676_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace676_1_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace676 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace676_0.value, &replace676_1.value },
   NULL,
};

   /* search677_0 -> search57_0 in the cache */

/* search677_1 -> search57_1_1 in the cache */
static const nir_search_expression search677 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_uhadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

   /* replace677_0_0 -> search57_0 in the cache */

/* replace677_0_1 -> search57_1_1 in the cache */
/* replace677_0 -> replace676_0 in the cache */

/* replace677_1_0_0 -> search57_0 in the cache */

/* replace677_1_0_1 -> search57_1_1 in the cache */
/* replace677_1_0 -> replace676_1_0 in the cache */

/* replace677_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace677_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace676_1_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace677 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace676_0.value, &replace677_1.value },
   NULL,
};

   /* search678_0 -> search57_0 in the cache */

/* search678_1 -> search57_1_1 in the cache */
static const nir_search_expression search678 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_irhadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

   /* replace678_0_0 -> search57_0 in the cache */

/* replace678_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace678_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

/* replace678_1_0_0 -> search57_0 in the cache */

/* replace678_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace678_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_ixor,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

/* replace678_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace678_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace678_1_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace678 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &replace678_0.value, &replace678_1.value },
   NULL,
};

   /* search679_0 -> search57_0 in the cache */

/* search679_1 -> search57_1_1 in the cache */
static const nir_search_expression search679 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_urhadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

   /* replace679_0_0 -> search57_0 in the cache */

/* replace679_0_1 -> search57_1_1 in the cache */
/* replace679_0 -> replace678_0 in the cache */

/* replace679_1_0_0 -> search57_0 in the cache */

/* replace679_1_0_1 -> search57_1_1 in the cache */
/* replace679_1_0 -> replace678_1_0 in the cache */

/* replace679_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace679_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace678_1_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace679 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &replace678_0.value, &replace679_1.value },
   NULL,
};

   /* search680_0 -> search57_0 in the cache */

/* search680_1 -> search57_1_1 in the cache */
static const nir_search_expression search680 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_uadd_sat,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

   /* replace680_0_0_0 -> search57_0 in the cache */

/* replace680_0_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace680_0_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

/* replace680_0_1 -> search57_0 in the cache */
static const nir_search_expression replace680_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace680_0_0.value, &search57_0.value },
   NULL,
};

static const nir_search_constant replace680_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { -0x1 /* -1 */ },
};

/* replace680_2_0 -> search57_0 in the cache */

/* replace680_2_1 -> search57_1_1 in the cache */
static const nir_search_expression replace680_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace680 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace680_0.value, &replace680_1.value, &replace680_2.value },
   NULL,
};

   /* search681_0 -> search14_0 in the cache */

/* search681_1 -> replace14_1_0 in the cache */
static const nir_search_expression search681 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_uadd_sat,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace681_0_0_0 -> search14_0 in the cache */

/* replace681_0_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace681_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* replace681_0_1 -> search14_0 in the cache */
static const nir_search_expression replace681_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace681_0_0.value, &search14_0.value },
   NULL,
};

static const nir_search_constant replace681_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { -0x1 /* -1 */ },
};

/* replace681_2_0 -> search14_0 in the cache */

/* replace681_2_1 -> replace14_1_0 in the cache */
/* replace681_2 -> search32_1 in the cache */
static const nir_search_expression replace681 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace681_0.value, &replace681_1.value, &search32_1.value },
   NULL,
};

   /* search682_0 -> search14_0 in the cache */

/* search682_1 -> replace14_1_0 in the cache */
static const nir_search_expression search682 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_usub_sat,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace682_0_0 -> search14_0 in the cache */

/* replace682_0_1 -> replace14_1_0 in the cache */
/* replace682_0 -> search128_0 in the cache */

/* replace682_1 -> replace199_1 in the cache */

/* replace682_2_0 -> search14_0 in the cache */

/* replace682_2_1 -> replace14_1_0 in the cache */
/* replace682_2 -> search644 in the cache */
static const nir_search_expression replace682 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search128_0.value, &replace199_1.value, &search644.value },
   NULL,
};

   /* search683_0 -> search57_0 in the cache */

/* search683_1 -> search57_1_1 in the cache */
static const nir_search_expression search683 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_usub_sat,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

   /* replace683_0_0 -> search57_0 in the cache */

/* replace683_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace683_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

/* replace683_1 -> replace107_2 in the cache */

/* replace683_2_0 -> search57_0 in the cache */

/* replace683_2_1 -> search57_1_1 in the cache */
static const nir_search_expression replace683_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace683 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace683_0.value, &replace107_2.value, &replace683_2.value },
   NULL,
};

   /* search684_0 -> search57_0 in the cache */

/* search684_1 -> search57_1_1 in the cache */
static const nir_search_expression search684 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iadd_sat,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

   /* replace684_0_0_0_0 -> search57_0 in the cache */

/* replace684_0_0_0_1 -> replace107_2 in the cache */
static const nir_search_expression replace684_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

/* replace684_0_0_1_0 -> search57_1_1 in the cache */

/* replace684_0_0_1_1 -> replace107_2 in the cache */
static const nir_search_expression replace684_0_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_1_1.value, &replace107_2.value },
   NULL,
};
static const nir_search_expression replace684_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace684_0_0_0.value, &replace684_0_0_1.value },
   NULL,
};

/* replace684_0_1_0_0 -> search57_0 in the cache */

/* replace684_0_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace684_0_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

/* replace684_0_1_1 -> replace107_2 in the cache */
static const nir_search_expression replace684_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace684_0_1_0.value, &replace107_2.value },
   NULL,
};
static const nir_search_expression replace684_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace684_0_0.value, &replace684_0_1.value },
   NULL,
};

static const nir_search_constant replace684_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x8000000000000000 /* 9223372036854775808 */ },
};

/* replace684_2_0_0_0_0 -> search57_0 in the cache */

/* replace684_2_0_0_0_1 -> replace107_2 in the cache */
/* replace684_2_0_0_0 -> replace684_0_0_0 in the cache */

/* replace684_2_0_0_1_0 -> search57_1_1 in the cache */

/* replace684_2_0_0_1_1 -> replace107_2 in the cache */
/* replace684_2_0_0_1 -> replace684_0_0_1 in the cache */
static const nir_search_expression replace684_2_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   4, 1,
   nir_op_ior,
   { &replace684_0_0_0.value, &replace684_0_0_1.value },
   NULL,
};

/* replace684_2_0_1_0_0 -> search57_0 in the cache */

/* replace684_2_0_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace684_2_0_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   5, 1,
   nir_op_iadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

/* replace684_2_0_1_1 -> replace107_2 in the cache */
static const nir_search_expression replace684_2_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace684_2_0_1_0.value, &replace107_2.value },
   NULL,
};
static const nir_search_expression replace684_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 3,
   nir_op_ior,
   { &replace684_2_0_0.value, &replace684_2_0_1.value },
   NULL,
};

/* replace684_2_1_0 -> search57_0 in the cache */

/* replace684_2_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace684_2_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   6, 1,
   nir_op_iadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

static const nir_search_constant replace684_2_2 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7fffffffffffffff /* 9223372036854775807 */ },
};
static const nir_search_expression replace684_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace684_2_0.value, &replace684_2_1.value, &replace684_2_2.value },
   NULL,
};
static const nir_search_expression replace684 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 7,
   nir_op_bcsel,
   { &replace684_0.value, &replace684_1.value, &replace684_2.value },
   NULL,
};

   /* search685_0 -> search57_0 in the cache */

/* search685_1 -> search57_1_1 in the cache */
static const nir_search_expression search685 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_isub_sat,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

   /* replace685_0_0_0_0 -> search57_0 in the cache */

/* replace685_0_0_0_1 -> replace107_2 in the cache */
/* replace685_0_0_0 -> replace684_0_0_0 in the cache */

/* replace685_0_0_1_0 -> search57_1_1 in the cache */

/* replace685_0_0_1_1 -> replace107_2 in the cache */
static const nir_search_expression replace685_0_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_1_1.value, &replace107_2.value },
   NULL,
};
static const nir_search_expression replace685_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace684_0_0_0.value, &replace685_0_0_1.value },
   NULL,
};

/* replace685_0_1_0_0 -> search57_0 in the cache */

/* replace685_0_1_0_1 -> search57_1_1 in the cache */
/* replace685_0_1_0 -> replace683_2 in the cache */

/* replace685_0_1_1 -> replace107_2 in the cache */
static const nir_search_expression replace685_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace683_2.value, &replace107_2.value },
   NULL,
};
static const nir_search_expression replace685_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace685_0_0.value, &replace685_0_1.value },
   NULL,
};

/* replace685_1 -> replace684_1 in the cache */

/* replace685_2_0_0_0_0 -> search57_0 in the cache */

/* replace685_2_0_0_0_1 -> replace107_2 in the cache */
/* replace685_2_0_0_0 -> replace684_0_0_0 in the cache */

/* replace685_2_0_0_1_0 -> search57_1_1 in the cache */

/* replace685_2_0_0_1_1 -> replace107_2 in the cache */
/* replace685_2_0_0_1 -> replace685_0_0_1 in the cache */
static const nir_search_expression replace685_2_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ior,
   { &replace684_0_0_0.value, &replace685_0_0_1.value },
   NULL,
};

/* replace685_2_0_1_0_0 -> search57_0 in the cache */

/* replace685_2_0_1_0_1 -> search57_1_1 in the cache */
/* replace685_2_0_1_0 -> replace683_2 in the cache */

/* replace685_2_0_1_1 -> replace107_2 in the cache */
/* replace685_2_0_1 -> replace685_0_1 in the cache */
static const nir_search_expression replace685_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 2,
   nir_op_ior,
   { &replace685_2_0_0.value, &replace685_0_1.value },
   NULL,
};

/* replace685_2_1_0 -> search57_0 in the cache */

/* replace685_2_1_1 -> search57_1_1 in the cache */
/* replace685_2_1 -> replace683_2 in the cache */

/* replace685_2_2 -> replace684_2_2 in the cache */
static const nir_search_expression replace685_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace685_2_0.value, &replace683_2.value, &replace684_2_2.value },
   NULL,
};
static const nir_search_expression replace685 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace685_0.value, &replace684_1.value, &replace685_2.value },
   NULL,
};

   /* search686_0_0 -> search57_0 in the cache */

/* search686_0_1 -> search57_1_1 in the cache */
static const nir_search_expression search686_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search57_0.value, &search57_1_1.value },
   (is_used_once),
};

/* search686_1 -> replace107_2 in the cache */
static const nir_search_expression search686 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search686_0.value, &replace107_2.value },
   NULL,
};

   /* replace686_0_0_0 -> search57_0 in the cache */
/* replace686_0_0 -> search572_1 in the cache */

/* replace686_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace686_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_y,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace686_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search572_1.value, &replace686_0_1.value },
   NULL,
};

/* replace686_1 -> search26_1 in the cache */
static const nir_search_expression replace686 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace686_0.value, &search26_1.value },
   NULL,
};

   /* search687_0_0 -> search57_0 in the cache */

/* search687_0_1 -> search57_1_1 in the cache */
static const nir_search_expression search687_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search57_0.value, &search57_1_1.value },
   (is_used_once),
};

/* search687_1 -> replace107_2 in the cache */
static const nir_search_expression search687 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search687_0.value, &replace107_2.value },
   NULL,
};

   /* replace687_0_0_0 -> search57_0 in the cache */
/* replace687_0_0 -> search572_1 in the cache */

/* replace687_0_1_0 -> search57_1_1 in the cache */
/* replace687_0_1 -> replace686_0_1 in the cache */
static const nir_search_expression replace687_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search572_1.value, &replace686_0_1.value },
   NULL,
};

/* replace687_1 -> search26_1 in the cache */
static const nir_search_expression replace687 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace687_0.value, &search26_1.value },
   NULL,
};

   /* search688_0_0 -> search57_0 in the cache */

/* search688_0_1 -> search57_1_1 in the cache */
/* search688_0 -> search686_0 in the cache */

/* search688_1 -> replace107_2 in the cache */
static const nir_search_expression search688 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search686_0.value, &replace107_2.value },
   NULL,
};

   /* replace688_0_0_0 -> search57_0 in the cache */
/* replace688_0_0 -> search572_1 in the cache */

/* replace688_0_1_0 -> search57_1_1 in the cache */
/* replace688_0_1 -> replace686_0_1 in the cache */
/* replace688_0 -> replace686_0 in the cache */

/* replace688_1 -> search26_1 in the cache */
static const nir_search_expression replace688 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace686_0.value, &search26_1.value },
   NULL,
};

   /* search689_0_0 -> search57_0 in the cache */

/* search689_0_1 -> search57_1_1 in the cache */
/* search689_0 -> search687_0 in the cache */

/* search689_1 -> replace107_2 in the cache */
static const nir_search_expression search689 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search687_0.value, &replace107_2.value },
   NULL,
};

   /* replace689_0_0_0 -> search57_0 in the cache */
/* replace689_0_0 -> search572_1 in the cache */

/* replace689_0_1_0 -> search57_1_1 in the cache */
/* replace689_0_1 -> replace686_0_1 in the cache */
/* replace689_0 -> replace687_0 in the cache */

/* replace689_1 -> search26_1 in the cache */
static const nir_search_expression replace689 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace687_0.value, &search26_1.value },
   NULL,
};

   /* search690_0 -> search57_0 in the cache */

/* search690_1 -> replace107_2 in the cache */
/* search690 -> replace684_0_0_0 in the cache */

   /* replace690_0_0 -> search57_0 in the cache */
/* replace690_0 -> search572_1 in the cache */

/* replace690_1 -> search26_1 in the cache */
static const nir_search_expression replace690 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search572_1.value, &search26_1.value },
   NULL,
};

   /* search691_0 -> search57_0 in the cache */

/* search691_1 -> replace107_2 in the cache */
static const nir_search_expression search691 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

   /* replace691_0_0 -> search57_0 in the cache */
/* replace691_0 -> search572_1 in the cache */

/* replace691_1 -> search26_1 in the cache */
static const nir_search_expression replace691 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search572_1.value, &search26_1.value },
   NULL,
};

   /* search692_0 -> search57_0 in the cache */

/* search692_1 -> replace107_2 in the cache */
static const nir_search_expression search692 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

   /* replace692_0_0_0 -> search57_0 in the cache */
/* replace692_0_0 -> search572_0 in the cache */

/* replace692_0_1_0 -> search57_0 in the cache */
/* replace692_0_1 -> search572_1 in the cache */
static const nir_search_expression replace692_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search572_0.value, &search572_1.value },
   NULL,
};

/* replace692_1 -> search26_1 in the cache */
static const nir_search_expression replace692 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace692_0.value, &search26_1.value },
   NULL,
};

   /* search693_0 -> search57_0 in the cache */

/* search693_1 -> replace107_2 in the cache */
static const nir_search_expression search693 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

   /* replace693_0_0_0 -> search57_0 in the cache */
/* replace693_0_0 -> search572_0 in the cache */

/* replace693_0_1_0 -> search57_0 in the cache */
/* replace693_0_1 -> search572_1 in the cache */
/* replace693_0 -> replace692_0 in the cache */

/* replace693_1 -> search26_1 in the cache */
static const nir_search_expression replace693 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace692_0.value, &search26_1.value },
   NULL,
};

   /* search694_0 -> replace107_2 in the cache */

/* search694_1 -> search57_0 in the cache */
static const nir_search_expression search694 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace107_2.value, &search57_0.value },
   NULL,
};

   /* replace694_0_0_0 -> search57_0 in the cache */
/* replace694_0_0 -> search572_0 in the cache */

/* replace694_0_1_0 -> search57_0 in the cache */
/* replace694_0_1 -> search572_1 in the cache */
/* replace694_0 -> replace692_0 in the cache */

/* replace694_1 -> search26_1 in the cache */
/* replace694 -> replace692 in the cache */

   /* search695_0 -> search671_0 in the cache */

/* search695_1 -> search671_1 in the cache */

/* search695_2 -> search671_2 in the cache */

/* search695_3 -> search671_3 in the cache */
/* search695 -> search671 in the cache */

   /* replace695_0_0 -> replace106_1_1 in the cache */

/* replace695_0_1 -> search671_3 in the cache */
/* replace695_0 -> replace671_0 in the cache */

/* replace695_1 -> search671_1 in the cache */

/* replace695_2_0_0 -> search671_0 in the cache */

/* replace695_2_0_1_0_0_0_0 -> search110_0_1 in the cache */

/* replace695_2_0_1_0_0_0_1 -> search671_3 in the cache */
static const nir_search_expression replace695_2_0_1_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search110_0_1.value, &search671_3.value },
   NULL,
};

/* replace695_2_0_1_0_0_1 -> search110_0_1 in the cache */
static const nir_search_expression replace695_2_0_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace695_2_0_1_0_0_0.value, &search110_0_1.value },
   NULL,
};

/* replace695_2_0_1_0_1 -> search671_2 in the cache */
static const nir_search_expression replace695_2_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace695_2_0_1_0_0.value, &search671_2.value },
   NULL,
};
static const nir_search_expression replace695_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace695_2_0_1_0.value },
   NULL,
};
static const nir_search_expression replace695_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search671_0.value, &replace695_2_0_1.value },
   NULL,
};

/* replace695_2_1_0_0 -> search671_1 in the cache */

/* replace695_2_1_0_1 -> search671_2 in the cache */
static const nir_search_expression replace695_2_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search671_1.value, &search671_2.value },
   NULL,
};

/* replace695_2_1_1_0_0_0 -> search110_0_1 in the cache */

/* replace695_2_1_1_0_0_1 -> search671_3 in the cache */
/* replace695_2_1_1_0_0 -> replace695_2_0_1_0_0_0 in the cache */

/* replace695_2_1_1_0_1 -> search110_0_1 in the cache */
/* replace695_2_1_1_0 -> replace695_2_0_1_0_0 in the cache */

/* replace695_2_1_1_1 -> search671_2 in the cache */
/* replace695_2_1_1 -> replace695_2_0_1_0 in the cache */
static const nir_search_expression replace695_2_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace695_2_1_0.value, &replace695_2_0_1_0.value },
   NULL,
};
static const nir_search_expression replace695_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace695_2_0.value, &replace695_2_1.value },
   NULL,
};
static const nir_search_expression replace695 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 3,
   nir_op_bcsel,
   { &replace671_0.value, &search671_1.value, &replace695_2.value },
   NULL,
};

   /* search696_0 -> search671_0 in the cache */

/* search696_1 -> search671_1 in the cache */

/* search696_2 -> search671_2 in the cache */

/* search696_3 -> search671_3 in the cache */
/* search696 -> search671 in the cache */

   /* replace696_0_0 -> replace106_1_1 in the cache */

/* replace696_0_1 -> search671_3 in the cache */
/* replace696_0 -> replace671_0 in the cache */

/* replace696_1 -> search671_1 in the cache */

/* replace696_2_0_0 -> search671_3 in the cache */

/* replace696_2_0_1 -> search671_2 in the cache */
/* replace696_2_0 -> replace671_2_0 in the cache */

/* replace696_2_1_0 -> search671_1 in the cache */

/* replace696_2_1_1 -> search671_2 in the cache */
/* replace696_2_1 -> replace695_2_1_0 in the cache */

/* replace696_2_2 -> search671_0 in the cache */
static const nir_search_expression replace696_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bitfield_select,
   { &replace671_2_0.value, &replace695_2_1_0.value, &search671_0.value },
   NULL,
};
static const nir_search_expression replace696 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace671_0.value, &search671_1.value, &replace696_2.value },
   NULL,
};

   static const nir_search_variable search697_0 = {
   { nir_search_value_variable, 32 },
   0, /* value */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search697_1 = {
   { nir_search_value_variable, 32 },
   1, /* offset */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search697_2 = {
   { nir_search_value_variable, 32 },
   2, /* bits */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search697 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ibitfield_extract,
   { &search697_0.value, &search697_1.value, &search697_2.value },
   NULL,
};

   /* replace697_0_0 -> replace106_1_1 in the cache */

/* replace697_0_1 -> search697_2 in the cache */
static const nir_search_expression replace697_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace106_1_1.value, &search697_2.value },
   NULL,
};

/* replace697_1 -> search697_0 in the cache */

/* replace697_2_0 -> search697_0 in the cache */

/* replace697_2_1 -> search697_1 in the cache */

/* replace697_2_2 -> search697_2 in the cache */
static const nir_search_expression replace697_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ibfe,
   { &search697_0.value, &search697_1.value, &search697_2.value },
   NULL,
};
static const nir_search_expression replace697 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace697_0.value, &search697_0.value, &replace697_2.value },
   NULL,
};

   /* search698_0 -> search697_0 in the cache */

/* search698_1 -> search697_1 in the cache */

/* search698_2 -> search697_2 in the cache */
static const nir_search_expression search698 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ubitfield_extract,
   { &search697_0.value, &search697_1.value, &search697_2.value },
   NULL,
};

   /* replace698_0_0 -> replace106_1_1 in the cache */

/* replace698_0_1 -> search697_2 in the cache */
/* replace698_0 -> replace697_0 in the cache */

/* replace698_1 -> search697_0 in the cache */

/* replace698_2_0 -> search697_0 in the cache */

/* replace698_2_1 -> search697_1 in the cache */

/* replace698_2_2 -> search697_2 in the cache */
static const nir_search_expression replace698_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ubfe,
   { &search697_0.value, &search697_1.value, &search697_2.value },
   NULL,
};
static const nir_search_expression replace698 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace697_0.value, &search697_0.value, &replace698_2.value },
   NULL,
};

   /* search699_0 -> search697_0 in the cache */

/* search699_1 -> search697_1 in the cache */

/* search699_2_0 -> replace106_1_1 in the cache */

/* search699_2_1 -> search697_2 in the cache */
static const nir_search_expression search699_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace106_1_1.value, &search697_2.value },
   NULL,
};
static const nir_search_expression search699 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ubfe,
   { &search697_0.value, &search697_1.value, &search699_2.value },
   NULL,
};

   /* replace699_0 -> search697_0 in the cache */

/* replace699_1 -> search697_1 in the cache */

/* replace699_2 -> search697_2 in the cache */
/* replace699 -> replace698_2 in the cache */

   /* search700_0 -> search697_0 in the cache */

/* search700_1_0 -> replace106_1_1 in the cache */

/* search700_1_1 -> search697_1 in the cache */
static const nir_search_expression search700_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace106_1_1.value, &search697_1.value },
   NULL,
};

/* search700_2 -> search697_2 in the cache */
static const nir_search_expression search700 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ubfe,
   { &search697_0.value, &search700_1.value, &search697_2.value },
   NULL,
};

   /* replace700_0 -> search697_0 in the cache */

/* replace700_1 -> search697_1 in the cache */

/* replace700_2 -> search697_2 in the cache */
/* replace700 -> replace698_2 in the cache */

   /* search701_0 -> search697_0 in the cache */

/* search701_1 -> search697_1 in the cache */

/* search701_2_0 -> replace106_1_1 in the cache */

/* search701_2_1 -> search697_2 in the cache */
/* search701_2 -> search699_2 in the cache */
static const nir_search_expression search701 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ibfe,
   { &search697_0.value, &search697_1.value, &search699_2.value },
   NULL,
};

   /* replace701_0 -> search697_0 in the cache */

/* replace701_1 -> search697_1 in the cache */

/* replace701_2 -> search697_2 in the cache */
/* replace701 -> replace697_2 in the cache */

   /* search702_0 -> search697_0 in the cache */

/* search702_1_0 -> replace106_1_1 in the cache */

/* search702_1_1 -> search697_1 in the cache */
/* search702_1 -> search700_1 in the cache */

/* search702_2 -> search697_2 in the cache */
static const nir_search_expression search702 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ibfe,
   { &search697_0.value, &search700_1.value, &search697_2.value },
   NULL,
};

   /* replace702_0 -> search697_0 in the cache */

/* replace702_1 -> search697_1 in the cache */

/* replace702_2 -> search697_2 in the cache */
/* replace702 -> replace697_2 in the cache */

   static const nir_search_variable search703_0 = {
   { nir_search_value_variable, 32 },
   0, /* bits */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search703_1_0 -> replace106_1_1 in the cache */

/* search703_1_1 -> search697_1 in the cache */
/* search703_1 -> search700_1 in the cache */
static const nir_search_expression search703 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bfm,
   { &search703_0.value, &search700_1.value },
   NULL,
};

   /* replace703_0 -> search703_0 in the cache */

/* replace703_1 -> search697_1 in the cache */
static const nir_search_expression replace703 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bfm,
   { &search703_0.value, &search697_1.value },
   NULL,
};

   /* search704_0_0 -> replace106_1_1 in the cache */

/* search704_0_1 -> search703_0 in the cache */
static const nir_search_expression search704_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace106_1_1.value, &search703_0.value },
   NULL,
};

/* search704_1 -> search697_1 in the cache */
static const nir_search_expression search704 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bfm,
   { &search704_0.value, &search697_1.value },
   NULL,
};

   /* replace704_0 -> search703_0 in the cache */

/* replace704_1 -> search697_1 in the cache */
/* replace704 -> replace703 in the cache */

   /* search705_0 -> search697_0 in the cache */

/* search705_1 -> search697_1 in the cache */

/* search705_2 -> search697_2 in the cache */
/* search705 -> search697 in the cache */

   /* replace705_0_0 -> search26_1 in the cache */

/* replace705_0_1 -> search697_2 in the cache */
static const nir_search_expression replace705_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search26_1.value, &search697_2.value },
   NULL,
};

/* replace705_1 -> search26_1 in the cache */

/* replace705_2_0_0 -> search697_0 in the cache */

/* replace705_2_0_1_0_0 -> replace104_0_1 in the cache */

/* replace705_2_0_1_0_1 -> search697_2 in the cache */
static const nir_search_expression replace705_2_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace104_0_1.value, &search697_2.value },
   NULL,
};

/* replace705_2_0_1_1 -> search697_1 in the cache */
static const nir_search_expression replace705_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace705_2_0_1_0.value, &search697_1.value },
   NULL,
};
static const nir_search_expression replace705_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search697_0.value, &replace705_2_0_1.value },
   NULL,
};

/* replace705_2_1_0 -> replace104_0_1 in the cache */

/* replace705_2_1_1 -> search697_2 in the cache */
/* replace705_2_1 -> replace705_2_0_1_0 in the cache */
static const nir_search_expression replace705_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &replace705_2_0.value, &replace705_2_0_1_0.value },
   NULL,
};
static const nir_search_expression replace705 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace705_0.value, &search26_1.value, &replace705_2.value },
   NULL,
};

   /* search706_0 -> search697_0 in the cache */

/* search706_1 -> search697_1 in the cache */

/* search706_2 -> search697_2 in the cache */
/* search706 -> search698 in the cache */

   /* replace706_0_0 -> search697_0 in the cache */

/* replace706_0_1 -> search697_1 in the cache */
static const nir_search_expression replace706_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search697_0.value, &search697_1.value },
   NULL,
};

/* replace706_1_0_0 -> search697_2 in the cache */

/* replace706_1_0_1 -> replace104_0_1 in the cache */
static const nir_search_expression replace706_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search697_2.value, &replace104_0_1.value },
   NULL,
};

/* replace706_1_1 -> replace104_0_0_0_1 in the cache */

/* replace706_1_2_0_0 -> search110_0_1 in the cache */

/* replace706_1_2_0_1 -> search697_2 in the cache */
static const nir_search_expression replace706_1_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search110_0_1.value, &search697_2.value },
   NULL,
};

/* replace706_1_2_1 -> search110_0_1 in the cache */
static const nir_search_expression replace706_1_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace706_1_2_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace706_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace706_1_0.value, &replace104_0_0_0_1.value, &replace706_1_2.value },
   NULL,
};
static const nir_search_expression replace706 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace706_0.value, &replace706_1.value },
   NULL,
};

   /* search707_0 -> search697_0 in the cache */
static const nir_search_expression search707 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ifind_msb,
   { &search697_0.value },
   NULL,
};

   /* replace707_0_0_0 -> search697_0 in the cache */

/* replace707_0_0_1 -> search26_1 in the cache */
static const nir_search_expression replace707_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search697_0.value, &search26_1.value },
   NULL,
};

/* replace707_0_1_0 -> search697_0 in the cache */
static const nir_search_expression replace707_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search697_0.value },
   NULL,
};

/* replace707_0_2 -> search697_0 in the cache */
static const nir_search_expression replace707_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace707_0_0.value, &replace707_0_1.value, &search697_0.value },
   NULL,
};
static const nir_search_expression replace707 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ufind_msb,
   { &replace707_0.value },
   NULL,
};

   static const nir_search_variable search708_0 = {
   { nir_search_value_variable, -1 },
   0, /* value */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search708 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &search708_0.value },
   NULL,
};

   /* replace708_0_0 -> search708_0 in the cache */

/* replace708_0_1_0 -> search708_0 in the cache */
static const nir_search_expression replace708_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search708_0.value },
   NULL,
};
static const nir_search_expression replace708_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search708_0.value, &replace708_0_1.value },
   NULL,
};
static const nir_search_expression replace708 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ufind_msb,
   { &replace708_0.value },
   NULL,
};

   /* search709_0 -> search0_0 in the cache */

/* search709_1 -> replace0_1_0 in the cache */
static const nir_search_expression search709 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace709_0_0 -> search0_0 in the cache */

/* replace709_0_1_0_0 -> search114_0_1 in the cache */

/* replace709_0_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace709_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search114_0_1.value, &replace0_1_0.value },
   NULL,
};

/* replace709_0_1_1 -> replace98_0_1 in the cache */
static const nir_search_expression replace709_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace709_0_1_0.value, &replace98_0_1.value },
   NULL,
};
static const nir_search_expression replace709_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search0_0.value, &replace709_0_1.value },
   NULL,
};

/* replace709_1 -> search451_1_1 in the cache */
static const nir_search_expression replace709 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace709_0.value, &search451_1_1.value },
   NULL,
};

   /* search710_0 -> search0_0 in the cache */

/* search710_1 -> replace0_1_0 in the cache */
static const nir_search_expression search710 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace710_0_0 -> search0_0 in the cache */

/* replace710_0_1_0 -> replace0_1_0 in the cache */

/* replace710_0_1_1 -> replace98_0_1 in the cache */
static const nir_search_expression replace710_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_imul,
   { &replace0_1_0.value, &replace98_0_1.value },
   NULL,
};
static const nir_search_expression replace710_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search0_0.value, &replace710_0_1.value },
   NULL,
};

/* replace710_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace710 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace710_0.value, &replace98_0_0_0_1.value },
   NULL,
};

   /* search711_0 -> search0_0 in the cache */

/* search711_1 -> replace0_1_0 in the cache */
static const nir_search_expression search711 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace711_0_0 -> search0_0 in the cache */

/* replace711_0_1_0_0 -> search110_0_1 in the cache */

/* replace711_0_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace711_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search110_0_1.value, &replace0_1_0.value },
   NULL,
};

/* replace711_0_1_1 -> replace101_0_1 in the cache */
static const nir_search_expression replace711_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace711_0_1_0.value, &replace101_0_1.value },
   NULL,
};
static const nir_search_expression replace711_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search0_0.value, &replace711_0_1.value },
   NULL,
};

/* replace711_1 -> replace101_0_1 in the cache */
static const nir_search_expression replace711 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace711_0.value, &replace101_0_1.value },
   NULL,
};

   /* search712_0 -> search0_0 in the cache */

/* search712_1 -> replace0_1_0 in the cache */
static const nir_search_expression search712 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace712_0_0 -> search0_0 in the cache */

/* replace712_0_1_0 -> replace0_1_0 in the cache */

/* replace712_0_1_1 -> replace101_0_1 in the cache */
static const nir_search_expression replace712_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_imul,
   { &replace0_1_0.value, &replace101_0_1.value },
   NULL,
};
static const nir_search_expression replace712_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search0_0.value, &replace712_0_1.value },
   NULL,
};

/* replace712_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace712 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace712_0.value, &replace101_0_0_0_1.value },
   NULL,
};

   static const nir_search_variable search713_0 = {
   { nir_search_value_variable, 32 },
   0, /* v */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search713 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_unorm_2x16,
   { &search713_0.value },
   NULL,
};

   /* replace713_0_0_0_0_0 -> search713_0 in the cache */
static const nir_search_expression replace713_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search713_0.value },
   NULL,
};

static const nir_search_constant replace713_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x40efffe000000000 /* 65535.0 */ },
};
static const nir_search_expression replace713_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace713_0_0_0_0.value, &replace713_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace713_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fround_even,
   { &replace713_0_0_0.value },
   NULL,
};
static const nir_search_expression replace713_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_f2u32,
   { &replace713_0_0.value },
   NULL,
};
static const nir_search_expression replace713 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_pack_uvec2_to_uint,
   { &replace713_0.value },
   NULL,
};

   /* search714_0 -> search713_0 in the cache */
static const nir_search_expression search714 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_unorm_4x8,
   { &search713_0.value },
   NULL,
};

   /* replace714_0_0_0_0_0 -> search713_0 in the cache */
/* replace714_0_0_0_0 -> replace713_0_0_0_0 in the cache */

static const nir_search_constant replace714_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x406fe00000000000 /* 255.0 */ },
};
static const nir_search_expression replace714_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace713_0_0_0_0.value, &replace714_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace714_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fround_even,
   { &replace714_0_0_0.value },
   NULL,
};
static const nir_search_expression replace714_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_f2u32,
   { &replace714_0_0.value },
   NULL,
};
static const nir_search_expression replace714 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_pack_uvec4_to_uint,
   { &replace714_0.value },
   NULL,
};

   /* search715_0 -> search713_0 in the cache */
static const nir_search_expression search715 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_snorm_2x16,
   { &search713_0.value },
   NULL,
};

   /* replace715_0_0_0_0_0 -> replace60_0_0 in the cache */

/* replace715_0_0_0_0_1_0 -> search506_1 in the cache */

/* replace715_0_0_0_0_1_1 -> search713_0 in the cache */
static const nir_search_expression replace715_0_0_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search506_1.value, &search713_0.value },
   NULL,
};
static const nir_search_expression replace715_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace60_0_0.value, &replace715_0_0_0_0_1.value },
   NULL,
};

static const nir_search_constant replace715_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x40dfffc000000000 /* 32767.0 */ },
};
static const nir_search_expression replace715_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace715_0_0_0_0.value, &replace715_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace715_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fround_even,
   { &replace715_0_0_0.value },
   NULL,
};
static const nir_search_expression replace715_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_f2i32,
   { &replace715_0_0.value },
   NULL,
};
static const nir_search_expression replace715 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_pack_uvec2_to_uint,
   { &replace715_0.value },
   NULL,
};

   /* search716_0 -> search713_0 in the cache */
static const nir_search_expression search716 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_snorm_4x8,
   { &search713_0.value },
   NULL,
};

   /* replace716_0_0_0_0_0 -> replace60_0_0 in the cache */

/* replace716_0_0_0_0_1_0 -> search506_1 in the cache */

/* replace716_0_0_0_0_1_1 -> search713_0 in the cache */
/* replace716_0_0_0_0_1 -> replace715_0_0_0_0_1 in the cache */
/* replace716_0_0_0_0 -> replace715_0_0_0_0 in the cache */

static const nir_search_constant replace716_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x405fc00000000000 /* 127.0 */ },
};
static const nir_search_expression replace716_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace715_0_0_0_0.value, &replace716_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace716_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fround_even,
   { &replace716_0_0_0.value },
   NULL,
};
static const nir_search_expression replace716_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_f2i32,
   { &replace716_0_0.value },
   NULL,
};
static const nir_search_expression replace716 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_pack_uvec4_to_uint,
   { &replace716_0.value },
   NULL,
};

   /* search717_0 -> search713_0 in the cache */
static const nir_search_expression search717 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_unorm_2x16,
   { &search713_0.value },
   NULL,
};

   /* replace717_0_0_0_0 -> search713_0 in the cache */

/* replace717_0_0_0_1 -> search26_1 in the cache */
static const nir_search_expression replace717_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search713_0.value, &search26_1.value },
   NULL,
};

/* replace717_0_0_1_0 -> search713_0 in the cache */

/* replace717_0_0_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace717_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search713_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace717_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &replace717_0_0_0.value, &replace717_0_0_1.value },
   NULL,
};
static const nir_search_expression replace717_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &replace717_0_0.value },
   NULL,
};

/* replace717_1 -> replace713_0_0_0_1 in the cache */
static const nir_search_expression replace717 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &replace717_0.value, &replace713_0_0_0_1.value },
   NULL,
};

   /* search718_0 -> search713_0 in the cache */
static const nir_search_expression search718 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_unorm_4x8,
   { &search713_0.value },
   NULL,
};

   /* replace718_0_0_0_0 -> search713_0 in the cache */

/* replace718_0_0_0_1 -> search26_1 in the cache */
static const nir_search_expression replace718_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search713_0.value, &search26_1.value },
   NULL,
};

/* replace718_0_0_1_0 -> search713_0 in the cache */

/* replace718_0_0_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace718_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search713_0.value, &search110_0_1.value },
   NULL,
};

/* replace718_0_0_2_0 -> search713_0 in the cache */

/* replace718_0_0_2_1 -> search112_0_1 in the cache */
static const nir_search_expression replace718_0_0_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search713_0.value, &search112_0_1.value },
   NULL,
};

/* replace718_0_0_3_0 -> search713_0 in the cache */

/* replace718_0_0_3_1 -> search114_0_1 in the cache */
static const nir_search_expression replace718_0_0_3 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search713_0.value, &search114_0_1.value },
   NULL,
};
static const nir_search_expression replace718_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &replace718_0_0_0.value, &replace718_0_0_1.value, &replace718_0_0_2.value, &replace718_0_0_3.value },
   NULL,
};
static const nir_search_expression replace718_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &replace718_0_0.value },
   NULL,
};

/* replace718_1 -> replace714_0_0_0_1 in the cache */
static const nir_search_expression replace718 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &replace718_0.value, &replace714_0_0_0_1.value },
   NULL,
};

   /* search719_0 -> search713_0 in the cache */
static const nir_search_expression search719 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_snorm_2x16,
   { &search713_0.value },
   NULL,
};

   /* replace719_0 -> replace60_0_0 in the cache */

/* replace719_1_0 -> search506_1 in the cache */

/* replace719_1_1_0_0_0_0 -> search713_0 in the cache */

/* replace719_1_1_0_0_0_1 -> search26_1 in the cache */
static const nir_search_expression replace719_1_1_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search713_0.value, &search26_1.value },
   NULL,
};

/* replace719_1_1_0_0_1_0 -> search713_0 in the cache */

/* replace719_1_1_0_0_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace719_1_1_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search713_0.value, &search110_0_1.value },
   NULL,
};
static const nir_search_expression replace719_1_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &replace719_1_1_0_0_0.value, &replace719_1_1_0_0_1.value },
   NULL,
};
static const nir_search_expression replace719_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &replace719_1_1_0_0.value },
   NULL,
};

/* replace719_1_1_1 -> replace715_0_0_0_1 in the cache */
static const nir_search_expression replace719_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &replace719_1_1_0.value, &replace715_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace719_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search506_1.value, &replace719_1_1.value },
   NULL,
};
static const nir_search_expression replace719 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace60_0_0.value, &replace719_1.value },
   NULL,
};

   /* search720_0 -> search713_0 in the cache */
static const nir_search_expression search720 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_snorm_4x8,
   { &search713_0.value },
   NULL,
};

   /* replace720_0 -> replace60_0_0 in the cache */

/* replace720_1_0 -> search506_1 in the cache */

/* replace720_1_1_0_0_0_0 -> search713_0 in the cache */

/* replace720_1_1_0_0_0_1 -> search26_1 in the cache */
static const nir_search_expression replace720_1_1_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search713_0.value, &search26_1.value },
   NULL,
};

/* replace720_1_1_0_0_1_0 -> search713_0 in the cache */

/* replace720_1_1_0_0_1_1 -> search110_0_1 in the cache */
static const nir_search_expression replace720_1_1_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search713_0.value, &search110_0_1.value },
   NULL,
};

/* replace720_1_1_0_0_2_0 -> search713_0 in the cache */

/* replace720_1_1_0_0_2_1 -> search112_0_1 in the cache */
static const nir_search_expression replace720_1_1_0_0_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search713_0.value, &search112_0_1.value },
   NULL,
};

/* replace720_1_1_0_0_3_0 -> search713_0 in the cache */

/* replace720_1_1_0_0_3_1 -> search114_0_1 in the cache */
static const nir_search_expression replace720_1_1_0_0_3 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search713_0.value, &search114_0_1.value },
   NULL,
};
static const nir_search_expression replace720_1_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &replace720_1_1_0_0_0.value, &replace720_1_1_0_0_1.value, &replace720_1_1_0_0_2.value, &replace720_1_1_0_0_3.value },
   NULL,
};
static const nir_search_expression replace720_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &replace720_1_1_0_0.value },
   NULL,
};

/* replace720_1_1_1 -> replace716_0_0_0_1 in the cache */
static const nir_search_expression replace720_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &replace720_1_1_0.value, &replace716_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace720_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search506_1.value, &replace720_1_1.value },
   NULL,
};
static const nir_search_expression replace720 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace60_0_0.value, &replace720_1.value },
   NULL,
};

   /* search721_0 -> search0_0 in the cache */

/* search721_1 -> replace0_1_0 in the cache */
static const nir_search_expression search721 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16_split,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace721_0_0_0_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace721_0_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace721_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace721_0_0_0.value },
   NULL,
};

/* replace721_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression replace721_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace721_0_0.value, &replace101_0_1.value },
   NULL,
};

/* replace721_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace721_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression replace721_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace721_1_0.value },
   NULL,
};
static const nir_search_expression replace721 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace721_0.value, &replace721_1.value },
   NULL,
};

   /* search722_0 -> search0_0 in the cache */
/* search722 -> replace581 in the cache */

   /* replace722_0_0 -> search0_0 in the cache */
static const nir_search_expression replace722_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression replace722 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &replace722_0.value },
   NULL,
};

   /* search723_0 -> search0_0 in the cache */
/* search723 -> replace584 in the cache */

   /* replace723_0_0_0 -> search0_0 in the cache */

/* replace723_0_0_1 -> replace101_0_1 in the cache */
/* replace723_0_0 -> search452_1 in the cache */
static const nir_search_expression replace723_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search452_1.value },
   NULL,
};
static const nir_search_expression replace723 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &replace723_0.value },
   NULL,
};

   /* search724_0 -> search2_0 in the cache */
static const nir_search_expression search724 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_isign,
   { &search2_0.value },
   NULL,
};

   /* replace724_0_0 -> search2_0 in the cache */

/* replace724_0_1 -> search44_1 in the cache */
static const nir_search_expression replace724_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search2_0.value, &search44_1.value },
   NULL,
};

/* replace724_1 -> replace2_1_0 in the cache */
static const nir_search_expression replace724 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_imin,
   { &replace724_0.value, &replace2_1_0.value },
   NULL,
};

   /* search725_0 -> search2_0 in the cache */
/* search725 -> search45_0 in the cache */

   /* replace725_0_0_0 -> search24_1 in the cache */

/* replace725_0_0_1 -> search2_0 in the cache */
/* replace725_0_0 -> replace157 in the cache */
/* replace725_0 -> replace278 in the cache */

/* replace725_1_0_0 -> search2_0 in the cache */

/* replace725_1_0_1 -> search24_1 in the cache */
/* replace725_1_0 -> replace65_0 in the cache */
static const nir_search_expression replace725_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace65_0.value },
   NULL,
};
static const nir_search_expression replace725 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &replace278.value, &replace725_1.value },
   NULL,
};

   /* search726_0 -> search14_0 in the cache */

/* search726_1 -> replace14_1_0 in the cache */
static const nir_search_expression search726 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_amul,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace726_0 -> search14_0 in the cache */

/* replace726_1 -> replace14_1_0 in the cache */
/* replace726 -> replace648_0 in the cache */

   /* search727_0 -> search0_0 in the cache */

/* search727_1 -> replace0_1_0 in the cache */

/* search727_2 -> search26_1 in the cache */
static const nir_search_expression search727 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imad24_ir3,
   { &search0_0.value, &replace0_1_0.value, &search26_1.value },
   NULL,
};

   /* replace727_0 -> search0_0 in the cache */

/* replace727_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace727 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul24,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search728_0 -> search0_0 in the cache */

/* search728_1 -> search26_1 in the cache */

/* search728_2 -> search71_0_1_1_0 in the cache */
static const nir_search_expression search728 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imad24_ir3,
   { &search0_0.value, &search26_1.value, &search71_0_1_1_0.value },
   NULL,
};

   /* replace728 -> search71_0_1_1_0 in the cache */

   /* search729_0 -> search0_0 in the cache */

/* search729_1 -> search110_0_1 in the cache */

/* search729_2 -> search71_0_1_1_0 in the cache */
static const nir_search_expression search729 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imad24_ir3,
   { &search0_0.value, &search110_0_1.value, &search71_0_1_1_0.value },
   NULL,
};

   /* replace729_0 -> search0_0 in the cache */

/* replace729_1 -> search71_0_1_1_0 in the cache */
static const nir_search_expression replace729 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search0_0.value, &search71_0_1_1_0.value },
   NULL,
};

   static const nir_search_variable search730_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search730_1 -> search2_1 in the cache */

/* search730_2 -> search56_2 in the cache */
static const nir_search_expression search730 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imad24_ir3,
   { &search730_0.value, &search2_1.value, &search56_2.value },
   NULL,
};

   /* replace730_0_0 -> search0_0 in the cache */

/* replace730_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace730_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace730_1 -> search56_2 in the cache */
static const nir_search_expression replace730 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace730_0.value, &search56_2.value },
   NULL,
};

   /* search731_0 -> search0_0 in the cache */

/* search731_1 -> search0_1 in the cache */
static const nir_search_expression search731 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul24,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace731_0 -> search0_0 in the cache */

/* replace731_1_0 -> replace0_1_0 in the cache */
/* replace731_1 -> replace0_1 in the cache */
/* replace731 -> replace0 in the cache */

   /* search732_0 -> search0_0 in the cache */

/* search732_1 -> search1_1 in the cache */
static const nir_search_expression search732 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul24,
   { &search0_0.value, &search1_1.value },
   NULL,
};

   /* replace732_0_0 -> search0_0 in the cache */

/* replace732_0_1_0_0 -> replace0_1_0 in the cache */
/* replace732_0_1_0 -> replace1_0_1_0 in the cache */
/* replace732_0_1 -> replace1_0_1 in the cache */
/* replace732_0 -> replace1_0 in the cache */
/* replace732 -> replace1 in the cache */

   /* search733_0 -> search0_0 in the cache */

/* search733_1 -> search26_1 in the cache */
static const nir_search_expression search733 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul24,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* replace733 -> search26_1 in the cache */

   /* search734_0 -> search98_0_0 in the cache */

static const nir_search_variable search734_1 = {
   { nir_search_value_variable, 8 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search734 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_iadd_sat,
   { &search98_0_0.value, &search734_1.value },
   NULL,
};

   /* replace734_0_0 -> search734_1 in the cache */

static const nir_search_constant replace734_0_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace734_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search734_1.value, &replace734_0_1.value },
   NULL,
};

/* replace734_1_0_0_0 -> search98_0_0 in the cache */

/* replace734_1_0_0_1 -> search734_1 in the cache */
static const nir_search_expression replace734_1_0_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search98_0_0.value, &search734_1.value },
   NULL,
};

/* replace734_1_0_1 -> search98_0_0 in the cache */
static const nir_search_expression replace734_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace734_1_0_0.value, &search98_0_0.value },
   NULL,
};

static const nir_search_constant replace734_1_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x7f /* 127 */ },
};

/* replace734_1_2_0 -> search98_0_0 in the cache */

/* replace734_1_2_1 -> search734_1 in the cache */
static const nir_search_expression replace734_1_2 = {
   { nir_search_value_expression, 8 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search98_0_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace734_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace734_1_0.value, &replace734_1_1.value, &replace734_1_2.value },
   NULL,
};

/* replace734_2_0_0 -> search98_0_0 in the cache */

/* replace734_2_0_1_0 -> search98_0_0 in the cache */

/* replace734_2_0_1_1 -> search734_1 in the cache */
static const nir_search_expression replace734_2_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search98_0_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace734_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search98_0_0.value, &replace734_2_0_1.value },
   NULL,
};

static const nir_search_constant replace734_2_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x80 /* 128 */ },
};

/* replace734_2_2_0 -> search98_0_0 in the cache */

/* replace734_2_2_1 -> search734_1 in the cache */
static const nir_search_expression replace734_2_2 = {
   { nir_search_value_expression, 8 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &search98_0_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace734_2 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace734_2_0.value, &replace734_2_1.value, &replace734_2_2.value },
   NULL,
};
static const nir_search_expression replace734 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace734_0.value, &replace734_1.value, &replace734_2.value },
   NULL,
};

   /* search735_0 -> search98_0_0 in the cache */

/* search735_1 -> search734_1 in the cache */
static const nir_search_expression search735 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_isub_sat,
   { &search98_0_0.value, &search734_1.value },
   NULL,
};

   /* replace735_0_0 -> search734_1 in the cache */

/* replace735_0_1 -> replace98_2 in the cache */
static const nir_search_expression replace735_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search734_1.value, &replace98_2.value },
   NULL,
};

/* replace735_1_0_0_0 -> search98_0_0 in the cache */

/* replace735_1_0_0_1 -> search734_1 in the cache */
static const nir_search_expression replace735_1_0_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search98_0_0.value, &search734_1.value },
   NULL,
};

/* replace735_1_0_1 -> search98_0_0 in the cache */
static const nir_search_expression replace735_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace735_1_0_0.value, &search98_0_0.value },
   NULL,
};

/* replace735_1_1 -> replace734_1_1 in the cache */

/* replace735_1_2_0 -> search98_0_0 in the cache */

/* replace735_1_2_1 -> search734_1 in the cache */
/* replace735_1_2 -> replace735_1_0_0 in the cache */
static const nir_search_expression replace735_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace735_1_0.value, &replace734_1_1.value, &replace735_1_0_0.value },
   NULL,
};

/* replace735_2_0_0 -> search98_0_0 in the cache */

/* replace735_2_0_1_0 -> search98_0_0 in the cache */

/* replace735_2_0_1_1 -> search734_1 in the cache */
/* replace735_2_0_1 -> replace735_1_0_0 in the cache */
static const nir_search_expression replace735_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search98_0_0.value, &replace735_1_0_0.value },
   NULL,
};

/* replace735_2_1 -> replace734_2_1 in the cache */

/* replace735_2_2_0 -> search98_0_0 in the cache */

/* replace735_2_2_1 -> search734_1 in the cache */
/* replace735_2_2 -> replace735_1_0_0 in the cache */
static const nir_search_expression replace735_2 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace735_2_0.value, &replace734_2_1.value, &replace735_1_0_0.value },
   NULL,
};
static const nir_search_expression replace735 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace735_0.value, &replace735_1.value, &replace735_2.value },
   NULL,
};

   /* search736_0 -> search101_0_0 in the cache */

/* search736_1 -> replace573_1_0 in the cache */
static const nir_search_expression search736 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iadd_sat,
   { &search101_0_0.value, &replace573_1_0.value },
   NULL,
};

   /* replace736_0_0 -> replace573_1_0 in the cache */

/* replace736_0_1 -> replace574_1 in the cache */
static const nir_search_expression replace736_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace573_1_0.value, &replace574_1.value },
   NULL,
};

/* replace736_1_0_0_0 -> search101_0_0 in the cache */

/* replace736_1_0_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace736_1_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search101_0_0.value, &replace573_1_0.value },
   NULL,
};

/* replace736_1_0_1 -> search101_0_0 in the cache */
static const nir_search_expression replace736_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace736_1_0_0.value, &search101_0_0.value },
   NULL,
};

static const nir_search_constant replace736_1_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x7fff /* 32767 */ },
};

/* replace736_1_2_0 -> search101_0_0 in the cache */

/* replace736_1_2_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace736_1_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search101_0_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace736_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace736_1_0.value, &replace736_1_1.value, &replace736_1_2.value },
   NULL,
};

/* replace736_2_0_0 -> search101_0_0 in the cache */

/* replace736_2_0_1_0 -> search101_0_0 in the cache */

/* replace736_2_0_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace736_2_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search101_0_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace736_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search101_0_0.value, &replace736_2_0_1.value },
   NULL,
};

static const nir_search_constant replace736_2_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x8000 /* 32768 */ },
};

/* replace736_2_2_0 -> search101_0_0 in the cache */

/* replace736_2_2_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace736_2_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &search101_0_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace736_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace736_2_0.value, &replace736_2_1.value, &replace736_2_2.value },
   NULL,
};
static const nir_search_expression replace736 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace736_0.value, &replace736_1.value, &replace736_2.value },
   NULL,
};

   /* search737_0 -> search101_0_0 in the cache */

/* search737_1 -> replace573_1_0 in the cache */
static const nir_search_expression search737 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_isub_sat,
   { &search101_0_0.value, &replace573_1_0.value },
   NULL,
};

   /* replace737_0_0 -> replace573_1_0 in the cache */

/* replace737_0_1 -> replace101_2 in the cache */
static const nir_search_expression replace737_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace573_1_0.value, &replace101_2.value },
   NULL,
};

/* replace737_1_0_0_0 -> search101_0_0 in the cache */

/* replace737_1_0_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace737_1_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search101_0_0.value, &replace573_1_0.value },
   NULL,
};

/* replace737_1_0_1 -> search101_0_0 in the cache */
static const nir_search_expression replace737_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace737_1_0_0.value, &search101_0_0.value },
   NULL,
};

/* replace737_1_1 -> replace736_1_1 in the cache */

/* replace737_1_2_0 -> search101_0_0 in the cache */

/* replace737_1_2_1 -> replace573_1_0 in the cache */
/* replace737_1_2 -> replace737_1_0_0 in the cache */
static const nir_search_expression replace737_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace737_1_0.value, &replace736_1_1.value, &replace737_1_0_0.value },
   NULL,
};

/* replace737_2_0_0 -> search101_0_0 in the cache */

/* replace737_2_0_1_0 -> search101_0_0 in the cache */

/* replace737_2_0_1_1 -> replace573_1_0 in the cache */
/* replace737_2_0_1 -> replace737_1_0_0 in the cache */
static const nir_search_expression replace737_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace737_1_0_0.value },
   NULL,
};

/* replace737_2_1 -> replace736_2_1 in the cache */

/* replace737_2_2_0 -> search101_0_0 in the cache */

/* replace737_2_2_1 -> replace573_1_0 in the cache */
/* replace737_2_2 -> replace737_1_0_0 in the cache */
static const nir_search_expression replace737_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace737_2_0.value, &replace736_2_1.value, &replace737_1_0_0.value },
   NULL,
};
static const nir_search_expression replace737 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace737_0.value, &replace737_1.value, &replace737_2.value },
   NULL,
};

   /* search738_0 -> search0_0 in the cache */

/* search738_1 -> replace0_1_0 in the cache */
static const nir_search_expression search738 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd_sat,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace738_0_0 -> replace0_1_0 in the cache */

/* replace738_0_1 -> search110_0_1 in the cache */
static const nir_search_expression replace738_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace0_1_0.value, &search110_0_1.value },
   NULL,
};

/* replace738_1_0_0_0 -> search0_0 in the cache */

/* replace738_1_0_0_1 -> replace0_1_0 in the cache */
/* replace738_1_0_0 -> replace669_0_0 in the cache */

/* replace738_1_0_1 -> search0_0 in the cache */
static const nir_search_expression replace738_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace669_0_0.value, &search0_0.value },
   NULL,
};

static const nir_search_constant replace738_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7fffffff /* 2147483647 */ },
};

/* replace738_1_2_0 -> search0_0 in the cache */

/* replace738_1_2_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace738_1_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace738_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace738_1_0.value, &replace738_1_1.value, &replace738_1_2.value },
   NULL,
};

/* replace738_2_0_0 -> search0_0 in the cache */

/* replace738_2_0_1_0 -> search0_0 in the cache */

/* replace738_2_0_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace738_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace738_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search0_0.value, &replace738_2_0_1.value },
   NULL,
};

/* replace738_2_1 -> replace334_1_1 in the cache */

/* replace738_2_2_0 -> search0_0 in the cache */

/* replace738_2_2_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace738_2_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace738_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace738_2_0.value, &replace334_1_1.value, &replace738_2_2.value },
   NULL,
};
static const nir_search_expression replace738 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace738_0.value, &replace738_1.value, &replace738_2.value },
   NULL,
};

   /* search739_0 -> search0_0 in the cache */

/* search739_1 -> replace0_1_0 in the cache */
static const nir_search_expression search739 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub_sat,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace739_0_0 -> replace0_1_0 in the cache */

/* replace739_0_1 -> search26_1 in the cache */
static const nir_search_expression replace739_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace0_1_0.value, &search26_1.value },
   NULL,
};

/* replace739_1_0_0_0 -> search0_0 in the cache */

/* replace739_1_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace739_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace739_1_0_1 -> search0_0 in the cache */
static const nir_search_expression replace739_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace739_1_0_0.value, &search0_0.value },
   NULL,
};

/* replace739_1_1 -> replace738_1_1 in the cache */

/* replace739_1_2_0 -> search0_0 in the cache */

/* replace739_1_2_1 -> replace0_1_0 in the cache */
/* replace739_1_2 -> replace739_1_0_0 in the cache */
static const nir_search_expression replace739_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace739_1_0.value, &replace738_1_1.value, &replace739_1_0_0.value },
   NULL,
};

/* replace739_2_0_0 -> search0_0 in the cache */

/* replace739_2_0_1_0 -> search0_0 in the cache */

/* replace739_2_0_1_1 -> replace0_1_0 in the cache */
/* replace739_2_0_1 -> replace739_1_0_0 in the cache */
static const nir_search_expression replace739_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace739_1_0_0.value },
   NULL,
};

/* replace739_2_1 -> replace334_1_1 in the cache */

/* replace739_2_2_0 -> search0_0 in the cache */

/* replace739_2_2_1 -> replace0_1_0 in the cache */
/* replace739_2_2 -> replace739_1_0_0 in the cache */
static const nir_search_expression replace739_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace739_2_0.value, &replace334_1_1.value, &replace739_1_0_0.value },
   NULL,
};
static const nir_search_expression replace739 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace739_0.value, &replace739_1.value, &replace739_2.value },
   NULL,
};

   /* search740_0 -> search57_0 in the cache */

/* search740_1 -> search57_1_1 in the cache */
/* search740 -> search684 in the cache */

   /* replace740_0_0 -> search57_1_1 in the cache */

/* replace740_0_1 -> replace595_1 in the cache */
static const nir_search_expression replace740_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_1_1.value, &replace595_1.value },
   NULL,
};

/* replace740_1_0_0_0 -> search57_0 in the cache */

/* replace740_1_0_0_1 -> search57_1_1 in the cache */
/* replace740_1_0_0 -> replace680_0_0 in the cache */

/* replace740_1_0_1 -> search57_0 in the cache */
static const nir_search_expression replace740_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace680_0_0.value, &search57_0.value },
   NULL,
};

/* replace740_1_1 -> replace684_2_2 in the cache */

/* replace740_1_2_0 -> search57_0 in the cache */

/* replace740_1_2_1 -> search57_1_1 in the cache */
/* replace740_1_2 -> replace680_2 in the cache */
static const nir_search_expression replace740_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace740_1_0.value, &replace684_2_2.value, &replace680_2.value },
   NULL,
};

/* replace740_2_0_0 -> search57_0 in the cache */

/* replace740_2_0_1_0 -> search57_0 in the cache */

/* replace740_2_0_1_1 -> search57_1_1 in the cache */
/* replace740_2_0_1 -> replace684_0_1_0 in the cache */
static const nir_search_expression replace740_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search57_0.value, &replace684_0_1_0.value },
   NULL,
};

/* replace740_2_1 -> replace684_1 in the cache */

/* replace740_2_2_0 -> search57_0 in the cache */

/* replace740_2_2_1 -> search57_1_1 in the cache */
static const nir_search_expression replace740_2_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace740_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace740_2_0.value, &replace684_1.value, &replace740_2_2.value },
   NULL,
};
static const nir_search_expression replace740 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace740_0.value, &replace740_1.value, &replace740_2.value },
   NULL,
};

   /* search741_0 -> search57_0 in the cache */

/* search741_1 -> search57_1_1 in the cache */
/* search741 -> search685 in the cache */

   /* replace741_0_0 -> search57_1_1 in the cache */

/* replace741_0_1 -> replace107_2 in the cache */
/* replace741_0 -> replace684_0_0_1 in the cache */

/* replace741_1_0_0_0 -> search57_0 in the cache */

/* replace741_1_0_0_1 -> search57_1_1 in the cache */
/* replace741_1_0_0 -> replace683_2 in the cache */

/* replace741_1_0_1 -> search57_0 in the cache */
static const nir_search_expression replace741_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace683_2.value, &search57_0.value },
   NULL,
};

/* replace741_1_1 -> replace684_2_2 in the cache */

/* replace741_1_2_0 -> search57_0 in the cache */

/* replace741_1_2_1 -> search57_1_1 in the cache */
/* replace741_1_2 -> replace683_2 in the cache */
static const nir_search_expression replace741_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace741_1_0.value, &replace684_2_2.value, &replace683_2.value },
   NULL,
};

/* replace741_2_0_0 -> search57_0 in the cache */

/* replace741_2_0_1_0 -> search57_0 in the cache */

/* replace741_2_0_1_1 -> search57_1_1 in the cache */
/* replace741_2_0_1 -> replace683_2 in the cache */
static const nir_search_expression replace741_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace683_2.value },
   NULL,
};

/* replace741_2_1 -> replace684_1 in the cache */

/* replace741_2_2_0 -> search57_0 in the cache */

/* replace741_2_2_1 -> search57_1_1 in the cache */
/* replace741_2_2 -> replace683_2 in the cache */
static const nir_search_expression replace741_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace741_2_0.value, &replace684_1.value, &replace683_2.value },
   NULL,
};
static const nir_search_expression replace741 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace684_0_0_1.value, &replace741_1.value, &replace741_2.value },
   NULL,
};

   /* search742_0_0_0 -> search14_0 in the cache */

/* search742_0_0_1 -> replace14_1_0 in the cache */
/* search742_0_0 -> search133_0 in the cache */

/* search742_0_1_0 -> search62_1_1 in the cache */

/* search742_0_1_1 -> search62_2 in the cache */
static const nir_search_expression search742_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_feq,
   { &search62_1_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression search742_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search133_0.value, &search742_0_1.value },
   (is_used_once),
};
static const nir_search_expression search742 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search742_0.value },
   NULL,
};

   /* replace742_0_0 -> search14_0 in the cache */

/* replace742_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace742_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_fne,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* replace742_1_0 -> search62_1_1 in the cache */

/* replace742_1_1 -> search62_2 in the cache */
static const nir_search_expression replace742_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_fne,
   { &search62_1_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression replace742 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace742_0.value, &replace742_1.value },
   NULL,
};

   /* search743_0_0_0 -> search14_0 in the cache */

/* search743_0_0_1 -> replace14_1_0 in the cache */
/* search743_0_0 -> search133_0 in the cache */

/* search743_0_1_0 -> search62_1_1 in the cache */

/* search743_0_1_1 -> search62_2 in the cache */
/* search743_0_1 -> search742_0_1 in the cache */
static const nir_search_expression search743_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search133_0.value, &search742_0_1.value },
   (is_used_once),
};
static const nir_search_expression search743 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search743_0.value },
   NULL,
};

   /* replace743_0_0 -> search14_0 in the cache */

/* replace743_0_1 -> replace14_1_0 in the cache */
/* replace743_0 -> replace742_0 in the cache */

/* replace743_1_0 -> search62_1_1 in the cache */

/* replace743_1_1 -> search62_2 in the cache */
/* replace743_1 -> replace742_1 in the cache */
static const nir_search_expression replace743 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace742_0.value, &replace742_1.value },
   NULL,
};

   /* search744_0_0_0 -> search14_0 in the cache */

/* search744_0_0_1 -> replace14_1_0 in the cache */
/* search744_0_0 -> search133_0 in the cache */

/* search744_0_1_0 -> search62_1_1 in the cache */

/* search744_0_1_1 -> search62_2 in the cache */
/* search744_0_1 -> replace742_1 in the cache */
static const nir_search_expression search744_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search133_0.value, &replace742_1.value },
   (is_used_once),
};
static const nir_search_expression search744 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search744_0.value },
   NULL,
};

   /* replace744_0_0 -> search14_0 in the cache */

/* replace744_0_1 -> replace14_1_0 in the cache */
/* replace744_0 -> replace742_0 in the cache */

/* replace744_1_0 -> search62_1_1 in the cache */

/* replace744_1_1 -> search62_2 in the cache */
/* replace744_1 -> search742_0_1 in the cache */
static const nir_search_expression replace744 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace742_0.value, &search742_0_1.value },
   NULL,
};

   /* search745_0_0_0 -> search14_0 in the cache */

/* search745_0_0_1 -> replace14_1_0 in the cache */
/* search745_0_0 -> search133_0 in the cache */

/* search745_0_1_0 -> search62_1_1 in the cache */

/* search745_0_1_1 -> search62_2 in the cache */
/* search745_0_1 -> replace742_1 in the cache */
static const nir_search_expression search745_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search133_0.value, &replace742_1.value },
   (is_used_once),
};
static const nir_search_expression search745 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search745_0.value },
   NULL,
};

   /* replace745_0_0 -> search14_0 in the cache */

/* replace745_0_1 -> replace14_1_0 in the cache */
/* replace745_0 -> replace742_0 in the cache */

/* replace745_1_0 -> search62_1_1 in the cache */

/* replace745_1_1 -> search62_2 in the cache */
/* replace745_1 -> search742_0_1 in the cache */
static const nir_search_expression replace745 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace742_0.value, &search742_0_1.value },
   NULL,
};

   /* search746_0_0_0 -> search14_0 in the cache */

/* search746_0_0_1 -> replace14_1_0 in the cache */
/* search746_0_0 -> replace742_0 in the cache */

/* search746_0_1_0 -> search62_1_1 in the cache */

/* search746_0_1_1 -> search62_2 in the cache */
/* search746_0_1 -> replace742_1 in the cache */
static const nir_search_expression search746_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace742_0.value, &replace742_1.value },
   (is_used_once),
};
static const nir_search_expression search746 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search746_0.value },
   NULL,
};

   /* replace746_0_0 -> search14_0 in the cache */

/* replace746_0_1 -> replace14_1_0 in the cache */
/* replace746_0 -> search133_0 in the cache */

/* replace746_1_0 -> search62_1_1 in the cache */

/* replace746_1_1 -> search62_2 in the cache */
/* replace746_1 -> search742_0_1 in the cache */
static const nir_search_expression replace746 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search133_0.value, &search742_0_1.value },
   NULL,
};

   /* search747_0_0_0 -> search14_0 in the cache */

/* search747_0_0_1 -> replace14_1_0 in the cache */
/* search747_0_0 -> replace742_0 in the cache */

/* search747_0_1_0 -> search62_1_1 in the cache */

/* search747_0_1_1 -> search62_2 in the cache */
/* search747_0_1 -> replace742_1 in the cache */
static const nir_search_expression search747_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace742_0.value, &replace742_1.value },
   (is_used_once),
};
static const nir_search_expression search747 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search747_0.value },
   NULL,
};

   /* replace747_0_0 -> search14_0 in the cache */

/* replace747_0_1 -> replace14_1_0 in the cache */
/* replace747_0 -> search133_0 in the cache */

/* replace747_1_0 -> search62_1_1 in the cache */

/* replace747_1_1 -> search62_2 in the cache */
/* replace747_1 -> search742_0_1 in the cache */
static const nir_search_expression replace747 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search133_0.value, &search742_0_1.value },
   NULL,
};

   /* search748_0_0 -> replace80_0 in the cache */
/* search748_0 -> search158_1 in the cache */
static const nir_search_expression search748 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_f2b1,
   { &search158_1.value },
   NULL,
};

   /* replace748 -> replace80_0 in the cache */

   /* search749_0_0 -> replace80_0 in the cache */
/* search749_0 -> search205_0 in the cache */
static const nir_search_expression search749 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2b1,
   { &search205_0.value },
   NULL,
};

   /* replace749 -> replace80_0 in the cache */

   /* search750_0_0 -> search98_0_0 in the cache */
static const nir_search_expression search750_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search98_0_0.value },
   NULL,
};
static const nir_search_expression search750 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_f2b8,
   { &search750_0.value },
   NULL,
};

   /* replace750 -> search98_0_0 in the cache */

   /* search751_0_0 -> search98_0_0 in the cache */
static const nir_search_expression search751_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search98_0_0.value },
   NULL,
};
static const nir_search_expression search751 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2b8,
   { &search751_0.value },
   NULL,
};

   /* replace751 -> search98_0_0 in the cache */

   /* search752_0_0 -> search101_0_0 in the cache */
static const nir_search_expression search752_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search101_0_0.value },
   NULL,
};
static const nir_search_expression search752 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2b16,
   { &search752_0.value },
   NULL,
};

   /* replace752 -> search101_0_0 in the cache */

   /* search753_0_0 -> search101_0_0 in the cache */
static const nir_search_expression search753_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search101_0_0.value },
   NULL,
};
static const nir_search_expression search753 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2b16,
   { &search753_0.value },
   NULL,
};

   /* replace753 -> search101_0_0 in the cache */

   /* search754_0_0 -> search0_0 in the cache */
static const nir_search_expression search754_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search754 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2b32,
   { &search754_0.value },
   NULL,
};

   /* replace754 -> search0_0 in the cache */

   /* search755_0_0 -> search0_0 in the cache */
/* search755_0 -> search526_0 in the cache */
/* search755 -> search526 in the cache */

   /* replace755 -> search0_0 in the cache */

   /* search756_0_0 -> search2_0 in the cache */
/* search756_0 -> search279_0 in the cache */
static const nir_search_expression search756 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2f,
   { &search279_0.value },
   NULL,
};

   /* replace756_0 -> search2_0 in the cache */
/* replace756 -> search279_0 in the cache */

   /* search757_0_0 -> search2_0 in the cache */
/* search757_0 -> search279_0 in the cache */
static const nir_search_expression search757 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search279_0.value },
   NULL,
};

   /* replace757_0 -> search2_0 in the cache */
/* replace757 -> search521_0_0 in the cache */

   /* search758_0_0 -> search2_0 in the cache */
/* search758_0 -> search279_0 in the cache */
static const nir_search_expression search758 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search279_0.value },
   NULL,
};

   /* replace758_0 -> search2_0 in the cache */
/* replace758 -> search521_0_0 in the cache */

   /* search759_0_0 -> search2_0 in the cache */
/* search759_0 -> search521_0_0 in the cache */
static const nir_search_expression search759 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search521_0_0.value },
   NULL,
};

   /* replace759_0 -> search2_0 in the cache */
/* replace759 -> search279_0 in the cache */

   /* search760_0_0 -> search2_0 in the cache */
/* search760_0 -> search521_0_0 in the cache */
static const nir_search_expression search760 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2u,
   { &search521_0_0.value },
   NULL,
};

   /* replace760_0 -> search2_0 in the cache */
/* replace760 -> search521_0_0 in the cache */

   /* search761_0_0 -> search2_0 in the cache */
/* search761_0 -> search521_0_0 in the cache */
static const nir_search_expression search761 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search521_0_0.value },
   NULL,
};

   /* replace761_0 -> search2_0 in the cache */
/* replace761 -> search279_0 in the cache */

   /* search762_0_0 -> search2_0 in the cache */
/* search762_0 -> search521_0_0 in the cache */
static const nir_search_expression search762 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2i,
   { &search521_0_0.value },
   NULL,
};

   /* replace762_0 -> search2_0 in the cache */
/* replace762 -> search521_0_0 in the cache */

   /* search763_0 -> replace80_0 in the cache */
static const nir_search_expression search763 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &replace80_0.value },
   NULL,
};

   /* replace763 -> replace80_0 in the cache */

   /* search764_0 -> search98_0_0 in the cache */
static const nir_search_expression search764 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search98_0_0.value },
   NULL,
};

   /* replace764 -> search98_0_0 in the cache */

   /* search765_0 -> search101_0_0 in the cache */
static const nir_search_expression search765 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search101_0_0.value },
   NULL,
};

   /* replace765 -> search101_0_0 in the cache */

   /* search766_0 -> search0_0 in the cache */
static const nir_search_expression search766 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search0_0.value },
   NULL,
};

   /* replace766 -> search0_0 in the cache */

   /* search767_0 -> search57_0 in the cache */
static const nir_search_expression search767 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search57_0.value },
   NULL,
};

   /* replace767 -> search57_0 in the cache */

   /* search768_0 -> replace80_0 in the cache */
static const nir_search_expression search768 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &replace80_0.value },
   NULL,
};

   /* replace768 -> replace80_0 in the cache */

   /* search769_0 -> search98_0_0 in the cache */
static const nir_search_expression search769 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search98_0_0.value },
   NULL,
};

   /* replace769 -> search98_0_0 in the cache */

   /* search770_0 -> search101_0_0 in the cache */
static const nir_search_expression search770 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search101_0_0.value },
   NULL,
};

   /* replace770 -> search101_0_0 in the cache */

   /* search771_0 -> search0_0 in the cache */
static const nir_search_expression search771 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search0_0.value },
   NULL,
};

   /* replace771 -> search0_0 in the cache */

   /* search772_0 -> search57_0 in the cache */
static const nir_search_expression search772 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search57_0.value },
   NULL,
};

   /* replace772 -> search57_0 in the cache */

   /* search773_0 -> search101_0_0 in the cache */
static const nir_search_expression search773 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search101_0_0.value },
   NULL,
};

   /* replace773 -> search101_0_0 in the cache */

   /* search774_0 -> search0_0 in the cache */
static const nir_search_expression search774 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search0_0.value },
   NULL,
};

   /* replace774 -> search0_0 in the cache */

   /* search775_0 -> search57_0 in the cache */
static const nir_search_expression search775 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search57_0.value },
   NULL,
};

   /* replace775 -> search57_0 in the cache */

   /* search776_0_0 -> search2_0 in the cache */
static const nir_search_expression search776_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search776 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search776_0.value },
   NULL,
};

   /* replace776_0 -> search2_0 in the cache */
static const nir_search_expression replace776 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search2_0.value },
   NULL,
};

   /* search777_0_0 -> search2_0 in the cache */
static const nir_search_expression search777_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search777 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search777_0.value },
   NULL,
};

   /* replace777_0 -> search2_0 in the cache */
static const nir_search_expression replace777 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search2_0.value },
   NULL,
};

   /* search778_0_0 -> search2_0 in the cache */
/* search778_0 -> search776_0 in the cache */
static const nir_search_expression search778 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search776_0.value },
   NULL,
};

   /* replace778_0 -> search2_0 in the cache */
/* replace778 -> replace776 in the cache */

   /* search779_0_0 -> search2_0 in the cache */
/* search779_0 -> search777_0 in the cache */
static const nir_search_expression search779 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search777_0.value },
   NULL,
};

   /* replace779_0 -> search2_0 in the cache */
/* replace779 -> replace777 in the cache */

   /* search780_0_0 -> search2_0 in the cache */
static const nir_search_expression search780_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search780 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search780_0.value },
   NULL,
};

   /* replace780_0 -> search2_0 in the cache */
/* replace780 -> replace776 in the cache */

   /* search781_0_0 -> search2_0 in the cache */
static const nir_search_expression search781_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search781 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search781_0.value },
   NULL,
};

   /* replace781_0 -> search2_0 in the cache */
/* replace781 -> replace777 in the cache */

   /* search782_0_0 -> search2_0 in the cache */
/* search782_0 -> search780_0 in the cache */
static const nir_search_expression search782 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search780_0.value },
   NULL,
};

   /* replace782_0 -> search2_0 in the cache */
/* replace782 -> replace776 in the cache */

   /* search783_0_0 -> search2_0 in the cache */
/* search783_0 -> search781_0 in the cache */
static const nir_search_expression search783 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search781_0.value },
   NULL,
};

   /* replace783_0 -> search2_0 in the cache */
/* replace783 -> replace777 in the cache */

   /* search784_0_0 -> search2_0 in the cache */
static const nir_search_expression search784_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search784 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search784_0.value },
   NULL,
};

   /* replace784_0 -> search2_0 in the cache */
/* replace784 -> replace776 in the cache */

   /* search785_0_0 -> search2_0 in the cache */
static const nir_search_expression search785_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search785 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search785_0.value },
   NULL,
};

   /* replace785_0 -> search2_0 in the cache */
/* replace785 -> replace777 in the cache */

   /* search786_0_0 -> search2_0 in the cache */
/* search786_0 -> search784_0 in the cache */
static const nir_search_expression search786 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search784_0.value },
   NULL,
};

   /* replace786_0 -> search2_0 in the cache */
/* replace786 -> replace776 in the cache */

   /* search787_0_0 -> search2_0 in the cache */
/* search787_0 -> search785_0 in the cache */
static const nir_search_expression search787 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search785_0.value },
   NULL,
};

   /* replace787_0 -> search2_0 in the cache */
/* replace787 -> replace777 in the cache */

   /* search788_0_0 -> search2_0 in the cache */
static const nir_search_expression search788_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search788 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search788_0.value },
   NULL,
};

   /* replace788_0 -> search2_0 in the cache */
/* replace788 -> replace776 in the cache */

   /* search789_0_0 -> search2_0 in the cache */
static const nir_search_expression search789_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search789 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search789_0.value },
   NULL,
};

   /* replace789_0 -> search2_0 in the cache */
/* replace789 -> replace777 in the cache */

   /* search790_0_0 -> search2_0 in the cache */
/* search790_0 -> search788_0 in the cache */
static const nir_search_expression search790 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search788_0.value },
   NULL,
};

   /* replace790_0 -> search2_0 in the cache */
/* replace790 -> replace776 in the cache */

   /* search791_0_0 -> search2_0 in the cache */
/* search791_0 -> search789_0 in the cache */
static const nir_search_expression search791 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search789_0.value },
   NULL,
};

   /* replace791_0 -> search2_0 in the cache */
/* replace791 -> replace777 in the cache */

   /* search792_0_0 -> replace80_0 in the cache */
/* search792_0 -> search763 in the cache */
static const nir_search_expression search792 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search763.value },
   NULL,
};

   /* replace792_0 -> replace80_0 in the cache */
static const nir_search_expression replace792 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &replace80_0.value },
   NULL,
};

   /* search793_0_0 -> replace80_0 in the cache */
/* search793_0 -> search768 in the cache */
static const nir_search_expression search793 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search768.value },
   NULL,
};

   /* replace793_0 -> replace80_0 in the cache */
static const nir_search_expression replace793 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &replace80_0.value },
   NULL,
};

   /* search794_0_0 -> search2_0 in the cache */
/* search794_0 -> search780_0 in the cache */
static const nir_search_expression search794 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search780_0.value },
   NULL,
};

   /* replace794_0 -> search2_0 in the cache */
/* replace794 -> search776_0 in the cache */

   /* search795_0_0 -> search2_0 in the cache */
/* search795_0 -> search781_0 in the cache */
static const nir_search_expression search795 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search781_0.value },
   NULL,
};

   /* replace795_0 -> search2_0 in the cache */
/* replace795 -> search777_0 in the cache */

   /* search796_0_0 -> search2_0 in the cache */
/* search796_0 -> search780_0 in the cache */
static const nir_search_expression search796 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search780_0.value },
   NULL,
};

   /* replace796_0 -> search2_0 in the cache */
/* replace796 -> search776_0 in the cache */

   /* search797_0_0 -> search2_0 in the cache */
/* search797_0 -> search781_0 in the cache */
static const nir_search_expression search797 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search781_0.value },
   NULL,
};

   /* replace797_0 -> search2_0 in the cache */
/* replace797 -> search777_0 in the cache */

   /* search798_0_0 -> search2_0 in the cache */
/* search798_0 -> search784_0 in the cache */
static const nir_search_expression search798 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search784_0.value },
   NULL,
};

   /* replace798_0 -> search2_0 in the cache */
/* replace798 -> search776_0 in the cache */

   /* search799_0_0 -> search2_0 in the cache */
/* search799_0 -> search785_0 in the cache */
static const nir_search_expression search799 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search785_0.value },
   NULL,
};

   /* replace799_0 -> search2_0 in the cache */
/* replace799 -> search777_0 in the cache */

   /* search800_0_0 -> search2_0 in the cache */
/* search800_0 -> search784_0 in the cache */
static const nir_search_expression search800 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search784_0.value },
   NULL,
};

   /* replace800_0 -> search2_0 in the cache */
/* replace800 -> search776_0 in the cache */

   /* search801_0_0 -> search2_0 in the cache */
/* search801_0 -> search785_0 in the cache */
static const nir_search_expression search801 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search785_0.value },
   NULL,
};

   /* replace801_0 -> search2_0 in the cache */
/* replace801 -> search777_0 in the cache */

   /* search802_0_0 -> search2_0 in the cache */
/* search802_0 -> search788_0 in the cache */
static const nir_search_expression search802 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search788_0.value },
   NULL,
};

   /* replace802_0 -> search2_0 in the cache */
/* replace802 -> search776_0 in the cache */

   /* search803_0_0 -> search2_0 in the cache */
/* search803_0 -> search789_0 in the cache */
static const nir_search_expression search803 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search789_0.value },
   NULL,
};

   /* replace803_0 -> search2_0 in the cache */
/* replace803 -> search777_0 in the cache */

   /* search804_0_0 -> search2_0 in the cache */
/* search804_0 -> search788_0 in the cache */
static const nir_search_expression search804 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search788_0.value },
   NULL,
};

   /* replace804_0 -> search2_0 in the cache */
/* replace804 -> search776_0 in the cache */

   /* search805_0_0 -> search2_0 in the cache */
/* search805_0 -> search789_0 in the cache */
static const nir_search_expression search805 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search789_0.value },
   NULL,
};

   /* replace805_0 -> search2_0 in the cache */
/* replace805 -> search777_0 in the cache */

   /* search806_0_0 -> replace80_0 in the cache */
/* search806_0 -> search763 in the cache */
static const nir_search_expression search806 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search763.value },
   NULL,
};

   /* replace806_0 -> replace80_0 in the cache */
static const nir_search_expression replace806 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &replace80_0.value },
   NULL,
};

   /* search807_0_0 -> replace80_0 in the cache */
/* search807_0 -> search768 in the cache */
static const nir_search_expression search807 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search768.value },
   NULL,
};

   /* replace807_0 -> replace80_0 in the cache */
static const nir_search_expression replace807 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &replace80_0.value },
   NULL,
};

   /* search808_0_0 -> replace80_0 in the cache */
/* search808_0 -> replace792 in the cache */
static const nir_search_expression search808 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &replace792.value },
   NULL,
};

   /* replace808_0 -> replace80_0 in the cache */
/* replace808 -> replace806 in the cache */

   /* search809_0_0 -> replace80_0 in the cache */
/* search809_0 -> replace793 in the cache */
static const nir_search_expression search809 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &replace793.value },
   NULL,
};

   /* replace809_0 -> replace80_0 in the cache */
/* replace809 -> replace807 in the cache */

   /* search810_0_0 -> search98_0_0 in the cache */
/* search810_0 -> search764 in the cache */
static const nir_search_expression search810 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search764.value },
   NULL,
};

   /* replace810_0 -> search98_0_0 in the cache */
static const nir_search_expression replace810 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search98_0_0.value },
   NULL,
};

   /* search811_0_0 -> search98_0_0 in the cache */
/* search811_0 -> search769 in the cache */
static const nir_search_expression search811 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search769.value },
   NULL,
};

   /* replace811_0 -> search98_0_0 in the cache */
static const nir_search_expression replace811 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search98_0_0.value },
   NULL,
};

   /* search812_0_0 -> search2_0 in the cache */
/* search812_0 -> search784_0 in the cache */
static const nir_search_expression search812 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search784_0.value },
   NULL,
};

   /* replace812_0 -> search2_0 in the cache */
/* replace812 -> search780_0 in the cache */

   /* search813_0_0 -> search2_0 in the cache */
/* search813_0 -> search785_0 in the cache */
static const nir_search_expression search813 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search785_0.value },
   NULL,
};

   /* replace813_0 -> search2_0 in the cache */
/* replace813 -> search781_0 in the cache */

   /* search814_0_0 -> search2_0 in the cache */
/* search814_0 -> search784_0 in the cache */
static const nir_search_expression search814 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search784_0.value },
   NULL,
};

   /* replace814_0 -> search2_0 in the cache */
/* replace814 -> search780_0 in the cache */

   /* search815_0_0 -> search2_0 in the cache */
/* search815_0 -> search785_0 in the cache */
static const nir_search_expression search815 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search785_0.value },
   NULL,
};

   /* replace815_0 -> search2_0 in the cache */
/* replace815 -> search781_0 in the cache */

   /* search816_0_0 -> search2_0 in the cache */
/* search816_0 -> search788_0 in the cache */
static const nir_search_expression search816 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search788_0.value },
   NULL,
};

   /* replace816_0 -> search2_0 in the cache */
/* replace816 -> search780_0 in the cache */

   /* search817_0_0 -> search2_0 in the cache */
/* search817_0 -> search789_0 in the cache */
static const nir_search_expression search817 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search789_0.value },
   NULL,
};

   /* replace817_0 -> search2_0 in the cache */
/* replace817 -> search781_0 in the cache */

   /* search818_0_0 -> search2_0 in the cache */
/* search818_0 -> search788_0 in the cache */
static const nir_search_expression search818 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search788_0.value },
   NULL,
};

   /* replace818_0 -> search2_0 in the cache */
/* replace818 -> search780_0 in the cache */

   /* search819_0_0 -> search2_0 in the cache */
/* search819_0 -> search789_0 in the cache */
static const nir_search_expression search819 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search789_0.value },
   NULL,
};

   /* replace819_0 -> search2_0 in the cache */
/* replace819 -> search781_0 in the cache */

   /* search820_0_0 -> replace80_0 in the cache */
/* search820_0 -> search763 in the cache */
static const nir_search_expression search820 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search763.value },
   NULL,
};

   /* replace820_0 -> replace80_0 in the cache */
static const nir_search_expression replace820 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace80_0.value },
   NULL,
};

   /* search821_0_0 -> replace80_0 in the cache */
/* search821_0 -> search768 in the cache */
static const nir_search_expression search821 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search768.value },
   NULL,
};

   /* replace821_0 -> replace80_0 in the cache */
static const nir_search_expression replace821 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace80_0.value },
   NULL,
};

   /* search822_0_0 -> replace80_0 in the cache */
/* search822_0 -> replace792 in the cache */
static const nir_search_expression search822 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace792.value },
   NULL,
};

   /* replace822_0 -> replace80_0 in the cache */
/* replace822 -> replace820 in the cache */

   /* search823_0_0 -> replace80_0 in the cache */
/* search823_0 -> replace793 in the cache */
static const nir_search_expression search823 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace793.value },
   NULL,
};

   /* replace823_0 -> replace80_0 in the cache */
/* replace823 -> replace821 in the cache */

   /* search824_0_0 -> search98_0_0 in the cache */
/* search824_0 -> search764 in the cache */
static const nir_search_expression search824 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search764.value },
   NULL,
};

   /* replace824_0 -> search98_0_0 in the cache */
static const nir_search_expression replace824 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search98_0_0.value },
   NULL,
};

   /* search825_0_0 -> search98_0_0 in the cache */
/* search825_0 -> search769 in the cache */
static const nir_search_expression search825 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search769.value },
   NULL,
};

   /* replace825_0 -> search98_0_0 in the cache */
static const nir_search_expression replace825 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search98_0_0.value },
   NULL,
};

   /* search826_0_0 -> replace80_0 in the cache */
/* search826_0 -> replace806 in the cache */
static const nir_search_expression search826 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace806.value },
   NULL,
};

   /* replace826_0 -> replace80_0 in the cache */
/* replace826 -> replace820 in the cache */

   /* search827_0_0 -> replace80_0 in the cache */
/* search827_0 -> replace807 in the cache */
static const nir_search_expression search827 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace807.value },
   NULL,
};

   /* replace827_0 -> replace80_0 in the cache */
/* replace827 -> replace821 in the cache */

   /* search828_0_0 -> search98_0_0 in the cache */
/* search828_0 -> replace810 in the cache */
static const nir_search_expression search828 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace810.value },
   NULL,
};

   /* replace828_0 -> search98_0_0 in the cache */
/* replace828 -> replace824 in the cache */

   /* search829_0_0 -> search98_0_0 in the cache */
/* search829_0 -> replace811 in the cache */
static const nir_search_expression search829 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace811.value },
   NULL,
};

   /* replace829_0 -> search98_0_0 in the cache */
/* replace829 -> replace825 in the cache */

   /* search830_0_0 -> search101_0_0 in the cache */
/* search830_0 -> search765 in the cache */
static const nir_search_expression search830 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search765.value },
   NULL,
};

   /* replace830_0 -> search101_0_0 in the cache */
static const nir_search_expression replace830 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search101_0_0.value },
   NULL,
};

   /* search831_0_0 -> search101_0_0 in the cache */
/* search831_0 -> search770 in the cache */
static const nir_search_expression search831 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search770.value },
   NULL,
};

   /* replace831_0 -> search101_0_0 in the cache */
static const nir_search_expression replace831 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search101_0_0.value },
   NULL,
};

   /* search832_0_0 -> search2_0 in the cache */
/* search832_0 -> search788_0 in the cache */
static const nir_search_expression search832 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search788_0.value },
   NULL,
};

   /* replace832_0 -> search2_0 in the cache */
/* replace832 -> search784_0 in the cache */

   /* search833_0_0 -> search2_0 in the cache */
/* search833_0 -> search789_0 in the cache */
static const nir_search_expression search833 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search789_0.value },
   NULL,
};

   /* replace833_0 -> search2_0 in the cache */
/* replace833 -> search785_0 in the cache */

   /* search834_0_0 -> search2_0 in the cache */
/* search834_0 -> search788_0 in the cache */
static const nir_search_expression search834 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search788_0.value },
   NULL,
};

   /* replace834_0 -> search2_0 in the cache */
/* replace834 -> search784_0 in the cache */

   /* search835_0_0 -> search2_0 in the cache */
/* search835_0 -> search789_0 in the cache */
static const nir_search_expression search835 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search789_0.value },
   NULL,
};

   /* replace835_0 -> search2_0 in the cache */
/* replace835 -> search785_0 in the cache */

   /* search836_0_0 -> replace80_0 in the cache */
/* search836_0 -> search763 in the cache */
static const nir_search_expression search836 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search763.value },
   NULL,
};

   /* replace836_0 -> replace80_0 in the cache */
static const nir_search_expression replace836 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace80_0.value },
   NULL,
};

   /* search837_0_0 -> replace80_0 in the cache */
/* search837_0 -> search768 in the cache */
static const nir_search_expression search837 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search768.value },
   NULL,
};

   /* replace837_0 -> replace80_0 in the cache */
static const nir_search_expression replace837 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace80_0.value },
   NULL,
};

   /* search838_0_0 -> replace80_0 in the cache */
/* search838_0 -> replace792 in the cache */
static const nir_search_expression search838 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace792.value },
   NULL,
};

   /* replace838_0 -> replace80_0 in the cache */
/* replace838 -> replace836 in the cache */

   /* search839_0_0 -> replace80_0 in the cache */
/* search839_0 -> replace793 in the cache */
static const nir_search_expression search839 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace793.value },
   NULL,
};

   /* replace839_0 -> replace80_0 in the cache */
/* replace839 -> replace837 in the cache */

   /* search840_0_0 -> search98_0_0 in the cache */
/* search840_0 -> search764 in the cache */
static const nir_search_expression search840 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search764.value },
   NULL,
};

   /* replace840_0 -> search98_0_0 in the cache */
static const nir_search_expression replace840 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search98_0_0.value },
   NULL,
};

   /* search841_0_0 -> search98_0_0 in the cache */
/* search841_0 -> search769 in the cache */
static const nir_search_expression search841 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search769.value },
   NULL,
};

   /* replace841_0 -> search98_0_0 in the cache */
static const nir_search_expression replace841 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search98_0_0.value },
   NULL,
};

   /* search842_0_0 -> replace80_0 in the cache */
/* search842_0 -> replace806 in the cache */
static const nir_search_expression search842 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace806.value },
   NULL,
};

   /* replace842_0 -> replace80_0 in the cache */
/* replace842 -> replace836 in the cache */

   /* search843_0_0 -> replace80_0 in the cache */
/* search843_0 -> replace807 in the cache */
static const nir_search_expression search843 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace807.value },
   NULL,
};

   /* replace843_0 -> replace80_0 in the cache */
/* replace843 -> replace837 in the cache */

   /* search844_0_0 -> search98_0_0 in the cache */
/* search844_0 -> replace810 in the cache */
static const nir_search_expression search844 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace810.value },
   NULL,
};

   /* replace844_0 -> search98_0_0 in the cache */
/* replace844 -> replace840 in the cache */

   /* search845_0_0 -> search98_0_0 in the cache */
/* search845_0 -> replace811 in the cache */
static const nir_search_expression search845 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace811.value },
   NULL,
};

   /* replace845_0 -> search98_0_0 in the cache */
/* replace845 -> replace841 in the cache */

   /* search846_0_0 -> search101_0_0 in the cache */
/* search846_0 -> search765 in the cache */
static const nir_search_expression search846 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search765.value },
   NULL,
};

   /* replace846_0 -> search101_0_0 in the cache */
static const nir_search_expression replace846 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search101_0_0.value },
   NULL,
};

   /* search847_0_0 -> search101_0_0 in the cache */
/* search847_0 -> search770 in the cache */
static const nir_search_expression search847 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search770.value },
   NULL,
};

   /* replace847_0 -> search101_0_0 in the cache */
static const nir_search_expression replace847 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search101_0_0.value },
   NULL,
};

   /* search848_0_0 -> replace80_0 in the cache */
/* search848_0 -> replace820 in the cache */
static const nir_search_expression search848 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace820.value },
   NULL,
};

   /* replace848_0 -> replace80_0 in the cache */
/* replace848 -> replace836 in the cache */

   /* search849_0_0 -> replace80_0 in the cache */
/* search849_0 -> replace821 in the cache */
static const nir_search_expression search849 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace821.value },
   NULL,
};

   /* replace849_0 -> replace80_0 in the cache */
/* replace849 -> replace837 in the cache */

   /* search850_0_0 -> search98_0_0 in the cache */
/* search850_0 -> replace824 in the cache */
static const nir_search_expression search850 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace824.value },
   NULL,
};

   /* replace850_0 -> search98_0_0 in the cache */
/* replace850 -> replace840 in the cache */

   /* search851_0_0 -> search98_0_0 in the cache */
/* search851_0 -> replace825 in the cache */
static const nir_search_expression search851 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace825.value },
   NULL,
};

   /* replace851_0 -> search98_0_0 in the cache */
/* replace851 -> replace841 in the cache */

   /* search852_0_0 -> search101_0_0 in the cache */
/* search852_0 -> replace830 in the cache */
static const nir_search_expression search852 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace830.value },
   NULL,
};

   /* replace852_0 -> search101_0_0 in the cache */
/* replace852 -> replace846 in the cache */

   /* search853_0_0 -> search101_0_0 in the cache */
/* search853_0 -> replace831 in the cache */
static const nir_search_expression search853 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace831.value },
   NULL,
};

   /* replace853_0 -> search101_0_0 in the cache */
/* replace853 -> replace847 in the cache */

   /* search854_0_0 -> search0_0 in the cache */
/* search854_0 -> search766 in the cache */
static const nir_search_expression search854 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search766.value },
   NULL,
};

   /* replace854_0 -> search0_0 in the cache */
static const nir_search_expression replace854 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search0_0.value },
   NULL,
};

   /* search855_0_0 -> search0_0 in the cache */
/* search855_0 -> search771 in the cache */
static const nir_search_expression search855 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search771.value },
   NULL,
};

   /* replace855_0 -> search0_0 in the cache */
static const nir_search_expression replace855 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search0_0.value },
   NULL,
};

   /* search856_0_0 -> search98_0_0 in the cache */
/* search856_0 -> replace810 in the cache */

/* search856_1_0 -> search734_1 in the cache */
static const nir_search_expression search856_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search734_1.value },
   NULL,
};
static const nir_search_expression search856 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace810.value, &search856_1.value },
   NULL,
};

   /* replace856_0 -> search98_0_0 in the cache */

/* replace856_1_0 -> search734_1 in the cache */
static const nir_search_expression replace856_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search734_1.value },
   NULL,
};
static const nir_search_expression replace856 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace856_1.value },
   NULL,
};

   /* search857_0_0 -> search98_0_0 in the cache */
/* search857_0 -> replace810 in the cache */

/* search857_1_0 -> search734_1 in the cache */
/* search857_1 -> search856_1 in the cache */
static const nir_search_expression search857 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace810.value, &search856_1.value },
   NULL,
};

   /* replace857_0 -> search98_0_0 in the cache */

/* replace857_1_0 -> search734_1 in the cache */
/* replace857_1 -> replace856_1 in the cache */
static const nir_search_expression replace857 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace856_1.value },
   NULL,
};

   /* search858_0_0 -> search98_0_0 in the cache */
/* search858_0 -> replace810 in the cache */

/* search858_1_0 -> search734_1 in the cache */
/* search858_1 -> search856_1 in the cache */
static const nir_search_expression search858 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace810.value, &search856_1.value },
   NULL,
};

   /* replace858_0 -> search98_0_0 in the cache */

/* replace858_1_0 -> search734_1 in the cache */
/* replace858_1 -> replace856_1 in the cache */
static const nir_search_expression replace858 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search98_0_0.value, &replace856_1.value },
   NULL,
};

   /* search859_0_0 -> search98_0_0 in the cache */
/* search859_0 -> replace810 in the cache */

/* search859_1_0 -> search734_1 in the cache */
/* search859_1 -> search856_1 in the cache */
static const nir_search_expression search859 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace810.value, &search856_1.value },
   NULL,
};

   /* replace859_0 -> search98_0_0 in the cache */

/* replace859_1_0 -> search734_1 in the cache */
/* replace859_1 -> replace856_1 in the cache */
static const nir_search_expression replace859 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search98_0_0.value, &replace856_1.value },
   NULL,
};

   static const nir_search_variable search860_0_0 = {
   { nir_search_value_variable, 8 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search860_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search860_0_0.value },
   NULL,
};

static const nir_search_variable search860_1_0 = {
   { nir_search_value_variable, 8 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search860_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search860_1_0.value },
   NULL,
};
static const nir_search_expression search860 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search860_0.value, &search860_1.value },
   NULL,
};

   /* replace860_0_0 -> search860_0_0 in the cache */
static const nir_search_expression replace860_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search860_0_0.value },
   NULL,
};

/* replace860_1 -> search860_1_0 in the cache */
static const nir_search_expression replace860 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace860_0.value, &search860_1_0.value },
   NULL,
};

   /* search861_0_0 -> search860_0_0 in the cache */
/* search861_0 -> search860_0 in the cache */

/* search861_1_0 -> search860_1_0 in the cache */
/* search861_1 -> search860_1 in the cache */
static const nir_search_expression search861 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search860_0.value, &search860_1.value },
   NULL,
};

   /* replace861_0_0 -> search860_0_0 in the cache */
/* replace861_0 -> replace860_0 in the cache */

/* replace861_1 -> search860_1_0 in the cache */
static const nir_search_expression replace861 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace860_0.value, &search860_1_0.value },
   NULL,
};

   /* search862_0_0 -> search98_0_0 in the cache */
/* search862_0 -> replace810 in the cache */

/* search862_1 -> search573_0_1 in the cache */
static const nir_search_expression search862 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace810.value, &search573_0_1.value },
   NULL,
};

   /* replace862_0_0 -> search98_0_0 in the cache */

/* replace862_0_1_0 -> replace573_1_0 in the cache */
static const nir_search_expression replace862_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace862_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace862_0_1.value },
   NULL,
};

/* replace862_1_0_0_0 -> replace573_1_0 in the cache */
/* replace862_1_0_0 -> replace862_0_1 in the cache */
static const nir_search_expression replace862_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &replace862_0_1.value },
   NULL,
};

/* replace862_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace862_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace862_1_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace862 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace862_0.value, &replace862_1.value },
   NULL,
};

   /* search863_0_0 -> search98_0_0 in the cache */
/* search863_0 -> replace810 in the cache */

/* search863_1 -> search573_0_1 in the cache */
static const nir_search_expression search863 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace810.value, &search573_0_1.value },
   NULL,
};

   /* replace863_0_0 -> search98_0_0 in the cache */

/* replace863_0_1_0 -> replace573_1_0 in the cache */
/* replace863_0_1 -> replace862_0_1 in the cache */
static const nir_search_expression replace863_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace862_0_1.value },
   NULL,
};

/* replace863_1_0_0_0 -> replace573_1_0 in the cache */
/* replace863_1_0_0 -> replace862_0_1 in the cache */
/* replace863_1_0 -> replace862_1_0 in the cache */

/* replace863_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace863_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace862_1_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace863 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace863_0.value, &replace863_1.value },
   NULL,
};

   /* search864_0_0 -> search98_0_0 in the cache */
/* search864_0 -> replace810 in the cache */

/* search864_1 -> search573_0_1 in the cache */
static const nir_search_expression search864 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace810.value, &search573_0_1.value },
   NULL,
};

   static const nir_search_constant replace864_0_0 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { -0x80 /* -128 */ },
};

/* replace864_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace864_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace864_0_0.value, &replace573_1_0.value },
   NULL,
};

static const nir_search_constant replace864_1_0_0 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x7f /* 127 */ },
};

/* replace864_1_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace864_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace864_1_0_0.value, &replace573_1_0.value },
   NULL,
};

/* replace864_1_1_0 -> search98_0_0 in the cache */

/* replace864_1_1_1_0 -> replace573_1_0 in the cache */
/* replace864_1_1_1 -> replace862_0_1 in the cache */
static const nir_search_expression replace864_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search98_0_0.value, &replace862_0_1.value },
   NULL,
};
static const nir_search_expression replace864_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace864_1_0.value, &replace864_1_1.value },
   NULL,
};
static const nir_search_expression replace864 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace864_0.value, &replace864_1.value },
   NULL,
};

   static const nir_search_variable search865_0 = {
   { nir_search_value_variable, 16 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search865_1_0 -> search734_1 in the cache */
/* search865_1 -> search856_1 in the cache */
static const nir_search_expression search865 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search865_0.value, &search856_1.value },
   NULL,
};

   /* replace865_0_0 -> search101_0_0 in the cache */

/* replace865_0_1 -> replace864_1_0_0 in the cache */
static const nir_search_expression replace865_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace864_1_0_0.value },
   NULL,
};

/* replace865_1_0_0 -> search101_0_0 in the cache */

/* replace865_1_0_1 -> replace864_0_0 in the cache */
static const nir_search_expression replace865_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace864_0_0.value },
   NULL,
};

/* replace865_1_1_0_0 -> search101_0_0 in the cache */
static const nir_search_expression replace865_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search101_0_0.value },
   NULL,
};

/* replace865_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace865_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace865_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace865_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace865_1_0.value, &replace865_1_1.value },
   NULL,
};
static const nir_search_expression replace865 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace865_0.value, &replace865_1.value },
   NULL,
};

   /* search866_0_0 -> search98_0_0 in the cache */
/* search866_0 -> replace810 in the cache */

/* search866_1 -> search573_0_1 in the cache */
static const nir_search_expression search866 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace810.value, &search573_0_1.value },
   NULL,
};

   /* replace866_0_0 -> replace864_1_0_0 in the cache */

/* replace866_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace866_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace864_1_0_0.value, &replace573_1_0.value },
   NULL,
};

/* replace866_1_0_0 -> replace864_0_0 in the cache */

/* replace866_1_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace866_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace864_0_0.value, &replace573_1_0.value },
   NULL,
};

/* replace866_1_1_0 -> search98_0_0 in the cache */

/* replace866_1_1_1_0 -> replace573_1_0 in the cache */
/* replace866_1_1_1 -> replace862_0_1 in the cache */
static const nir_search_expression replace866_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search98_0_0.value, &replace862_0_1.value },
   NULL,
};
static const nir_search_expression replace866_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace866_1_0.value, &replace866_1_1.value },
   NULL,
};
static const nir_search_expression replace866 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace866_0.value, &replace866_1.value },
   NULL,
};

   /* search867_0 -> search865_0 in the cache */

/* search867_1_0 -> search734_1 in the cache */
/* search867_1 -> search856_1 in the cache */
static const nir_search_expression search867 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search865_0.value, &search856_1.value },
   NULL,
};

   /* replace867_0_0 -> search101_0_0 in the cache */

/* replace867_0_1 -> replace864_0_0 in the cache */
static const nir_search_expression replace867_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &replace864_0_0.value },
   NULL,
};

/* replace867_1_0_0 -> search101_0_0 in the cache */

/* replace867_1_0_1 -> replace864_1_0_0 in the cache */
static const nir_search_expression replace867_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &replace864_1_0_0.value },
   NULL,
};

/* replace867_1_1_0_0 -> search101_0_0 in the cache */
/* replace867_1_1_0 -> replace865_1_1_0 in the cache */

/* replace867_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace867_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace865_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace867_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace867_1_0.value, &replace867_1_1.value },
   NULL,
};
static const nir_search_expression replace867 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace867_0.value, &replace867_1.value },
   NULL,
};

   /* search868_0_0 -> search98_0_0 in the cache */
/* search868_0 -> replace824 in the cache */

/* search868_1_0 -> search734_1 in the cache */
static const nir_search_expression search868_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search734_1.value },
   NULL,
};
static const nir_search_expression search868 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace824.value, &search868_1.value },
   NULL,
};

   /* replace868_0 -> search98_0_0 in the cache */

/* replace868_1_0 -> search734_1 in the cache */
/* replace868_1 -> replace856_1 in the cache */
/* replace868 -> replace856 in the cache */

   /* search869_0_0 -> search98_0_0 in the cache */
/* search869_0 -> replace824 in the cache */

/* search869_1_0 -> search734_1 in the cache */
/* search869_1 -> search868_1 in the cache */
static const nir_search_expression search869 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace824.value, &search868_1.value },
   NULL,
};

   /* replace869_0 -> search98_0_0 in the cache */

/* replace869_1_0 -> search734_1 in the cache */
/* replace869_1 -> replace856_1 in the cache */
/* replace869 -> replace857 in the cache */

   /* search870_0_0 -> search98_0_0 in the cache */
/* search870_0 -> replace824 in the cache */

/* search870_1_0 -> search734_1 in the cache */
/* search870_1 -> search868_1 in the cache */
static const nir_search_expression search870 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace824.value, &search868_1.value },
   NULL,
};

   /* replace870_0 -> search98_0_0 in the cache */

/* replace870_1_0 -> search734_1 in the cache */
/* replace870_1 -> replace856_1 in the cache */
/* replace870 -> replace858 in the cache */

   /* search871_0_0 -> search98_0_0 in the cache */
/* search871_0 -> replace824 in the cache */

/* search871_1_0 -> search734_1 in the cache */
/* search871_1 -> search868_1 in the cache */
static const nir_search_expression search871 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace824.value, &search868_1.value },
   NULL,
};

   /* replace871_0 -> search98_0_0 in the cache */

/* replace871_1_0 -> search734_1 in the cache */
/* replace871_1 -> replace856_1 in the cache */
/* replace871 -> replace859 in the cache */

   /* search872_0_0 -> search860_0_0 in the cache */
static const nir_search_expression search872_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search860_0_0.value },
   NULL,
};

/* search872_1_0 -> search860_1_0 in the cache */
static const nir_search_expression search872_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search860_1_0.value },
   NULL,
};
static const nir_search_expression search872 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search872_0.value, &search872_1.value },
   NULL,
};

   /* replace872_0_0 -> search860_0_0 in the cache */
/* replace872_0 -> replace860_0 in the cache */

/* replace872_1 -> search860_1_0 in the cache */
/* replace872 -> replace860 in the cache */

   /* search873_0_0 -> search860_0_0 in the cache */
/* search873_0 -> search872_0 in the cache */

/* search873_1_0 -> search860_1_0 in the cache */
/* search873_1 -> search872_1 in the cache */
static const nir_search_expression search873 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search872_0.value, &search872_1.value },
   NULL,
};

   /* replace873_0_0 -> search860_0_0 in the cache */
/* replace873_0 -> replace860_0 in the cache */

/* replace873_1 -> search860_1_0 in the cache */
/* replace873 -> replace861 in the cache */

   /* search874_0_0 -> search98_0_0 in the cache */
/* search874_0 -> replace824 in the cache */

/* search874_1 -> search2_1 in the cache */
static const nir_search_expression search874 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace824.value, &search2_1.value },
   NULL,
};

   /* replace874_0_0 -> search98_0_0 in the cache */

/* replace874_0_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace874_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace874_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace874_0_1.value },
   NULL,
};

/* replace874_1_0_0_0 -> replace0_1_0 in the cache */
/* replace874_1_0_0 -> replace874_0_1 in the cache */
static const nir_search_expression replace874_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace874_0_1.value },
   NULL,
};

/* replace874_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace874_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace874_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace874 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace874_0.value, &replace874_1.value },
   NULL,
};

   /* search875_0_0 -> search98_0_0 in the cache */
/* search875_0 -> replace824 in the cache */

/* search875_1 -> search2_1 in the cache */
static const nir_search_expression search875 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace824.value, &search2_1.value },
   NULL,
};

   /* replace875_0_0 -> search98_0_0 in the cache */

/* replace875_0_1_0 -> replace0_1_0 in the cache */
/* replace875_0_1 -> replace874_0_1 in the cache */
static const nir_search_expression replace875_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace874_0_1.value },
   NULL,
};

/* replace875_1_0_0_0 -> replace0_1_0 in the cache */
/* replace875_1_0_0 -> replace874_0_1 in the cache */
/* replace875_1_0 -> replace874_1_0 in the cache */

/* replace875_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace875_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace874_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace875 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace875_0.value, &replace875_1.value },
   NULL,
};

   /* search876_0_0 -> search98_0_0 in the cache */
/* search876_0 -> replace824 in the cache */

/* search876_1 -> search2_1 in the cache */
static const nir_search_expression search876 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace824.value, &search2_1.value },
   NULL,
};

   static const nir_search_constant replace876_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { -0x80 /* -128 */ },
};

/* replace876_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace876_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace876_0_0.value, &replace0_1_0.value },
   NULL,
};

static const nir_search_constant replace876_1_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7f /* 127 */ },
};

/* replace876_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace876_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace876_1_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace876_1_1_0 -> search98_0_0 in the cache */

/* replace876_1_1_1_0 -> replace0_1_0 in the cache */
/* replace876_1_1_1 -> replace874_0_1 in the cache */
static const nir_search_expression replace876_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search98_0_0.value, &replace874_0_1.value },
   NULL,
};
static const nir_search_expression replace876_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace876_1_0.value, &replace876_1_1.value },
   NULL,
};
static const nir_search_expression replace876 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace876_0.value, &replace876_1.value },
   NULL,
};

   /* search877_0 -> search730_0 in the cache */

/* search877_1_0 -> search734_1 in the cache */
/* search877_1 -> search868_1 in the cache */
static const nir_search_expression search877 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search730_0.value, &search868_1.value },
   NULL,
};

   /* replace877_0_0 -> search0_0 in the cache */

/* replace877_0_1 -> replace876_1_0_0 in the cache */
static const nir_search_expression replace877_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace876_1_0_0.value },
   NULL,
};

/* replace877_1_0_0 -> search0_0 in the cache */

/* replace877_1_0_1 -> replace876_0_0 in the cache */
static const nir_search_expression replace877_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace876_0_0.value },
   NULL,
};

/* replace877_1_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace877_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search0_0.value },
   NULL,
};

/* replace877_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace877_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace877_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace877_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace877_1_0.value, &replace877_1_1.value },
   NULL,
};
static const nir_search_expression replace877 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace877_0.value, &replace877_1.value },
   NULL,
};

   /* search878_0_0 -> search98_0_0 in the cache */
/* search878_0 -> replace824 in the cache */

/* search878_1 -> search2_1 in the cache */
static const nir_search_expression search878 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace824.value, &search2_1.value },
   NULL,
};

   /* replace878_0_0 -> replace876_1_0_0 in the cache */

/* replace878_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace878_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace876_1_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace878_1_0_0 -> replace876_0_0 in the cache */

/* replace878_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace878_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace876_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace878_1_1_0 -> search98_0_0 in the cache */

/* replace878_1_1_1_0 -> replace0_1_0 in the cache */
/* replace878_1_1_1 -> replace874_0_1 in the cache */
static const nir_search_expression replace878_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search98_0_0.value, &replace874_0_1.value },
   NULL,
};
static const nir_search_expression replace878_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace878_1_0.value, &replace878_1_1.value },
   NULL,
};
static const nir_search_expression replace878 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace878_0.value, &replace878_1.value },
   NULL,
};

   /* search879_0 -> search730_0 in the cache */

/* search879_1_0 -> search734_1 in the cache */
/* search879_1 -> search868_1 in the cache */
static const nir_search_expression search879 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search730_0.value, &search868_1.value },
   NULL,
};

   /* replace879_0_0 -> search0_0 in the cache */

/* replace879_0_1 -> replace876_0_0 in the cache */
static const nir_search_expression replace879_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace876_0_0.value },
   NULL,
};

/* replace879_1_0_0 -> search0_0 in the cache */

/* replace879_1_0_1 -> replace876_1_0_0 in the cache */
static const nir_search_expression replace879_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace876_1_0_0.value },
   NULL,
};

/* replace879_1_1_0_0 -> search0_0 in the cache */
/* replace879_1_1_0 -> replace877_1_1_0 in the cache */

/* replace879_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace879_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace877_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace879_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace879_1_0.value, &replace879_1_1.value },
   NULL,
};
static const nir_search_expression replace879 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace879_0.value, &replace879_1.value },
   NULL,
};

   /* search880_0_0 -> search98_0_0 in the cache */
/* search880_0 -> replace840 in the cache */

/* search880_1_0 -> search734_1 in the cache */
static const nir_search_expression search880_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search734_1.value },
   NULL,
};
static const nir_search_expression search880 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace840.value, &search880_1.value },
   NULL,
};

   /* replace880_0 -> search98_0_0 in the cache */

/* replace880_1_0 -> search734_1 in the cache */
/* replace880_1 -> replace856_1 in the cache */
/* replace880 -> replace856 in the cache */

   /* search881_0_0 -> search98_0_0 in the cache */
/* search881_0 -> replace840 in the cache */

/* search881_1_0 -> search734_1 in the cache */
/* search881_1 -> search880_1 in the cache */
static const nir_search_expression search881 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace840.value, &search880_1.value },
   NULL,
};

   /* replace881_0 -> search98_0_0 in the cache */

/* replace881_1_0 -> search734_1 in the cache */
/* replace881_1 -> replace856_1 in the cache */
/* replace881 -> replace857 in the cache */

   /* search882_0_0 -> search98_0_0 in the cache */
/* search882_0 -> replace840 in the cache */

/* search882_1_0 -> search734_1 in the cache */
/* search882_1 -> search880_1 in the cache */
static const nir_search_expression search882 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace840.value, &search880_1.value },
   NULL,
};

   /* replace882_0 -> search98_0_0 in the cache */

/* replace882_1_0 -> search734_1 in the cache */
/* replace882_1 -> replace856_1 in the cache */
/* replace882 -> replace858 in the cache */

   /* search883_0_0 -> search98_0_0 in the cache */
/* search883_0 -> replace840 in the cache */

/* search883_1_0 -> search734_1 in the cache */
/* search883_1 -> search880_1 in the cache */
static const nir_search_expression search883 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace840.value, &search880_1.value },
   NULL,
};

   /* replace883_0 -> search98_0_0 in the cache */

/* replace883_1_0 -> search734_1 in the cache */
/* replace883_1 -> replace856_1 in the cache */
/* replace883 -> replace859 in the cache */

   /* search884_0_0 -> search860_0_0 in the cache */
static const nir_search_expression search884_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search860_0_0.value },
   NULL,
};

/* search884_1_0 -> search860_1_0 in the cache */
static const nir_search_expression search884_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search860_1_0.value },
   NULL,
};
static const nir_search_expression search884 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search884_0.value, &search884_1.value },
   NULL,
};

   /* replace884_0_0 -> search860_0_0 in the cache */
/* replace884_0 -> replace860_0 in the cache */

/* replace884_1 -> search860_1_0 in the cache */
/* replace884 -> replace860 in the cache */

   /* search885_0_0 -> search860_0_0 in the cache */
/* search885_0 -> search884_0 in the cache */

/* search885_1_0 -> search860_1_0 in the cache */
/* search885_1 -> search884_1 in the cache */
static const nir_search_expression search885 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search884_0.value, &search884_1.value },
   NULL,
};

   /* replace885_0_0 -> search860_0_0 in the cache */
/* replace885_0 -> replace860_0 in the cache */

/* replace885_1 -> search860_1_0 in the cache */
/* replace885 -> replace861 in the cache */

   /* search886_0_0 -> search98_0_0 in the cache */
/* search886_0 -> replace840 in the cache */

static const nir_search_variable search886_1 = {
   { nir_search_value_variable, 64 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search886 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace840.value, &search886_1.value },
   NULL,
};

   /* replace886_0_0 -> search98_0_0 in the cache */

/* replace886_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace886_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace886_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace886_0_1.value },
   NULL,
};

/* replace886_1_0_0_0 -> search57_1_1 in the cache */
/* replace886_1_0_0 -> replace886_0_1 in the cache */
static const nir_search_expression replace886_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace886_0_1.value },
   NULL,
};

/* replace886_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace886_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace886_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace886 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace886_0.value, &replace886_1.value },
   NULL,
};

   /* search887_0_0 -> search98_0_0 in the cache */
/* search887_0 -> replace840 in the cache */

/* search887_1 -> search886_1 in the cache */
static const nir_search_expression search887 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace840.value, &search886_1.value },
   NULL,
};

   /* replace887_0_0 -> search98_0_0 in the cache */

/* replace887_0_1_0 -> search57_1_1 in the cache */
/* replace887_0_1 -> replace886_0_1 in the cache */
static const nir_search_expression replace887_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace886_0_1.value },
   NULL,
};

/* replace887_1_0_0_0 -> search57_1_1 in the cache */
/* replace887_1_0_0 -> replace886_0_1 in the cache */
/* replace887_1_0 -> replace886_1_0 in the cache */

/* replace887_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace887_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace886_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace887 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace887_0.value, &replace887_1.value },
   NULL,
};

   /* search888_0_0 -> search98_0_0 in the cache */
/* search888_0 -> replace840 in the cache */

/* search888_1 -> search886_1 in the cache */
static const nir_search_expression search888 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace840.value, &search886_1.value },
   NULL,
};

   static const nir_search_constant replace888_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { -0x80 /* -128 */ },
};

/* replace888_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace888_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace888_0_0.value, &search57_1_1.value },
   NULL,
};

static const nir_search_constant replace888_1_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7f /* 127 */ },
};

/* replace888_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace888_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace888_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace888_1_1_0 -> search98_0_0 in the cache */

/* replace888_1_1_1_0 -> search57_1_1 in the cache */
/* replace888_1_1_1 -> replace886_0_1 in the cache */
static const nir_search_expression replace888_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search98_0_0.value, &replace886_0_1.value },
   NULL,
};
static const nir_search_expression replace888_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace888_1_0.value, &replace888_1_1.value },
   NULL,
};
static const nir_search_expression replace888 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace888_0.value, &replace888_1.value },
   NULL,
};

   static const nir_search_variable search889_0 = {
   { nir_search_value_variable, 64 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search889_1_0 -> search734_1 in the cache */
/* search889_1 -> search880_1 in the cache */
static const nir_search_expression search889 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search889_0.value, &search880_1.value },
   NULL,
};

   /* replace889_0_0 -> search57_0 in the cache */

/* replace889_0_1 -> replace888_1_0_0 in the cache */
static const nir_search_expression replace889_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace888_1_0_0.value },
   NULL,
};

/* replace889_1_0_0 -> search57_0 in the cache */

/* replace889_1_0_1 -> replace888_0_0 in the cache */
static const nir_search_expression replace889_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace888_0_0.value },
   NULL,
};

/* replace889_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace889_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search57_0.value },
   NULL,
};

/* replace889_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace889_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace889_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace889_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace889_1_0.value, &replace889_1_1.value },
   NULL,
};
static const nir_search_expression replace889 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace889_0.value, &replace889_1.value },
   NULL,
};

   /* search890_0_0 -> search98_0_0 in the cache */
/* search890_0 -> replace840 in the cache */

/* search890_1 -> search886_1 in the cache */
static const nir_search_expression search890 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace840.value, &search886_1.value },
   NULL,
};

   /* replace890_0_0 -> replace888_1_0_0 in the cache */

/* replace890_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace890_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace888_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace890_1_0_0 -> replace888_0_0 in the cache */

/* replace890_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace890_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace888_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace890_1_1_0 -> search98_0_0 in the cache */

/* replace890_1_1_1_0 -> search57_1_1 in the cache */
/* replace890_1_1_1 -> replace886_0_1 in the cache */
static const nir_search_expression replace890_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search98_0_0.value, &replace886_0_1.value },
   NULL,
};
static const nir_search_expression replace890_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace890_1_0.value, &replace890_1_1.value },
   NULL,
};
static const nir_search_expression replace890 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace890_0.value, &replace890_1.value },
   NULL,
};

   /* search891_0 -> search889_0 in the cache */

/* search891_1_0 -> search734_1 in the cache */
/* search891_1 -> search880_1 in the cache */
static const nir_search_expression search891 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search889_0.value, &search880_1.value },
   NULL,
};

   /* replace891_0_0 -> search57_0 in the cache */

/* replace891_0_1 -> replace888_0_0 in the cache */
static const nir_search_expression replace891_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace888_0_0.value },
   NULL,
};

/* replace891_1_0_0 -> search57_0 in the cache */

/* replace891_1_0_1 -> replace888_1_0_0 in the cache */
static const nir_search_expression replace891_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace888_1_0_0.value },
   NULL,
};

/* replace891_1_1_0_0 -> search57_0 in the cache */
/* replace891_1_1_0 -> replace889_1_1_0 in the cache */

/* replace891_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace891_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace889_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace891_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace891_1_0.value, &replace891_1_1.value },
   NULL,
};
static const nir_search_expression replace891 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace891_0.value, &replace891_1.value },
   NULL,
};

   /* search892_0_0 -> search101_0_0 in the cache */
/* search892_0 -> replace830 in the cache */

/* search892_1_0 -> search734_1 in the cache */
/* search892_1 -> search868_1 in the cache */
static const nir_search_expression search892 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace830.value, &search868_1.value },
   NULL,
};

   /* replace892_0 -> search101_0_0 in the cache */

/* replace892_1_0 -> search734_1 in the cache */
/* replace892_1 -> search856_1 in the cache */
static const nir_search_expression replace892 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search101_0_0.value, &search856_1.value },
   NULL,
};

   /* search893_0_0 -> search101_0_0 in the cache */
/* search893_0 -> replace830 in the cache */

/* search893_1_0 -> search734_1 in the cache */
/* search893_1 -> search868_1 in the cache */
static const nir_search_expression search893 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace830.value, &search868_1.value },
   NULL,
};

   /* replace893_0 -> search101_0_0 in the cache */

/* replace893_1_0 -> search734_1 in the cache */
/* replace893_1 -> search856_1 in the cache */
static const nir_search_expression replace893 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search101_0_0.value, &search856_1.value },
   NULL,
};

   /* search894_0_0 -> search101_0_0 in the cache */
/* search894_0 -> replace830 in the cache */

/* search894_1_0 -> search734_1 in the cache */
/* search894_1 -> search868_1 in the cache */
static const nir_search_expression search894 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace830.value, &search868_1.value },
   NULL,
};

   /* replace894_0 -> search101_0_0 in the cache */

/* replace894_1_0 -> search734_1 in the cache */
/* replace894_1 -> search856_1 in the cache */
static const nir_search_expression replace894 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &search856_1.value },
   NULL,
};

   /* search895_0_0 -> search101_0_0 in the cache */
/* search895_0 -> replace830 in the cache */

/* search895_1_0 -> search734_1 in the cache */
/* search895_1 -> search868_1 in the cache */
static const nir_search_expression search895 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace830.value, &search868_1.value },
   NULL,
};

   /* replace895_0 -> search101_0_0 in the cache */

/* replace895_1_0 -> search734_1 in the cache */
/* replace895_1 -> search856_1 in the cache */
static const nir_search_expression replace895 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &search856_1.value },
   NULL,
};

   /* search896_0_0 -> search860_0_0 in the cache */
/* search896_0 -> search872_0 in the cache */

static const nir_search_variable search896_1_0 = {
   { nir_search_value_variable, 16 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search896_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search896_1_0.value },
   NULL,
};
static const nir_search_expression search896 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search872_0.value, &search896_1.value },
   NULL,
};

   /* replace896_0_0 -> search860_0_0 in the cache */
/* replace896_0 -> search860_0 in the cache */

/* replace896_1 -> search896_1_0 in the cache */
static const nir_search_expression replace896 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search860_0.value, &search896_1_0.value },
   NULL,
};

   /* search897_0_0 -> search860_0_0 in the cache */
/* search897_0 -> search872_0 in the cache */

/* search897_1_0 -> search896_1_0 in the cache */
/* search897_1 -> search896_1 in the cache */
static const nir_search_expression search897 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search872_0.value, &search896_1.value },
   NULL,
};

   /* replace897_0_0 -> search860_0_0 in the cache */
/* replace897_0 -> search860_0 in the cache */

/* replace897_1 -> search896_1_0 in the cache */
static const nir_search_expression replace897 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search860_0.value, &search896_1_0.value },
   NULL,
};

   /* search898_0_0 -> search101_0_0 in the cache */
/* search898_0 -> replace830 in the cache */

/* search898_1_0 -> replace573_1_0 in the cache */
static const nir_search_expression search898_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace573_1_0.value },
   NULL,
};
static const nir_search_expression search898 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace830.value, &search898_1.value },
   NULL,
};

   /* replace898_0 -> search101_0_0 in the cache */

/* replace898_1_0 -> replace573_1_0 in the cache */
static const nir_search_expression replace898_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace898 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace898_1.value },
   NULL,
};

   /* search899_0_0 -> search101_0_0 in the cache */
/* search899_0 -> replace830 in the cache */

/* search899_1_0 -> replace573_1_0 in the cache */
/* search899_1 -> search898_1 in the cache */
static const nir_search_expression search899 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace830.value, &search898_1.value },
   NULL,
};

   /* replace899_0 -> search101_0_0 in the cache */

/* replace899_1_0 -> replace573_1_0 in the cache */
/* replace899_1 -> replace898_1 in the cache */
static const nir_search_expression replace899 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace898_1.value },
   NULL,
};

   /* search900_0_0 -> search101_0_0 in the cache */
/* search900_0 -> replace830 in the cache */

/* search900_1_0 -> replace573_1_0 in the cache */
/* search900_1 -> search898_1 in the cache */
static const nir_search_expression search900 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace830.value, &search898_1.value },
   NULL,
};

   /* replace900_0 -> search101_0_0 in the cache */

/* replace900_1_0 -> replace573_1_0 in the cache */
/* replace900_1 -> replace898_1 in the cache */
static const nir_search_expression replace900 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &replace898_1.value },
   NULL,
};

   /* search901_0_0 -> search101_0_0 in the cache */
/* search901_0 -> replace830 in the cache */

/* search901_1_0 -> replace573_1_0 in the cache */
/* search901_1 -> search898_1 in the cache */
static const nir_search_expression search901 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace830.value, &search898_1.value },
   NULL,
};

   /* replace901_0 -> search101_0_0 in the cache */

/* replace901_1_0 -> replace573_1_0 in the cache */
/* replace901_1 -> replace898_1 in the cache */
static const nir_search_expression replace901 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace898_1.value },
   NULL,
};

   static const nir_search_variable search902_0_0 = {
   { nir_search_value_variable, 16 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search902_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search902_0_0.value },
   NULL,
};

/* search902_1_0 -> search896_1_0 in the cache */
/* search902_1 -> search896_1 in the cache */
static const nir_search_expression search902 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search902_0.value, &search896_1.value },
   NULL,
};

   /* replace902_0_0 -> search902_0_0 in the cache */
static const nir_search_expression replace902_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search902_0_0.value },
   NULL,
};

/* replace902_1 -> search896_1_0 in the cache */
static const nir_search_expression replace902 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace902_0.value, &search896_1_0.value },
   NULL,
};

   /* search903_0_0 -> search902_0_0 in the cache */
/* search903_0 -> search902_0 in the cache */

/* search903_1_0 -> search896_1_0 in the cache */
/* search903_1 -> search896_1 in the cache */
static const nir_search_expression search903 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search902_0.value, &search896_1.value },
   NULL,
};

   /* replace903_0_0 -> search902_0_0 in the cache */
/* replace903_0 -> replace902_0 in the cache */

/* replace903_1 -> search896_1_0 in the cache */
static const nir_search_expression replace903 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace902_0.value, &search896_1_0.value },
   NULL,
};

   /* search904_0_0 -> search101_0_0 in the cache */
/* search904_0 -> replace830 in the cache */

/* search904_1 -> search2_1 in the cache */
static const nir_search_expression search904 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace830.value, &search2_1.value },
   NULL,
};

   /* replace904_0_0 -> search101_0_0 in the cache */

/* replace904_0_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace904_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace904_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace904_0_1.value },
   NULL,
};

/* replace904_1_0_0_0 -> replace0_1_0 in the cache */
/* replace904_1_0_0 -> replace904_0_1 in the cache */
static const nir_search_expression replace904_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace904_0_1.value },
   NULL,
};

/* replace904_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace904_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace904_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace904 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace904_0.value, &replace904_1.value },
   NULL,
};

   /* search905_0_0 -> search101_0_0 in the cache */
/* search905_0 -> replace830 in the cache */

/* search905_1 -> search2_1 in the cache */
static const nir_search_expression search905 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace830.value, &search2_1.value },
   NULL,
};

   /* replace905_0_0 -> search101_0_0 in the cache */

/* replace905_0_1_0 -> replace0_1_0 in the cache */
/* replace905_0_1 -> replace904_0_1 in the cache */
static const nir_search_expression replace905_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace904_0_1.value },
   NULL,
};

/* replace905_1_0_0_0 -> replace0_1_0 in the cache */
/* replace905_1_0_0 -> replace904_0_1 in the cache */
/* replace905_1_0 -> replace904_1_0 in the cache */

/* replace905_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace905_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace904_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace905 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace905_0.value, &replace905_1.value },
   NULL,
};

   /* search906_0_0 -> search101_0_0 in the cache */
/* search906_0 -> replace830 in the cache */

/* search906_1 -> search2_1 in the cache */
static const nir_search_expression search906 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace830.value, &search2_1.value },
   NULL,
};

   static const nir_search_constant replace906_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { -0x8000 /* -32768 */ },
};

/* replace906_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace906_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace906_0_0.value, &replace0_1_0.value },
   NULL,
};

static const nir_search_constant replace906_1_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7fff /* 32767 */ },
};

/* replace906_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace906_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace906_1_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace906_1_1_0 -> search101_0_0 in the cache */

/* replace906_1_1_1_0 -> replace0_1_0 in the cache */
/* replace906_1_1_1 -> replace904_0_1 in the cache */
static const nir_search_expression replace906_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace904_0_1.value },
   NULL,
};
static const nir_search_expression replace906_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace906_1_0.value, &replace906_1_1.value },
   NULL,
};
static const nir_search_expression replace906 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace906_0.value, &replace906_1.value },
   NULL,
};

   /* search907_0 -> search730_0 in the cache */

/* search907_1_0 -> replace573_1_0 in the cache */
/* search907_1 -> search898_1 in the cache */
static const nir_search_expression search907 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search730_0.value, &search898_1.value },
   NULL,
};

   /* replace907_0_0 -> search0_0 in the cache */

/* replace907_0_1 -> replace906_1_0_0 in the cache */
static const nir_search_expression replace907_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace906_1_0_0.value },
   NULL,
};

/* replace907_1_0_0 -> search0_0 in the cache */

/* replace907_1_0_1 -> replace906_0_0 in the cache */
static const nir_search_expression replace907_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace906_0_0.value },
   NULL,
};

/* replace907_1_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace907_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search0_0.value },
   NULL,
};

/* replace907_1_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace907_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace907_1_1_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace907_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace907_1_0.value, &replace907_1_1.value },
   NULL,
};
static const nir_search_expression replace907 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace907_0.value, &replace907_1.value },
   NULL,
};

   /* search908_0_0 -> search101_0_0 in the cache */
/* search908_0 -> replace830 in the cache */

/* search908_1 -> search2_1 in the cache */
static const nir_search_expression search908 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace830.value, &search2_1.value },
   NULL,
};

   /* replace908_0_0 -> replace906_1_0_0 in the cache */

/* replace908_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace908_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace906_1_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace908_1_0_0 -> replace906_0_0 in the cache */

/* replace908_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace908_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace906_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace908_1_1_0 -> search101_0_0 in the cache */

/* replace908_1_1_1_0 -> replace0_1_0 in the cache */
/* replace908_1_1_1 -> replace904_0_1 in the cache */
static const nir_search_expression replace908_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &replace904_0_1.value },
   NULL,
};
static const nir_search_expression replace908_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace908_1_0.value, &replace908_1_1.value },
   NULL,
};
static const nir_search_expression replace908 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace908_0.value, &replace908_1.value },
   NULL,
};

   /* search909_0 -> search730_0 in the cache */

/* search909_1_0 -> replace573_1_0 in the cache */
/* search909_1 -> search898_1 in the cache */
static const nir_search_expression search909 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search730_0.value, &search898_1.value },
   NULL,
};

   /* replace909_0_0 -> search0_0 in the cache */

/* replace909_0_1 -> replace906_0_0 in the cache */
static const nir_search_expression replace909_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace906_0_0.value },
   NULL,
};

/* replace909_1_0_0 -> search0_0 in the cache */

/* replace909_1_0_1 -> replace906_1_0_0 in the cache */
static const nir_search_expression replace909_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace906_1_0_0.value },
   NULL,
};

/* replace909_1_1_0_0 -> search0_0 in the cache */
/* replace909_1_1_0 -> replace907_1_1_0 in the cache */

/* replace909_1_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace909_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace907_1_1_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace909_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace909_1_0.value, &replace909_1_1.value },
   NULL,
};
static const nir_search_expression replace909 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace909_0.value, &replace909_1.value },
   NULL,
};

   /* search910_0_0 -> search101_0_0 in the cache */
/* search910_0 -> replace846 in the cache */

/* search910_1_0 -> search734_1 in the cache */
/* search910_1 -> search880_1 in the cache */
static const nir_search_expression search910 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace846.value, &search880_1.value },
   NULL,
};

   /* replace910_0 -> search101_0_0 in the cache */

/* replace910_1_0 -> search734_1 in the cache */
/* replace910_1 -> search856_1 in the cache */
/* replace910 -> replace892 in the cache */

   /* search911_0_0 -> search101_0_0 in the cache */
/* search911_0 -> replace846 in the cache */

/* search911_1_0 -> search734_1 in the cache */
/* search911_1 -> search880_1 in the cache */
static const nir_search_expression search911 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace846.value, &search880_1.value },
   NULL,
};

   /* replace911_0 -> search101_0_0 in the cache */

/* replace911_1_0 -> search734_1 in the cache */
/* replace911_1 -> search856_1 in the cache */
/* replace911 -> replace893 in the cache */

   /* search912_0_0 -> search101_0_0 in the cache */
/* search912_0 -> replace846 in the cache */

/* search912_1_0 -> search734_1 in the cache */
/* search912_1 -> search880_1 in the cache */
static const nir_search_expression search912 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace846.value, &search880_1.value },
   NULL,
};

   /* replace912_0 -> search101_0_0 in the cache */

/* replace912_1_0 -> search734_1 in the cache */
/* replace912_1 -> search856_1 in the cache */
/* replace912 -> replace894 in the cache */

   /* search913_0_0 -> search101_0_0 in the cache */
/* search913_0 -> replace846 in the cache */

/* search913_1_0 -> search734_1 in the cache */
/* search913_1 -> search880_1 in the cache */
static const nir_search_expression search913 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace846.value, &search880_1.value },
   NULL,
};

   /* replace913_0 -> search101_0_0 in the cache */

/* replace913_1_0 -> search734_1 in the cache */
/* replace913_1 -> search856_1 in the cache */
/* replace913 -> replace895 in the cache */

   /* search914_0_0 -> search860_0_0 in the cache */
/* search914_0 -> search884_0 in the cache */

/* search914_1_0 -> search896_1_0 in the cache */
static const nir_search_expression search914_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search896_1_0.value },
   NULL,
};
static const nir_search_expression search914 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search884_0.value, &search914_1.value },
   NULL,
};

   /* replace914_0_0 -> search860_0_0 in the cache */
/* replace914_0 -> search860_0 in the cache */

/* replace914_1 -> search896_1_0 in the cache */
/* replace914 -> replace896 in the cache */

   /* search915_0_0 -> search860_0_0 in the cache */
/* search915_0 -> search884_0 in the cache */

/* search915_1_0 -> search896_1_0 in the cache */
/* search915_1 -> search914_1 in the cache */
static const nir_search_expression search915 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search884_0.value, &search914_1.value },
   NULL,
};

   /* replace915_0_0 -> search860_0_0 in the cache */
/* replace915_0 -> search860_0 in the cache */

/* replace915_1 -> search896_1_0 in the cache */
/* replace915 -> replace897 in the cache */

   /* search916_0_0 -> search101_0_0 in the cache */
/* search916_0 -> replace846 in the cache */

/* search916_1_0 -> replace573_1_0 in the cache */
static const nir_search_expression search916_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace573_1_0.value },
   NULL,
};
static const nir_search_expression search916 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace846.value, &search916_1.value },
   NULL,
};

   /* replace916_0 -> search101_0_0 in the cache */

/* replace916_1_0 -> replace573_1_0 in the cache */
/* replace916_1 -> replace898_1 in the cache */
/* replace916 -> replace898 in the cache */

   /* search917_0_0 -> search101_0_0 in the cache */
/* search917_0 -> replace846 in the cache */

/* search917_1_0 -> replace573_1_0 in the cache */
/* search917_1 -> search916_1 in the cache */
static const nir_search_expression search917 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace846.value, &search916_1.value },
   NULL,
};

   /* replace917_0 -> search101_0_0 in the cache */

/* replace917_1_0 -> replace573_1_0 in the cache */
/* replace917_1 -> replace898_1 in the cache */
/* replace917 -> replace899 in the cache */

   /* search918_0_0 -> search101_0_0 in the cache */
/* search918_0 -> replace846 in the cache */

/* search918_1_0 -> replace573_1_0 in the cache */
/* search918_1 -> search916_1 in the cache */
static const nir_search_expression search918 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace846.value, &search916_1.value },
   NULL,
};

   /* replace918_0 -> search101_0_0 in the cache */

/* replace918_1_0 -> replace573_1_0 in the cache */
/* replace918_1 -> replace898_1 in the cache */
/* replace918 -> replace900 in the cache */

   /* search919_0_0 -> search101_0_0 in the cache */
/* search919_0 -> replace846 in the cache */

/* search919_1_0 -> replace573_1_0 in the cache */
/* search919_1 -> search916_1 in the cache */
static const nir_search_expression search919 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace846.value, &search916_1.value },
   NULL,
};

   /* replace919_0 -> search101_0_0 in the cache */

/* replace919_1_0 -> replace573_1_0 in the cache */
/* replace919_1 -> replace898_1 in the cache */
/* replace919 -> replace901 in the cache */

   /* search920_0_0 -> search902_0_0 in the cache */
static const nir_search_expression search920_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search902_0_0.value },
   NULL,
};

/* search920_1_0 -> search896_1_0 in the cache */
/* search920_1 -> search914_1 in the cache */
static const nir_search_expression search920 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search920_0.value, &search914_1.value },
   NULL,
};

   /* replace920_0_0 -> search902_0_0 in the cache */
/* replace920_0 -> replace902_0 in the cache */

/* replace920_1 -> search896_1_0 in the cache */
/* replace920 -> replace902 in the cache */

   /* search921_0_0 -> search902_0_0 in the cache */
/* search921_0 -> search920_0 in the cache */

/* search921_1_0 -> search896_1_0 in the cache */
/* search921_1 -> search914_1 in the cache */
static const nir_search_expression search921 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search920_0.value, &search914_1.value },
   NULL,
};

   /* replace921_0_0 -> search902_0_0 in the cache */
/* replace921_0 -> replace902_0 in the cache */

/* replace921_1 -> search896_1_0 in the cache */
/* replace921 -> replace903 in the cache */

   /* search922_0_0 -> search101_0_0 in the cache */
/* search922_0 -> replace846 in the cache */

/* search922_1 -> search886_1 in the cache */
static const nir_search_expression search922 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace846.value, &search886_1.value },
   NULL,
};

   /* replace922_0_0 -> search101_0_0 in the cache */

/* replace922_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace922_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace922_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace922_0_1.value },
   NULL,
};

/* replace922_1_0_0_0 -> search57_1_1 in the cache */
/* replace922_1_0_0 -> replace922_0_1 in the cache */
static const nir_search_expression replace922_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace922_0_1.value },
   NULL,
};

/* replace922_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace922_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace922_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace922 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace922_0.value, &replace922_1.value },
   NULL,
};

   /* search923_0_0 -> search101_0_0 in the cache */
/* search923_0 -> replace846 in the cache */

/* search923_1 -> search886_1 in the cache */
static const nir_search_expression search923 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace846.value, &search886_1.value },
   NULL,
};

   /* replace923_0_0 -> search101_0_0 in the cache */

/* replace923_0_1_0 -> search57_1_1 in the cache */
/* replace923_0_1 -> replace922_0_1 in the cache */
static const nir_search_expression replace923_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace922_0_1.value },
   NULL,
};

/* replace923_1_0_0_0 -> search57_1_1 in the cache */
/* replace923_1_0_0 -> replace922_0_1 in the cache */
/* replace923_1_0 -> replace922_1_0 in the cache */

/* replace923_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace923_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace922_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace923 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace923_0.value, &replace923_1.value },
   NULL,
};

   /* search924_0_0 -> search101_0_0 in the cache */
/* search924_0 -> replace846 in the cache */

/* search924_1 -> search886_1 in the cache */
static const nir_search_expression search924 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace846.value, &search886_1.value },
   NULL,
};

   static const nir_search_constant replace924_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { -0x8000 /* -32768 */ },
};

/* replace924_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace924_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace924_0_0.value, &search57_1_1.value },
   NULL,
};

static const nir_search_constant replace924_1_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7fff /* 32767 */ },
};

/* replace924_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace924_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace924_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace924_1_1_0 -> search101_0_0 in the cache */

/* replace924_1_1_1_0 -> search57_1_1 in the cache */
/* replace924_1_1_1 -> replace922_0_1 in the cache */
static const nir_search_expression replace924_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace922_0_1.value },
   NULL,
};
static const nir_search_expression replace924_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace924_1_0.value, &replace924_1_1.value },
   NULL,
};
static const nir_search_expression replace924 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace924_0.value, &replace924_1.value },
   NULL,
};

   /* search925_0 -> search889_0 in the cache */

/* search925_1_0 -> replace573_1_0 in the cache */
/* search925_1 -> search916_1 in the cache */
static const nir_search_expression search925 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search889_0.value, &search916_1.value },
   NULL,
};

   /* replace925_0_0 -> search57_0 in the cache */

/* replace925_0_1 -> replace924_1_0_0 in the cache */
static const nir_search_expression replace925_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace924_1_0_0.value },
   NULL,
};

/* replace925_1_0_0 -> search57_0 in the cache */

/* replace925_1_0_1 -> replace924_0_0 in the cache */
static const nir_search_expression replace925_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace924_0_0.value },
   NULL,
};

/* replace925_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace925_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search57_0.value },
   NULL,
};

/* replace925_1_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace925_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace925_1_1_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace925_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace925_1_0.value, &replace925_1_1.value },
   NULL,
};
static const nir_search_expression replace925 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace925_0.value, &replace925_1.value },
   NULL,
};

   /* search926_0_0 -> search101_0_0 in the cache */
/* search926_0 -> replace846 in the cache */

/* search926_1 -> search886_1 in the cache */
static const nir_search_expression search926 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace846.value, &search886_1.value },
   NULL,
};

   /* replace926_0_0 -> replace924_1_0_0 in the cache */

/* replace926_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace926_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace924_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace926_1_0_0 -> replace924_0_0 in the cache */

/* replace926_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace926_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace924_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace926_1_1_0 -> search101_0_0 in the cache */

/* replace926_1_1_1_0 -> search57_1_1 in the cache */
/* replace926_1_1_1 -> replace922_0_1 in the cache */
static const nir_search_expression replace926_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &replace922_0_1.value },
   NULL,
};
static const nir_search_expression replace926_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace926_1_0.value, &replace926_1_1.value },
   NULL,
};
static const nir_search_expression replace926 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace926_0.value, &replace926_1.value },
   NULL,
};

   /* search927_0 -> search889_0 in the cache */

/* search927_1_0 -> replace573_1_0 in the cache */
/* search927_1 -> search916_1 in the cache */
static const nir_search_expression search927 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search889_0.value, &search916_1.value },
   NULL,
};

   /* replace927_0_0 -> search57_0 in the cache */

/* replace927_0_1 -> replace924_0_0 in the cache */
static const nir_search_expression replace927_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace924_0_0.value },
   NULL,
};

/* replace927_1_0_0 -> search57_0 in the cache */

/* replace927_1_0_1 -> replace924_1_0_0 in the cache */
static const nir_search_expression replace927_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace924_1_0_0.value },
   NULL,
};

/* replace927_1_1_0_0 -> search57_0 in the cache */
/* replace927_1_1_0 -> replace925_1_1_0 in the cache */

/* replace927_1_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace927_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace925_1_1_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace927_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace927_1_0.value, &replace927_1_1.value },
   NULL,
};
static const nir_search_expression replace927 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace927_0.value, &replace927_1.value },
   NULL,
};

   /* search928_0_0 -> search0_0 in the cache */
/* search928_0 -> replace854 in the cache */

/* search928_1_0 -> search734_1 in the cache */
/* search928_1 -> search880_1 in the cache */
static const nir_search_expression search928 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace854.value, &search880_1.value },
   NULL,
};

   /* replace928_0 -> search0_0 in the cache */

/* replace928_1_0 -> search734_1 in the cache */
/* replace928_1 -> search868_1 in the cache */
static const nir_search_expression replace928 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &search868_1.value },
   NULL,
};

   /* search929_0_0 -> search0_0 in the cache */
/* search929_0 -> replace854 in the cache */

/* search929_1_0 -> search734_1 in the cache */
/* search929_1 -> search880_1 in the cache */
static const nir_search_expression search929 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace854.value, &search880_1.value },
   NULL,
};

   /* replace929_0 -> search0_0 in the cache */

/* replace929_1_0 -> search734_1 in the cache */
/* replace929_1 -> search868_1 in the cache */
static const nir_search_expression replace929 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search868_1.value },
   NULL,
};

   /* search930_0_0 -> search0_0 in the cache */
/* search930_0 -> replace854 in the cache */

/* search930_1_0 -> search734_1 in the cache */
/* search930_1 -> search880_1 in the cache */
static const nir_search_expression search930 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace854.value, &search880_1.value },
   NULL,
};

   /* replace930_0 -> search0_0 in the cache */

/* replace930_1_0 -> search734_1 in the cache */
/* replace930_1 -> search868_1 in the cache */
static const nir_search_expression replace930 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &search868_1.value },
   NULL,
};

   /* search931_0_0 -> search0_0 in the cache */
/* search931_0 -> replace854 in the cache */

/* search931_1_0 -> search734_1 in the cache */
/* search931_1 -> search880_1 in the cache */
static const nir_search_expression search931 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace854.value, &search880_1.value },
   NULL,
};

   /* replace931_0 -> search0_0 in the cache */

/* replace931_1_0 -> search734_1 in the cache */
/* replace931_1 -> search868_1 in the cache */
static const nir_search_expression replace931 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &search868_1.value },
   NULL,
};

   /* search932_0_0 -> search860_0_0 in the cache */
/* search932_0 -> search884_0 in the cache */

static const nir_search_variable search932_1_0 = {
   { nir_search_value_variable, 32 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search932_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search932_1_0.value },
   NULL,
};
static const nir_search_expression search932 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search884_0.value, &search932_1.value },
   NULL,
};

   /* replace932_0_0 -> search860_0_0 in the cache */
/* replace932_0 -> search872_0 in the cache */

/* replace932_1 -> search932_1_0 in the cache */
static const nir_search_expression replace932 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search872_0.value, &search932_1_0.value },
   NULL,
};

   /* search933_0_0 -> search860_0_0 in the cache */
/* search933_0 -> search884_0 in the cache */

/* search933_1_0 -> search932_1_0 in the cache */
/* search933_1 -> search932_1 in the cache */
static const nir_search_expression search933 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search884_0.value, &search932_1.value },
   NULL,
};

   /* replace933_0_0 -> search860_0_0 in the cache */
/* replace933_0 -> search872_0 in the cache */

/* replace933_1 -> search932_1_0 in the cache */
static const nir_search_expression replace933 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search872_0.value, &search932_1_0.value },
   NULL,
};

   /* search934_0_0 -> search0_0 in the cache */
/* search934_0 -> replace854 in the cache */

/* search934_1_0 -> replace573_1_0 in the cache */
/* search934_1 -> search916_1 in the cache */
static const nir_search_expression search934 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace854.value, &search916_1.value },
   NULL,
};

   /* replace934_0 -> search0_0 in the cache */

/* replace934_1_0 -> replace573_1_0 in the cache */
/* replace934_1 -> search898_1 in the cache */
static const nir_search_expression replace934 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &search898_1.value },
   NULL,
};

   /* search935_0_0 -> search0_0 in the cache */
/* search935_0 -> replace854 in the cache */

/* search935_1_0 -> replace573_1_0 in the cache */
/* search935_1 -> search916_1 in the cache */
static const nir_search_expression search935 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace854.value, &search916_1.value },
   NULL,
};

   /* replace935_0 -> search0_0 in the cache */

/* replace935_1_0 -> replace573_1_0 in the cache */
/* replace935_1 -> search898_1 in the cache */
static const nir_search_expression replace935 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search898_1.value },
   NULL,
};

   /* search936_0_0 -> search0_0 in the cache */
/* search936_0 -> replace854 in the cache */

/* search936_1_0 -> replace573_1_0 in the cache */
/* search936_1 -> search916_1 in the cache */
static const nir_search_expression search936 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace854.value, &search916_1.value },
   NULL,
};

   /* replace936_0 -> search0_0 in the cache */

/* replace936_1_0 -> replace573_1_0 in the cache */
/* replace936_1 -> search898_1 in the cache */
static const nir_search_expression replace936 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &search898_1.value },
   NULL,
};

   /* search937_0_0 -> search0_0 in the cache */
/* search937_0 -> replace854 in the cache */

/* search937_1_0 -> replace573_1_0 in the cache */
/* search937_1 -> search916_1 in the cache */
static const nir_search_expression search937 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace854.value, &search916_1.value },
   NULL,
};

   /* replace937_0 -> search0_0 in the cache */

/* replace937_1_0 -> replace573_1_0 in the cache */
/* replace937_1 -> search898_1 in the cache */
static const nir_search_expression replace937 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &search898_1.value },
   NULL,
};

   /* search938_0_0 -> search902_0_0 in the cache */
/* search938_0 -> search920_0 in the cache */

/* search938_1_0 -> search932_1_0 in the cache */
/* search938_1 -> search932_1 in the cache */
static const nir_search_expression search938 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search920_0.value, &search932_1.value },
   NULL,
};

   /* replace938_0_0 -> search902_0_0 in the cache */
/* replace938_0 -> search902_0 in the cache */

/* replace938_1 -> search932_1_0 in the cache */
static const nir_search_expression replace938 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search902_0.value, &search932_1_0.value },
   NULL,
};

   /* search939_0_0 -> search902_0_0 in the cache */
/* search939_0 -> search920_0 in the cache */

/* search939_1_0 -> search932_1_0 in the cache */
/* search939_1 -> search932_1 in the cache */
static const nir_search_expression search939 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search920_0.value, &search932_1.value },
   NULL,
};

   /* replace939_0_0 -> search902_0_0 in the cache */
/* replace939_0 -> search902_0 in the cache */

/* replace939_1 -> search932_1_0 in the cache */
static const nir_search_expression replace939 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search902_0.value, &search932_1_0.value },
   NULL,
};

   /* search940_0_0 -> search0_0 in the cache */
/* search940_0 -> replace854 in the cache */

/* search940_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search940_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search940 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace854.value, &search940_1.value },
   NULL,
};

   /* replace940_0 -> search0_0 in the cache */

/* replace940_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace940_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace940 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &replace940_1.value },
   NULL,
};

   /* search941_0_0 -> search0_0 in the cache */
/* search941_0 -> replace854 in the cache */

/* search941_1_0 -> replace0_1_0 in the cache */
/* search941_1 -> search940_1 in the cache */
static const nir_search_expression search941 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace854.value, &search940_1.value },
   NULL,
};

   /* replace941_0 -> search0_0 in the cache */

/* replace941_1_0 -> replace0_1_0 in the cache */
/* replace941_1 -> replace940_1 in the cache */
static const nir_search_expression replace941 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &replace940_1.value },
   NULL,
};

   /* search942_0_0 -> search0_0 in the cache */
/* search942_0 -> replace854 in the cache */

/* search942_1_0 -> replace0_1_0 in the cache */
/* search942_1 -> search940_1 in the cache */
static const nir_search_expression search942 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace854.value, &search940_1.value },
   NULL,
};

   /* replace942_0 -> search0_0 in the cache */

/* replace942_1_0 -> replace0_1_0 in the cache */
/* replace942_1 -> replace940_1 in the cache */
static const nir_search_expression replace942 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace940_1.value },
   NULL,
};

   /* search943_0_0 -> search0_0 in the cache */
/* search943_0 -> replace854 in the cache */

/* search943_1_0 -> replace0_1_0 in the cache */
/* search943_1 -> search940_1 in the cache */
static const nir_search_expression search943 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace854.value, &search940_1.value },
   NULL,
};

   /* replace943_0 -> search0_0 in the cache */

/* replace943_1_0 -> replace0_1_0 in the cache */
/* replace943_1 -> replace940_1 in the cache */
static const nir_search_expression replace943 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace940_1.value },
   NULL,
};

   static const nir_search_variable search944_0_0 = {
   { nir_search_value_variable, 32 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search944_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search944_0_0.value },
   NULL,
};

/* search944_1_0 -> search932_1_0 in the cache */
/* search944_1 -> search932_1 in the cache */
static const nir_search_expression search944 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search944_0.value, &search932_1.value },
   NULL,
};

   /* replace944_0_0 -> search944_0_0 in the cache */
static const nir_search_expression replace944_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search944_0_0.value },
   NULL,
};

/* replace944_1 -> search932_1_0 in the cache */
static const nir_search_expression replace944 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace944_0.value, &search932_1_0.value },
   NULL,
};

   /* search945_0_0 -> search944_0_0 in the cache */
/* search945_0 -> search944_0 in the cache */

/* search945_1_0 -> search932_1_0 in the cache */
/* search945_1 -> search932_1 in the cache */
static const nir_search_expression search945 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search944_0.value, &search932_1.value },
   NULL,
};

   /* replace945_0_0 -> search944_0_0 in the cache */
/* replace945_0 -> replace944_0 in the cache */

/* replace945_1 -> search932_1_0 in the cache */
static const nir_search_expression replace945 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace944_0.value, &search932_1_0.value },
   NULL,
};

   /* search946_0_0 -> search0_0 in the cache */
/* search946_0 -> replace854 in the cache */

/* search946_1 -> search886_1 in the cache */
static const nir_search_expression search946 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace854.value, &search886_1.value },
   NULL,
};

   /* replace946_0_0 -> search0_0 in the cache */

/* replace946_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace946_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace946_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search0_0.value, &replace946_0_1.value },
   NULL,
};

/* replace946_1_0_0_0 -> search57_1_1 in the cache */
/* replace946_1_0_0 -> replace946_0_1 in the cache */
static const nir_search_expression replace946_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace946_0_1.value },
   NULL,
};

/* replace946_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace946_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace946_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace946 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace946_0.value, &replace946_1.value },
   NULL,
};

   /* search947_0_0 -> search0_0 in the cache */
/* search947_0 -> replace854 in the cache */

/* search947_1 -> search886_1 in the cache */
static const nir_search_expression search947 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace854.value, &search886_1.value },
   NULL,
};

   /* replace947_0_0 -> search0_0 in the cache */

/* replace947_0_1_0 -> search57_1_1 in the cache */
/* replace947_0_1 -> replace946_0_1 in the cache */
static const nir_search_expression replace947_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search0_0.value, &replace946_0_1.value },
   NULL,
};

/* replace947_1_0_0_0 -> search57_1_1 in the cache */
/* replace947_1_0_0 -> replace946_0_1 in the cache */
/* replace947_1_0 -> replace946_1_0 in the cache */

/* replace947_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace947_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace946_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace947 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace947_0.value, &replace947_1.value },
   NULL,
};

   /* search948_0_0 -> search0_0 in the cache */
/* search948_0 -> replace854 in the cache */

/* search948_1 -> search886_1 in the cache */
static const nir_search_expression search948 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace854.value, &search886_1.value },
   NULL,
};

   static const nir_search_constant replace948_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { -0x80000000 /* -2147483648 */ },
};

/* replace948_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace948_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace948_0_0.value, &search57_1_1.value },
   NULL,
};

static const nir_search_constant replace948_1_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7fffffff /* 2147483647 */ },
};

/* replace948_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace948_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace948_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace948_1_1_0 -> search0_0 in the cache */

/* replace948_1_1_1_0 -> search57_1_1 in the cache */
/* replace948_1_1_1 -> replace946_0_1 in the cache */
static const nir_search_expression replace948_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace946_0_1.value },
   NULL,
};
static const nir_search_expression replace948_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace948_1_0.value, &replace948_1_1.value },
   NULL,
};
static const nir_search_expression replace948 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace948_0.value, &replace948_1.value },
   NULL,
};

   /* search949_0 -> search889_0 in the cache */

/* search949_1_0 -> replace0_1_0 in the cache */
/* search949_1 -> search940_1 in the cache */
static const nir_search_expression search949 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search889_0.value, &search940_1.value },
   NULL,
};

   /* replace949_0_0 -> search57_0 in the cache */

/* replace949_0_1 -> replace948_1_0_0 in the cache */
static const nir_search_expression replace949_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace948_1_0_0.value },
   NULL,
};

/* replace949_1_0_0 -> search57_0 in the cache */

/* replace949_1_0_1 -> replace948_0_0 in the cache */
static const nir_search_expression replace949_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace948_0_0.value },
   NULL,
};

/* replace949_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace949_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search57_0.value },
   NULL,
};

/* replace949_1_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace949_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace949_1_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace949_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace949_1_0.value, &replace949_1_1.value },
   NULL,
};
static const nir_search_expression replace949 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace949_0.value, &replace949_1.value },
   NULL,
};

   /* search950_0_0 -> search0_0 in the cache */
/* search950_0 -> replace854 in the cache */

/* search950_1 -> search886_1 in the cache */
static const nir_search_expression search950 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace854.value, &search886_1.value },
   NULL,
};

   /* replace950_0_0 -> replace948_1_0_0 in the cache */

/* replace950_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace950_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace948_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace950_1_0_0 -> replace948_0_0 in the cache */

/* replace950_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace950_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace948_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace950_1_1_0 -> search0_0 in the cache */

/* replace950_1_1_1_0 -> search57_1_1 in the cache */
/* replace950_1_1_1 -> replace946_0_1 in the cache */
static const nir_search_expression replace950_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace946_0_1.value },
   NULL,
};
static const nir_search_expression replace950_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace950_1_0.value, &replace950_1_1.value },
   NULL,
};
static const nir_search_expression replace950 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace950_0.value, &replace950_1.value },
   NULL,
};

   /* search951_0 -> search889_0 in the cache */

/* search951_1_0 -> replace0_1_0 in the cache */
/* search951_1 -> search940_1 in the cache */
static const nir_search_expression search951 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search889_0.value, &search940_1.value },
   NULL,
};

   /* replace951_0_0 -> search57_0 in the cache */

/* replace951_0_1 -> replace948_0_0 in the cache */
static const nir_search_expression replace951_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace948_0_0.value },
   NULL,
};

/* replace951_1_0_0 -> search57_0 in the cache */

/* replace951_1_0_1 -> replace948_1_0_0 in the cache */
static const nir_search_expression replace951_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace948_1_0_0.value },
   NULL,
};

/* replace951_1_1_0_0 -> search57_0 in the cache */
/* replace951_1_1_0 -> replace949_1_1_0 in the cache */

/* replace951_1_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace951_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace949_1_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace951_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace951_1_0.value, &replace951_1_1.value },
   NULL,
};
static const nir_search_expression replace951 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace951_0.value, &replace951_1.value },
   NULL,
};

   /* search952_0_0 -> search98_0_0 in the cache */
/* search952_0 -> replace811 in the cache */

/* search952_1_0 -> search734_1 in the cache */
static const nir_search_expression search952_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search734_1.value },
   NULL,
};
static const nir_search_expression search952 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace811.value, &search952_1.value },
   NULL,
};

   /* replace952_0 -> search98_0_0 in the cache */

/* replace952_1_0 -> search734_1 in the cache */
static const nir_search_expression replace952_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search734_1.value },
   NULL,
};
static const nir_search_expression replace952 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace952_1.value },
   NULL,
};

   /* search953_0_0 -> search98_0_0 in the cache */
/* search953_0 -> replace811 in the cache */

/* search953_1_0 -> search734_1 in the cache */
/* search953_1 -> search952_1 in the cache */
static const nir_search_expression search953 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace811.value, &search952_1.value },
   NULL,
};

   /* replace953_0 -> search98_0_0 in the cache */

/* replace953_1_0 -> search734_1 in the cache */
/* replace953_1 -> replace952_1 in the cache */
static const nir_search_expression replace953 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace952_1.value },
   NULL,
};

   /* search954_0_0 -> search98_0_0 in the cache */
/* search954_0 -> replace811 in the cache */

/* search954_1_0 -> search734_1 in the cache */
/* search954_1 -> search952_1 in the cache */
static const nir_search_expression search954 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace811.value, &search952_1.value },
   NULL,
};

   /* replace954_0 -> search98_0_0 in the cache */

/* replace954_1_0 -> search734_1 in the cache */
/* replace954_1 -> replace952_1 in the cache */
static const nir_search_expression replace954 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search98_0_0.value, &replace952_1.value },
   NULL,
};

   /* search955_0_0 -> search98_0_0 in the cache */
/* search955_0 -> replace811 in the cache */

/* search955_1_0 -> search734_1 in the cache */
/* search955_1 -> search952_1 in the cache */
static const nir_search_expression search955 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace811.value, &search952_1.value },
   NULL,
};

   /* replace955_0 -> search98_0_0 in the cache */

/* replace955_1_0 -> search734_1 in the cache */
/* replace955_1 -> replace952_1 in the cache */
static const nir_search_expression replace955 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search98_0_0.value, &replace952_1.value },
   NULL,
};

   /* search956_0_0 -> search860_0_0 in the cache */
static const nir_search_expression search956_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search860_0_0.value },
   NULL,
};

/* search956_1_0 -> search860_1_0 in the cache */
static const nir_search_expression search956_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search860_1_0.value },
   NULL,
};
static const nir_search_expression search956 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search956_0.value, &search956_1.value },
   NULL,
};

   /* replace956_0_0 -> search860_0_0 in the cache */
static const nir_search_expression replace956_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search860_0_0.value },
   NULL,
};

/* replace956_1 -> search860_1_0 in the cache */
static const nir_search_expression replace956 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace956_0.value, &search860_1_0.value },
   NULL,
};

   /* search957_0_0 -> search860_0_0 in the cache */
/* search957_0 -> search956_0 in the cache */

/* search957_1_0 -> search860_1_0 in the cache */
/* search957_1 -> search956_1 in the cache */
static const nir_search_expression search957 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search956_0.value, &search956_1.value },
   NULL,
};

   /* replace957_0_0 -> search860_0_0 in the cache */
/* replace957_0 -> replace956_0 in the cache */

/* replace957_1 -> search860_1_0 in the cache */
static const nir_search_expression replace957 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace956_0.value, &search860_1_0.value },
   NULL,
};

   /* search958_0_0 -> search98_0_0 in the cache */
/* search958_0 -> replace811 in the cache */

/* search958_1 -> search573_0_1 in the cache */
static const nir_search_expression search958 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace811.value, &search573_0_1.value },
   NULL,
};

   /* replace958_0_0 -> search98_0_0 in the cache */

/* replace958_0_1_0 -> replace573_1_0 in the cache */
static const nir_search_expression replace958_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace958_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace958_0_1.value },
   NULL,
};

/* replace958_1_0_0_0 -> replace573_1_0 in the cache */
/* replace958_1_0_0 -> replace958_0_1 in the cache */
static const nir_search_expression replace958_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &replace958_0_1.value },
   NULL,
};

/* replace958_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace958_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace958_1_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace958 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace958_0.value, &replace958_1.value },
   NULL,
};

   /* search959_0_0 -> search98_0_0 in the cache */
/* search959_0 -> replace811 in the cache */

/* search959_1 -> search573_0_1 in the cache */
static const nir_search_expression search959 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace811.value, &search573_0_1.value },
   NULL,
};

   /* replace959_0_0 -> search98_0_0 in the cache */

/* replace959_0_1_0 -> replace573_1_0 in the cache */
/* replace959_0_1 -> replace958_0_1 in the cache */
static const nir_search_expression replace959_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace958_0_1.value },
   NULL,
};

/* replace959_1_0_0_0 -> replace573_1_0 in the cache */
/* replace959_1_0_0 -> replace958_0_1 in the cache */
/* replace959_1_0 -> replace958_1_0 in the cache */

/* replace959_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace959_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace958_1_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace959 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace959_0.value, &replace959_1.value },
   NULL,
};

   /* search960_0_0 -> search98_0_0 in the cache */
/* search960_0 -> replace811 in the cache */

/* search960_1 -> search573_0_1 in the cache */
static const nir_search_expression search960 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace811.value, &search573_0_1.value },
   NULL,
};

   /* replace960_0_0 -> replace101_2 in the cache */

/* replace960_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace960_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace101_2.value, &replace573_1_0.value },
   NULL,
};

static const nir_search_constant replace960_1_0_0 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0xff /* 255 */ },
};

/* replace960_1_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace960_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace960_1_0_0.value, &replace573_1_0.value },
   NULL,
};

/* replace960_1_1_0 -> search98_0_0 in the cache */

/* replace960_1_1_1_0 -> replace573_1_0 in the cache */
/* replace960_1_1_1 -> replace958_0_1 in the cache */
static const nir_search_expression replace960_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search98_0_0.value, &replace958_0_1.value },
   NULL,
};
static const nir_search_expression replace960_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace960_1_0.value, &replace960_1_1.value },
   NULL,
};
static const nir_search_expression replace960 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace960_0.value, &replace960_1.value },
   NULL,
};

   /* search961_0 -> search865_0 in the cache */

/* search961_1_0 -> search734_1 in the cache */
/* search961_1 -> search952_1 in the cache */
static const nir_search_expression search961 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search865_0.value, &search952_1.value },
   NULL,
};

   /* replace961_0_0 -> search101_0_0 in the cache */

/* replace961_0_1 -> replace960_1_0_0 in the cache */
static const nir_search_expression replace961_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &replace960_1_0_0.value },
   NULL,
};

/* replace961_1_0_0 -> search101_0_0 in the cache */

/* replace961_1_0_1 -> replace101_2 in the cache */
static const nir_search_expression replace961_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &replace101_2.value },
   NULL,
};

/* replace961_1_1_0_0 -> search101_0_0 in the cache */
static const nir_search_expression replace961_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search101_0_0.value },
   NULL,
};

/* replace961_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace961_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace961_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace961_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace961_1_0.value, &replace961_1_1.value },
   NULL,
};
static const nir_search_expression replace961 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace961_0.value, &replace961_1.value },
   NULL,
};

   /* search962_0_0 -> search98_0_0 in the cache */
/* search962_0 -> replace811 in the cache */

/* search962_1 -> search573_0_1 in the cache */
static const nir_search_expression search962 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace811.value, &search573_0_1.value },
   NULL,
};

   /* replace962_0_0 -> replace960_1_0_0 in the cache */

/* replace962_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace962_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace960_1_0_0.value, &replace573_1_0.value },
   NULL,
};

/* replace962_1_0_0 -> replace101_2 in the cache */

/* replace962_1_0_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace962_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace101_2.value, &replace573_1_0.value },
   NULL,
};

/* replace962_1_1_0 -> search98_0_0 in the cache */

/* replace962_1_1_1_0 -> replace573_1_0 in the cache */
/* replace962_1_1_1 -> replace958_0_1 in the cache */
static const nir_search_expression replace962_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search98_0_0.value, &replace958_0_1.value },
   NULL,
};
static const nir_search_expression replace962_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace962_1_0.value, &replace962_1_1.value },
   NULL,
};
static const nir_search_expression replace962 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace962_0.value, &replace962_1.value },
   NULL,
};

   /* search963_0 -> search865_0 in the cache */

/* search963_1_0 -> search734_1 in the cache */
/* search963_1 -> search952_1 in the cache */
static const nir_search_expression search963 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search865_0.value, &search952_1.value },
   NULL,
};

   /* replace963_0_0 -> search101_0_0 in the cache */

/* replace963_0_1 -> replace101_2 in the cache */
static const nir_search_expression replace963_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &replace101_2.value },
   NULL,
};

/* replace963_1_0_0 -> search101_0_0 in the cache */

/* replace963_1_0_1 -> replace960_1_0_0 in the cache */
static const nir_search_expression replace963_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &replace960_1_0_0.value },
   NULL,
};

/* replace963_1_1_0_0 -> search101_0_0 in the cache */
/* replace963_1_1_0 -> replace961_1_1_0 in the cache */

/* replace963_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace963_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace961_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace963_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace963_1_0.value, &replace963_1_1.value },
   NULL,
};
static const nir_search_expression replace963 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace963_0.value, &replace963_1.value },
   NULL,
};

   /* search964_0_0 -> search98_0_0 in the cache */
/* search964_0 -> replace825 in the cache */

/* search964_1_0 -> search734_1 in the cache */
static const nir_search_expression search964_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search734_1.value },
   NULL,
};
static const nir_search_expression search964 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace825.value, &search964_1.value },
   NULL,
};

   /* replace964_0 -> search98_0_0 in the cache */

/* replace964_1_0 -> search734_1 in the cache */
/* replace964_1 -> replace952_1 in the cache */
/* replace964 -> replace952 in the cache */

   /* search965_0_0 -> search98_0_0 in the cache */
/* search965_0 -> replace825 in the cache */

/* search965_1_0 -> search734_1 in the cache */
/* search965_1 -> search964_1 in the cache */
static const nir_search_expression search965 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace825.value, &search964_1.value },
   NULL,
};

   /* replace965_0 -> search98_0_0 in the cache */

/* replace965_1_0 -> search734_1 in the cache */
/* replace965_1 -> replace952_1 in the cache */
/* replace965 -> replace953 in the cache */

   /* search966_0_0 -> search98_0_0 in the cache */
/* search966_0 -> replace825 in the cache */

/* search966_1_0 -> search734_1 in the cache */
/* search966_1 -> search964_1 in the cache */
static const nir_search_expression search966 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace825.value, &search964_1.value },
   NULL,
};

   /* replace966_0 -> search98_0_0 in the cache */

/* replace966_1_0 -> search734_1 in the cache */
/* replace966_1 -> replace952_1 in the cache */
/* replace966 -> replace954 in the cache */

   /* search967_0_0 -> search98_0_0 in the cache */
/* search967_0 -> replace825 in the cache */

/* search967_1_0 -> search734_1 in the cache */
/* search967_1 -> search964_1 in the cache */
static const nir_search_expression search967 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace825.value, &search964_1.value },
   NULL,
};

   /* replace967_0 -> search98_0_0 in the cache */

/* replace967_1_0 -> search734_1 in the cache */
/* replace967_1 -> replace952_1 in the cache */
/* replace967 -> replace955 in the cache */

   /* search968_0_0 -> search860_0_0 in the cache */
static const nir_search_expression search968_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search860_0_0.value },
   NULL,
};

/* search968_1_0 -> search860_1_0 in the cache */
static const nir_search_expression search968_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search860_1_0.value },
   NULL,
};
static const nir_search_expression search968 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search968_0.value, &search968_1.value },
   NULL,
};

   /* replace968_0_0 -> search860_0_0 in the cache */
/* replace968_0 -> replace956_0 in the cache */

/* replace968_1 -> search860_1_0 in the cache */
/* replace968 -> replace956 in the cache */

   /* search969_0_0 -> search860_0_0 in the cache */
/* search969_0 -> search968_0 in the cache */

/* search969_1_0 -> search860_1_0 in the cache */
/* search969_1 -> search968_1 in the cache */
static const nir_search_expression search969 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search968_0.value, &search968_1.value },
   NULL,
};

   /* replace969_0_0 -> search860_0_0 in the cache */
/* replace969_0 -> replace956_0 in the cache */

/* replace969_1 -> search860_1_0 in the cache */
/* replace969 -> replace957 in the cache */

   /* search970_0_0 -> search98_0_0 in the cache */
/* search970_0 -> replace825 in the cache */

/* search970_1 -> search2_1 in the cache */
static const nir_search_expression search970 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace825.value, &search2_1.value },
   NULL,
};

   /* replace970_0_0 -> search98_0_0 in the cache */

/* replace970_0_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace970_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace970_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace970_0_1.value },
   NULL,
};

/* replace970_1_0_0_0 -> replace0_1_0 in the cache */
/* replace970_1_0_0 -> replace970_0_1 in the cache */
static const nir_search_expression replace970_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace970_0_1.value },
   NULL,
};

/* replace970_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace970_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace970_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace970 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace970_0.value, &replace970_1.value },
   NULL,
};

   /* search971_0_0 -> search98_0_0 in the cache */
/* search971_0 -> replace825 in the cache */

/* search971_1 -> search2_1 in the cache */
static const nir_search_expression search971 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace825.value, &search2_1.value },
   NULL,
};

   /* replace971_0_0 -> search98_0_0 in the cache */

/* replace971_0_1_0 -> replace0_1_0 in the cache */
/* replace971_0_1 -> replace970_0_1 in the cache */
static const nir_search_expression replace971_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace970_0_1.value },
   NULL,
};

/* replace971_1_0_0_0 -> replace0_1_0 in the cache */
/* replace971_1_0_0 -> replace970_0_1 in the cache */
/* replace971_1_0 -> replace970_1_0 in the cache */

/* replace971_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace971_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace970_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace971 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace971_0.value, &replace971_1.value },
   NULL,
};

   /* search972_0_0 -> search98_0_0 in the cache */
/* search972_0 -> replace825 in the cache */

/* search972_1 -> search2_1 in the cache */
static const nir_search_expression search972 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace825.value, &search2_1.value },
   NULL,
};

   /* replace972_0_0 -> search26_1 in the cache */

/* replace972_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace972_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search26_1.value, &replace0_1_0.value },
   NULL,
};

/* replace972_1_0_0 -> replace98_0_0_0_1 in the cache */

/* replace972_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace972_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace98_0_0_0_1.value, &replace0_1_0.value },
   NULL,
};

/* replace972_1_1_0 -> search98_0_0 in the cache */

/* replace972_1_1_1_0 -> replace0_1_0 in the cache */
/* replace972_1_1_1 -> replace970_0_1 in the cache */
static const nir_search_expression replace972_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search98_0_0.value, &replace970_0_1.value },
   NULL,
};
static const nir_search_expression replace972_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace972_1_0.value, &replace972_1_1.value },
   NULL,
};
static const nir_search_expression replace972 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace972_0.value, &replace972_1.value },
   NULL,
};

   /* search973_0 -> search730_0 in the cache */

/* search973_1_0 -> search734_1 in the cache */
/* search973_1 -> search964_1 in the cache */
static const nir_search_expression search973 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search730_0.value, &search964_1.value },
   NULL,
};

   /* replace973_0_0 -> search0_0 in the cache */

/* replace973_0_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace973_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace98_0_0_0_1.value },
   NULL,
};

/* replace973_1_0_0 -> search0_0 in the cache */

/* replace973_1_0_1 -> search26_1 in the cache */
static const nir_search_expression replace973_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &search26_1.value },
   NULL,
};

/* replace973_1_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace973_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search0_0.value },
   NULL,
};

/* replace973_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace973_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace973_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace973_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace973_1_0.value, &replace973_1_1.value },
   NULL,
};
static const nir_search_expression replace973 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace973_0.value, &replace973_1.value },
   NULL,
};

   /* search974_0_0 -> search98_0_0 in the cache */
/* search974_0 -> replace825 in the cache */

/* search974_1 -> search2_1 in the cache */
static const nir_search_expression search974 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace825.value, &search2_1.value },
   NULL,
};

   /* replace974_0_0 -> replace98_0_0_0_1 in the cache */

/* replace974_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace974_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace98_0_0_0_1.value, &replace0_1_0.value },
   NULL,
};

/* replace974_1_0_0 -> search26_1 in the cache */

/* replace974_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace974_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search26_1.value, &replace0_1_0.value },
   NULL,
};

/* replace974_1_1_0 -> search98_0_0 in the cache */

/* replace974_1_1_1_0 -> replace0_1_0 in the cache */
/* replace974_1_1_1 -> replace970_0_1 in the cache */
static const nir_search_expression replace974_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search98_0_0.value, &replace970_0_1.value },
   NULL,
};
static const nir_search_expression replace974_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace974_1_0.value, &replace974_1_1.value },
   NULL,
};
static const nir_search_expression replace974 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace974_0.value, &replace974_1.value },
   NULL,
};

   /* search975_0 -> search730_0 in the cache */

/* search975_1_0 -> search734_1 in the cache */
/* search975_1 -> search964_1 in the cache */
static const nir_search_expression search975 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search730_0.value, &search964_1.value },
   NULL,
};

   /* replace975_0_0 -> search0_0 in the cache */

/* replace975_0_1 -> search26_1 in the cache */
static const nir_search_expression replace975_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &search26_1.value },
   NULL,
};

/* replace975_1_0_0 -> search0_0 in the cache */

/* replace975_1_0_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace975_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &replace98_0_0_0_1.value },
   NULL,
};

/* replace975_1_1_0_0 -> search0_0 in the cache */
/* replace975_1_1_0 -> replace973_1_1_0 in the cache */

/* replace975_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace975_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace973_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace975_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace975_1_0.value, &replace975_1_1.value },
   NULL,
};
static const nir_search_expression replace975 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace975_0.value, &replace975_1.value },
   NULL,
};

   /* search976_0_0 -> search98_0_0 in the cache */
/* search976_0 -> replace841 in the cache */

/* search976_1_0 -> search734_1 in the cache */
static const nir_search_expression search976_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search734_1.value },
   NULL,
};
static const nir_search_expression search976 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace841.value, &search976_1.value },
   NULL,
};

   /* replace976_0 -> search98_0_0 in the cache */

/* replace976_1_0 -> search734_1 in the cache */
/* replace976_1 -> replace952_1 in the cache */
/* replace976 -> replace952 in the cache */

   /* search977_0_0 -> search98_0_0 in the cache */
/* search977_0 -> replace841 in the cache */

/* search977_1_0 -> search734_1 in the cache */
/* search977_1 -> search976_1 in the cache */
static const nir_search_expression search977 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace841.value, &search976_1.value },
   NULL,
};

   /* replace977_0 -> search98_0_0 in the cache */

/* replace977_1_0 -> search734_1 in the cache */
/* replace977_1 -> replace952_1 in the cache */
/* replace977 -> replace953 in the cache */

   /* search978_0_0 -> search98_0_0 in the cache */
/* search978_0 -> replace841 in the cache */

/* search978_1_0 -> search734_1 in the cache */
/* search978_1 -> search976_1 in the cache */
static const nir_search_expression search978 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace841.value, &search976_1.value },
   NULL,
};

   /* replace978_0 -> search98_0_0 in the cache */

/* replace978_1_0 -> search734_1 in the cache */
/* replace978_1 -> replace952_1 in the cache */
/* replace978 -> replace954 in the cache */

   /* search979_0_0 -> search98_0_0 in the cache */
/* search979_0 -> replace841 in the cache */

/* search979_1_0 -> search734_1 in the cache */
/* search979_1 -> search976_1 in the cache */
static const nir_search_expression search979 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace841.value, &search976_1.value },
   NULL,
};

   /* replace979_0 -> search98_0_0 in the cache */

/* replace979_1_0 -> search734_1 in the cache */
/* replace979_1 -> replace952_1 in the cache */
/* replace979 -> replace955 in the cache */

   /* search980_0_0 -> search860_0_0 in the cache */
static const nir_search_expression search980_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search860_0_0.value },
   NULL,
};

/* search980_1_0 -> search860_1_0 in the cache */
static const nir_search_expression search980_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search860_1_0.value },
   NULL,
};
static const nir_search_expression search980 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search980_0.value, &search980_1.value },
   NULL,
};

   /* replace980_0_0 -> search860_0_0 in the cache */
/* replace980_0 -> replace956_0 in the cache */

/* replace980_1 -> search860_1_0 in the cache */
/* replace980 -> replace956 in the cache */

   /* search981_0_0 -> search860_0_0 in the cache */
/* search981_0 -> search980_0 in the cache */

/* search981_1_0 -> search860_1_0 in the cache */
/* search981_1 -> search980_1 in the cache */
static const nir_search_expression search981 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search980_0.value, &search980_1.value },
   NULL,
};

   /* replace981_0_0 -> search860_0_0 in the cache */
/* replace981_0 -> replace956_0 in the cache */

/* replace981_1 -> search860_1_0 in the cache */
/* replace981 -> replace957 in the cache */

   /* search982_0_0 -> search98_0_0 in the cache */
/* search982_0 -> replace841 in the cache */

/* search982_1 -> search886_1 in the cache */
static const nir_search_expression search982 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace841.value, &search886_1.value },
   NULL,
};

   /* replace982_0_0 -> search98_0_0 in the cache */

/* replace982_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace982_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace982_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace982_0_1.value },
   NULL,
};

/* replace982_1_0_0_0 -> search57_1_1 in the cache */
/* replace982_1_0_0 -> replace982_0_1 in the cache */
static const nir_search_expression replace982_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace982_0_1.value },
   NULL,
};

/* replace982_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace982_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace982_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace982 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace982_0.value, &replace982_1.value },
   NULL,
};

   /* search983_0_0 -> search98_0_0 in the cache */
/* search983_0 -> replace841 in the cache */

/* search983_1 -> search886_1 in the cache */
static const nir_search_expression search983 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace841.value, &search886_1.value },
   NULL,
};

   /* replace983_0_0 -> search98_0_0 in the cache */

/* replace983_0_1_0 -> search57_1_1 in the cache */
/* replace983_0_1 -> replace982_0_1 in the cache */
static const nir_search_expression replace983_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace982_0_1.value },
   NULL,
};

/* replace983_1_0_0_0 -> search57_1_1 in the cache */
/* replace983_1_0_0 -> replace982_0_1 in the cache */
/* replace983_1_0 -> replace982_1_0 in the cache */

/* replace983_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace983_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace982_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace983 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace983_0.value, &replace983_1.value },
   NULL,
};

   /* search984_0_0 -> search98_0_0 in the cache */
/* search984_0 -> replace841 in the cache */

/* search984_1 -> search886_1 in the cache */
static const nir_search_expression search984 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace841.value, &search886_1.value },
   NULL,
};

   /* replace984_0_0 -> replace107_2 in the cache */

/* replace984_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace984_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace107_2.value, &search57_1_1.value },
   NULL,
};

static const nir_search_constant replace984_1_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xff /* 255 */ },
};

/* replace984_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace984_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace984_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace984_1_1_0 -> search98_0_0 in the cache */

/* replace984_1_1_1_0 -> search57_1_1 in the cache */
/* replace984_1_1_1 -> replace982_0_1 in the cache */
static const nir_search_expression replace984_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search98_0_0.value, &replace982_0_1.value },
   NULL,
};
static const nir_search_expression replace984_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace984_1_0.value, &replace984_1_1.value },
   NULL,
};
static const nir_search_expression replace984 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace984_0.value, &replace984_1.value },
   NULL,
};

   /* search985_0 -> search889_0 in the cache */

/* search985_1_0 -> search734_1 in the cache */
/* search985_1 -> search976_1 in the cache */
static const nir_search_expression search985 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search889_0.value, &search976_1.value },
   NULL,
};

   /* replace985_0_0 -> search57_0 in the cache */

/* replace985_0_1 -> replace984_1_0_0 in the cache */
static const nir_search_expression replace985_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search57_0.value, &replace984_1_0_0.value },
   NULL,
};

/* replace985_1_0_0 -> search57_0 in the cache */

/* replace985_1_0_1 -> replace107_2 in the cache */
static const nir_search_expression replace985_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

/* replace985_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace985_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search57_0.value },
   NULL,
};

/* replace985_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace985_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace985_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace985_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace985_1_0.value, &replace985_1_1.value },
   NULL,
};
static const nir_search_expression replace985 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace985_0.value, &replace985_1.value },
   NULL,
};

   /* search986_0_0 -> search98_0_0 in the cache */
/* search986_0 -> replace841 in the cache */

/* search986_1 -> search886_1 in the cache */
static const nir_search_expression search986 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace841.value, &search886_1.value },
   NULL,
};

   /* replace986_0_0 -> replace984_1_0_0 in the cache */

/* replace986_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace986_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace984_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace986_1_0_0 -> replace107_2 in the cache */

/* replace986_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace986_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace107_2.value, &search57_1_1.value },
   NULL,
};

/* replace986_1_1_0 -> search98_0_0 in the cache */

/* replace986_1_1_1_0 -> search57_1_1 in the cache */
/* replace986_1_1_1 -> replace982_0_1 in the cache */
static const nir_search_expression replace986_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search98_0_0.value, &replace982_0_1.value },
   NULL,
};
static const nir_search_expression replace986_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace986_1_0.value, &replace986_1_1.value },
   NULL,
};
static const nir_search_expression replace986 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace986_0.value, &replace986_1.value },
   NULL,
};

   /* search987_0 -> search889_0 in the cache */

/* search987_1_0 -> search734_1 in the cache */
/* search987_1 -> search976_1 in the cache */
static const nir_search_expression search987 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search889_0.value, &search976_1.value },
   NULL,
};

   /* replace987_0_0 -> search57_0 in the cache */

/* replace987_0_1 -> replace107_2 in the cache */
static const nir_search_expression replace987_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

/* replace987_1_0_0 -> search57_0 in the cache */

/* replace987_1_0_1 -> replace984_1_0_0 in the cache */
static const nir_search_expression replace987_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search57_0.value, &replace984_1_0_0.value },
   NULL,
};

/* replace987_1_1_0_0 -> search57_0 in the cache */
/* replace987_1_1_0 -> replace985_1_1_0 in the cache */

/* replace987_1_1_1 -> search734_1 in the cache */
static const nir_search_expression replace987_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace985_1_1_0.value, &search734_1.value },
   NULL,
};
static const nir_search_expression replace987_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace987_1_0.value, &replace987_1_1.value },
   NULL,
};
static const nir_search_expression replace987 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace987_0.value, &replace987_1.value },
   NULL,
};

   /* search988_0_0 -> search101_0_0 in the cache */
/* search988_0 -> replace831 in the cache */

/* search988_1_0 -> search734_1 in the cache */
/* search988_1 -> search964_1 in the cache */
static const nir_search_expression search988 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace831.value, &search964_1.value },
   NULL,
};

   /* replace988_0 -> search101_0_0 in the cache */

/* replace988_1_0 -> search734_1 in the cache */
/* replace988_1 -> search952_1 in the cache */
static const nir_search_expression replace988 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search101_0_0.value, &search952_1.value },
   NULL,
};

   /* search989_0_0 -> search101_0_0 in the cache */
/* search989_0 -> replace831 in the cache */

/* search989_1_0 -> search734_1 in the cache */
/* search989_1 -> search964_1 in the cache */
static const nir_search_expression search989 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace831.value, &search964_1.value },
   NULL,
};

   /* replace989_0 -> search101_0_0 in the cache */

/* replace989_1_0 -> search734_1 in the cache */
/* replace989_1 -> search952_1 in the cache */
static const nir_search_expression replace989 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search101_0_0.value, &search952_1.value },
   NULL,
};

   /* search990_0_0 -> search101_0_0 in the cache */
/* search990_0 -> replace831 in the cache */

/* search990_1_0 -> search734_1 in the cache */
/* search990_1 -> search964_1 in the cache */
static const nir_search_expression search990 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace831.value, &search964_1.value },
   NULL,
};

   /* replace990_0 -> search101_0_0 in the cache */

/* replace990_1_0 -> search734_1 in the cache */
/* replace990_1 -> search952_1 in the cache */
static const nir_search_expression replace990 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &search952_1.value },
   NULL,
};

   /* search991_0_0 -> search101_0_0 in the cache */
/* search991_0 -> replace831 in the cache */

/* search991_1_0 -> search734_1 in the cache */
/* search991_1 -> search964_1 in the cache */
static const nir_search_expression search991 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace831.value, &search964_1.value },
   NULL,
};

   /* replace991_0 -> search101_0_0 in the cache */

/* replace991_1_0 -> search734_1 in the cache */
/* replace991_1 -> search952_1 in the cache */
static const nir_search_expression replace991 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &search952_1.value },
   NULL,
};

   /* search992_0_0 -> search860_0_0 in the cache */
/* search992_0 -> search968_0 in the cache */

/* search992_1_0 -> search896_1_0 in the cache */
static const nir_search_expression search992_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search896_1_0.value },
   NULL,
};
static const nir_search_expression search992 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search968_0.value, &search992_1.value },
   NULL,
};

   /* replace992_0_0 -> search860_0_0 in the cache */
/* replace992_0 -> search956_0 in the cache */

/* replace992_1 -> search896_1_0 in the cache */
static const nir_search_expression replace992 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search956_0.value, &search896_1_0.value },
   NULL,
};

   /* search993_0_0 -> search860_0_0 in the cache */
/* search993_0 -> search968_0 in the cache */

/* search993_1_0 -> search896_1_0 in the cache */
/* search993_1 -> search992_1 in the cache */
static const nir_search_expression search993 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search968_0.value, &search992_1.value },
   NULL,
};

   /* replace993_0_0 -> search860_0_0 in the cache */
/* replace993_0 -> search956_0 in the cache */

/* replace993_1 -> search896_1_0 in the cache */
static const nir_search_expression replace993 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search956_0.value, &search896_1_0.value },
   NULL,
};

   /* search994_0_0 -> search101_0_0 in the cache */
/* search994_0 -> replace831 in the cache */

/* search994_1_0 -> replace573_1_0 in the cache */
static const nir_search_expression search994_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace573_1_0.value },
   NULL,
};
static const nir_search_expression search994 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace831.value, &search994_1.value },
   NULL,
};

   /* replace994_0 -> search101_0_0 in the cache */

/* replace994_1_0 -> replace573_1_0 in the cache */
static const nir_search_expression replace994_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace994 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace994_1.value },
   NULL,
};

   /* search995_0_0 -> search101_0_0 in the cache */
/* search995_0 -> replace831 in the cache */

/* search995_1_0 -> replace573_1_0 in the cache */
/* search995_1 -> search994_1 in the cache */
static const nir_search_expression search995 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace831.value, &search994_1.value },
   NULL,
};

   /* replace995_0 -> search101_0_0 in the cache */

/* replace995_1_0 -> replace573_1_0 in the cache */
/* replace995_1 -> replace994_1 in the cache */
static const nir_search_expression replace995 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace994_1.value },
   NULL,
};

   /* search996_0_0 -> search101_0_0 in the cache */
/* search996_0 -> replace831 in the cache */

/* search996_1_0 -> replace573_1_0 in the cache */
/* search996_1 -> search994_1 in the cache */
static const nir_search_expression search996 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace831.value, &search994_1.value },
   NULL,
};

   /* replace996_0 -> search101_0_0 in the cache */

/* replace996_1_0 -> replace573_1_0 in the cache */
/* replace996_1 -> replace994_1 in the cache */
static const nir_search_expression replace996 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &replace994_1.value },
   NULL,
};

   /* search997_0_0 -> search101_0_0 in the cache */
/* search997_0 -> replace831 in the cache */

/* search997_1_0 -> replace573_1_0 in the cache */
/* search997_1 -> search994_1 in the cache */
static const nir_search_expression search997 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace831.value, &search994_1.value },
   NULL,
};

   /* replace997_0 -> search101_0_0 in the cache */

/* replace997_1_0 -> replace573_1_0 in the cache */
/* replace997_1 -> replace994_1 in the cache */
static const nir_search_expression replace997 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &replace994_1.value },
   NULL,
};

   /* search998_0_0 -> search902_0_0 in the cache */
static const nir_search_expression search998_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search902_0_0.value },
   NULL,
};

/* search998_1_0 -> search896_1_0 in the cache */
/* search998_1 -> search992_1 in the cache */
static const nir_search_expression search998 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search998_0.value, &search992_1.value },
   NULL,
};

   /* replace998_0_0 -> search902_0_0 in the cache */
static const nir_search_expression replace998_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search902_0_0.value },
   NULL,
};

/* replace998_1 -> search896_1_0 in the cache */
static const nir_search_expression replace998 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace998_0.value, &search896_1_0.value },
   NULL,
};

   /* search999_0_0 -> search902_0_0 in the cache */
/* search999_0 -> search998_0 in the cache */

/* search999_1_0 -> search896_1_0 in the cache */
/* search999_1 -> search992_1 in the cache */
static const nir_search_expression search999 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search998_0.value, &search992_1.value },
   NULL,
};

   /* replace999_0_0 -> search902_0_0 in the cache */
/* replace999_0 -> replace998_0 in the cache */

/* replace999_1 -> search896_1_0 in the cache */
static const nir_search_expression replace999 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace998_0.value, &search896_1_0.value },
   NULL,
};

   /* search1000_0_0 -> search101_0_0 in the cache */
/* search1000_0 -> replace831 in the cache */

/* search1000_1 -> search2_1 in the cache */
static const nir_search_expression search1000 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace831.value, &search2_1.value },
   NULL,
};

   /* replace1000_0_0 -> search101_0_0 in the cache */

/* replace1000_0_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace1000_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace1000_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace1000_0_1.value },
   NULL,
};

/* replace1000_1_0_0_0 -> replace0_1_0 in the cache */
/* replace1000_1_0_0 -> replace1000_0_1 in the cache */
static const nir_search_expression replace1000_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace1000_0_1.value },
   NULL,
};

/* replace1000_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace1000_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace1000_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace1000 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace1000_0.value, &replace1000_1.value },
   NULL,
};

   /* search1001_0_0 -> search101_0_0 in the cache */
/* search1001_0 -> replace831 in the cache */

/* search1001_1 -> search2_1 in the cache */
static const nir_search_expression search1001 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace831.value, &search2_1.value },
   NULL,
};

   /* replace1001_0_0 -> search101_0_0 in the cache */

/* replace1001_0_1_0 -> replace0_1_0 in the cache */
/* replace1001_0_1 -> replace1000_0_1 in the cache */
static const nir_search_expression replace1001_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace1000_0_1.value },
   NULL,
};

/* replace1001_1_0_0_0 -> replace0_1_0 in the cache */
/* replace1001_1_0_0 -> replace1000_0_1 in the cache */
/* replace1001_1_0 -> replace1000_1_0 in the cache */

/* replace1001_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace1001_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace1000_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace1001 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace1001_0.value, &replace1001_1.value },
   NULL,
};

   /* search1002_0_0 -> search101_0_0 in the cache */
/* search1002_0 -> replace831 in the cache */

/* search1002_1 -> search2_1 in the cache */
static const nir_search_expression search1002 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace831.value, &search2_1.value },
   NULL,
};

   /* replace1002_0_0 -> search26_1 in the cache */

/* replace1002_0_1 -> replace0_1_0 in the cache */
/* replace1002_0 -> replace972_0 in the cache */

/* replace1002_1_0_0 -> replace101_0_0_0_1 in the cache */

/* replace1002_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace1002_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace101_0_0_0_1.value, &replace0_1_0.value },
   NULL,
};

/* replace1002_1_1_0 -> search101_0_0 in the cache */

/* replace1002_1_1_1_0 -> replace0_1_0 in the cache */
/* replace1002_1_1_1 -> replace1000_0_1 in the cache */
static const nir_search_expression replace1002_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &replace1000_0_1.value },
   NULL,
};
static const nir_search_expression replace1002_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace1002_1_0.value, &replace1002_1_1.value },
   NULL,
};
static const nir_search_expression replace1002 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace972_0.value, &replace1002_1.value },
   NULL,
};

   /* search1003_0 -> search730_0 in the cache */

/* search1003_1_0 -> replace573_1_0 in the cache */
/* search1003_1 -> search994_1 in the cache */
static const nir_search_expression search1003 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search730_0.value, &search994_1.value },
   NULL,
};

   /* replace1003_0_0 -> search0_0 in the cache */

/* replace1003_0_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace1003_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace101_0_0_0_1.value },
   NULL,
};

/* replace1003_1_0_0 -> search0_0 in the cache */

/* replace1003_1_0_1 -> search26_1 in the cache */
/* replace1003_1_0 -> replace973_1_0 in the cache */

/* replace1003_1_1_0_0 -> search0_0 in the cache */
/* replace1003_1_1_0 -> replace722_0 in the cache */

/* replace1003_1_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace1003_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace722_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace1003_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace973_1_0.value, &replace1003_1_1.value },
   NULL,
};
static const nir_search_expression replace1003 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace1003_0.value, &replace1003_1.value },
   NULL,
};

   /* search1004_0_0 -> search101_0_0 in the cache */
/* search1004_0 -> replace831 in the cache */

/* search1004_1 -> search2_1 in the cache */
static const nir_search_expression search1004 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace831.value, &search2_1.value },
   NULL,
};

   /* replace1004_0_0 -> replace101_0_0_0_1 in the cache */

/* replace1004_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace1004_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace101_0_0_0_1.value, &replace0_1_0.value },
   NULL,
};

/* replace1004_1_0_0 -> search26_1 in the cache */

/* replace1004_1_0_1 -> replace0_1_0 in the cache */
/* replace1004_1_0 -> replace974_1_0 in the cache */

/* replace1004_1_1_0 -> search101_0_0 in the cache */

/* replace1004_1_1_1_0 -> replace0_1_0 in the cache */
/* replace1004_1_1_1 -> replace1000_0_1 in the cache */
static const nir_search_expression replace1004_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &replace1000_0_1.value },
   NULL,
};
static const nir_search_expression replace1004_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace974_1_0.value, &replace1004_1_1.value },
   NULL,
};
static const nir_search_expression replace1004 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace1004_0.value, &replace1004_1.value },
   NULL,
};

   /* search1005_0 -> search730_0 in the cache */

/* search1005_1_0 -> replace573_1_0 in the cache */
/* search1005_1 -> search994_1 in the cache */
static const nir_search_expression search1005 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search730_0.value, &search994_1.value },
   NULL,
};

   /* replace1005_0_0 -> search0_0 in the cache */

/* replace1005_0_1 -> search26_1 in the cache */
/* replace1005_0 -> replace975_0 in the cache */

/* replace1005_1_0_0 -> search0_0 in the cache */

/* replace1005_1_0_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace1005_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &replace101_0_0_0_1.value },
   NULL,
};

/* replace1005_1_1_0_0 -> search0_0 in the cache */
/* replace1005_1_1_0 -> replace722_0 in the cache */

/* replace1005_1_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace1005_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace722_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace1005_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace1005_1_0.value, &replace1005_1_1.value },
   NULL,
};
static const nir_search_expression replace1005 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace975_0.value, &replace1005_1.value },
   NULL,
};

   /* search1006_0_0 -> search101_0_0 in the cache */
/* search1006_0 -> replace847 in the cache */

/* search1006_1_0 -> search734_1 in the cache */
/* search1006_1 -> search976_1 in the cache */
static const nir_search_expression search1006 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace847.value, &search976_1.value },
   NULL,
};

   /* replace1006_0 -> search101_0_0 in the cache */

/* replace1006_1_0 -> search734_1 in the cache */
/* replace1006_1 -> search952_1 in the cache */
/* replace1006 -> replace988 in the cache */

   /* search1007_0_0 -> search101_0_0 in the cache */
/* search1007_0 -> replace847 in the cache */

/* search1007_1_0 -> search734_1 in the cache */
/* search1007_1 -> search976_1 in the cache */
static const nir_search_expression search1007 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace847.value, &search976_1.value },
   NULL,
};

   /* replace1007_0 -> search101_0_0 in the cache */

/* replace1007_1_0 -> search734_1 in the cache */
/* replace1007_1 -> search952_1 in the cache */
/* replace1007 -> replace989 in the cache */

   /* search1008_0_0 -> search101_0_0 in the cache */
/* search1008_0 -> replace847 in the cache */

/* search1008_1_0 -> search734_1 in the cache */
/* search1008_1 -> search976_1 in the cache */
static const nir_search_expression search1008 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace847.value, &search976_1.value },
   NULL,
};

   /* replace1008_0 -> search101_0_0 in the cache */

/* replace1008_1_0 -> search734_1 in the cache */
/* replace1008_1 -> search952_1 in the cache */
/* replace1008 -> replace990 in the cache */

   /* search1009_0_0 -> search101_0_0 in the cache */
/* search1009_0 -> replace847 in the cache */

/* search1009_1_0 -> search734_1 in the cache */
/* search1009_1 -> search976_1 in the cache */
static const nir_search_expression search1009 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace847.value, &search976_1.value },
   NULL,
};

   /* replace1009_0 -> search101_0_0 in the cache */

/* replace1009_1_0 -> search734_1 in the cache */
/* replace1009_1 -> search952_1 in the cache */
/* replace1009 -> replace991 in the cache */

   /* search1010_0_0 -> search860_0_0 in the cache */
/* search1010_0 -> search980_0 in the cache */

/* search1010_1_0 -> search896_1_0 in the cache */
static const nir_search_expression search1010_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search896_1_0.value },
   NULL,
};
static const nir_search_expression search1010 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search980_0.value, &search1010_1.value },
   NULL,
};

   /* replace1010_0_0 -> search860_0_0 in the cache */
/* replace1010_0 -> search956_0 in the cache */

/* replace1010_1 -> search896_1_0 in the cache */
/* replace1010 -> replace992 in the cache */

   /* search1011_0_0 -> search860_0_0 in the cache */
/* search1011_0 -> search980_0 in the cache */

/* search1011_1_0 -> search896_1_0 in the cache */
/* search1011_1 -> search1010_1 in the cache */
static const nir_search_expression search1011 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search980_0.value, &search1010_1.value },
   NULL,
};

   /* replace1011_0_0 -> search860_0_0 in the cache */
/* replace1011_0 -> search956_0 in the cache */

/* replace1011_1 -> search896_1_0 in the cache */
/* replace1011 -> replace993 in the cache */

   /* search1012_0_0 -> search101_0_0 in the cache */
/* search1012_0 -> replace847 in the cache */

/* search1012_1_0 -> replace573_1_0 in the cache */
static const nir_search_expression search1012_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace573_1_0.value },
   NULL,
};
static const nir_search_expression search1012 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace847.value, &search1012_1.value },
   NULL,
};

   /* replace1012_0 -> search101_0_0 in the cache */

/* replace1012_1_0 -> replace573_1_0 in the cache */
/* replace1012_1 -> replace994_1 in the cache */
/* replace1012 -> replace994 in the cache */

   /* search1013_0_0 -> search101_0_0 in the cache */
/* search1013_0 -> replace847 in the cache */

/* search1013_1_0 -> replace573_1_0 in the cache */
/* search1013_1 -> search1012_1 in the cache */
static const nir_search_expression search1013 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace847.value, &search1012_1.value },
   NULL,
};

   /* replace1013_0 -> search101_0_0 in the cache */

/* replace1013_1_0 -> replace573_1_0 in the cache */
/* replace1013_1 -> replace994_1 in the cache */
/* replace1013 -> replace995 in the cache */

   /* search1014_0_0 -> search101_0_0 in the cache */
/* search1014_0 -> replace847 in the cache */

/* search1014_1_0 -> replace573_1_0 in the cache */
/* search1014_1 -> search1012_1 in the cache */
static const nir_search_expression search1014 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace847.value, &search1012_1.value },
   NULL,
};

   /* replace1014_0 -> search101_0_0 in the cache */

/* replace1014_1_0 -> replace573_1_0 in the cache */
/* replace1014_1 -> replace994_1 in the cache */
/* replace1014 -> replace996 in the cache */

   /* search1015_0_0 -> search101_0_0 in the cache */
/* search1015_0 -> replace847 in the cache */

/* search1015_1_0 -> replace573_1_0 in the cache */
/* search1015_1 -> search1012_1 in the cache */
static const nir_search_expression search1015 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace847.value, &search1012_1.value },
   NULL,
};

   /* replace1015_0 -> search101_0_0 in the cache */

/* replace1015_1_0 -> replace573_1_0 in the cache */
/* replace1015_1 -> replace994_1 in the cache */
/* replace1015 -> replace997 in the cache */

   /* search1016_0_0 -> search902_0_0 in the cache */
static const nir_search_expression search1016_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search902_0_0.value },
   NULL,
};

/* search1016_1_0 -> search896_1_0 in the cache */
/* search1016_1 -> search1010_1 in the cache */
static const nir_search_expression search1016 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search1016_0.value, &search1010_1.value },
   NULL,
};

   /* replace1016_0_0 -> search902_0_0 in the cache */
/* replace1016_0 -> replace998_0 in the cache */

/* replace1016_1 -> search896_1_0 in the cache */
/* replace1016 -> replace998 in the cache */

   /* search1017_0_0 -> search902_0_0 in the cache */
/* search1017_0 -> search1016_0 in the cache */

/* search1017_1_0 -> search896_1_0 in the cache */
/* search1017_1 -> search1010_1 in the cache */
static const nir_search_expression search1017 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search1016_0.value, &search1010_1.value },
   NULL,
};

   /* replace1017_0_0 -> search902_0_0 in the cache */
/* replace1017_0 -> replace998_0 in the cache */

/* replace1017_1 -> search896_1_0 in the cache */
/* replace1017 -> replace999 in the cache */

   /* search1018_0_0 -> search101_0_0 in the cache */
/* search1018_0 -> replace847 in the cache */

/* search1018_1 -> search886_1 in the cache */
static const nir_search_expression search1018 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace847.value, &search886_1.value },
   NULL,
};

   /* replace1018_0_0 -> search101_0_0 in the cache */

/* replace1018_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace1018_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace1018_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace1018_0_1.value },
   NULL,
};

/* replace1018_1_0_0_0 -> search57_1_1 in the cache */
/* replace1018_1_0_0 -> replace1018_0_1 in the cache */
static const nir_search_expression replace1018_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace1018_0_1.value },
   NULL,
};

/* replace1018_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace1018_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace1018_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace1018 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace1018_0.value, &replace1018_1.value },
   NULL,
};

   /* search1019_0_0 -> search101_0_0 in the cache */
/* search1019_0 -> replace847 in the cache */

/* search1019_1 -> search886_1 in the cache */
static const nir_search_expression search1019 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace847.value, &search886_1.value },
   NULL,
};

   /* replace1019_0_0 -> search101_0_0 in the cache */

/* replace1019_0_1_0 -> search57_1_1 in the cache */
/* replace1019_0_1 -> replace1018_0_1 in the cache */
static const nir_search_expression replace1019_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace1018_0_1.value },
   NULL,
};

/* replace1019_1_0_0_0 -> search57_1_1 in the cache */
/* replace1019_1_0_0 -> replace1018_0_1 in the cache */
/* replace1019_1_0 -> replace1018_1_0 in the cache */

/* replace1019_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace1019_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace1018_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace1019 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace1019_0.value, &replace1019_1.value },
   NULL,
};

   /* search1020_0_0 -> search101_0_0 in the cache */
/* search1020_0 -> replace847 in the cache */

/* search1020_1 -> search886_1 in the cache */
static const nir_search_expression search1020 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace847.value, &search886_1.value },
   NULL,
};

   /* replace1020_0_0 -> replace107_2 in the cache */

/* replace1020_0_1 -> search57_1_1 in the cache */
/* replace1020_0 -> replace984_0 in the cache */

static const nir_search_constant replace1020_1_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xffff /* 65535 */ },
};

/* replace1020_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace1020_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace1020_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace1020_1_1_0 -> search101_0_0 in the cache */

/* replace1020_1_1_1_0 -> search57_1_1 in the cache */
/* replace1020_1_1_1 -> replace1018_0_1 in the cache */
static const nir_search_expression replace1020_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &replace1018_0_1.value },
   NULL,
};
static const nir_search_expression replace1020_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace1020_1_0.value, &replace1020_1_1.value },
   NULL,
};
static const nir_search_expression replace1020 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace984_0.value, &replace1020_1.value },
   NULL,
};

   /* search1021_0 -> search889_0 in the cache */

/* search1021_1_0 -> replace573_1_0 in the cache */
/* search1021_1 -> search1012_1 in the cache */
static const nir_search_expression search1021 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search889_0.value, &search1012_1.value },
   NULL,
};

   /* replace1021_0_0 -> search57_0 in the cache */

/* replace1021_0_1 -> replace1020_1_0_0 in the cache */
static const nir_search_expression replace1021_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search57_0.value, &replace1020_1_0_0.value },
   NULL,
};

/* replace1021_1_0_0 -> search57_0 in the cache */

/* replace1021_1_0_1 -> replace107_2 in the cache */
/* replace1021_1_0 -> replace985_1_0 in the cache */

/* replace1021_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace1021_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search57_0.value },
   NULL,
};

/* replace1021_1_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace1021_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace1021_1_1_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace1021_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace985_1_0.value, &replace1021_1_1.value },
   NULL,
};
static const nir_search_expression replace1021 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace1021_0.value, &replace1021_1.value },
   NULL,
};

   /* search1022_0_0 -> search101_0_0 in the cache */
/* search1022_0 -> replace847 in the cache */

/* search1022_1 -> search886_1 in the cache */
static const nir_search_expression search1022 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace847.value, &search886_1.value },
   NULL,
};

   /* replace1022_0_0 -> replace1020_1_0_0 in the cache */

/* replace1022_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace1022_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace1020_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace1022_1_0_0 -> replace107_2 in the cache */

/* replace1022_1_0_1 -> search57_1_1 in the cache */
/* replace1022_1_0 -> replace986_1_0 in the cache */

/* replace1022_1_1_0 -> search101_0_0 in the cache */

/* replace1022_1_1_1_0 -> search57_1_1 in the cache */
/* replace1022_1_1_1 -> replace1018_0_1 in the cache */
static const nir_search_expression replace1022_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &replace1018_0_1.value },
   NULL,
};
static const nir_search_expression replace1022_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace986_1_0.value, &replace1022_1_1.value },
   NULL,
};
static const nir_search_expression replace1022 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace1022_0.value, &replace1022_1.value },
   NULL,
};

   /* search1023_0 -> search889_0 in the cache */

/* search1023_1_0 -> replace573_1_0 in the cache */
/* search1023_1 -> search1012_1 in the cache */
static const nir_search_expression search1023 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search889_0.value, &search1012_1.value },
   NULL,
};

   /* replace1023_0_0 -> search57_0 in the cache */

/* replace1023_0_1 -> replace107_2 in the cache */
/* replace1023_0 -> replace987_0 in the cache */

/* replace1023_1_0_0 -> search57_0 in the cache */

/* replace1023_1_0_1 -> replace1020_1_0_0 in the cache */
static const nir_search_expression replace1023_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search57_0.value, &replace1020_1_0_0.value },
   NULL,
};

/* replace1023_1_1_0_0 -> search57_0 in the cache */
/* replace1023_1_1_0 -> replace1021_1_1_0 in the cache */

/* replace1023_1_1_1 -> replace573_1_0 in the cache */
static const nir_search_expression replace1023_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace1021_1_1_0.value, &replace573_1_0.value },
   NULL,
};
static const nir_search_expression replace1023_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace1023_1_0.value, &replace1023_1_1.value },
   NULL,
};
static const nir_search_expression replace1023 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace987_0.value, &replace1023_1.value },
   NULL,
};

   /* search1024_0_0 -> search0_0 in the cache */
/* search1024_0 -> replace855 in the cache */

/* search1024_1_0 -> search734_1 in the cache */
/* search1024_1 -> search976_1 in the cache */
static const nir_search_expression search1024 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace855.value, &search976_1.value },
   NULL,
};

   /* replace1024_0 -> search0_0 in the cache */

/* replace1024_1_0 -> search734_1 in the cache */
/* replace1024_1 -> search964_1 in the cache */
static const nir_search_expression replace1024 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &search964_1.value },
   NULL,
};

   /* search1025_0_0 -> search0_0 in the cache */
/* search1025_0 -> replace855 in the cache */

/* search1025_1_0 -> search734_1 in the cache */
/* search1025_1 -> search976_1 in the cache */
static const nir_search_expression search1025 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace855.value, &search976_1.value },
   NULL,
};

   /* replace1025_0 -> search0_0 in the cache */

/* replace1025_1_0 -> search734_1 in the cache */
/* replace1025_1 -> search964_1 in the cache */
static const nir_search_expression replace1025 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search964_1.value },
   NULL,
};

   /* search1026_0_0 -> search0_0 in the cache */
/* search1026_0 -> replace855 in the cache */

/* search1026_1_0 -> search734_1 in the cache */
/* search1026_1 -> search976_1 in the cache */
static const nir_search_expression search1026 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace855.value, &search976_1.value },
   NULL,
};

   /* replace1026_0 -> search0_0 in the cache */

/* replace1026_1_0 -> search734_1 in the cache */
/* replace1026_1 -> search964_1 in the cache */
static const nir_search_expression replace1026 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &search964_1.value },
   NULL,
};

   /* search1027_0_0 -> search0_0 in the cache */
/* search1027_0 -> replace855 in the cache */

/* search1027_1_0 -> search734_1 in the cache */
/* search1027_1 -> search976_1 in the cache */
static const nir_search_expression search1027 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace855.value, &search976_1.value },
   NULL,
};

   /* replace1027_0 -> search0_0 in the cache */

/* replace1027_1_0 -> search734_1 in the cache */
/* replace1027_1 -> search964_1 in the cache */
static const nir_search_expression replace1027 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &search964_1.value },
   NULL,
};

   /* search1028_0_0 -> search860_0_0 in the cache */
/* search1028_0 -> search980_0 in the cache */

/* search1028_1_0 -> search932_1_0 in the cache */
static const nir_search_expression search1028_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search932_1_0.value },
   NULL,
};
static const nir_search_expression search1028 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search980_0.value, &search1028_1.value },
   NULL,
};

   /* replace1028_0_0 -> search860_0_0 in the cache */
/* replace1028_0 -> search968_0 in the cache */

/* replace1028_1 -> search932_1_0 in the cache */
static const nir_search_expression replace1028 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search968_0.value, &search932_1_0.value },
   NULL,
};

   /* search1029_0_0 -> search860_0_0 in the cache */
/* search1029_0 -> search980_0 in the cache */

/* search1029_1_0 -> search932_1_0 in the cache */
/* search1029_1 -> search1028_1 in the cache */
static const nir_search_expression search1029 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search980_0.value, &search1028_1.value },
   NULL,
};

   /* replace1029_0_0 -> search860_0_0 in the cache */
/* replace1029_0 -> search968_0 in the cache */

/* replace1029_1 -> search932_1_0 in the cache */
static const nir_search_expression replace1029 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search968_0.value, &search932_1_0.value },
   NULL,
};

   /* search1030_0_0 -> search0_0 in the cache */
/* search1030_0 -> replace855 in the cache */

/* search1030_1_0 -> replace573_1_0 in the cache */
/* search1030_1 -> search1012_1 in the cache */
static const nir_search_expression search1030 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace855.value, &search1012_1.value },
   NULL,
};

   /* replace1030_0 -> search0_0 in the cache */

/* replace1030_1_0 -> replace573_1_0 in the cache */
/* replace1030_1 -> search994_1 in the cache */
static const nir_search_expression replace1030 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &search994_1.value },
   NULL,
};

   /* search1031_0_0 -> search0_0 in the cache */
/* search1031_0 -> replace855 in the cache */

/* search1031_1_0 -> replace573_1_0 in the cache */
/* search1031_1 -> search1012_1 in the cache */
static const nir_search_expression search1031 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace855.value, &search1012_1.value },
   NULL,
};

   /* replace1031_0 -> search0_0 in the cache */

/* replace1031_1_0 -> replace573_1_0 in the cache */
/* replace1031_1 -> search994_1 in the cache */
static const nir_search_expression replace1031 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search994_1.value },
   NULL,
};

   /* search1032_0_0 -> search0_0 in the cache */
/* search1032_0 -> replace855 in the cache */

/* search1032_1_0 -> replace573_1_0 in the cache */
/* search1032_1 -> search1012_1 in the cache */
static const nir_search_expression search1032 = {
   { nir_search_value_expression, 1 },
