/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Draw/Line/LineHorizontal/Tests/LineHorizontalTest00.js
// Timestamp   : 2011-02-17 14:59:27
// Description : 6 lines, length of 10 / 20, different reference points

include('scripts/Pro/Developer/TestingDashboard/TdbTest.js');

function LineHorizontalTest00() {
    TdbTest.call(this, 'scripts/Draw/Line/LineHorizontal/Tests/LineHorizontalTest00.js');
}

LineHorizontalTest00.prototype = new TdbTest();

LineHorizontalTest00.prototype.test00 = function() {
    qDebug('running LineHorizontalTest00.test00()...');
    this.setUp();
    this.clickOnWidget('MainWindow::MainToolsPanel::LineToolsPanelButton');
    this.clickOnWidget('MainWindow::LineToolsPanel::LineHorizontalButton');
    this.setToolOption('LineHorizontal/Length',  [ 20, 0 ] );
    this.setToolOption('LineHorizontal/ReferencePoint', 'Start');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineHorizontal/Length',  [ 20, 0 ] );
    this.setToolOption('LineHorizontal/ReferencePoint', 'Middle');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 2);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineHorizontal/Length',  [ 20, 0 ] );
    this.setToolOption('LineHorizontal/ReferencePoint', 'End');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 4);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineHorizontal/Length',  [ 10, 0 ] );
    this.setToolOption('LineHorizontal/ReferencePoint', 'End');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 6);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineHorizontal/Length',  [ 10, 0 ] );
    this.setToolOption('LineHorizontal/ReferencePoint', 'Middle');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 8);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineHorizontal/Length',  [ 10, 0 ] );
    this.setToolOption('LineHorizontal/ReferencePoint', 'Start');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 10);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.sendMouseEventToGv(QEvent.MouseButtonPress, new QPoint(266, 115), Qt.RightButton, 2, 0);
    this.sendMouseEventToGv(QEvent.MouseButtonRelease, new QPoint(266, 115), Qt.RightButton, 0, 0);
    this.sendMouseEventToGv(QEvent.MouseButtonPress, new QPoint(207, 205), Qt.RightButton, 2, 0);
    this.sendMouseEventToGv(QEvent.MouseButtonRelease, new QPoint(207, 205), Qt.RightButton, 0, 0);
    this.verifyDrawing('LineHorizontalTest00_000.dxf');
    this.tearDown();
    qDebug('finished LineHorizontalTest00.test00()');
};

