"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.XJsonWorker = void 0;
const grammar_1 = require("../grammar");
class XJsonWorker {
    constructor(ctx) {
        this.ctx = ctx;
    }
    async parse(modelUri) {
        if (!this.parser) {
            this.parser = grammar_1.createParser();
        }
        const model = this.ctx.getMirrorModels().find((m) => m.uri.toString() === modelUri);
        if (model) {
            return this.parser(model.getValue());
        }
    }
}
exports.XJsonWorker = XJsonWorker;
//# sourceMappingURL=xjson_worker.js.map