# This file was automatically generated by bifcl from /pobj/zeek-4.0.0/zeek-4.0.0/src/broker/messaging.bif (alternative mode).


##! Functions for peering and various messaging patterns.

export {


module Broker;




## Create a data structure that may be used to send a remote event via
## :zeek:see:`Broker::publish`.
##
## args: an event, followed by a list of argument values that may be used
##       to call it.
##
## Returns: opaque communication data that may be used to send a remote
##          event.
global Broker::make_event: function(va_args: any): Broker::Event ;


## Publishes an event at a given topic.
##
## topic: a topic associated with the event message.
##
## args: Either the event arguments as already made by
##       :zeek:see:`Broker::make_event` or the argument list to pass along
##       to it.
##
## Returns: true if the message is sent.
global Broker::publish: function(va_args: any): bool ;


global Broker::__flush_logs: function(): count ;


global Broker::__publish_id: function(topic: string , id: string ): bool ;


global Broker::__auto_publish: function(topic: string , ev: any ): bool ;


global Broker::__auto_unpublish: function(topic: string , ev: any ): bool ;


global Broker::__subscribe: function(topic_prefix: string ): bool ;


global Broker::__forward: function(topic_prefix: string ): bool ;


global Broker::__unsubscribe: function(topic_prefix: string ): bool ;


module Cluster;




## Publishes an event to a node within a pool according to Round-Robin
## distribution strategy.
##
## pool: the pool of nodes that are eligible to receive the event.
##
## key: an arbitrary string to identify the purpose for which you're
##      distributing the event.  e.g. consider using namespacing of your
##      script like "Intel::cluster_rr_key".
##
## args: Either the event arguments as already made by
##       :zeek:see:`Broker::make_event` or the argument list to pass along
##       to it.
##
## Returns: true if the message is sent.
global Cluster::publish_rr: function(va_args: any): bool ;



## Publishes an event to a node within a pool according to Rendezvous
## (Highest Random Weight) hashing strategy.
##
## pool: the pool of nodes that are eligible to receive the event.
##
## key: data used for input to the hashing function that will uniformly
##      distribute keys among available nodes.
##
## args: Either the event arguments as already made by
##       :zeek:see:`Broker::make_event` or the argument list to pass along
##       to it.
##
## Returns: true if the message is sent.
global Cluster::publish_hrw: function(va_args: any): bool ;

} # end of export section
module GLOBAL;
