(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/actor/rpc/proto/cipher#::digest-type
    std/crypto/digest#digest::sha256)
  (define std/actor/rpc/proto/cipher#::digest-size
    (std/crypto/digest#digest-size std/actor/rpc/proto/cipher#::digest-type))
  (define std/actor/rpc/proto/cipher#::cipher-type
    std/crypto/cipher#cipher::aes-128-cbc)
  (define std/actor/rpc/proto/cipher#::cipher-key-length
    (std/crypto/cipher#cipher-key-length
     std/actor/rpc/proto/cipher#::cipher-type))
  (define std/actor/rpc/proto/cipher#::cipher-iv-length
    (std/crypto/cipher#cipher-iv-length
     std/actor/rpc/proto/cipher#::cipher-type))
  (define std/actor/rpc/proto/cipher#::cipher-block-size
    (std/crypto/cipher#cipher-block-size
     std/actor/rpc/proto/cipher#::cipher-type))
  (define std/actor/rpc/proto/cipher#::DH::new std/crypto/dh#DH-get-1024-160)
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-key-exchange
    (lambda (_ibuf622_ _obuf623_)
      (let* ((_dh625_ (std/actor/rpc/proto/cipher#::DH::new))
             (_g5709_ (std/crypto/dh#DH-generate-key _dh625_))
             (_pubk628_ (std/crypto/libcrypto#DH_pub_key _dh625_))
             (_bytes630_ (std/crypto/bn#BN->bytes _pubk628_)))
        (std/net/bio/output#bio-write-u8
         std/actor/rpc/proto/message#rpc-proto-key-exchange
         _obuf623_)
        (std/net/bio/output#bio-write-u32
         (u8vector-length _bytes630_)
         _obuf623_)
        (std/net/bio/output#bio-write-bytes _bytes630_ _obuf623_)
        (std/net/bio/output#bio-force-output _obuf623_)
        (let ((_e633_ (std/net/bio/input#bio-read-u8 _ibuf622_)))
          (if (eq? _e633_ std/actor/rpc/proto/message#rpc-proto-key-exchange)
              (let* ((_sz635_ (std/net/bio/input#bio-read-u32 _ibuf622_))
                     (_g5710_ (if (fx> _sz635_ '1024)
                                  (std/actor/proto#raise-rpc-io-error
                                   'rpc-proto-key-exchange
                                   '"inordinately sized key"
                                   _sz635_)
                                  '#!void))
                     (_bytes638_ (make-u8vector _sz635_))
                     (_g5711_ (std/net/bio/input#bio-read-bytes
                               _bytes638_
                               _ibuf622_))
                     (_peerk641_ (std/crypto/bn#bytes->BN__0 _bytes638_)))
                (std/crypto/dh#DH-compute-key _dh625_ _peerk641_))
              (if (eof-object? _e633_)
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-key-exchange
                   '"connection closed")
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-key-exchange
                   '"key exchange error"
                   _e633_)))))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-read-e
    (lambda (_secret608_)
      (let ((_key610_
             (subu8vector
              _secret608_
              '0
              std/actor/rpc/proto/cipher#::cipher-key-length))
            (_hmac611_
             (make-u8vector std/actor/rpc/proto/cipher#::digest-size))
            (_iv612_ (make-u8vector
                      std/actor/rpc/proto/cipher#::cipher-iv-length))
            (_ctext613_ (box (make-u8vector '4096))))
        (lambda (_g614617_ _g615619_)
          (std/actor/rpc/proto/cipher#rpc-cipher-proto-read
           _g614617_
           _g615619_
           _secret608_
           _key610_
           _hmac611_
           _iv612_
           _ctext613_)))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-read
    (lambda (_ibuf569_
             _bytes570_
             _secret571_
             _key572_
             _hmac573_
             _iv574_
             _ctext575_)
      (let ((_e577_ (std/net/bio/input#bio-read-u8 _ibuf569_)))
        (if (eq? _e577_ std/actor/rpc/proto/message#rpc-proto-message)
            (let* ((_digest579_
                    (let ((__obj5703
                           (make-object std/crypto/digest#digest::t '2)))
                      (std/crypto/digest#digest:::init!
                       __obj5703
                       std/actor/rpc/proto/cipher#::digest-type)
                      __obj5703))
                   (_cipher581_
                    (let ((__obj5704
                           (make-object std/crypto/cipher#cipher::t '2)))
                      (std/crypto/cipher#cipher:::init!
                       __obj5704
                       std/actor/rpc/proto/cipher#::cipher-type)
                      __obj5704))
                   (_g5712_ (std/net/bio/input#bio-read-bytes
                             _hmac573_
                             _ibuf569_))
                   (_g5713_ (std/net/bio/input#bio-read-bytes
                             _iv574_
                             _ibuf569_))
                   (_size585_ (std/net/bio/input#bio-read-u32 _ibuf569_))
                   (_g5714_ (if (fx<= _size585_
                                      std/actor/rpc/proto/message#rpc-proto-message-max-length)
                                '#!void
                                (std/actor/proto#raise-rpc-io-error
                                 'rpc-proto-read
                                 '"message too large"
                                 _size585_)))
                   (_ctext592_
                    (let ((_buf588_ (unbox _ctext575_)))
                      (if (fx< (u8vector-length _buf588_) _size585_)
                          (let ((_buf590_ (make-u8vector _size585_)))
                            (set-box! _ctext575_ _buf590_)
                            _buf590_)
                          _buf588_)))
                   (_rd594_ (std/net/bio/input#bio-read-subu8vector-unbuffered
                             _ctext592_
                             '0
                             _size585_
                             _ibuf569_))
                   (_g5715_ (if (fx< _rd594_ _size585_)
                                (std/actor/proto#raise-rpc-io-error
                                 'rpc-proto-read
                                 '"incomplete message"
                                 _rd594_
                                 _size585_)
                                '#!void))
                   (_g5716_ (std/crypto/digest#digest-update!__0
                             _digest579_
                             _secret571_))
                   (_g5717_ (std/crypto/digest#digest-update!__0
                             _digest579_
                             _iv574_))
                   (_g5718_ (std/crypto/digest#digest-update!__%
                             _digest579_
                             _ctext592_
                             '0
                             _size585_))
                   (_hmac*600_
                    (std/crypto/digest#digest-final!__0 _digest579_))
                   (_g5719_ (if (equal? _hmac573_ _hmac*600_)
                                '#!void
                                (std/actor/proto#raise-rpc-io-error
                                 'rpc-proto-read
                                 '"HMAC failure")))
                   (_bytes603_
                    (if (fx< (u8vector-length _bytes570_) _size585_)
                        (make-u8vector _size585_)
                        _bytes570_))
                   (_len605_
                    (std/crypto/cipher#decrypt-u8vector!
                     _cipher581_
                     _key572_
                     _iv574_
                     _ctext592_
                     '0
                     _size585_
                     _bytes603_)))
              (values _bytes603_ _len605_))
            (if (eq? _e577_ std/actor/rpc/proto/message#rpc-proto-keep-alive)
                '#!void
                (if (eof-object? _e577_)
                    _e577_
                    (std/actor/proto#raise-rpc-io-error
                     'rpc-proto-read
                     '"bad message"
                     _e577_)))))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-write-e
    (lambda (_secret556_)
      (let ((_key558_
             (subu8vector
              _secret556_
              '0
              std/actor/rpc/proto/cipher#::cipher-key-length))
            (_iv559_ (make-u8vector
                      std/actor/rpc/proto/cipher#::cipher-iv-length))
            (_ctext560_ (box (make-u8vector '4096))))
        (lambda (_g561564_ _g562566_)
          (std/actor/rpc/proto/cipher#rpc-cipher-proto-write
           _g561564_
           _g562566_
           _secret556_
           _key558_
           _iv559_
           _ctext560_)))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-write
    (lambda (_obuf491_ _obj492_ _secret493_ _key494_ _iv495_ _ctext496_)
      (if (eq? _obj492_ '#!void)
          (begin
            (std/net/bio/output#bio-write-u8
             std/actor/rpc/proto/message#rpc-proto-keep-alive
             _obuf491_)
            (std/net/bio/output#bio-force-output _obuf491_))
          (if (u8vector? _obj492_)
              (begin
                (std/net/bio/output#bio-write-u8
                 std/actor/rpc/proto/message#rpc-proto-message
                 _obuf491_)
                (let* ((_digest498_
                        (let ((__obj5705
                               (make-object std/crypto/digest#digest::t '2)))
                          (std/crypto/digest#digest:::init!
                           __obj5705
                           std/actor/rpc/proto/cipher#::digest-type)
                          __obj5705))
                       (_cipher500_
                        (let ((__obj5706
                               (make-object std/crypto/cipher#cipher::t '2)))
                          (std/crypto/cipher#cipher:::init!
                           __obj5706
                           std/actor/rpc/proto/cipher#::cipher-type)
                          __obj5706))
                       (_g5720_ (std/crypto/etc#random-bytes!__0 _iv495_))
                       (_plen503_ (u8vector-length _obj492_))
                       (_maxlen505_
                        (fx+ _plen503_
                             std/actor/rpc/proto/cipher#::cipher-block-size))
                       (_ctext511_
                        (let ((_buf507_ (unbox _ctext496_)))
                          (if (fx< (u8vector-length _buf507_) _maxlen505_)
                              (let ((_buf509_ (make-u8vector _maxlen505_)))
                                (set-box! _ctext496_ _buf509_)
                                _buf509_)
                              _buf507_)))
                       (_clen513_
                        (std/crypto/cipher#encrypt-u8vector!
                         _cipher500_
                         _key494_
                         _iv495_
                         _obj492_
                         '0
                         _plen503_
                         _ctext511_))
                       (_g5721_ (std/crypto/digest#digest-update!__0
                                 _digest498_
                                 _secret493_))
                       (_g5722_ (std/crypto/digest#digest-update!__0
                                 _digest498_
                                 _iv495_))
                       (_g5723_ (std/crypto/digest#digest-update!__%
                                 _digest498_
                                 _ctext511_
                                 '0
                                 _clen513_))
                       (_hmac518_
                        (std/crypto/digest#digest-final!__0 _digest498_)))
                  (std/net/bio/output#bio-write-bytes _hmac518_ _obuf491_)
                  (std/net/bio/output#bio-write-bytes _iv495_ _obuf491_)
                  (std/net/bio/output#bio-write-u32 _clen513_ _obuf491_)
                  (std/net/bio/output#bio-write-subu8vector
                   _ctext511_
                   '0
                   _clen513_
                   _obuf491_)
                  (std/net/bio/output#bio-force-output _obuf491_)))
              (if (##structure-instance-of?
                   _obj492_
                   'std/net/bio/buffer#chunked-output-buffer::t)
                  (begin
                    (std/net/bio/output#bio-write-u8
                     std/actor/rpc/proto/message#rpc-proto-message
                     _obuf491_)
                    (let* ((_digest521_
                            (let ((__obj5707
                                   (make-object
                                    std/crypto/digest#digest::t
                                    '2)))
                              (std/crypto/digest#digest:::init!
                               __obj5707
                               std/actor/rpc/proto/cipher#::digest-type)
                              __obj5707))
                           (_cipher523_
                            (let ((__obj5708
                                   (make-object
                                    std/crypto/cipher#cipher::t
                                    '2)))
                              (std/crypto/cipher#cipher:::init!
                               __obj5708
                               std/actor/rpc/proto/cipher#::cipher-type)
                              __obj5708))
                           (_g5724_ (std/crypto/etc#random-bytes!__0 _iv495_))
                           (_plen526_
                            (std/net/bio/buffer#chunked-output-length
                             _obj492_))
                           (_chunks528_
                            (std/net/bio/buffer#chunked-output-chunks
                             _obj492_))
                           (_maxlen530_
                            (fx+ _plen526_
                                 std/actor/rpc/proto/cipher#::cipher-block-size))
                           (_ctext536_
                            (let ((_buf532_ (unbox _ctext496_)))
                              (if (fx< (u8vector-length _buf532_) _maxlen530_)
                                  (let ((_buf534_ (make-u8vector _maxlen530_)))
                                    (set-box! _ctext496_ _buf534_)
                                    _buf534_)
                                  _buf532_)))
                           (_g5725_ (std/crypto/cipher#encrypt-init!
                                     _cipher523_
                                     _key494_
                                     _iv495_))
                           (_clen544_
                            (foldl1 (lambda (_chunk539_ _r540_)
                                      (let ((_count542_
                                             (std/crypto/cipher#encrypt-update!
                                              _cipher523_
                                              _ctext536_
                                              _r540_
                                              _chunk539_
                                              '0
                                              (u8vector-length _chunk539_))))
                                        (fx+ _r540_ _count542_)))
                                    '0
                                    _chunks528_))
                           (_flen546_
                            (std/crypto/cipher#encrypt-final!__%
                             _cipher523_
                             _ctext536_
                             _clen544_))
                           (_clen548_ (fx+ _clen544_ _flen546_))
                           (_g5726_ (std/crypto/digest#digest-update!__0
                                     _digest521_
                                     _secret493_))
                           (_g5727_ (std/crypto/digest#digest-update!__0
                                     _digest521_
                                     _iv495_))
                           (_g5728_ (std/crypto/digest#digest-update!__%
                                     _digest521_
                                     _ctext536_
                                     '0
                                     _clen548_))
                           (_hmac553_
                            (std/crypto/digest#digest-final!__0 _digest521_)))
                      (std/net/bio/output#bio-write-bytes _hmac553_ _obuf491_)
                      (std/net/bio/output#bio-write-bytes _iv495_ _obuf491_)
                      (std/net/bio/output#bio-write-u32 _clen548_ _obuf491_)
                      (std/net/bio/output#bio-write-subu8vector
                       _ctext536_
                       '0
                       _clen548_
                       _obuf491_)
                      (std/net/bio/output#bio-force-output _obuf491_)))
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-write
                   '"unexpected object"
                   _obj492_))))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-accept
    (lambda (_ibuf483_ _obuf484_)
      (std/actor/rpc/proto/null#rpc-proto-accept-e
       _ibuf483_
       _obuf484_
       std/actor/rpc/proto/message#rpc-proto-cipher
       (lambda (_ibuf486_ _obuf487_)
         (let ((_secret489_
                (std/actor/rpc/proto/cipher#rpc-cipher-proto-key-exchange
                 _ibuf486_
                 _obuf487_)))
           (values (std/actor/rpc/proto/cipher#rpc-cipher-proto-read-e
                    _secret489_)
                   (std/actor/rpc/proto/cipher#rpc-cipher-proto-write-e
                    _secret489_)))))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-connect
    (lambda (_ibuf475_ _obuf476_)
      (std/actor/rpc/proto/null#rpc-proto-connect-e
       _ibuf475_
       _obuf476_
       std/actor/rpc/proto/message#rpc-proto-cipher
       (lambda (_ibuf478_ _obuf479_)
         (let ((_secret481_
                (std/actor/rpc/proto/cipher#rpc-cipher-proto-key-exchange
                 _ibuf478_
                 _obuf479_)))
           (values (std/actor/rpc/proto/cipher#rpc-cipher-proto-read-e
                    _secret481_)
                   (std/actor/rpc/proto/cipher#rpc-cipher-proto-write-e
                    _secret481_)))))))
  (define std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto-accept
    (lambda (_ibuf466_ _obuf467_ _cookie468_)
      (std/actor/rpc/proto/null#rpc-proto-accept-e
       _ibuf466_
       _obuf467_
       std/actor/rpc/proto/message#rpc-proto-cookie-cipher
       (lambda (_ibuf470_ _obuf471_)
         (std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge
          _ibuf470_
          _obuf471_
          _cookie468_)
         (let ((_secret473_
                (std/actor/rpc/proto/cipher#rpc-cipher-proto-key-exchange
                 _ibuf470_
                 _obuf471_)))
           (values (std/actor/rpc/proto/cipher#rpc-cipher-proto-read-e
                    _secret473_)
                   (std/actor/rpc/proto/cipher#rpc-cipher-proto-write-e
                    _secret473_)))))))
  (define std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto-connect
    (lambda (_ibuf455_ _obuf456_ _cookie457_)
      (std/actor/rpc/proto/null#rpc-proto-connect-e
       _ibuf455_
       _obuf456_
       std/actor/rpc/proto/message#rpc-proto-cookie-cipher
       (lambda (_ibuf459_ _obuf460_)
         (let ((_e462_ (std/net/bio/input#bio-read-u8 _ibuf459_)))
           (if (eq? _e462_ std/actor/rpc/proto/message#rpc-proto-challenge)
               (begin
                 (std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge-respond
                  _ibuf459_
                  _obuf460_
                  _cookie457_)
                 (let ((_secret464_
                        (std/actor/rpc/proto/cipher#rpc-cipher-proto-key-exchange
                         _ibuf459_
                         _obuf460_)))
                   (values (std/actor/rpc/proto/cipher#rpc-cipher-proto-read-e
                            _secret464_)
                           (std/actor/rpc/proto/cipher#rpc-cipher-proto-write-e
                            _secret464_))))
               (if (eof-object? _e462_)
                   (std/actor/proto#raise-rpc-io-error
                    'rpc-proto-connect
                    '"connect closed")
                   (std/actor/proto#raise-rpc-io-error
                    'rpc-proto-connect
                    '"bad hello"
                    _e462_))))))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto
    (lambda ()
      (##structure
       std/actor/rpc/base#!rpc-protocol::t
       std/actor/rpc/proto/cipher#rpc-cipher-proto-accept
       std/actor/rpc/proto/cipher#rpc-cipher-proto-connect)))
  (define std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto__%
    (lambda (_cookie-file428_)
      (let ((_cookie430_ (call-with-input-file _cookie-file428_ read)))
        (if (u8vector? _cookie430_)
            (##structure
             std/actor/rpc/base#!rpc-protocol::t
             (lambda (_g431434_ _g432436_)
               (std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto-connect
                _g431434_
                _g432436_
                _cookie430_))
             (lambda (_g438441_ _g439443_)
               (std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto-accept
                _g438441_
                _g439443_
                _cookie430_)))
            (error '"Invalid cookie; expected u8vector"
                   _cookie-file428_
                   _cookie430_)))))
  (define std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto__0
    (lambda ()
      (let ((_cookie-file450_ '"~/.gerbil/cookie"))
        (std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto__%
         _cookie-file450_))))
  (define std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto
    (lambda _g5730_
      (let ((_g5729_ (##length _g5730_)))
        (cond ((##fx= _g5729_ 0)
               (apply std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto__0
                      _g5730_))
              ((##fx= _g5729_ 1)
               (apply std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto__%
                      _g5730_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto
                _g5730_)))))))
