(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/bn#BN->bytes
    (lambda (_bn429_)
      (let* ((_bytes431_
              (make-u8vector (std/crypto/libcrypto#BN_num_bytes _bn429_)))
             (_count433_ (std/crypto/libcrypto#BN_bn2bin _bn429_ _bytes431_)))
        (if (let ((__tmp4091 (u8vector-length _bytes431_)))
              (declare (not safe))
              (##fx< _count433_ __tmp4091))
            (u8vector-shrink! _bytes431_ _count433_)
            _bytes431_))))
  (define std/crypto/bn#bytes->BN__%
    (lambda (_bytes399_ _start400_ _end401_)
      (if (u8vector? _bytes399_)
          (let* ((_end406_
                  (let ((_$e403_ _end401_))
                    (if _$e403_ _$e403_ (u8vector-length _bytes399_))))
                 (_$e408_ (std/crypto/libcrypto#BN_bin2bn
                           _bytes399_
                           _start400_
                           _end406_)))
            (if _$e408_
                _$e408_
                (error '"error decoding BN; NULL pointer" _bytes399_)))
          (error '"bad argument; expected bytes" _bytes399_))))
  (define std/crypto/bn#bytes->BN__0
    (lambda (_bytes414_)
      (let* ((_start416_ '0) (_end418_ '#f))
        (std/crypto/bn#bytes->BN__% _bytes414_ _start416_ _end418_))))
  (define std/crypto/bn#bytes->BN__1
    (lambda (_bytes420_ _start421_)
      (let ((_end423_ '#f))
        (std/crypto/bn#bytes->BN__% _bytes420_ _start421_ _end423_))))
  (define std/crypto/bn#bytes->BN
    (lambda _g4093_
      (let ((_g4092_ (let () (declare (not safe)) (##length _g4093_))))
        (cond ((let () (declare (not safe)) (##fx= _g4092_ 1))
               (apply std/crypto/bn#bytes->BN__0 _g4093_))
              ((let () (declare (not safe)) (##fx= _g4092_ 2))
               (apply std/crypto/bn#bytes->BN__1 _g4093_))
              ((let () (declare (not safe)) (##fx= _g4092_ 3))
               (apply std/crypto/bn#bytes->BN__% _g4093_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/bn#bytes->BN
                _g4093_)))))))
