/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFontVariantLigatures
extends org.w3c.css.properties.css.CssFontVariantLigatures {
    public static final CssIdent[] commonLigValues;
    public static final CssIdent[] discretionaryLigValues;
    public static final CssIdent[] historicalLigValues;
    public static final CssIdent[] contextualAltValues;
    public static final CssIdent normal;

    public static final CssIdent getCommonLigValues(CssIdent ident) {
        for (CssIdent id : commonLigValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getDiscretionaryLigValues(CssIdent ident) {
        for (CssIdent id : discretionaryLigValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getHistoricalLigValues(CssIdent ident) {
        for (CssIdent id : historicalLigValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getContextualAltValues(CssIdent ident) {
        for (CssIdent id : contextualAltValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getAllowedValue(CssIdent ident) {
        if (none.equals(ident)) {
            return none;
        }
        CssIdent id = CssFontVariantLigatures.getCommonLigValues(ident);
        if (id == null && (id = CssFontVariantLigatures.getDiscretionaryLigValues(ident)) == null && (id = CssFontVariantLigatures.getHistoricalLigValues(ident)) == null) {
            id = CssFontVariantLigatures.getContextualAltValues(ident);
        }
        return id;
    }

    public CssFontVariantLigatures() {
        this.value = initial;
    }

    public CssFontVariantLigatures(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssIdent histValue = null;
        CssIdent commonValue = null;
        CssIdent discValue = null;
        CssIdent altValue = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() == 0) {
                CssIdent ident = (CssIdent)val;
                if (inherit.equals(ident)) {
                    if (expression.getCount() != 1) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    this.value = inherit;
                } else if (normal.equals(ident)) {
                    if (expression.getCount() != 1) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    this.value = normal;
                } else if (none.equals(ident)) {
                    if (expression.getCount() != 1) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    this.value = none;
                } else {
                    boolean match = false;
                    if (commonValue == null) {
                        commonValue = CssFontVariantLigatures.getCommonLigValues(ident);
                        boolean bl = match = commonValue != null;
                    }
                    if (!match && histValue == null) {
                        histValue = CssFontVariantLigatures.getHistoricalLigValues(ident);
                        boolean bl = match = histValue != null;
                    }
                    if (!match && discValue == null) {
                        discValue = CssFontVariantLigatures.getDiscretionaryLigValues(ident);
                        boolean bl = match = discValue != null;
                    }
                    if (!match && altValue == null) {
                        altValue = CssFontVariantLigatures.getContextualAltValues(ident);
                        boolean bl = match = altValue != null;
                    }
                    if (!match) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                }
            } else {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            expression.next();
        }
        if (expression.getCount() == 1) {
            if (commonValue != null) {
                this.value = commonValue;
            } else if (histValue != null) {
                this.value = histValue;
            } else if (discValue != null) {
                this.value = discValue;
            } else if (altValue != null) {
                this.value = altValue;
            }
        } else {
            ArrayList<CssValue> v = new ArrayList<CssValue>();
            if (commonValue != null) {
                v.add(commonValue);
            }
            if (histValue != null) {
                v.add(histValue);
            }
            if (discValue != null) {
                v.add(discValue);
            }
            if (altValue != null) {
                v.add(altValue);
            }
            this.value = new CssValueList(v);
        }
    }

    public CssFontVariantLigatures(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _commonLigValues = new String[]{"common-ligatures", "no-common-ligatures"};
        String[] _discretionaryLigValues = new String[]{"discretionary-ligatures", "no-discretionary-ligatures"};
        String[] _historicalLigValues = new String[]{"historical-ligatures", "no-historical-ligatures"};
        String[] _contextualAltValues = new String[]{"contextual", "no-contextual"};
        normal = CssIdent.getIdent("normal");
        commonLigValues = new CssIdent[_commonLigValues.length];
        int i = 0;
        for (String s : _commonLigValues) {
            CssFontVariantLigatures.commonLigValues[i++] = CssIdent.getIdent(s);
        }
        discretionaryLigValues = new CssIdent[_discretionaryLigValues.length];
        i = 0;
        for (String s : _discretionaryLigValues) {
            CssFontVariantLigatures.discretionaryLigValues[i++] = CssIdent.getIdent(s);
        }
        historicalLigValues = new CssIdent[_historicalLigValues.length];
        i = 0;
        for (String s : _historicalLigValues) {
            CssFontVariantLigatures.historicalLigValues[i++] = CssIdent.getIdent(s);
        }
        contextualAltValues = new CssIdent[_contextualAltValues.length];
        i = 0;
        for (String s : _contextualAltValues) {
            CssFontVariantLigatures.contextualAltValues[i++] = CssIdent.getIdent(s);
        }
    }
}

